/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.idm.query.internal;

import org.keycloak.storage.ldap.idm.query.EscapeStrategy;

class OctetStringEncoder {
    private final EscapeStrategy fallback;

    OctetStringEncoder() {
        this(null);
    }

    OctetStringEncoder(EscapeStrategy fallback) {
        this.fallback = fallback;
    }

    public String encode(Object parameterValue, boolean isBinary) {
        String escaped = parameterValue instanceof byte[] ? EscapeStrategy.escapeHex((byte[])parameterValue) : this.escapeAsString(parameterValue, isBinary);
        return escaped;
    }

    private String escapeAsString(Object parameterValue, boolean isBinary) {
        String stringValue = parameterValue.toString();
        String escaped = isBinary ? EscapeStrategy.OCTET_STRING.escape(stringValue) : (this.fallback == null ? stringValue : this.fallback.escape(stringValue));
        return escaped;
    }
}

