/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class URIUtils {
    private static final Logger LOG = Logger.getLogger(URIUtils.class);

    private URIUtils() {
    }

    public static Map<String, String> splitFragment(String location) {
        if (StringUtils.isEmpty((String)location)) {
            return Collections.emptyMap();
        }
        URI uri = null;
        try {
            uri = new URI(location);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return URIUtils.splitFragment(uri);
    }

    public static Map<String, String> splitFragment(URI uri) {
        return URIUtils.splitQuery(uri.getFragment());
    }

    public static Map<String, String> splitQuery(String q) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (q != null) {
            try {
                String[] split;
                String decoded = URLDecoder.decode(q, StandardCharsets.UTF_8.toString());
                for (String pair : split = decoded.split("&")) {
                    String[] keyValue = pair.split("=");
                    if (keyValue.length < 2) continue;
                    params.put(keyValue[0], keyValue[1]);
                }
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Object)("Unable to decode " + q), (Throwable)e);
            }
        }
        return params;
    }
}

