/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.function.IntFunction;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;

public class CollectionExternalizer<T extends Collection<Object>>
implements Externalizer<T> {
    private final Class<T> targetClass;
    private final IntFunction<T> factory;

    public CollectionExternalizer(Class<?> targetClass, IntFunction<T> factory) {
        this.targetClass = targetClass;
        this.factory = factory;
    }

    public void writeObject(ObjectOutput output, T collection) throws IOException {
        CollectionExternalizer.writeCollection(output, collection);
    }

    static <T extends Collection<Object>> void writeCollection(ObjectOutput output, T collection) throws IOException {
        IndexSerializer.VARIABLE.writeInt(output, collection.size());
        for (Object element : collection) {
            output.writeObject(element);
        }
    }

    public T readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int size = IndexSerializer.VARIABLE.readInt(input);
        return (T)CollectionExternalizer.readCollection(input, (Collection)this.factory.apply(size), size);
    }

    static <T extends Collection<Object>> T readCollection(ObjectInput input, T collection, int size) throws IOException, ClassNotFoundException {
        for (int i = 0; i < size; ++i) {
            collection.add((Object)input.readObject());
        }
        return collection;
    }

    public Class<T> getTargetClass() {
        return this.targetClass;
    }
}

