/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.NoSuchAlgorithmException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.SecurityActions;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;

class DefaultSSLContextService
implements Service {
    static final ServiceName SERVICE_NAME = ElytronExtension.BASE_SERVICE_NAME.append(new String[]{"ssl-context-registration"});
    private static final boolean RESTORE_SSL_CONTEXT = SecurityActions.doPrivileged(() -> Boolean.getBoolean(ElytronDefinition.RESTORE_DEFAULT_SSL_CONTEXT));
    private final Supplier<SSLContext> defaultSSLContextSupplier;
    private final Consumer<SSLContext> valueConsumer;

    DefaultSSLContextService(Supplier<SSLContext> defaultSSLContextSupplier, Consumer<SSLContext> valueConsumer) {
        this.defaultSSLContextSupplier = defaultSSLContextSupplier;
        this.valueConsumer = valueConsumer;
    }

    public void start(StartContext context) throws StartException {
        SSLContext sslContext = this.defaultSSLContextSupplier.get();
        SecurityActions.doPrivileged(() -> {
            SSLContext.setDefault(sslContext);
            return null;
        });
        this.valueConsumer.accept(sslContext);
    }

    public void stop(StopContext context) {
        if (RESTORE_SSL_CONTEXT) {
            try {
                SSLContext defaultSSLContext = SSLContext.getInstance("Default");
                SecurityActions.doPrivileged(() -> {
                    SSLContext.setDefault(defaultSSLContext);
                    return null;
                });
            }
            catch (NoSuchAlgorithmException e) {
                ElytronSubsystemMessages.ROOT_LOGGER.debug(e);
            }
        }
    }
}

