/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.docker.installation;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.ClientInstallationProvider;
import org.keycloak.protocol.docker.installation.compose.DockerComposeZipContent;

public class DockerComposeYamlInstallationProvider
implements ClientInstallationProvider {
    private static Logger log = Logger.getLogger(DockerComposeYamlInstallationProvider.class);
    public static final String ROOT_DIR = "keycloak-docker-compose-yaml/";

    public ClientInstallationProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "docker-v2-compose-yaml";
    }

    public Response generateInstallation(KeycloakSession session, RealmModel realm, ClientModel client, URI serverBaseUri) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ZipOutputStream zipOutput = new ZipOutputStream(byteStream);
        try {
            return this.generateInstallation(zipOutput, byteStream, session.keys().getActiveRsaKey(realm).getCertificate(), session.getContext().getUri().getBaseUri().toURL(), realm.getName(), client.getClientId());
        }
        catch (IOException e) {
            try {
                zipOutput.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                byteStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new RuntimeException("Error occurred during attempt to generate docker-compose yaml installation files", e);
        }
    }

    public Response generateInstallation(ZipOutputStream zipOutput, ByteArrayOutputStream byteStream, Certificate realmCert, URL realmBaseURl, String realmName, String clientName) throws IOException {
        DockerComposeZipContent zipContent = new DockerComposeZipContent(realmCert, realmBaseURl, realmName, clientName);
        zipOutput.putNextEntry(new ZipEntry(ROOT_DIR));
        zipOutput.putNextEntry(new ZipEntry("keycloak-docker-compose-yaml/docker-compose.yaml"));
        zipOutput.write(zipContent.getYamlFile().generateDockerComposeFileBytes());
        zipOutput.closeEntry();
        zipOutput.putNextEntry(new ZipEntry(ROOT_DIR + zipContent.getDataDirectoryName() + "/"));
        zipOutput.putNextEntry(new ZipEntry(ROOT_DIR + zipContent.getDataDirectoryName() + "/.gitignore"));
        zipOutput.write("*".getBytes());
        zipOutput.closeEntry();
        String certsDirectory = ROOT_DIR + zipContent.getCertsDirectory().getDirectoryName() + "/";
        zipOutput.putNextEntry(new ZipEntry(certsDirectory));
        zipOutput.putNextEntry(new ZipEntry(certsDirectory + zipContent.getCertsDirectory().getLocalhostCertFile().getKey()));
        zipOutput.write(zipContent.getCertsDirectory().getLocalhostCertFile().getValue());
        zipOutput.closeEntry();
        zipOutput.putNextEntry(new ZipEntry(certsDirectory + zipContent.getCertsDirectory().getLocalhostKeyFile().getKey()));
        zipOutput.write(zipContent.getCertsDirectory().getLocalhostKeyFile().getValue());
        zipOutput.closeEntry();
        zipOutput.putNextEntry(new ZipEntry(certsDirectory + zipContent.getCertsDirectory().getIdpTrustChainFile().getKey()));
        zipOutput.write(zipContent.getCertsDirectory().getIdpTrustChainFile().getValue());
        zipOutput.closeEntry();
        zipOutput.putNextEntry(new ZipEntry("keycloak-docker-compose-yaml/README.md"));
        String readmeContent = new BufferedReader(new InputStreamReader(DockerComposeYamlInstallationProvider.class.getResourceAsStream("/DockerComposeYamlReadme.md"))).lines().collect(Collectors.joining("\n"));
        zipOutput.write(readmeContent.getBytes());
        zipOutput.closeEntry();
        zipOutput.close();
        byteStream.close();
        return Response.ok((Object)byteStream.toByteArray(), (String)this.getMediaType()).build();
    }

    public String getProtocol() {
        return "docker-v2";
    }

    public String getDisplayType() {
        return "Docker Compose YAML";
    }

    public String getHelpText() {
        return "Produces a zip file that can be used to stand up a development registry on localhost";
    }

    public String getFilename() {
        return "keycloak-docker-compose-yaml.zip";
    }

    public String getMediaType() {
        return "application/zip";
    }

    public boolean isDownloadOnly() {
        return true;
    }
}

