/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.x509;

import freemarker.template.utility.NullArgumentException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.keycloak.authentication.authenticators.x509.X509AuthenticatorConfigModel;
import org.keycloak.common.util.PemUtils;
import org.keycloak.services.ServicesLogger;

public abstract class UserIdentityExtractor {
    private static final ServicesLogger logger = ServicesLogger.LOGGER;

    public abstract Object extractUserIdentity(X509Certificate[] var1);

    public static UserIdentityExtractor getPatternIdentityExtractor(String pattern, Function<X509Certificate[], String> func) {
        return new PatternMatcher(pattern, func);
    }

    public static UserIdentityExtractor getX500NameExtractor(ASN1ObjectIdentifier identifier, Function<X509Certificate[], X500Name> x500Name) {
        return new X500NameRDNExtractor(identifier, x500Name);
    }

    public static SubjectAltNameExtractor getSubjectAltNameExtractor(int generalName) {
        return new SubjectAltNameExtractor(generalName);
    }

    public static OrBuilder either(UserIdentityExtractor extractor) {
        return new OrBuilder(extractor);
    }

    public static UserIdentityExtractor getCertificatePemIdentityExtractor(X509AuthenticatorConfigModel config) {
        return new UserIdentityExtractor(){

            @Override
            public Object extractUserIdentity(X509Certificate[] certs) {
                if (certs == null || certs.length == 0) {
                    throw new IllegalArgumentException();
                }
                String pem = PemUtils.encodeCertificate((Certificate)certs[0]);
                logger.debugf("Using PEM certificate \"%s\" as user identity.", pem);
                return pem;
            }
        };
    }

    static class OrBuilder {
        UserIdentityExtractor extractor;
        UserIdentityExtractor other;

        OrBuilder(UserIdentityExtractor extractor) {
            this.extractor = extractor;
        }

        public UserIdentityExtractor or(UserIdentityExtractor other) {
            return new OrExtractor(this.extractor, other);
        }
    }

    static class PatternMatcher
    extends UserIdentityExtractor {
        private final String _pattern;
        private final Function<X509Certificate[], String> _f;

        PatternMatcher(String pattern, Function<X509Certificate[], String> valueToMatch) {
            this._pattern = pattern;
            this._f = valueToMatch;
        }

        @Override
        public Object extractUserIdentity(X509Certificate[] certs) {
            String value = Optional.ofNullable(this._f.apply(certs)).orElseThrow(IllegalArgumentException::new);
            Pattern r = Pattern.compile(this._pattern, 2);
            Matcher m = r.matcher(value);
            if (!m.find()) {
                logger.debugf("[PatternMatcher:extract] No matches were found for input \"%s\", pattern=\"%s\"", value, this._pattern);
                return null;
            }
            if (m.groupCount() != 1) {
                logger.debugf("[PatternMatcher:extract] Match produced more than a single group for input \"%s\", pattern=\"%s\"", value, this._pattern);
                return null;
            }
            return m.group(1);
        }
    }

    static class SubjectAltNameExtractor
    extends UserIdentityExtractor {
        private static final String UPN_OID = "1.3.6.1.4.1.311.20.2.3";
        private final int generalName;

        SubjectAltNameExtractor(int generalName) {
            this.generalName = generalName;
        }

        @Override
        public Object extractUserIdentity(X509Certificate[] certs) {
            if (certs == null || certs.length == 0) {
                throw new IllegalArgumentException();
            }
            try {
                Collection<List<?>> subjectAlternativeNames = certs[0].getSubjectAlternativeNames();
                if (subjectAlternativeNames == null) {
                    return null;
                }
                Iterator<List<?>> iterator = subjectAlternativeNames.iterator();
                boolean foundUpn = false;
                String tempOtherName = null;
                String tempOid = null;
                block4: while (iterator.hasNext() && !foundUpn) {
                    List<?> next = iterator.next();
                    if ((Integer)Integer.class.cast(next.get(0)) != this.generalName) continue;
                    for (int i = 1; i < next.size(); ++i) {
                        Object obj = next.get(i);
                        if (this.generalName != 0) {
                            logger.tracef("Extracted identity '%s' from Subject Alternative Name of type '%d'", obj, this.generalName);
                            return obj;
                        }
                        byte[] otherNameBytes = (byte[])obj;
                        try {
                            ASN1InputStream asn1Stream = new ASN1InputStream((InputStream)new ByteArrayInputStream(otherNameBytes));
                            ASN1Primitive asn1otherName = asn1Stream.readObject();
                            asn1otherName = this.unwrap((ASN1Encodable)asn1otherName);
                            ASN1Sequence asn1Sequence = ASN1Sequence.getInstance((Object)asn1otherName);
                            if (asn1Sequence == null) continue;
                            ASN1Encodable encodedOid = asn1Sequence.getObjectAt(0);
                            ASN1ObjectIdentifier oid = ASN1ObjectIdentifier.getInstance((Object)this.unwrap(encodedOid));
                            tempOid = oid.getId();
                            ASN1Encodable principalNameEncoded = asn1Sequence.getObjectAt(1);
                            DERUTF8String principalName = DERUTF8String.getInstance((Object)this.unwrap(principalNameEncoded));
                            tempOtherName = principalName.getString();
                            if (!UPN_OID.equals(tempOid)) continue;
                            foundUpn = true;
                            continue block4;
                        }
                        catch (Exception e) {
                            logger.error("Failed to parse subjectAltName", e);
                        }
                    }
                }
                logger.tracef("Parsed otherName from subjectAltName. OID: '%s', Principal: '%s'", tempOid, tempOtherName);
                return tempOtherName;
            }
            catch (CertificateParsingException cause) {
                logger.errorf(cause, "Failed to obtain identity from subjectAltName extension", new Object[0]);
                return null;
            }
        }

        private ASN1Encodable unwrap(ASN1Encodable encodable) {
            while (encodable instanceof ASN1TaggedObject) {
                ASN1TaggedObject taggedObj = (ASN1TaggedObject)encodable;
                encodable = taggedObj.getObject();
            }
            return encodable;
        }
    }

    static class X500NameRDNExtractor
    extends UserIdentityExtractor {
        private ASN1ObjectIdentifier x500NameStyle;
        Function<X509Certificate[], X500Name> x500Name;

        X500NameRDNExtractor(ASN1ObjectIdentifier x500NameStyle, Function<X509Certificate[], X500Name> x500Name) {
            this.x500NameStyle = x500NameStyle;
            this.x500Name = x500Name;
        }

        @Override
        public Object extractUserIdentity(X509Certificate[] certs) {
            RDN[] rnds;
            if (certs == null || certs.length == 0) {
                throw new IllegalArgumentException();
            }
            X500Name name = this.x500Name.apply(certs);
            if (name != null && (rnds = name.getRDNs(this.x500NameStyle)) != null && rnds.length > 0) {
                RDN cn = rnds[0];
                return IETFUtils.valueToString((ASN1Encodable)cn.getFirst().getValue());
            }
            return null;
        }
    }

    static class OrExtractor
    extends UserIdentityExtractor {
        UserIdentityExtractor extractor;
        UserIdentityExtractor other;

        OrExtractor(UserIdentityExtractor extractor, UserIdentityExtractor other) {
            this.extractor = extractor;
            this.other = other;
            if (this.extractor == null) {
                throw new NullArgumentException("extractor");
            }
            if (this.other == null) {
                throw new NullArgumentException("other");
            }
        }

        @Override
        public Object extractUserIdentity(X509Certificate[] certs) {
            Object result = this.extractor.extractUserIdentity(certs);
            if (result == null) {
                result = this.other.extractUserIdentity(certs);
            }
            return result;
        }
    }
}

