/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.stream;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.function.Predicate;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.sessions.infinispan.entities.RootAuthenticationSessionEntity;
import org.keycloak.models.sessions.infinispan.util.KeycloakMarshallUtil;

@SerializeWith(value=ExternalizerImpl.class)
public class RootAuthenticationSessionPredicate
implements Predicate<Map.Entry<String, RootAuthenticationSessionEntity>> {
    private final String realm;
    private Integer expired;

    private RootAuthenticationSessionPredicate(String realm) {
        this.realm = realm;
    }

    public static RootAuthenticationSessionPredicate create(String realm) {
        return new RootAuthenticationSessionPredicate(realm);
    }

    public RootAuthenticationSessionPredicate expired(Integer expired) {
        this.expired = expired;
        return this;
    }

    @Override
    public boolean test(Map.Entry<String, RootAuthenticationSessionEntity> entry) {
        RootAuthenticationSessionEntity entity = entry.getValue();
        if (!this.realm.equals(entity.getRealmId())) {
            return false;
        }
        return this.expired == null || entity.getTimestamp() <= this.expired;
    }

    public static class ExternalizerImpl
    implements Externalizer<RootAuthenticationSessionPredicate> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, RootAuthenticationSessionPredicate obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.realm, (ObjectOutput)output);
            KeycloakMarshallUtil.marshall(obj.expired, output);
        }

        public RootAuthenticationSessionPredicate readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public RootAuthenticationSessionPredicate readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            RootAuthenticationSessionPredicate res = new RootAuthenticationSessionPredicate(MarshallUtil.unmarshallString((ObjectInput)input));
            res.expired(KeycloakMarshallUtil.unmarshallInteger(input));
            return res;
        }
    }
}

