/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.RealmCacheInvalidationEvent;

@SerializeWith(value=ExternalizerImpl.class)
public class GroupUpdatedEvent
extends InvalidationEvent
implements RealmCacheInvalidationEvent {
    private String groupId;

    public static GroupUpdatedEvent create(String groupId) {
        GroupUpdatedEvent event = new GroupUpdatedEvent();
        event.groupId = groupId;
        return event;
    }

    @Override
    public String getId() {
        return this.groupId;
    }

    public String toString() {
        return "GroupUpdatedEvent [ " + this.groupId + " ]";
    }

    @Override
    public void addInvalidations(RealmCacheManager realmCache, Set<String> invalidations) {
    }

    public static class ExternalizerImpl
    implements Externalizer<GroupUpdatedEvent> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, GroupUpdatedEvent obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.groupId, (ObjectOutput)output);
        }

        public GroupUpdatedEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public GroupUpdatedEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            GroupUpdatedEvent res = new GroupUpdatedEvent();
            res.groupId = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

