/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.authentication.internal;

import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.picketlink.authentication.Authenticator;
import org.picketlink.authentication.BaseAuthenticator;
import org.picketlink.authentication.LockedAccountException;
import org.picketlink.authentication.UnexpectedCredentialException;
import org.picketlink.credential.DefaultLoginCredentials;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Digest;
import org.picketlink.idm.credential.DigestCredentials;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.credential.UsernamePasswordCredentials;
import org.picketlink.log.BaseLog;

public class IdmAuthenticator
extends BaseAuthenticator {
    @Inject
    Instance<IdentityManager> identityManager;
    @Inject
    DefaultLoginCredentials credentials;

    public void authenticate() {
        UsernamePasswordCredentials creds;
        if (this.credentials.getCredential() == null) {
            return;
        }
        if (this.isUsernamePasswordCredential()) {
            creds = new UsernamePasswordCredentials(this.credentials.getUserId(), (Password)this.credentials.getCredential());
        } else if (this.isDigestCredential()) {
            creds = new DigestCredentials((Digest)this.credentials.getCredential());
        } else if (this.isCustomCredential()) {
            creds = (Credentials)this.credentials.getCredential();
        } else {
            throw new UnexpectedCredentialException("Unsupported credential type [" + this.credentials.getCredential() + "].");
        }
        if (BaseLog.AUTHENTICATION_LOGGER.isDebugEnabled()) {
            BaseLog.AUTHENTICATION_LOGGER.debugf("Validating credentials [%s] using PicketLink IDM.", (Object)creds);
        }
        ((IdentityManager)this.identityManager.get()).validateCredentials((Credentials)creds);
        this.credentials.setStatus(creds.getStatus());
        this.credentials.setValidatedAccount(creds.getValidatedAccount());
        if (BaseLog.AUTHENTICATION_LOGGER.isDebugEnabled()) {
            BaseLog.AUTHENTICATION_LOGGER.debugf("Credential status is [%s] and validated account [%s]", (Object)this.credentials.getStatus(), (Object)this.credentials.getValidatedAccount());
        }
        if (Credentials.Status.VALID.equals((Object)creds.getStatus())) {
            this.setStatus(Authenticator.AuthenticationStatus.SUCCESS);
            this.setAccount(creds.getValidatedAccount());
        } else if (Credentials.Status.ACCOUNT_DISABLED.equals((Object)creds.getStatus())) {
            throw new LockedAccountException("Account [" + this.credentials.getUserId() + "] is disabled.");
        }
    }

    private boolean isCustomCredential() {
        return Credentials.class.isInstance(this.credentials.getCredential());
    }

    private boolean isDigestCredential() {
        return Digest.class.equals(this.credentials.getCredential().getClass());
    }

    private boolean isUsernamePasswordCredential() {
        return Password.class.equals(this.credentials.getCredential().getClass()) && this.credentials.getUserId() != null;
    }
}

