/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.core.spi.Activation;
import org.drools.core.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryHeapQueue
implements Queue,
Externalizable {
    protected static final transient Logger log = LoggerFactory.getLogger(BinaryHeapQueue.class);
    private static final int DEFAULT_CAPACITY = 13;
    private Comparator<Activation> comparator;
    private volatile int size;
    private Activation[] elements;

    public BinaryHeapQueue() {
    }

    public BinaryHeapQueue(Comparator<Activation> comparator) {
        this(comparator, 13);
    }

    public BinaryHeapQueue(Comparator<Activation> comparator, int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("invalid capacity");
        }
        this.elements = new Activation[capacity + 1];
        this.comparator = comparator;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.comparator = (Comparator)in.readObject();
        this.elements = (Activation[])in.readObject();
        this.size = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.comparator);
        out.writeObject(this.elements);
        out.writeInt(this.size);
    }

    public void clear() {
        this.elements = new Activation[this.elements.length];
        this.size = 0;
    }

    public Activation[] getAndClear() {
        Activation[] queue = new Activation[this.size];
        System.arraycopy(this.elements, 1, queue, 0, this.size);
        this.elements = new Activation[this.elements.length];
        this.size = 0;
        return queue;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isFull() {
        return this.elements.length == this.size + 1;
    }

    public int size() {
        return this.size;
    }

    public Activation peek() {
        return this.elements[1];
    }

    @Override
    public void enqueue(Activation element) {
        if (this.isFull()) {
            this.grow();
        }
        this.percolateUpMaxHeap(element);
        element.setQueued(true);
        if (log.isTraceEnabled()) {
            log.trace("Queue Added {} {}", (Object)element.getQueueIndex(), (Object)element);
        }
    }

    @Override
    public Activation dequeue() throws NoSuchElementException {
        if (this.isEmpty()) {
            return null;
        }
        Activation result = this.elements[1];
        this.dequeue(result.getQueueIndex());
        return result;
    }

    @Override
    public Activation dequeue(Activation activation) {
        return this.dequeue(activation.getQueueIndex());
    }

    Activation dequeue(int index) {
        if (index < 1 || index > this.size) {
            return null;
        }
        Activation result = this.elements[index];
        if (log.isTraceEnabled()) {
            log.trace("Queue Removed {} {}", (Object)result.getQueueIndex(), (Object)result);
        }
        this.setElement(index, this.elements[this.size]);
        this.elements[this.size] = null;
        --this.size;
        if (this.size != 0 && index <= this.size) {
            int compareToParent = 0;
            if (index > 1) {
                compareToParent = this.compare(this.elements[index], this.elements[index / 2]);
            }
            if (index > 1 && compareToParent > 0) {
                this.percolateUpMaxHeap(index);
            } else {
                this.percolateDownMaxHeap(index);
            }
        }
        result.setQueued(false);
        result.setQueueIndex(-1);
        return result;
    }

    protected void percolateDownMaxHeap(int index) {
        Activation element = this.elements[index];
        int hole = index;
        while (hole * 2 <= this.size) {
            int child = hole * 2;
            if (child != this.size && this.compare(this.elements[child + 1], this.elements[child]) > 0) {
                ++child;
            }
            if (this.compare(this.elements[child], element) <= 0) break;
            this.setElement(hole, this.elements[child]);
            hole = child;
        }
        this.setElement(hole, element);
    }

    protected void percolateUpMaxHeap(int index) {
        int hole = index;
        Activation element = this.elements[hole];
        while (hole > 1 && this.compare(element, this.elements[hole / 2]) > 0) {
            int next = hole / 2;
            this.setElement(hole, this.elements[next]);
            hole = next;
        }
        this.setElement(hole, element);
    }

    protected void percolateUpMaxHeap(Activation element) {
        this.setElement(++this.size, element);
        this.percolateUpMaxHeap(this.size);
    }

    private int compare(Activation a, Activation b) {
        return this.comparator.compare(a, b);
    }

    private void grow() {
        Activation[] elements = new Activation[this.elements.length * 2];
        System.arraycopy(this.elements, 0, elements, 0, this.elements.length);
        this.elements = elements;
    }

    private void setElement(int index, Activation element) {
        this.elements[index] = element;
        element.setQueueIndex(index);
    }

    public Object[] toArray(Object[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.elements, 1, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    public String toString() {
        return Stream.of(this.elements).filter(e -> e != null).collect(Collectors.toList()).toString();
    }

    public static class Synchronized
    extends BinaryHeapQueue {
        public Synchronized() {
        }

        public Synchronized(Comparator<Activation> comparator) {
            super(comparator);
        }

        public Synchronized(Comparator<Activation> comparator, int capacity) {
            super(comparator, capacity);
        }

        @Override
        public synchronized void clear() {
            super.clear();
        }

        @Override
        public synchronized Activation[] getAndClear() {
            return super.getAndClear();
        }

        @Override
        public synchronized boolean isEmpty() {
            return super.isEmpty();
        }

        @Override
        public synchronized boolean isFull() {
            return super.isFull();
        }

        @Override
        public synchronized int size() {
            return super.size();
        }

        @Override
        public synchronized Activation peek() {
            return super.peek();
        }

        @Override
        public synchronized void enqueue(Activation element) {
            super.enqueue(element);
        }

        @Override
        public synchronized Activation dequeue() throws NoSuchElementException {
            return super.dequeue();
        }

        @Override
        public synchronized Activation dequeue(Activation activation) {
            return super.dequeue(activation);
        }

        @Override
        public synchronized Object[] toArray(Object[] a) {
            return super.toArray(a);
        }
    }
}

