/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.drools.core.reteoo.ObjectSinkNode;

public class ObjectSinkNodeList
implements Externalizable {
    private static final long serialVersionUID = 510L;
    private ObjectSinkNode firstNode;
    private ObjectSinkNode lastNode;
    private int size;

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.firstNode = (ObjectSinkNode)in.readObject();
        this.lastNode = (ObjectSinkNode)in.readObject();
        this.size = in.readInt();
        if (this.firstNode == this.lastNode) {
            return;
        }
        ObjectSinkNode current = this.firstNode;
        ObjectSinkNode previous = null;
        while (current != this.lastNode) {
            ObjectSinkNode next = (ObjectSinkNode)in.readObject();
            current.setPreviousObjectSinkNode(previous);
            current.setNextObjectSinkNode(next);
            previous = current;
            current = next;
        }
        current.setPreviousObjectSinkNode(previous);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.firstNode);
        out.writeObject(this.lastNode);
        out.writeInt(this.size);
        if (this.firstNode == this.lastNode) {
            return;
        }
        for (ObjectSinkNode node = this.firstNode; node != null; node = node.getNextObjectSinkNode()) {
            out.writeObject(node.getNextObjectSinkNode());
        }
    }

    public void add(ObjectSinkNode node) {
        if (this.firstNode == null) {
            this.firstNode = node;
            this.lastNode = node;
        } else {
            this.lastNode.setNextObjectSinkNode(node);
            node.setPreviousObjectSinkNode(this.lastNode);
            this.lastNode = node;
        }
        ++this.size;
    }

    public void remove(ObjectSinkNode node) {
        if (this.firstNode != node && this.lastNode != node) {
            node.getPreviousObjectSinkNode().setNextObjectSinkNode(node.getNextObjectSinkNode());
            node.getNextObjectSinkNode().setPreviousObjectSinkNode(node.getPreviousObjectSinkNode());
            --this.size;
            node.setPreviousObjectSinkNode(null);
            node.setNextObjectSinkNode(null);
        } else if (this.firstNode == node) {
            this.removeFirst();
        } else {
            this.removeLast();
        }
    }

    public final ObjectSinkNode getFirst() {
        return this.firstNode;
    }

    public final ObjectSinkNode getLast() {
        return this.lastNode;
    }

    public ObjectSinkNode removeFirst() {
        if (this.firstNode == null) {
            return null;
        }
        ObjectSinkNode node = this.firstNode;
        this.firstNode = node.getNextObjectSinkNode();
        node.setNextObjectSinkNode(null);
        if (this.firstNode != null) {
            this.firstNode.setPreviousObjectSinkNode(null);
        } else {
            this.lastNode = null;
        }
        --this.size;
        return node;
    }

    public ObjectSinkNode removeLast() {
        if (this.lastNode == null) {
            return null;
        }
        ObjectSinkNode node = this.lastNode;
        this.lastNode = node.getPreviousObjectSinkNode();
        node.setPreviousObjectSinkNode(null);
        if (this.lastNode != null) {
            this.lastNode.setNextObjectSinkNode(null);
        } else {
            this.firstNode = this.lastNode;
        }
        --this.size;
        return node;
    }

    public final boolean isEmpty() {
        return this.firstNode == null;
    }

    public void clear() {
        while (this.removeFirst() != null) {
        }
    }

    public final int size() {
        return this.size;
    }

    public Iterator iterator() {
        return new Iterator(){
            private ObjectSinkNode currentNode = null;
            private ObjectSinkNode nextNode = ObjectSinkNodeList.this.getFirst();

            @Override
            public boolean hasNext() {
                return this.nextNode != null;
            }

            public Object next() {
                this.currentNode = this.nextNode;
                if (this.currentNode == null) {
                    throw new NoSuchElementException("No more elements to return");
                }
                this.nextNode = this.currentNode.getNextObjectSinkNode();
                return this.currentNode;
            }

            @Override
            public void remove() {
                if (this.currentNode == null) {
                    throw new IllegalStateException("No item to remove. Call next() before calling remove().");
                }
                ObjectSinkNodeList.this.remove(this.currentNode);
                this.currentNode = null;
            }
        };
    }
}

