/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;

public class DiscoverySettings {
    public static final Setting<TimeValue> PUBLISH_TIMEOUT_SETTING = Setting.positiveTimeSetting("discovery.zen.publish_timeout", TimeValue.timeValueSeconds((long)30L), Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<TimeValue> COMMIT_TIMEOUT_SETTING = new Setting<TimeValue>("discovery.zen.commit_timeout", PUBLISH_TIMEOUT_SETTING::getRaw, s -> TimeValue.parseTimeValue((String)s, (TimeValue)TimeValue.timeValueSeconds((long)30L), (String)"discovery.zen.commit_timeout"), Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<Boolean> PUBLISH_DIFF_ENABLE_SETTING = Setting.boolSetting("discovery.zen.publish_diff.enable", true, Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<TimeValue> INITIAL_STATE_TIMEOUT_SETTING = Setting.positiveTimeSetting("discovery.initial_state_timeout", TimeValue.timeValueSeconds((long)30L), Setting.Property.NodeScope);
    private volatile TimeValue publishTimeout;
    private volatile TimeValue commitTimeout;
    private volatile boolean publishDiff;

    public DiscoverySettings(Settings settings, ClusterSettings clusterSettings) {
        clusterSettings.addSettingsUpdateConsumer(PUBLISH_DIFF_ENABLE_SETTING, this::setPublishDiff);
        clusterSettings.addSettingsUpdateConsumer(COMMIT_TIMEOUT_SETTING, this::setCommitTimeout);
        clusterSettings.addSettingsUpdateConsumer(PUBLISH_TIMEOUT_SETTING, this::setPublishTimeout);
        this.publishTimeout = PUBLISH_TIMEOUT_SETTING.get(settings);
        this.commitTimeout = COMMIT_TIMEOUT_SETTING.get(settings);
        this.publishDiff = PUBLISH_DIFF_ENABLE_SETTING.get(settings);
    }

    public TimeValue getPublishTimeout() {
        return this.publishTimeout;
    }

    public TimeValue getCommitTimeout() {
        return this.commitTimeout;
    }

    private void setPublishDiff(boolean publishDiff) {
        this.publishDiff = publishDiff;
    }

    private void setPublishTimeout(TimeValue publishTimeout) {
        this.publishTimeout = publishTimeout;
    }

    private void setCommitTimeout(TimeValue commitTimeout) {
        this.commitTimeout = commitTimeout;
    }

    public boolean getPublishDiff() {
        return this.publishDiff;
    }
}

