/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Arrays;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.ShapeQuery;
import org.apache.lucene.geo.Polygon2D;
import org.apache.lucene.geo.XYEncodingUtils;
import org.apache.lucene.geo.XYPolygon;
import org.apache.lucene.geo.XYPolygon2D;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.NumericUtils;

final class XYShapePolygonQuery
extends ShapeQuery {
    final XYPolygon[] polygons;
    private final Polygon2D poly2D;

    public XYShapePolygonQuery(String field, ShapeField.QueryRelation queryRelation, XYPolygon ... polygons) {
        super(field, queryRelation);
        if (polygons == null) {
            throw new IllegalArgumentException("polygons must not be null");
        }
        if (polygons.length == 0) {
            throw new IllegalArgumentException("polygons must not be empty");
        }
        for (int i = 0; i < polygons.length; ++i) {
            if (polygons[i] == null) {
                throw new IllegalArgumentException("polygon[" + i + "] must not be null");
            }
            if (polygons[i].minX > polygons[i].maxX) {
                throw new IllegalArgumentException("XYShapePolygonQuery: minX cannot be greater than maxX.");
            }
            if (!(polygons[i].minY > polygons[i].maxY)) continue;
            throw new IllegalArgumentException("XYShapePolygonQuery: minY cannot be greater than maxY.");
        }
        this.polygons = (XYPolygon[])polygons.clone();
        this.poly2D = XYPolygon2D.create(polygons);
    }

    @Override
    protected PointValues.Relation relateRangeBBoxToQuery(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        double minLat = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt((byte[])minTriangle, (int)minYOffset));
        double minLon = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt((byte[])minTriangle, (int)minXOffset));
        double maxLat = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt((byte[])maxTriangle, (int)maxYOffset));
        double maxLon = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt((byte[])maxTriangle, (int)maxXOffset));
        return this.poly2D.relate(minLat, maxLat, minLon, maxLon);
    }

    @Override
    protected boolean queryMatches(byte[] t, int[] scratchTriangle, ShapeField.QueryRelation queryRelation) {
        ShapeField.decodeTriangle(t, scratchTriangle);
        double alat = XYEncodingUtils.decode(scratchTriangle[0]);
        double alon = XYEncodingUtils.decode(scratchTriangle[1]);
        double blat = XYEncodingUtils.decode(scratchTriangle[2]);
        double blon = XYEncodingUtils.decode(scratchTriangle[3]);
        double clat = XYEncodingUtils.decode(scratchTriangle[4]);
        double clon = XYEncodingUtils.decode(scratchTriangle[5]);
        if (queryRelation == ShapeField.QueryRelation.WITHIN) {
            return this.poly2D.relateTriangle(alon, alat, blon, blat, clon, clat) == PointValues.Relation.CELL_INSIDE_QUERY;
        }
        return this.poly2D.relateTriangle(alon, alat, blon, blat, clon, clat) != PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("XYPolygon(").append(this.polygons[0].toGeoJSON()).append(")");
        return sb.toString();
    }

    @Override
    protected boolean equalsTo(Object o) {
        return super.equalsTo(o) && Arrays.equals(this.polygons, ((XYShapePolygonQuery)((Object)o)).polygons);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.polygons);
        return hash;
    }
}

