/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import com.ibm.wsdl.util.xml.DOM2Writer;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.TestUtils;
import org.eclipse.wst.wsi.internal.core.util.Utils;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BP1701
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1701(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        if (this.validator.isOneWayResponse(entryContext)) {
            this.result = "notApplicable";
        } else {
            try {
                Document doc = XMLUtils.parseXML(entryContext.getMessageEntry().getMessage());
                NodeList elementList = doc.getElementsByTagName("*");
                if (elementList != null) {
                    int i = 0;
                    while (i < elementList.getLength()) {
                        Element element = (Element)elementList.item(i);
                        element.removeAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                        ++i;
                    }
                }
                String filteredMessage = DOM2Writer.nodeToString((Node)doc);
                XMLUtils.parseXML(filteredMessage, TestUtils.getSOAPSchemaLocation());
            }
            catch (WSIException e) {
                if (e.getTargetException() instanceof SAXException) {
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail(Utils.getExceptionDetails(e.getTargetException()), entryContext);
                }
            }
            catch (Exception e) {
                this.result = "failed";
                this.failureDetail = this.validator.createFailureDetail(Utils.getExceptionDetails(e), entryContext);
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

