/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.actions;

import org.eclipse.datatools.sqltools.sqleditor.internal.actions.CopyToClipboardAction;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.CutAction;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.DeleteAction;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.PasteAction;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;

public class CCPActionGroup
extends ActionGroup {
    private IWorkbenchSite _fSite;
    private Clipboard _fClipboard;
    private SelectionDispatchAction[] _fActions;
    private SelectionDispatchAction _fDeleteAction;
    private SelectionDispatchAction _fCopyAction;
    private SelectionDispatchAction _fPasteAction;
    private SelectionDispatchAction _fCutAction;

    public CCPActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite());
    }

    public CCPActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    private CCPActionGroup(IWorkbenchSite site) {
        this._fSite = site;
        this._fClipboard = new Clipboard(site.getShell().getDisplay());
        this._fPasteAction = new PasteAction(this._fSite, this._fClipboard);
        this._fPasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this._fCopyAction = new CopyToClipboardAction(this._fSite, this._fClipboard, this._fPasteAction);
        this._fCopyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this._fCutAction = new CutAction(this._fSite, this._fClipboard, this._fPasteAction);
        this._fCutAction.setActionDefinitionId("org.eclipse.ui.edit.cut");
        this._fDeleteAction = new DeleteAction(this._fSite);
        this._fDeleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this._fActions = new SelectionDispatchAction[]{this._fCutAction, this._fCopyAction, this._fPasteAction, this._fDeleteAction};
        this.registerActionsAsSelectionChangeListeners();
    }

    private void registerActionsAsSelectionChangeListeners() {
        ISelectionProvider provider = this._fSite.getSelectionProvider();
        int i = 0;
        while (i < this._fActions.length) {
            provider.addSelectionChangedListener((ISelectionChangedListener)this._fActions[i]);
            ++i;
        }
    }

    private void deregisterActionsAsSelectionChangeListeners() {
        ISelectionProvider provider = this._fSite.getSelectionProvider();
        int i = 0;
        while (i < this._fActions.length) {
            provider.removeSelectionChangedListener((ISelectionChangedListener)this._fActions[i]);
            ++i;
        }
    }

    public IAction getDeleteAction() {
        return this._fDeleteAction;
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this._fDeleteAction);
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this._fCopyAction);
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this._fCutAction);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this._fPasteAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        int i = 0;
        while (i < this._fActions.length) {
            SelectionDispatchAction action = this._fActions[i];
            menu.add((IAction)action);
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
        if (this._fClipboard != null) {
            this._fClipboard.dispose();
            this._fClipboard = null;
        }
        this.deregisterActionsAsSelectionChangeListeners();
    }
}

