/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.floatingpoint;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPAbstractPane;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPAddressPane;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPDataPane;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPIMemorySelection;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPIViewportCache;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPMemoryByte;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPRendering;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPRenderingMessages;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPRenderingPlugin;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPutilities;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.renderings.GoToAddressComposite;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class Rendering
extends Composite
implements IDebugEventSetListener {
    private FPRendering fParent;
    protected FPAddressPane fAddressPane;
    protected FPDataPane fDataPane;
    private GoToAddressComposite fAddressBar;
    protected Control fAddressBarControl;
    private Selection fSelection = new Selection();
    BigInteger fViewportAddress = null;
    BigInteger fMemoryBlockStartAddress = null;
    BigInteger fMemoryBlockEndAddress = null;
    protected BigInteger fBaseAddress = null;
    protected int fColumnCount = 0;
    protected int fBytesPerRow = 0;
    int fScrollSelection = 0;
    private BigInteger fCaretAddress = null;
    private boolean fCellEditState = false;
    private BigInteger cellEditAddress = null;
    private BigInteger memoryAddress = null;
    private StringBuffer fEditBuffer = null;
    static boolean initialDisplayModeSet = false;
    public static final int PANE_ADDRESS = 1;
    public static final int PANE_DATA = 2;
    private static final MathContext SCROLL_CONVERSION_PRECISION = new MathContext(2);
    public static final int TEXT_ISO_8859_1 = 1;
    public static final int TEXT_USASCII = 2;
    public static final int TEXT_UTF8 = 3;
    protected static final int TEXT_UTF16 = 4;
    public static final int COLUMNS_AUTO_SIZE_TO_FIT = 0;
    private int fCellPadding = 2;
    private int fPaneSpacing = 16;
    private String fPaddingString = " ";
    private boolean fCacheDirty = false;
    public static final int UPDATE_ALWAYS = 1;
    public static final int UPDATE_ON_BREAKPOINT = 2;
    public static final int UPDATE_MANUAL = 3;
    public int fUpdateMode = 1;
    private static final int DECIMAL_POINT_SIZE = 1;
    private static final int SIGN_SIZE = 1;
    private static final int EXPONENT_CHARACTER_SIZE = 1;
    private static final int EXPONENT_VALUE_SIZE = 3;
    private FPutilities.FPDataType fFPDataType = FPutilities.FPDataType.FLOAT;
    private int fDisplayedPrecision = 8;
    private int fCharsPerColumn = this.charsPerColumn();
    private int fColumnsSetting = 0;
    private boolean fIsTargetLittleEndian = true;
    private boolean fIsDisplayLittleEndian = true;
    private boolean fEditInserMode = false;
    static int suspendCount = 0;
    ViewportCache fViewportCache = new ViewportCache();

    public Rendering(Composite parent, FPRendering renderingParent) {
        super(parent, 537133824);
        this.setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.MemoryViewTableFont"));
        this.fParent = renderingParent;
        if (this.fParent.getMemoryBlock() != null) {
            BigInteger base = this.fParent.getBigBaseAddress();
            this.fViewportAddress = this.fParent.getMemoryBlockStartAddress();
            if (this.fViewportAddress == null) {
                this.fViewportAddress = base;
            } else {
                BigInteger blockEndAddr = this.fParent.getMemoryBlockEndAddress();
                if (base.compareTo(this.fViewportAddress) > 0 && (blockEndAddr == null || base.compareTo(blockEndAddr) < 0)) {
                    this.fViewportAddress = base;
                }
            }
            this.fBaseAddress = this.fViewportAddress;
        }
        this.fAddressPane = this.createAddressPane();
        this.fDataPane = this.createDataPane();
        this.fAddressBar = new GoToAddressComposite();
        this.fAddressBarControl = this.fAddressBar.createControl(parent);
        Button button = this.fAddressBar.getButton(0);
        if (button != null) {
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Rendering.this.doGoToAddress();
                }
            });
            button = this.fAddressBar.getButton(1);
            if (button != null) {
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Rendering.this.setVisibleAddressBar(false);
                    }
                });
            }
        }
        this.fAddressBar.getExpressionWidget().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                Rendering.this.doGoToAddress();
            }
        });
        this.fAddressBar.getExpressionWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    Rendering.this.setVisibleAddressBar(false);
                }
                super.keyPressed(e);
            }
        });
        this.fAddressBarControl.setVisible(false);
        this.getHorizontalBar().addSelectionListener(this.createHorizontalBarSelectionListener());
        this.getVerticalBar().addSelectionListener(this.createVerticalBarSelectinListener());
        this.addPaintListener(pe -> {
            pe.gc.setBackground(this.getFPRendering().getColorBackground());
            pe.gc.fillRectangle(0, 0, this.getBounds().width, this.getBounds().height);
        });
        this.setLayout();
        this.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent ce) {
            }

            public void controlResized(ControlEvent ce) {
                Rendering.this.packColumns();
            }
        });
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    private int charsPerColumn() {
        return this.fDisplayedPrecision + 1 + 1 + 1 + 3 + this.fCellPadding;
    }

    protected void setLayout() {
        this.setLayout(new Layout(){

            public void layout(Composite composite, boolean changed) {
                int xOffset = 0;
                if (Rendering.this.getHorizontalBar().isVisible()) {
                    xOffset = Rendering.this.getHorizontalBar().getSelection();
                }
                int x = xOffset * -1;
                int y = 0;
                if (Rendering.this.fAddressBarControl.isVisible()) {
                    Rendering.this.fAddressBarControl.setBounds(0, 0, Rendering.this.getBounds().width, Rendering.this.fAddressBarControl.computeSize((int)100, (int)30).y);
                }
                if (Rendering.this.fAddressPane.isPaneVisible()) {
                    Rendering.this.fAddressPane.setBounds(x, y, Rendering.this.fAddressPane.computeSize((int)0, (int)0).x, Rendering.this.getBounds().height - y);
                    x = Rendering.this.fAddressPane.getBounds().x + Rendering.this.fAddressPane.getBounds().width;
                }
                if (Rendering.this.fDataPane.isPaneVisible()) {
                    Rendering.this.fDataPane.setBounds(x, y, Rendering.this.fDataPane.computeSize((int)0, (int)0).x, Rendering.this.getBounds().height - y);
                    x = Rendering.this.fDataPane.getBounds().x + Rendering.this.fDataPane.getBounds().width;
                }
                ScrollBar horizontal = Rendering.this.getHorizontalBar();
                horizontal.setVisible(true);
                horizontal.setMinimum(0);
                horizontal.setMaximum(Rendering.this.fDataPane.getBounds().x + Rendering.this.fDataPane.getBounds().width + xOffset);
                int temp = horizontal.getMaximum();
                horizontal.setThumb(Rendering.this.getClientArea().width);
                horizontal.setPageIncrement(40);
                horizontal.setIncrement(20);
            }

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                return new Point(100, 100);
            }
        });
    }

    protected void handleDownArrow() {
        this.fViewportAddress = this.fViewportAddress.add(BigInteger.valueOf(this.getAddressableCellsPerRow()));
        this.ensureViewportAddressDisplayable();
        this.redrawPanes();
    }

    protected void handleUpArrow() {
        this.fViewportAddress = this.fViewportAddress.subtract(BigInteger.valueOf(this.getAddressableCellsPerRow()));
        this.ensureViewportAddressDisplayable();
        this.redrawPanes();
    }

    protected void handlePageDown() {
        this.fViewportAddress = this.fViewportAddress.add(BigInteger.valueOf(this.getAddressableCellsPerRow() * (this.getRowCount() - 1)));
        this.ensureViewportAddressDisplayable();
        this.redrawPanes();
    }

    protected void handlePageUp() {
        this.fViewportAddress = this.fViewportAddress.subtract(BigInteger.valueOf(this.getAddressableCellsPerRow() * (this.getRowCount() - 1)));
        this.ensureViewportAddressDisplayable();
        this.redrawPanes();
    }

    protected SelectionListener createHorizontalBarSelectionListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent se) {
                Rendering.this.layout();
            }

            public void widgetDefaultSelected(SelectionEvent se) {
            }
        };
    }

    protected SelectionListener createVerticalBarSelectinListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent se) {
                switch (se.detail) {
                    case 0x1000002: {
                        Rendering.this.handleDownArrow();
                        break;
                    }
                    case 0x1000006: {
                        Rendering.this.handlePageDown();
                        break;
                    }
                    case 0x1000001: {
                        Rendering.this.handleUpArrow();
                        break;
                    }
                    case 0x1000005: {
                        Rendering.this.handlePageUp();
                        break;
                    }
                    default: {
                        if (Rendering.this.getVerticalBar().getSelection() == Rendering.this.getVerticalBar().getMinimum()) {
                            Rendering.this.fViewportAddress = Rendering.this.getMemoryBlockStartAddress();
                        } else if (Rendering.this.getVerticalBar().getSelection() == Rendering.this.getVerticalBar().getMaximum()) {
                            Rendering.this.fViewportAddress = Rendering.this.getMemoryBlockEndAddress();
                        } else {
                            BigInteger newAddress;
                            int deltaScroll = Rendering.this.getVerticalBar().getSelection() - Rendering.this.fScrollSelection;
                            if (deltaScroll == 0) break;
                            BigInteger deltaRows = Rendering.this.scrollbar2rows(deltaScroll);
                            Rendering.this.fViewportAddress = newAddress = Rendering.this.fViewportAddress.add(BigInteger.valueOf(Rendering.this.getAddressableCellsPerRow()).multiply(deltaRows));
                        }
                        Rendering.this.ensureViewportAddressDisplayable();
                        if (Rendering.this.fAddressPane.isPaneVisible()) {
                            Rendering.this.fAddressPane.redraw();
                        }
                        Rendering.this.redrawPanes();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent se) {
            }
        };
    }

    protected FPAddressPane createAddressPane() {
        return new FPAddressPane(this);
    }

    protected FPDataPane createDataPane() {
        return new FPDataPane(this);
    }

    public FPRendering getFPRendering() {
        return this.fParent;
    }

    protected void setCaretAddress(BigInteger address) {
        this.fCaretAddress = address;
    }

    protected BigInteger getCaretAddress() {
        return this.fCaretAddress != null ? this.fCaretAddress : this.fViewportAddress;
    }

    void doGoToAddress() {
        try {
            BigInteger address = this.fAddressBar.getGoToAddress(this.getMemoryBlockStartAddress(), this.getCaretAddress());
            this.getFPRendering().gotoAddress(address);
            this.setVisibleAddressBar(false);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void ensureViewportAddressDisplayable() {
        if (this.fViewportAddress.compareTo(this.getMemoryBlockStartAddress()) < 0) {
            this.fViewportAddress = this.getMemoryBlockStartAddress();
        } else if (this.getViewportEndAddress().compareTo(this.getMemoryBlockEndAddress().add(BigInteger.ONE)) > 0) {
            this.fViewportAddress = this.getMemoryBlockEndAddress().subtract(BigInteger.valueOf(this.getAddressableCellsPerRow() * this.getRowCount() - 1));
        }
        this.setScrollSelection();
    }

    public FPIMemorySelection getSelection() {
        return this.fSelection;
    }

    protected int getHistoryDepth() {
        return this.fViewportCache.getHistoryDepth();
    }

    protected void setHistoryDepth(int depth) {
        this.fViewportCache.setHistoryDepth(depth);
    }

    public void logError(String message, Exception e) {
        Status status = new Status(4, this.fParent.getRenderingId(), 5013, message, (Throwable)e);
        FPRenderingPlugin.getDefault().getLog().log((IStatus)status);
    }

    public void handleFontPreferenceChange(Font font) {
        this.setFont(font);
        FPAbstractPane[] controls = this.getRenderingPanes();
        int index = 0;
        while (index < controls.length) {
            controls[index].setFont(font);
            ++index;
        }
        this.packColumns();
        this.layout(true);
    }

    public void setPaddingString(String padding) {
        this.fPaddingString = padding;
        this.refresh();
    }

    public char getPaddingCharacter() {
        return this.fPaddingString.charAt(0);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        if (this.isDisposed()) {
            return;
        }
        boolean isChangeOnly = false;
        boolean isSuspend = false;
        boolean isBreakpointHit = false;
        int index = 0;
        while (index < events.length) {
            if (events[0].getSource() instanceof IDebugElement) {
                int kind = events[index].getKind();
                int detail = events[index].getDetail();
                IDebugElement source = (IDebugElement)events[index].getSource();
                if (source.equals(this.getMemoryBlock()) && source.getDebugTarget() == this.getMemoryBlock().getDebugTarget()) {
                    if ((detail & 0x10) != 0) {
                        isBreakpointHit = true;
                    }
                    if (kind == 2) {
                        this.handleSuspendEvent(detail);
                        isSuspend = true;
                    } else if (kind == 16) {
                        this.handleChangeEvent();
                        isChangeOnly = true;
                    }
                }
            }
            ++index;
        }
        if (isSuspend) {
            this.handleSuspend(isBreakpointHit);
        } else if (isChangeOnly) {
            this.handleChange();
        }
    }

    protected void handleSuspend(boolean isBreakpointHit) {
        if (this.getUpdateMode() == 1 || this.getUpdateMode() == 2 && isBreakpointHit) {
            Display.getDefault().asyncExec(() -> {
                this.archiveDeltas();
                this.refresh();
            });
        }
    }

    protected void handleChange() {
        if (this.getUpdateMode() == 1) {
            Display.getDefault().asyncExec(() -> this.refresh());
        }
    }

    protected void handleSuspendEvent(int detail) {
    }

    protected void handleChangeEvent() {
    }

    public boolean isDebug() {
        return false;
    }

    protected IMemoryBlockExtension getMemoryBlock() {
        IMemoryBlock block = this.fParent.getMemoryBlock();
        if (block != null) {
            return (IMemoryBlockExtension)block.getAdapter(IMemoryBlockExtension.class);
        }
        return null;
    }

    public BigInteger getBigBaseAddress() {
        return this.fParent.getBigBaseAddress();
    }

    public int getAddressableSize() {
        return this.fParent.getAddressableSize();
    }

    protected FPIViewportCache getViewportCache() {
        return this.fViewportCache;
    }

    public FPMemoryByte[] getBytes(BigInteger address, int bytes) throws DebugException {
        return this.getViewportCache().getBytes(address, bytes);
    }

    public void setVisibleAddressBar(boolean visible) {
        this.fAddressBarControl.setVisible(visible);
        if (visible) {
            String selectedStr = "0x" + this.getCaretAddress().toString(16);
            Text text = this.fAddressBar.getExpressionWidget();
            text.setText(selectedStr);
            text.setSelection(0, text.getCharCount());
            this.fAddressBar.getExpressionWidget().setFocus();
        }
        this.layout(true);
        this.layoutPanes();
    }

    public void setDirty(boolean needRefresh) {
        this.fCacheDirty = needRefresh;
    }

    public boolean isDirty() {
        return this.fCacheDirty;
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        if (this.fViewportCache != null) {
            this.fViewportCache.dispose();
            this.fViewportCache = null;
        }
        super.dispose();
    }

    public void setPaneVisible(int pane, boolean visible) {
        switch (pane) {
            case 1: {
                this.fAddressPane.setPaneVisible(visible);
                break;
            }
            case 2: {
                this.fDataPane.setPaneVisible(visible);
            }
        }
        this.fireSettingsChanged();
        this.layoutPanes();
    }

    public boolean getPaneVisible(int pane) {
        switch (pane) {
            case 1: {
                return this.fAddressPane.isPaneVisible();
            }
            case 2: {
                return this.fDataPane.isPaneVisible();
            }
        }
        return false;
    }

    protected void packColumns() {
        int availableWidth = this.getSize().x;
        if (this.fAddressPane.isPaneVisible()) {
            availableWidth -= this.fAddressPane.computeSize((int)0, (int)0).x;
            availableWidth -= this.getRenderSpacing() * 2;
        }
        int combinedWidth = 0;
        if (this.fDataPane.isPaneVisible()) {
            combinedWidth += this.fDataPane.getCellWidth();
        }
        if (this.getColumnsSetting() == 0) {
            if (combinedWidth == 0) {
                this.fColumnCount = 0;
            } else {
                this.fColumnCount = availableWidth / combinedWidth;
                if (this.fColumnCount == 0) {
                    this.fColumnCount = 1;
                }
            }
        } else {
            this.fColumnCount = this.getColumnsSetting();
        }
        try {
            this.fBytesPerRow = this.getCharsPerColumn() * this.getColumnCount();
            this.getVerticalBar().setMinimum(1);
            this.getVerticalBar().setMaximum(this.getMaxScrollRange().min(BigInteger.valueOf(Integer.MAX_VALUE)).intValue());
            this.getVerticalBar().setIncrement(1);
            this.getVerticalBar().setPageIncrement(this.getRowCount() - 1);
            this.setScrollSelection();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.redraw();
        this.redrawPanes();
    }

    public FPAbstractPane[] getRenderingPanes() {
        return new FPAbstractPane[]{this.fAddressPane, this.fDataPane};
    }

    public int getCellPadding() {
        return this.fCellPadding;
    }

    protected int getRenderSpacing() {
        return this.fPaneSpacing;
    }

    public void refresh() {
        if (!this.isDisposed()) {
            if (this.isVisible() && this.getViewportCache() != null) {
                this.getViewportCache().refresh();
            } else {
                this.setDirty(true);
                this.fParent.updateRenderingLabels();
            }
        }
    }

    protected void archiveDeltas() {
        this.getViewportCache().archiveDeltas();
    }

    public void gotoAddress(BigInteger address) {
        if (address.compareTo(this.getMemoryBlockStartAddress()) < 0 || address.compareTo(this.getMemoryBlockEndAddress()) > 0) {
            return;
        }
        this.fViewportAddress = address;
        this.fCaretAddress = null;
        this.fSelection = new Selection();
        this.redrawPanes();
    }

    public void setViewportStartAddress(BigInteger newAddress) {
        this.fViewportAddress = newAddress;
    }

    public BigInteger getViewportStartAddress() {
        return this.fViewportAddress;
    }

    public BigInteger getViewportEndAddress() {
        return this.fViewportAddress.add(BigInteger.valueOf(this.getBytesPerRow() * this.getRowCount() / this.getAddressableSize()));
    }

    public String getAddressString(BigInteger address) {
        StringBuffer addressString = new StringBuffer(address.toString(16).toUpperCase());
        int chars = this.getAddressBytes() * 2 - addressString.length();
        while (chars > 0) {
            addressString.insert(0, '0');
            --chars;
        }
        addressString.insert(0, "0x");
        return addressString.toString();
    }

    protected int getAddressBytes() {
        return this.fParent.getAddressSize();
    }

    public Control getAddressBarControl() {
        return this.fAddressBarControl;
    }

    public int getColumnCount() {
        return this.fColumnCount;
    }

    public int getColumnsSetting() {
        return this.fColumnsSetting;
    }

    protected void setBytesPerRow(int count) {
        this.fBytesPerRow = count;
    }

    protected void setColumnCount(int count) {
        this.fColumnCount = count;
    }

    public void setColumnsSetting(int columns) {
        if (this.fColumnsSetting != columns) {
            this.fColumnsSetting = columns;
            this.fireSettingsChanged();
            this.layoutPanes();
        }
    }

    protected void ensureVisible(BigInteger address) {
        boolean isAddressAfterViewportEnd;
        BigInteger viewportStart = this.getViewportStartAddress();
        BigInteger viewportEnd = this.getViewportEndAddress();
        boolean isAddressBeforeViewportStart = address.compareTo(viewportStart) < 0;
        boolean bl = isAddressAfterViewportEnd = address.compareTo(viewportEnd) > 0;
        if (isAddressBeforeViewportStart || isAddressAfterViewportEnd) {
            this.gotoAddress(address);
        }
    }

    protected int getRowCount() {
        int rowCount = 0;
        FPAbstractPane[] panes = this.getRenderingPanes();
        int i = 0;
        while (i < panes.length) {
            if (panes[i] instanceof FPAbstractPane) {
                rowCount = Math.max(rowCount, panes[i].getRowCount());
            }
            ++i;
        }
        return rowCount;
    }

    protected int getBytesPerRow() {
        return this.fBytesPerRow;
    }

    protected int getAddressableCellsPerRow() {
        return this.getBytesPerRow() / this.getAddressableSize();
    }

    public int getAddressesPerColumn() {
        return this.getCharsPerColumn() / this.getAddressableSize();
    }

    protected void setScrollSelection() {
        BigInteger selection = this.getViewportStartAddress().divide(BigInteger.valueOf(this.getAddressableCellsPerRow()));
        this.fScrollSelection = this.rows2scrollbar(selection);
        this.getVerticalBar().setSelection(this.fScrollSelection);
    }

    private BigInteger getMaxScrollRange() {
        BigInteger difference = this.getMemoryBlockEndAddress().subtract(this.getMemoryBlockStartAddress()).add(BigInteger.ONE);
        BigInteger maxScrollRange = difference.divide(BigInteger.valueOf(this.getAddressableCellsPerRow()));
        if (maxScrollRange.multiply(BigInteger.valueOf(this.getAddressableCellsPerRow())).compareTo(difference) != 0) {
            maxScrollRange = maxScrollRange.add(BigInteger.ONE);
        }
        maxScrollRange = maxScrollRange.divide(BigInteger.valueOf(this.getAddressableSize()));
        return maxScrollRange;
    }

    private final BigDecimal getScrollRatio() {
        BigInteger maxRange = this.getMaxScrollRange();
        if (maxRange.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            return new BigDecimal(maxRange).divide(BigDecimal.valueOf(Integer.MAX_VALUE), SCROLL_CONVERSION_PRECISION);
        }
        return BigDecimal.ONE;
    }

    private int rows2scrollbar(BigInteger rows) {
        return new BigDecimal(rows).divide(this.getScrollRatio(), SCROLL_CONVERSION_PRECISION).intValue();
    }

    BigInteger scrollbar2rows(int scrollbarUnits) {
        return this.getScrollRatio().multiply(BigDecimal.valueOf(scrollbarUnits), SCROLL_CONVERSION_PRECISION).toBigInteger();
    }

    protected BigInteger getMemoryBlockStartAddress() {
        if (this.fMemoryBlockStartAddress == null) {
            this.fMemoryBlockStartAddress = this.fParent.getMemoryBlockStartAddress();
        }
        if (this.fMemoryBlockStartAddress == null) {
            this.fMemoryBlockStartAddress = BigInteger.ZERO;
        }
        return this.fMemoryBlockStartAddress;
    }

    protected BigInteger getMemoryBlockEndAddress() {
        if (this.fMemoryBlockEndAddress == null) {
            this.fMemoryBlockEndAddress = this.fParent.getMemoryBlockEndAddress();
        }
        return this.fMemoryBlockEndAddress;
    }

    public FPutilities.FPDataType getFPDataType() {
        return this.fFPDataType;
    }

    public void setFPDataType(FPutilities.FPDataType numberType) {
        if (this.fFPDataType == numberType) {
            return;
        }
        this.fFPDataType = numberType;
        this.fireSettingsChanged();
        this.layoutPanes();
    }

    public int getUpdateMode() {
        return this.fUpdateMode;
    }

    public void setUpdateMode(int fUpdateMode) {
        this.fUpdateMode = fUpdateMode;
    }

    protected String getCharacterSet(int mode) {
        switch (mode) {
            case 3: {
                return "UTF8";
            }
            case 4: {
                return "UTF16";
            }
            case 2: {
                return "US-ASCII";
            }
        }
        return "ISO-8859-1";
    }

    public int getBytesPerCharacter() {
        return 1;
    }

    public boolean isTargetLittleEndian() {
        return this.fIsTargetLittleEndian;
    }

    public void setTargetLittleEndian(boolean littleEndian) {
        if (this.fIsTargetLittleEndian == littleEndian) {
            return;
        }
        this.fParent.setTargetMemoryLittleEndian(littleEndian);
        this.fIsTargetLittleEndian = littleEndian;
        Display.getDefault().asyncExec(() -> {
            this.fireSettingsChanged();
            this.layoutPanes();
        });
    }

    public boolean isDisplayLittleEndian() {
        return this.fIsDisplayLittleEndian;
    }

    public void setDisplayLittleEndian(boolean isLittleEndian) {
        if (this.fIsDisplayLittleEndian == isLittleEndian) {
            return;
        }
        this.fIsDisplayLittleEndian = isLittleEndian;
        this.fireSettingsChanged();
        Display.getDefault().asyncExec(() -> this.layoutPanes());
    }

    public int getCharsPerColumn() {
        return this.fCharsPerColumn;
    }

    public int getDisplayedPrecision() {
        return this.fDisplayedPrecision;
    }

    public void setDisplayedPrecision(int displayedPrecision) {
        if (this.fDisplayedPrecision != displayedPrecision) {
            this.fDisplayedPrecision = displayedPrecision;
            this.fCharsPerColumn = this.charsPerColumn();
            this.fireSettingsChanged();
            this.layoutPanes();
        }
    }

    protected void redrawPane(int paneId) {
        if (!this.isDisposed() && this.isVisible()) {
            FPAbstractPane pane = null;
            if (paneId == 1) {
                pane = this.fAddressPane;
            } else if (paneId == 2) {
                pane = this.fDataPane;
            }
            if (pane != null && pane.isPaneVisible()) {
                pane.redraw();
                pane.setRowCount();
                if (pane.isFocusControl()) {
                    pane.updateTheCaret();
                }
            }
        }
        this.fParent.updateRenderingLabels();
    }

    protected void redrawPanes() {
        if (!this.isDisposed() && this.isVisible()) {
            if (this.fAddressPane.isPaneVisible()) {
                this.fAddressPane.redraw();
                this.fAddressPane.setRowCount();
                if (this.fAddressPane.isFocusControl()) {
                    this.fAddressPane.updateTheCaret();
                }
            }
            if (this.fDataPane.isPaneVisible()) {
                this.fDataPane.redraw();
                this.fDataPane.setRowCount();
                if (this.fDataPane.isFocusControl()) {
                    this.fDataPane.updateTheCaret();
                }
            }
        }
        this.fParent.updateRenderingLabels();
    }

    void layoutPanes() {
        this.packColumns();
        this.layout(true);
        this.redraw();
        this.redrawPanes();
    }

    void fireSettingsChanged() {
        this.fAddressPane.settingsChanged();
        this.fDataPane.settingsChanged();
    }

    protected void copyAddressToClipboard() {
        Clipboard clip = null;
        try {
            clip = new Clipboard(this.getDisplay());
            String addressString = "0x" + this.getCaretAddress().toString(16);
            TextTransfer plainTextTransfer = TextTransfer.getInstance();
            clip.setContents(new Object[]{addressString}, new Transfer[]{plainTextTransfer});
        }
        finally {
            if (clip != null) {
                clip.dispose();
            }
        }
    }

    public String sciNotationString(FPMemoryByte[] byteArray, FPutilities.FPDataType fpDataType, boolean isLittleEndian) {
        ByteOrder byteOrder;
        StringBuffer textString = null;
        int index = 0;
        while (index < byteArray.length) {
            if (!byteArray[index].isReadable()) {
                return FPutilities.fillString(this.fCharsPerColumn, '?');
            }
            ++index;
        }
        ByteOrder byteOrder2 = byteOrder = isLittleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        if (fpDataType == FPutilities.FPDataType.FLOAT) {
            float floatValue = ByteBuffer.wrap(FPutilities.memoryBytesToByteArray(byteArray)).order(byteOrder).getFloat();
            if ((floatValue = FPutilities.floatLimitCheck(floatValue)) == Float.NEGATIVE_INFINITY) {
                textString = new StringBuffer("-Infinity");
            }
            if (floatValue == Float.POSITIVE_INFINITY) {
                textString = new StringBuffer(" Infinity");
            }
        }
        if (fpDataType == FPutilities.FPDataType.DOUBLE) {
            double doubleValue = ByteBuffer.wrap(FPutilities.memoryBytesToByteArray(byteArray)).order(byteOrder).getDouble();
            if ((doubleValue = FPutilities.doubleLimitCheck(doubleValue)) == Double.NEGATIVE_INFINITY) {
                textString = new StringBuffer("-Infinity");
            }
            if (doubleValue == Double.POSITIVE_INFINITY) {
                textString = new StringBuffer(" Infinity");
            }
        }
        if (textString == null) {
            textString = new StringBuffer(FPutilities.byteArrayToSciNotation(fpDataType, isLittleEndian, byteArray, this.fDisplayedPrecision));
        }
        return textString.append(FPutilities.fillString(this.fCharsPerColumn - textString.length(), this.getPaddingCharacter())).toString();
    }

    public void convertAndUpdateCell(BigInteger memoryAddress, String editBuffer) {
        if (editBuffer != null && editBuffer.length() > 0) {
            byte[] targetByteArray = new byte[this.getFPDataType().getByteLength()];
            targetByteArray = FPutilities.floatingStringToByteArray(this.getFPDataType(), editBuffer, this.getFPDataType().getBitsize());
            if (this.fIsDisplayLittleEndian) {
                targetByteArray = FPutilities.reverseByteOrder(targetByteArray);
            }
            FPMemoryByte[] newMemoryBytes = new FPMemoryByte[targetByteArray.length];
            int index = 0;
            while (index < targetByteArray.length) {
                newMemoryBytes[index] = new FPMemoryByte(targetByteArray[index]);
                newMemoryBytes[index].setBigEndian(!this.isTargetLittleEndian());
                newMemoryBytes[index].setEdited(true);
                newMemoryBytes[index].setChanged(true);
                ++index;
            }
            this.getViewportCache().setEditedValue(memoryAddress, newMemoryBytes);
            this.getViewportCache().writeEditBuffer();
            this.redraw();
        } else {
            String errorText = NLS.bind((String)FPRenderingMessages.getString("FPRendering.ERROR_FPENTRY_POPUP_TEXT"), (Object)"<blanks>");
            try {
                this.setEditBuffer(new StringBuffer(this.fDataPane.bytesToSciNotation(this.getBytes(this.fCaretAddress, this.getFPDataType().getByteLength()))));
            }
            catch (DebugException e) {
                e.printStackTrace();
            }
            String statusString = FPRenderingMessages.getString("FPRendering.ERROR_FPENTRY_STATUS");
            Status status = new Status(4, FPRenderingPlugin.getUniqueIdentifier(), statusString);
            FPutilities.popupMessage(FPRenderingMessages.getString("FPRendering.ERROR_FPENTRY_POPUP_TITLE"), errorText, status);
        }
    }

    public void setInsertMode(boolean insertMode) {
        this.fEditInserMode = insertMode;
    }

    public boolean insertMode() {
        return this.fEditInserMode;
    }

    public boolean isEditingCell() {
        return this.fCellEditState;
    }

    public void setEditingCell(boolean state) {
        this.fCellEditState = state;
    }

    public BigInteger getCellEditAddress() {
        return this.cellEditAddress;
    }

    public void setCellEditAddress(BigInteger cellEditAddress) {
        this.cellEditAddress = cellEditAddress;
    }

    public BigInteger getMemoryAddress() {
        return this.memoryAddress;
    }

    public void setMemoryAddress(BigInteger memoryAddress) {
        this.memoryAddress = memoryAddress;
    }

    public StringBuffer getEditBuffer() {
        return this.fEditBuffer;
    }

    public void setEditBuffer(StringBuffer cellChars) {
        this.fEditBuffer = cellChars;
    }

    public void startCellEditing(BigInteger cellAddress, BigInteger memoryAddress, String editString) {
        this.setEditBuffer(new StringBuffer(editString));
        this.setCellEditAddress(cellAddress);
        this.setMemoryAddress(memoryAddress);
        this.setEditingCell(true);
    }

    public void endCellEditing() {
        this.setEditingCell(false);
        this.setCellEditAddress(null);
        this.setMemoryAddress(null);
        this.setEditBuffer(null);
    }

    public void displayEditModeIndicator(final boolean indicatorON) {
        UIJob job = new UIJob("FP Renderer Edit Indicator"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IViewPart viewInstance = null;
                String statusLineMessage = indicatorON ? NLS.bind((String)FPRenderingMessages.getString("FPRendering.EDIT_MODE"), (Object)(Rendering.this.insertMode() ? FPRenderingMessages.getString("FPRendering.EDIT_MODE_INSERT") : FPRenderingMessages.getString("FPRendering.EDIT_MODE_OVERWRITE"))) : null;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null) {
                    return Status.OK_STATUS;
                }
                IWorkbenchPage page = window.getActivePage();
                if (page == null) {
                    return Status.OK_STATUS;
                }
                viewInstance = page.findView("org.eclipse.debug.ui.MemoryView");
                if (viewInstance != null) {
                    viewInstance.getViewSite().getActionBars().getStatusLineManager().setMessage(statusLineMessage);
                }
                if ((viewInstance = page.findView("org.eclipse.cdt.debug.ui.memory.memorybrowser.MemoryBrowser")) != null) {
                    viewInstance.getViewSite().getActionBars().getStatusLineManager().setMessage(statusLineMessage);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public BigInteger cellToMemoryAddress(BigInteger cellAddress) {
        BigInteger vpStart = this.getViewportStartAddress();
        BigInteger colChars = BigInteger.valueOf(this.getCharsPerColumn());
        BigInteger dtBytes = BigInteger.valueOf(this.getFPDataType().getByteLength());
        return vpStart.add(cellAddress.subtract(vpStart).divide(colChars).multiply(dtBytes));
    }

    private static interface Request {
    }

    class Selection
    implements FPIMemorySelection {
        private BigInteger fStartHigh = null;
        private BigInteger fStartLow = null;
        private BigInteger fEndHigh = null;
        private BigInteger fEndLow = null;

        Selection() {
        }

        @Override
        public void clear() {
            this.fStartLow = null;
            this.fStartHigh = null;
            this.fEndLow = null;
            this.fEndHigh = null;
            Rendering.this.redrawPanes();
        }

        @Override
        public boolean hasSelection() {
            return this.fStartHigh != null && this.fStartLow != null && this.fEndHigh != null && this.fEndLow != null;
        }

        @Override
        public boolean isSelected(BigInteger address) {
            if (this.getEnd() == null || this.getStart() == null) {
                return false;
            }
            return this.getEnd().compareTo(this.getStart()) >= 0 ? address.compareTo(this.getStart()) >= 0 && address.compareTo(this.getEnd()) < 0 : this.getStart().compareTo(this.getEnd()) >= 0 && address.compareTo(this.getEnd()) >= 0 && address.compareTo(this.getStart()) < 0;
        }

        @Override
        public void setStart(BigInteger high, BigInteger low) {
            if (high == null && low == null) {
                if (this.fStartHigh != null && this.fStartLow != null) {
                    this.fStartHigh = null;
                    this.fStartLow = null;
                    Rendering.this.redrawPanes();
                }
                return;
            }
            boolean changed = false;
            if (this.fStartHigh == null || !high.equals(this.fStartHigh)) {
                this.fStartHigh = high;
                changed = true;
            }
            if (this.fStartLow == null || !low.equals(this.fStartLow)) {
                this.fStartLow = low;
                changed = true;
            }
            if (changed) {
                Rendering.this.redrawPanes();
            }
        }

        @Override
        public void setEnd(BigInteger high, BigInteger low) {
            if (high == null && low == null) {
                if (this.fEndHigh != null && this.fEndLow != null) {
                    this.fEndHigh = null;
                    this.fEndLow = null;
                    Rendering.this.redrawPanes();
                }
                return;
            }
            boolean changed = false;
            if (this.fEndHigh == null || !high.equals(this.fEndHigh)) {
                this.fEndHigh = high;
                changed = true;
            }
            if (this.fEndLow == null || !low.equals(this.fEndLow)) {
                this.fEndLow = low;
                changed = true;
            }
            if (changed) {
                Rendering.this.redrawPanes();
            }
        }

        @Override
        public BigInteger getHigh() {
            if (!this.hasSelection()) {
                return null;
            }
            return this.getStart().max(this.getEnd());
        }

        @Override
        public BigInteger getLow() {
            if (!this.hasSelection()) {
                return null;
            }
            return this.getStart().min(this.getEnd());
        }

        @Override
        public BigInteger getStart() {
            BigInteger differenceEndToStartLow;
            if (this.fStartHigh == null) {
                return null;
            }
            if (this.fEndHigh == null) {
                return this.fStartHigh;
            }
            if (this.fStartHigh.equals(this.fEndHigh) && this.fStartLow.equals(this.fEndLow)) {
                return this.fStartLow;
            }
            BigInteger differenceEndToStartHigh = this.fEndHigh.subtract(this.fStartHigh).abs();
            if (differenceEndToStartHigh.compareTo(differenceEndToStartLow = this.fEndHigh.subtract(this.fStartLow).abs()) > 0) {
                return this.fStartHigh;
            }
            return this.fStartLow;
        }

        @Override
        public BigInteger getStartLow() {
            return this.fStartLow;
        }

        @Override
        public BigInteger getEnd() {
            BigInteger differenceStartToEndLow;
            if (this.fEndHigh == null) {
                return null;
            }
            if (this.fStartHigh == null || this.fStartLow == null) {
                return null;
            }
            if (this.fStartHigh.equals(this.fEndHigh) && this.fStartLow.equals(this.fEndLow)) {
                return this.fStartHigh;
            }
            BigInteger differenceStartToEndHigh = this.fStartHigh.subtract(this.fEndHigh).abs();
            if (differenceStartToEndHigh.compareTo(differenceStartToEndLow = this.fStartHigh.subtract(this.fEndLow).abs()) >= 0) {
                return this.fEndHigh;
            }
            return this.fEndLow;
        }
    }

    class ViewportCache
    extends Thread
    implements FPIViewportCache {
        private HashMap<BigInteger, FPMemoryByte[]> fEditBuffer = new HashMap();
        private boolean fDisposed = false;
        private Object fLastQueued = null;
        private Vector<Object> fQueue = new Vector();
        protected MemoryUnit fCache = null;
        protected MemoryUnit[] fHistoryCache = new MemoryUnit[0];
        protected int fHistoryDepth = 0;

        public ViewportCache() {
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            this.fDisposed = true;
            Vector<Object> vector = this.fQueue;
            synchronized (vector) {
                this.fQueue.notify();
            }
        }

        public int getHistoryDepth() {
            return this.fHistoryDepth;
        }

        public void setHistoryDepth(int depth) {
            this.fHistoryDepth = depth;
            this.fHistoryCache = new MemoryUnit[this.fHistoryDepth];
        }

        @Override
        public void refresh() {
            assert (Thread.currentThread().equals(Display.getDefault().getThread())) : FPRenderingMessages.getString("CALLED_ON_NON_DISPATCH_THREAD");
            if (this.fCache != null) {
                this.queueRequest(Rendering.this.fViewportAddress, Rendering.this.getViewportEndAddress());
            }
        }

        @Override
        public void archiveDeltas() {
            assert (Thread.currentThread().equals(Display.getDefault().getThread())) : FPRenderingMessages.getString("CALLED_ON_NON_DISPATCH_THREAD");
            if (this.fCache != null) {
                this.queueRequestArchiveDeltas();
            }
        }

        private void queueRequest(BigInteger startAddress, BigInteger endAddress) {
            AddressPair pair = new AddressPair(startAddress, endAddress);
            this.queue(pair);
        }

        private void queueRequestArchiveDeltas() {
            ArchiveDeltas archive = new ArchiveDeltas();
            this.queue(archive);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void queue(Object element) {
            Vector<Object> vector = this.fQueue;
            synchronized (vector) {
                if (this.fQueue.size() <= 0 || !element.equals(this.fLastQueued)) {
                    this.fQueue.addElement(element);
                    this.fLastQueued = element;
                }
                this.fQueue.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.fDisposed) {
                AddressPair pair = null;
                boolean archiveDeltas = false;
                Vector<Object> vector = this.fQueue;
                synchronized (vector) {
                    if (this.fQueue.size() > 0) {
                        Request request = (Request)this.fQueue.elementAt(0);
                        Class<?> type = request.getClass();
                        while (this.fQueue.size() > 0 && type.isInstance(this.fQueue.elementAt(0))) {
                            request = (Request)this.fQueue.elementAt(0);
                            this.fQueue.removeElementAt(0);
                        }
                        if (request instanceof ArchiveDeltas) {
                            archiveDeltas = true;
                        } else if (request instanceof AddressPair) {
                            pair = (AddressPair)request;
                        }
                    }
                }
                if (archiveDeltas) {
                    int i = Rendering.this.fViewportCache.getHistoryDepth() - 1;
                    while (i > 0) {
                        this.fHistoryCache[i] = this.fHistoryCache[i - 1];
                        --i;
                    }
                    this.fHistoryCache[0] = this.fCache.clone();
                    continue;
                }
                if (pair != null) {
                    this.populateCache(pair.startAddress, pair.endAddress);
                    continue;
                }
                vector = this.fQueue;
                synchronized (vector) {
                    try {
                        if (this.fQueue.isEmpty()) {
                            this.fQueue.wait();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        private void populateCache(BigInteger startAddress, BigInteger endAddress) {
            try {
                IMemoryBlockExtension memoryBlock = Rendering.this.getMemoryBlock();
                BigInteger lengthInBytes = endAddress.subtract(startAddress);
                BigInteger addressableSize = BigInteger.valueOf(Rendering.this.getAddressableSize());
                long units = lengthInBytes.divide(addressableSize).add(lengthInBytes.mod(addressableSize).compareTo(BigInteger.ZERO) > 0 ? BigInteger.ONE : BigInteger.ZERO).longValue();
                MemoryByte[] readBytes = memoryBlock.getBytesFromAddress(startAddress, units);
                FPMemoryByte[] cachedBytes = new FPMemoryByte[readBytes.length];
                int index = 0;
                while (index < readBytes.length) {
                    cachedBytes[index] = new FPMemoryByte(readBytes[index].getValue(), readBytes[index].getFlags());
                    ++index;
                }
                if (cachedBytes.length > 0 && cachedBytes[0].isEndianessKnown()) {
                    Rendering.this.setTargetLittleEndian(!cachedBytes[0].isBigEndian());
                }
                if (!initialDisplayModeSet) {
                    Rendering.this.setDisplayLittleEndian(Rendering.this.isTargetLittleEndian());
                    initialDisplayModeSet = true;
                }
                if (Rendering.this.isTargetLittleEndian() && addressableSize.compareTo(BigInteger.ONE) != 0) {
                    int unitSize = addressableSize.intValue();
                    FPMemoryByte[] cachedBytesAsByteSequence = new FPMemoryByte[cachedBytes.length];
                    int unit = 0;
                    while ((long)unit < units) {
                        int unitbyte = 0;
                        while (unitbyte < unitSize) {
                            cachedBytesAsByteSequence[unit * unitSize + unitbyte] = cachedBytes[unit * unitSize + unitSize - unitbyte];
                            ++unitbyte;
                        }
                        ++unit;
                    }
                    cachedBytes = cachedBytesAsByteSequence;
                }
                FPMemoryByte[] cachedBytesFinal = cachedBytes;
                this.fCache = new MemoryUnit();
                this.fCache.start = startAddress;
                this.fCache.end = endAddress;
                this.fCache.bytes = cachedBytesFinal;
                Display.getDefault().asyncExec(() -> this.lambda$0(startAddress, endAddress, cachedBytesFinal));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public FPMemoryByte[] getBytes(BigInteger address, int bytesRequested) throws DebugException {
            assert (Thread.currentThread().equals(Display.getDefault().getThread())) : FPRenderingMessages.getString("CALLED_ON_NON_DISPATCH_THREAD");
            if (this.containsEditedCell(address)) {
                return this.getEditedMemory(address);
            }
            boolean contains = false;
            if (this.fCache != null && this.fCache.start != null) {
                BigInteger dataEnd = address.add(BigInteger.valueOf(bytesRequested));
                if (this.fCache.start.compareTo(address) <= 0 && this.fCache.end.compareTo(dataEnd) >= 0 && this.fCache.bytes.length > 0) {
                    contains = true;
                }
            }
            if (contains) {
                int offset = address.subtract(this.fCache.start).intValue();
                FPMemoryByte[] bytes = new FPMemoryByte[bytesRequested];
                int index = 0;
                while (index < bytes.length) {
                    bytes[index] = this.fCache.bytes[offset + index];
                    ++index;
                }
                return bytes;
            }
            FPMemoryByte[] bytes = new FPMemoryByte[bytesRequested];
            int index = 0;
            while (index < bytes.length) {
                bytes[index] = new FPMemoryByte();
                bytes[index].setReadable(false);
                ++index;
            }
            Rendering.this.fViewportCache.queueRequest(Rendering.this.fViewportAddress, Rendering.this.getViewportEndAddress());
            return bytes;
        }

        @Override
        public boolean containsEditedCell(BigInteger address) {
            assert (Thread.currentThread().equals(Display.getDefault().getThread())) : FPRenderingMessages.getString("CALLED_ON_NON_DISPATCH_THREAD");
            return this.fEditBuffer.containsKey(address);
        }

        public FPMemoryByte[] getEditedMemory(BigInteger address) {
            assert (Thread.currentThread().equals(Display.getDefault().getThread())) : FPRenderingMessages.getString("CALLED_ON_NON_DISPATCH_THREAD");
            return this.fEditBuffer.get(address);
        }

        @Override
        public void clearEditBuffer() {
            assert (Thread.currentThread().equals(Display.getDefault().getThread())) : FPRenderingMessages.getString("CALLED_ON_NON_DISPATCH_THREAD");
            this.fEditBuffer.clear();
            Rendering.this.redrawPanes();
        }

        @Override
        public void writeEditBuffer() {
            assert (Thread.currentThread().equals(Display.getDefault().getThread())) : FPRenderingMessages.getString("CALLED_ON_NON_DISPATCH_THREAD");
            Set<BigInteger> keySet = this.fEditBuffer.keySet();
            for (BigInteger address : keySet) {
                FPMemoryByte[] bytes = this.fEditBuffer.get(address);
                byte[] byteValue = new byte[bytes.length];
                int index = 0;
                while (index < bytes.length) {
                    byteValue[index] = bytes[index].getValue();
                    ++index;
                }
                try {
                    IMemoryBlockExtension block = Rendering.this.getMemoryBlock();
                    BigInteger offset = address.subtract(block.getBigBaseAddress());
                    block.setValue(offset, byteValue);
                }
                catch (Exception e) {
                    MemoryViewUtil.openError((String)FPRenderingMessages.getString("FAILURE_WRITE_MEMORY"), (String)"", (Exception)e);
                    Rendering.this.logError(FPRenderingMessages.getString("FAILURE_WRITE_MEMORY"), e);
                }
            }
            this.clearEditBuffer();
        }

        @Override
        public void setEditedValue(BigInteger address, FPMemoryByte[] bytes) {
            assert (Thread.currentThread().equals(Display.getDefault().getThread())) : FPRenderingMessages.getString("CALLED_ON_NON_DISPATCH_THREAD");
            this.fEditBuffer.put(address, bytes);
            Rendering.this.redrawPanes();
        }

        /*
         * Unable to fully structure code
         */
        private /* synthetic */ void lambda$0(BigInteger var1_1, BigInteger var2_2, FPMemoryByte[] var3_3) {
            historyIndex = 0;
            while (historyIndex < this.getHistoryDepth()) {
                block13: {
                    block15: {
                        block14: {
                            if (this.fHistoryCache[historyIndex] == null || !this.fHistoryCache[historyIndex].isValid()) break block13;
                            maxStart = var1_1.max(this.fHistoryCache[historyIndex].start);
                            minEnd = var2_2.min(this.fHistoryCache[historyIndex].end).subtract(BigInteger.ONE);
                            overlapLength = minEnd.subtract(maxStart);
                            if (overlapLength.compareTo(BigInteger.valueOf(0L)) <= 0) break block13;
                            offsetIntoOld = maxStart.subtract(this.fHistoryCache[historyIndex].start).intValue();
                            offsetIntoNew = maxStart.subtract(var1_1).intValue();
                            i = overlapLength.intValue();
                            while (i >= 0) {
                                var3_3[offsetIntoNew + i].setChanged(historyIndex, var3_3[offsetIntoNew + i].getValue() != this.fHistoryCache[historyIndex].bytes[offsetIntoOld + i].getValue());
                                --i;
                            }
                            if (historyIndex != 0) break block13;
                            dataStart = this.fCache.start.intValue();
                            dataEnd = this.fCache.end.intValue();
                            dataLength = this.fCache.bytes.length;
                            historyStart = this.fHistoryCache[0].start.intValue();
                            historyEnd = this.fHistoryCache[0].end.intValue();
                            historyLength = this.fHistoryCache[0].bytes.length;
                            if (dataStart >= historyStart && dataEnd <= historyEnd) break block13;
                            if ((dataStart >= historyStart || dataEnd >= historyStart) && dataStart <= historyEnd) break block14;
                            newHistoryCache1 = new MemoryUnit();
                            newHistoryCache1.start = this.fCache.start;
                            newHistoryCache1.end = this.fCache.end;
                            newHistoryCacheSize1 = this.fCache.bytes.length;
                            newHistoryCache1.bytes = new FPMemoryByte[newHistoryCacheSize1];
                            index1 = 0;
                            while (index1 < newHistoryCacheSize1) {
                                newHistoryCache1.bytes[index1] = new FPMemoryByte(this.fCache.bytes[index1].getValue());
                                ++index1;
                            }
                            this.fHistoryCache[0] = newHistoryCache1;
                            break block13;
                        }
                        if (dataStart >= historyStart || dataEnd < historyStart || dataEnd > historyEnd) break block15;
                        missingDataByteCount1 = historyStart - dataStart;
                        historyCacheSize1 = historyLength;
                        newHistoryCacheSize2 = missingDataByteCount1 + historyLength;
                        if (missingDataByteCount1 <= 0 && historyCacheSize1 <= 0) break;
                        newHistoryCache2 = new MemoryUnit();
                        newHistoryCache2.start = this.fCache.start;
                        newHistoryCache2.end = this.fHistoryCache[0].end;
                        newHistoryCache2.bytes = new FPMemoryByte[newHistoryCacheSize2];
                        index2 = 0;
                        while (index2 < missingDataByteCount1) {
                            newHistoryCache2.bytes[index2] = new FPMemoryByte(this.fCache.bytes[index2].getValue());
                            ++index2;
                        }
                        index3 = 0;
                        while (index3 < historyCacheSize1) {
                            newHistoryCache2.bytes[index3 + missingDataByteCount1] = new FPMemoryByte(this.fHistoryCache[0].bytes[index3].getValue());
                            ++index3;
                        }
                        this.fHistoryCache[0] = newHistoryCache2;
                        break block13;
                    }
                    if (dataStart < historyStart || dataStart > historyEnd || dataEnd <= historyEnd) ** GOTO lbl-1000
                    missingDataByteCount2 = dataEnd - historyEnd;
                    historyCacheSize2 = historyEnd - historyStart;
                    newHistoryCacheSize3 = missingDataByteCount2 + historyLength;
                    if (missingDataByteCount2 > 0 && historyCacheSize2 > 0) {
                        newHistoryCache3 = new MemoryUnit();
                        newHistoryCache3.start = this.fHistoryCache[0].start;
                        newHistoryCache3.end = this.fCache.end;
                        newHistoryCache3.bytes = new FPMemoryByte[newHistoryCacheSize3];
                        System.arraycopy(this.fHistoryCache[0].bytes, 0, newHistoryCache3.bytes, 0, historyLength);
                        index4 = 0;
                        while (index4 < missingDataByteCount2) {
                            srcIndex = dataLength - missingDataByteCount2 + index4;
                            dstIndex = historyLength + index4;
                            newHistoryCache3.bytes[dstIndex] = new FPMemoryByte(this.fCache.bytes[srcIndex].getValue());
                            ++index4;
                        }
                        this.fHistoryCache[0] = newHistoryCache3;
                    } else if (dataStart < historyStart && dataEnd > historyEnd) {
                        start = 0;
                        end = 0;
                        newHistoryCache4 = new MemoryUnit();
                        newHistoryCache4.start = this.fCache.start;
                        newHistoryCache4.end = this.fCache.end;
                        newHistoryCacheSize4 = this.fCache.bytes.length;
                        newHistoryCache4.bytes = new FPMemoryByte[newHistoryCacheSize4];
                        topByteCount = historyStart - dataStart;
                        bottomByteCount = dataEnd - historyEnd;
                        index5 = 0;
                        while (index5 < topByteCount) {
                            newHistoryCache4.bytes[index5] = new FPMemoryByte(this.fCache.bytes[index5].getValue());
                            ++index5;
                        }
                        start = topByteCount;
                        end = topByteCount + historyLength;
                        index6 = start;
                        while (index6 < end) {
                            newHistoryCache4.bytes[index6] = new FPMemoryByte(this.fCache.bytes[index6].getValue());
                            ++index6;
                        }
                        start = topByteCount + historyLength;
                        end = topByteCount + historyLength + bottomByteCount;
                        index7 = start;
                        while (index7 < end) {
                            newHistoryCache4.bytes[index7] = new FPMemoryByte(this.fCache.bytes[index7].getValue());
                            ++index7;
                        }
                        this.fHistoryCache[0] = newHistoryCache4;
                    }
                }
                ++historyIndex;
            }
            if (this.fHistoryCache[0] == null) {
                this.fHistoryCache[0] = this.fCache.clone();
            }
            Rendering.this.redrawPanes();
        }

        class AddressPair
        implements Request {
            BigInteger startAddress;
            BigInteger endAddress;

            public AddressPair(BigInteger start, BigInteger end) {
                this.startAddress = start;
                this.endAddress = end;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (obj instanceof AddressPair) {
                    return ((AddressPair)obj).startAddress.equals(this.startAddress) && ((AddressPair)obj).endAddress.equals(this.endAddress);
                }
                return false;
            }

            public int hashCode() {
                return super.hashCode() + this.startAddress.hashCode() + this.endAddress.hashCode();
            }
        }

        class ArchiveDeltas
        implements Request {
            ArchiveDeltas() {
            }
        }

        class MemoryUnit
        implements Cloneable {
            BigInteger start;
            BigInteger end;
            FPMemoryByte[] bytes;

            MemoryUnit() {
            }

            public MemoryUnit clone() {
                MemoryUnit b = new MemoryUnit();
                b.start = this.start;
                b.end = this.end;
                b.bytes = new FPMemoryByte[this.bytes.length];
                int index = 0;
                while (index < this.bytes.length) {
                    b.bytes[index] = new FPMemoryByte(this.bytes[index].getValue());
                    ++index;
                }
                return b;
            }

            public boolean isValid() {
                return this.start != null && this.end != null && this.bytes != null;
            }
        }
    }
}

