/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.breakpoints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.ToggleFilterAction;
import org.eclipse.debug.internal.ui.breakpoints.provisional.IBreakpointContainer;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ShowSupportedBreakpointsAction
extends ToggleFilterAction
implements ISelectionListener {
    private AbstractDebugView fView;
    private List<IDebugTarget> fDebugTargets = new ArrayList<IDebugTarget>(2);

    public ShowSupportedBreakpointsAction(StructuredViewer viewer, IViewPart view) {
        this.setText(ActionMessages.ShowSupportedBreakpointsAction_Show_For_Selected);
        this.setToolTipText(ActionMessages.ShowSupportedBreakpointsAction_tooltip);
        this.setViewerFilter(new BreakpointFilter());
        this.setViewer(viewer);
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_OBJS_DEBUG_TARGET"));
        this.setChecked(false);
        this.setId(String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".ShowSupportedBreakpointsAction");
        this.setView(view);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.show_breakpoints_for_model_action_context");
    }

    public void dispose() {
        if (this.isChecked()) {
            this.getView().getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            List<IDebugTarget> debugTargets = this.getDebugTargets(ss);
            if (!this.isChecked()) {
                this.fDebugTargets = debugTargets;
                return;
            }
            if (debugTargets.isEmpty()) {
                if (this.fDebugTargets.isEmpty()) {
                    return;
                }
                this.reapplyFilters(debugTargets);
                return;
            }
            if (this.fDebugTargets.isEmpty()) {
                this.reapplyFilters(debugTargets);
                return;
            }
            if (debugTargets.size() == this.fDebugTargets.size()) {
                ArrayList<IDebugTarget> copy = new ArrayList<IDebugTarget>(debugTargets.size());
                for (IDebugTarget target : this.fDebugTargets) {
                    Iterator<IDebugTarget> newDebugTargets = debugTargets.iterator();
                    while (newDebugTargets.hasNext()) {
                        IDebugTarget newTarget = newDebugTargets.next();
                        copy.add(newTarget);
                        if (!target.equals(newTarget)) continue;
                        newDebugTargets.remove();
                    }
                }
                if (debugTargets.isEmpty()) {
                    return;
                }
                this.reapplyFilters(copy);
            }
        }
    }

    protected void reapplyFilters(List<IDebugTarget> debugTargets) {
        this.fDebugTargets = debugTargets;
        this.getViewer().refresh();
    }

    protected IViewPart getView() {
        return this.fView;
    }

    protected void setView(IViewPart view) {
        this.fView = (AbstractDebugView)view;
    }

    protected List<IDebugTarget> getDebugTargets(IStructuredSelection ss) {
        ArrayList<IDebugTarget> debugTargets = new ArrayList<IDebugTarget>(2);
        for (Object next : ss) {
            IDebugTarget target;
            if (next instanceof IDebugElement) {
                debugTargets.add(((IDebugElement)next).getDebugTarget());
                continue;
            }
            if (next instanceof ILaunch) {
                IDebugTarget[] targets = ((ILaunch)next).getDebugTargets();
                Collections.addAll(debugTargets, targets);
                continue;
            }
            if (!(next instanceof IProcess) || (target = (IDebugTarget)((IProcess)next).getAdapter(IDebugTarget.class)) == null) continue;
            debugTargets.add(target);
        }
        return debugTargets;
    }

    @Override
    protected void valueChanged(boolean on) {
        if (this.getViewer().getControl().isDisposed()) {
            return;
        }
        if (on) {
            this.getView().getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
            ISelection selection = this.getView().getSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
            this.selectionChanged(null, selection);
        } else {
            this.getView().getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        }
        super.valueChanged(on);
        this.fView.getViewer().refresh();
    }

    class BreakpointFilter
    extends ViewerFilter {
        BreakpointFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IBreakpointContainer) {
                IBreakpoint[] breakpoints = ((IBreakpointContainer)element).getBreakpoints();
                int i = 0;
                while (i < breakpoints.length) {
                    if (this.select(viewer, element, breakpoints[i])) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            IBreakpoint breakpoint = (IBreakpoint)element;
            if (ShowSupportedBreakpointsAction.this.fDebugTargets.isEmpty()) {
                return true;
            }
            for (IDebugTarget target : ShowSupportedBreakpointsAction.this.fDebugTargets) {
                if (!target.supportsBreakpoint(breakpoint)) continue;
                return true;
            }
            return false;
        }
    }
}

