/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.task;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.task.TaskProcessorUI;
import org.jkiss.utils.CommonUtils;

public class TaskHandlerRun
extends AbstractHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String taskId = event.getParameter("task");
        DBTTask task = null;
        if (!CommonUtils.isEmpty((String)taskId)) {
            task = NavigatorUtils.getSelectedProject().getTaskManager().getTaskById(taskId);
        } else {
            Object element;
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof DBTTask) {
                task = (DBTTask)element;
            }
        }
        if (task != null) {
            TaskHandlerRun.runTask(task);
        }
        return null;
    }

    public static void runTask(DBTTask task) {
        try {
            TaskProcessorUI listener = new TaskProcessorUI(UIUtils.getDialogRunnableContext(), task);
            task.getProject().getTaskManager().runTask(task, (DBTTaskExecutionListener)listener, Collections.emptyMap());
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Task run", "Error running task '" + task.getName() + "'", (Throwable)e);
        }
    }

    public void updateElement(UIElement element, Map parameters) {
        DBTTask task;
        String taskId = CommonUtils.toString(parameters.get("task"));
        if (!CommonUtils.isEmpty((String)taskId) && (task = NavigatorUtils.getSelectedProject().getTaskManager().getTaskById(taskId)) != null) {
            DBPImage taskIcon = task.getType().getIcon();
            if (taskIcon == null) {
                taskIcon = DBIcon.TREE_TASK;
            }
            element.setIcon(DBeaverIcons.getImageDescriptor((DBPImage)taskIcon));
            element.setText(task.getName());
        }
    }
}

