"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const crypto_1 = require("crypto");
const uuidv4 = require("uuid/v4");
/**
 * Wrapper function over uuid's v4 method that attempts to source
 * entropy using Node's randomBytes
 */
function uuid() {
    return uuidv4({ random: crypto_1.randomBytes(16) });
}
/** The localStorage key for the stats GUID. */
exports.StatsGUIDKey = "stats-guid";
let cachedGUID = null;
/** Get the stats GUID. */
function getGUID() {
    if (!cachedGUID) {
        let GUID = localStorage.getItem(exports.StatsGUIDKey);
        if (!GUID) {
            GUID = uuid();
            localStorage.setItem(exports.StatsGUIDKey, GUID);
        }
        cachedGUID = GUID;
    }
    return cachedGUID;
}
exports.getGUID = getGUID;
//# sourceMappingURL=uuid.js.map