"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("../util");
class MemoryDatabase {
    constructor() {
        this.counters = Object.create(null);
        this.customEvents = [];
        this.timingEvents = [];
    }
    async addCustomEvent(eventType, customEvent) {
        const eventToInsert = Object.assign({}, customEvent, { date: util_1.getISODate(), eventType });
        this.customEvents.push(eventToInsert);
    }
    async incrementCounter(counterName) {
        this.counters[counterName] = (this.counters[counterName] || 0) + 1;
    }
    async addTiming(eventType, durationInMilliseconds, metadata = {}) {
        const timingData = {
            eventType,
            durationInMilliseconds,
            metadata,
            date: util_1.getISODate(),
        };
        this.timingEvents.push(timingData);
    }
    async clearData() {
        this.counters = Object.create(null);
        this.customEvents = [];
        this.timingEvents = [];
    }
    async getTimings() {
        return this.timingEvents;
    }
    async getCustomEvents() {
        return this.customEvents;
    }
    /**
     * Get all counters.
     * Returns something like { commits: 7, coAuthoredCommits: 8 }.
     */
    async getCounters() {
        return this.counters;
    }
}
exports.default = MemoryDatabase;
//# sourceMappingURL=memory.js.map