"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class GithubLoginView extends _react["default"].Component {
  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'handleLoginClick', 'handleCancelTokenClick', 'handleSubmitTokenClick', 'handleSubmitToken', 'handleTokenChange');
    this.state = {
      loggingIn: false,
      token: ''
    };
  }

  render() {
    let subview;

    if (this.state.loggingIn) {
      subview = this.renderTokenInput();
    } else {
      subview = this.renderLogin();
    }

    return _react["default"].createElement("div", {
      className: "github-GithubLoginView"
    }, subview);
  }

  renderLogin() {
    return _react["default"].createElement("div", {
      className: "github-GithubLoginView-Subview"
    }, _react["default"].createElement("div", {
      className: "github-GitHub-LargeIcon icon icon-mark-github"
    }), _react["default"].createElement("h1", null, "Log in to GitHub"), this.props.children, _react["default"].createElement("button", {
      onClick: this.handleLoginClick,
      className: "btn btn-primary icon icon-octoface"
    }, "Login"));
  }

  renderTokenInput() {
    return _react["default"].createElement("form", {
      className: "github-GithubLoginView-Subview",
      onSubmit: this.handleSubmitToken
    }, _react["default"].createElement("div", {
      className: "github-GitHub-LargeIcon icon icon-mark-github"
    }), _react["default"].createElement("h1", null, "Enter Token"), _react["default"].createElement("ol", null, _react["default"].createElement("li", null, "Visit ", _react["default"].createElement("a", {
      href: "https://github.atom.io/login"
    }, "github.atom.io/login"), " to generate an authentication token."), _react["default"].createElement("li", null, "Enter the token below:")), _react["default"].createElement("input", {
      type: "text",
      className: "input-text native-key-bindings",
      placeholder: "Enter your token...",
      value: this.state.token,
      onChange: this.handleTokenChange
    }), _react["default"].createElement("ul", null, _react["default"].createElement("li", null, _react["default"].createElement("button", {
      type: "button",
      onClick: this.handleCancelTokenClick,
      className: "btn icon icon-remove-close"
    }, "Cancel")), _react["default"].createElement("li", null, _react["default"].createElement("button", {
      type: "submit",
      onClick: this.handleSubmitTokenClick,
      className: "btn btn-primary icon icon-check"
    }, "Login"))));
  }

  handleLoginClick() {
    this.setState({
      loggingIn: true
    });
  }

  handleCancelTokenClick(e) {
    e.preventDefault();
    this.setState({
      loggingIn: false
    });
  }

  handleSubmitTokenClick(e) {
    e.preventDefault();
    this.handleSubmitToken();
  }

  handleSubmitToken() {
    this.props.onLogin(this.state.token);
  }

  handleTokenChange(e) {
    this.setState({
      token: e.target.value
    });
  }

}

exports["default"] = GithubLoginView;

_defineProperty(GithubLoginView, "propTypes", {
  children: _propTypes["default"].node,
  onLogin: _propTypes["default"].func
});

_defineProperty(GithubLoginView, "defaultProps", {
  children: _react["default"].createElement("div", {
    className: "initialize-repo-description"
  }, _react["default"].createElement("span", null, "Log in to GitHub to access PR information and more!")),
  onLogin: token => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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