"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareCheckRunView = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _githubDotcomMarkdown = _interopRequireDefault(require("./github-dotcom-markdown"));

var _buildStatus = require("../models/build-status");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareCheckRunView extends _react["default"].Component {
  render() {
    const {
      checkRun
    } = this.props;
    const {
      icon,
      classSuffix
    } = (0, _buildStatus.buildStatusFromCheckResult)(checkRun);
    return _react["default"].createElement("li", {
      className: "github-PrStatuses-list-item github-PrStatuses-list-item--checkRun"
    }, _react["default"].createElement("span", {
      className: "github-PrStatuses-list-item-icon"
    }, _react["default"].createElement(_octicon["default"], {
      icon: icon,
      className: `github-PrStatuses--${classSuffix}`
    })), _react["default"].createElement("a", {
      className: "github-PrStatuses-list-item-name",
      href: checkRun.permalink
    }, checkRun.name), _react["default"].createElement("div", {
      className: "github-PrStatuses-list-item-context"
    }, checkRun.title && _react["default"].createElement("span", {
      className: "github-PrStatuses-list-item-title"
    }, checkRun.title), checkRun.summary && _react["default"].createElement(_githubDotcomMarkdown["default"], {
      className: "github-PrStatuses-list-item-summary",
      switchToIssueish: this.props.switchToIssueish,
      markdown: checkRun.summary
    })), checkRun.detailsUrl && _react["default"].createElement("a", {
      className: "github-PrStatuses-list-item-details-link",
      href: checkRun.detailsUrl
    }, "Details"));
  }

}

exports.BareCheckRunView = BareCheckRunView;

_defineProperty(BareCheckRunView, "propTypes", {
  // Relay
  checkRun: _propTypes["default"].shape({
    name: _propTypes["default"].string.isRequired,
    status: _propTypes["default"].oneOf(['QUEUED', 'IN_PROGRESS', 'COMPLETED', 'REQUESTED']).isRequired,
    conclusion: _propTypes["default"].oneOf(['ACTION_REQUIRED', 'TIMED_OUT', 'CANCELLED', 'FAILURE', 'SUCCESS', 'NEUTRAL']),
    title: _propTypes["default"].string,
    detailsUrl: _propTypes["default"].string
  }).isRequired,
  // Actions
  switchToIssueish: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareCheckRunView, {
  checkRun: function () {
    const node = require("./__generated__/checkRunView_checkRun.graphql");

    if (node.hash && node.hash !== "7135f882a3513e65b0a52393a0cc8b40") {
      console.error("The definition of 'checkRunView_checkRun' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/checkRunView_checkRun.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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