/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.BaseUtilities;
import org.openide.util.NbCollections;
import org.openide.util.TopologicalSortException;

class Ordering {
    private static final Logger LOG = Logger.getLogger(Ordering.class.getName());
    private static final String ATTR_POSITION = "position";

    private Ordering() {
    }

    /*
     * WARNING - void declaration
     */
    static List<FileObject> getOrder(Collection<FileObject> collection, final boolean bl) throws IllegalArgumentException {
        Serializable serializable;
        FileObject fileObject;
        block29: {
            Object object;
            Object object2;
            Serializable serializable2;
            Object object5;
            LOG.log(Level.FINE, "getOrder for {0}", collection);
            Iterator<FileObject> iterator = collection.iterator();
            if (!iterator.hasNext()) {
                return Collections.emptyList();
            }
            HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
            class ChildAndPosition
            implements Comparable<ChildAndPosition> {
                final FileObject child;
                private final Number position;

                ChildAndPosition(FileObject fileObject, Number number) {
                    this.child = fileObject;
                    this.position = number;
                }

                @Override
                public int compareTo(ChildAndPosition childAndPosition) {
                    int n;
                    if (this.position instanceof Float || this.position instanceof Double || childAndPosition.position instanceof Float || childAndPosition.position instanceof Double) {
                        n = Double.compare(this.position.doubleValue(), childAndPosition.position.doubleValue());
                    } else {
                        long l;
                        long l2 = this.position.longValue();
                        int n2 = l2 < (l = childAndPosition.position.longValue()) ? -1 : (n = l2 == l ? 0 : 1);
                    }
                    if (n != 0) {
                        return n;
                    }
                    if (bl && childAndPosition != this && !this.position.equals(0)) {
                        LOG.log(Level.WARNING, "Found same position {0} for both {1} and {2}", new Object[]{this.position, childAndPosition.child.getPath(), this.child.getPath()});
                    }
                    return this.child.getNameExt().compareTo(childAndPosition.child.getNameExt());
                }
            }
            TreeSet<ChildAndPosition> treeSet = new TreeSet<ChildAndPosition>();
            fileObject = null;
            while (iterator.hasNext()) {
                serializable = iterator.next();
                if (hashMap.put(((FileObject)serializable).getNameExt(), serializable) != null) {
                    throw new IllegalArgumentException("Duplicate in children list: " + ((FileObject)serializable).getPath() + "\nChildren: " + collection);
                }
                object5 = ((FileObject)serializable).getAttribute(ATTR_POSITION);
                if (object5 instanceof Number) {
                    treeSet.add(new ChildAndPosition((FileObject)serializable, (Number)object5));
                } else if (bl && object5 != null) {
                    LOG.log(Level.WARNING, "Encountered nonnumeric position attribute {0} of {1} for {2}\nChildren: {3}", new Object[]{object5, object5.getClass(), ((FileObject)serializable).getPath(), collection});
                }
                if (fileObject == null) {
                    fileObject = ((FileObject)serializable).getParent();
                    continue;
                }
                if (((FileObject)serializable).getParent() == fileObject) continue;
                throw new IllegalArgumentException("All children must have the same parent: " + ((FileObject)serializable).getParent().getPath() + " vs. " + fileObject.getPath() + "\nChildren: " + collection);
            }
            serializable = new HashMap();
            object5 = NbCollections.iterable(fileObject.getAttributes()).iterator();
            while (object5.hasNext()) {
                int n;
                serializable2 = (String)object5.next();
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.FINEST, "  attr found {0}({1})", new Object[]{fileObject, serializable2});
                }
                if ((n = ((String)((Object)serializable2)).indexOf(47)) == -1) continue;
                Object object42 = fileObject.getAttribute((String)((Object)serializable2));
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "  reading attribute {0}({1}) -> {2}", new Object[]{fileObject, serializable2, object42});
                }
                if (!Boolean.TRUE.equals(object42)) {
                    if (!bl || object42 == null || object42 instanceof Boolean) continue;
                    LOG.log(Level.WARNING, "Encountered non-boolean relative ordering attribute {0} from {1} on {2}", new Object[]{object42, serializable2, fileObject.getPath()});
                    continue;
                }
                object2 = (FileObject)hashMap.get(((String)((Object)serializable2)).substring(0, n));
                FileObject fileObject2 = (FileObject)hashMap.get(((String)((Object)serializable2)).substring(n + 1));
                if (object2 != null && fileObject2 != null) {
                    object = (HashSet<FileObject>)serializable.get(object2);
                    if (object == null) {
                        object = new HashSet<FileObject>();
                        serializable.put(object2, object);
                    }
                    object.add(fileObject2);
                    if (!bl) continue;
                    LOG.log(Level.WARNING, "Relative ordering attribute {0} on {1} is deprecated in favor of numeric position attributes", new Object[]{serializable2, fileObject.getPath()});
                    continue;
                }
                if (!bl) continue;
                LOG.log(Level.WARNING, "Could not find both sides of relative ordering attribute {0} on {1}", new Object[]{serializable2, fileObject.getPath()});
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "  no more attribs {0}", fileObject);
            }
            if ((object5 = treeSet.iterator()).hasNext()) {
                serializable2 = ((ChildAndPosition)object5.next()).child;
                while (object5.hasNext()) {
                    void var10_17;
                    FileObject fileObject2 = ((ChildAndPosition)object5.next()).child;
                    Set set = (Set)serializable.get(serializable2);
                    if (set == null) {
                        HashSet hashSet = new HashSet();
                        serializable.put(serializable2, hashSet);
                    }
                    var10_17.add(fileObject2);
                    serializable2 = fileObject2;
                }
            }
            if (bl && !fileObject.getPath().matches("Projects/.+/Lookup") && !treeSet.isEmpty() && treeSet.size() < collection.size()) {
                serializable2 = new ArrayList<FileObject>(collection);
                for (ChildAndPosition childAndPosition : treeSet) {
                    serializable2.remove(childAndPosition.child);
                }
                Object object6 = serializable2.iterator();
                while (object6.hasNext()) {
                    FileObject fileObject3 = (FileObject)object6.next();
                    if (!fileObject3.getExt().endsWith("_hidden")) continue;
                    object6.remove();
                }
                if (!serializable2.isEmpty()) {
                    object6 = new ArrayList(serializable2.size());
                    Iterator iterator2 = serializable2.iterator();
                    while (iterator2.hasNext()) {
                        object2 = (FileObject)iterator2.next();
                        String string = ((FileObject)object2).getNameExt();
                        if (!string.contains("ergonomics")) {
                            object6.add(string);
                            continue;
                        }
                        break block29;
                    }
                    ArrayList<Object> arrayList = new ArrayList<Object>(treeSet.size());
                    for (ChildAndPosition childAndPosition : treeSet) {
                        object = childAndPosition.child.getNameExt();
                        if (!((String)object).contains("ergonomics")) {
                            arrayList.add(object);
                            continue;
                        }
                        break block29;
                    }
                    LOG.log(Level.WARNING, "Not all children in {0}/ marked with the position attribute: {1}, but some are: {2}", new Object[]{fileObject.getPath(), object6, arrayList});
                }
            }
        }
        if (serializable.isEmpty()) {
            return new ArrayList<FileObject>(collection);
        }
        try {
            return BaseUtilities.topologicalSort(collection, (Map)((Object)serializable));
        }
        catch (TopologicalSortException topologicalSortException) {
            if (bl) {
                LOG.log(Level.WARNING, "Contradictory partial ordering in " + fileObject.getPath(), topologicalSortException);
            }
            return NbCollections.checkedListByCopy((List)topologicalSortException.partialSort(), FileObject.class, (boolean)true);
        }
    }

    static void setOrder(List<FileObject> list) throws IllegalArgumentException, IOException {
        int n;
        List<FileObject> list2;
        FileObject fileObject2;
        boolean bl = false;
        boolean bl2 = true;
        for (FileObject fileObject2 : list) {
            if (Ordering.findPosition(fileObject2) != null) continue;
            bl2 = false;
            break;
        }
        Object object = null;
        fileObject2 = null;
        FileObject fileObject3 = null;
        if (bl2) {
            int n2;
            list2 = Ordering.getOrder(list, false);
            if (list.equals(list2)) {
                return;
            }
            int n3 = list.size();
            for (n = 0; n < n3 && list.get(n).equals(list2.get(n)); ++n) {
            }
            for (n2 = n3 - 1; n2 >= 0 && list.get(n2).equals(list2.get(n2)); --n2) {
            }
            int n4 = n2 - n + 1;
            if (n4 > 2) {
                if (list.get(n2).equals(list2.get(n)) && list.subList(n, n2).equals(list2.subList(n + 1, n2 + 1))) {
                    object = list.get(n2);
                    fileObject2 = list.get(n2 - 1);
                    fileObject3 = n2 + 1 < n3 ? list.get(n2 + 1) : null;
                } else if (list.get(n).equals(list2.get(n2)) && list.subList(n + 1, n2 + 1).equals(list2.subList(n, n2))) {
                    object = list.get(n);
                    fileObject2 = n - 1 >= 0 ? list.get(n - 1) : null;
                    fileObject3 = list.get(n + 1);
                }
            } else if (n4 == 2) {
                if (n == 0) {
                    object = list.get(n);
                    fileObject3 = list.get(n2);
                } else if (n2 == n3 - 1) {
                    object = list.get(n2);
                    fileObject2 = list.get(n);
                } else {
                    Float f = Ordering.findPosition(list.get(n - 1));
                    Float f2 = Ordering.findPosition(list.get(n2 + 1));
                    Float f3 = Ordering.findPosition(list.get(n));
                    Float f4 = Ordering.findPosition(list.get(n2));
                    if (f != null && f2 != null && f3 != null && f4 != null) {
                        if (f3.floatValue() - f.floatValue() < f2.floatValue() - f4.floatValue()) {
                            object = list.get(n2);
                            fileObject2 = list.get(n);
                            fileObject3 = list.get(n2 + 1);
                        } else {
                            object = list.get(n);
                            fileObject2 = list.get(n - 1);
                            fileObject3 = list.get(n2);
                        }
                    }
                }
            } else assert (n4 == 0) : list2 + " => " + list;
        } else if (list.size() > 1) {
            list2 = null;
            for (FileObject fileObject4 : list) {
                if (Ordering.findPosition(fileObject4) != null) continue;
                if (list2 == null) {
                    list2 = fileObject4;
                    continue;
                }
                list2 = null;
                break;
            }
            if (list2 != null) {
                bl = true;
                object = list2;
                int n5 = list.indexOf(list2);
                fileObject2 = n5 == 0 ? null : list.get(n5 - 1);
                FileObject fileObject5 = fileObject3 = n5 == list.size() - 1 ? null : list.get(n5 + 1);
            }
        }
        if (object != null) {
            if (fileObject2 == null) {
                ((FileObject)object).setAttribute(ATTR_POSITION, Math.round(Ordering.findPosition(fileObject3).floatValue() - 100.0f));
            } else if (fileObject3 == null) {
                ((FileObject)object).setAttribute(ATTR_POSITION, Math.round(Ordering.findPosition(fileObject2).floatValue() + 100.0f));
            } else {
                list2 = Ordering.findPosition(fileObject2);
                Float f = Ordering.findPosition(fileObject3);
                n = Math.round(((Float)((Object)list2)).floatValue() + f.floatValue()) / 2;
                if (((Float)((Object)list2)).floatValue() < (float)n && (float)n < f.floatValue()) {
                    ((FileObject)object).setAttribute(ATTR_POSITION, n);
                } else {
                    object = null;
                }
            }
        }
        if (object == null) {
            int n6 = 100;
            for (FileObject fileObject6 : list) {
                fileObject6.setAttribute(ATTR_POSITION, n6);
                n6 += 100;
            }
        }
        if (bl && object != null) {
            Ordering.setOrder(list);
            return;
        }
        FileObject fileObject7 = list.get(0).getParent();
        for (String string : NbCollections.iterable(fileObject7.getAttributes())) {
            if (string.indexOf(47) == -1 || !(fileObject7.getAttribute(string) instanceof Boolean)) continue;
            fileObject7.setAttribute(string, null);
        }
        boolean bl3 = false;
        if (!$assertionsDisabled) {
            bl3 = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (bl3) {
            List<FileObject> list3 = Ordering.getOrder(list, false);
            assert (list3.equals(list)) : "setOrder(" + list + ") -> " + list3;
        }
    }

    private static Float findPosition(FileObject fileObject) {
        Object object = fileObject.getAttribute(ATTR_POSITION);
        if (object instanceof Number) {
            return Float.valueOf(((Number)object).floatValue());
        }
        return null;
    }

    static boolean affectsOrder(FileAttributeEvent fileAttributeEvent) {
        String string = fileAttributeEvent.getName();
        if (string == null) {
            return true;
        }
        return string.equals(ATTR_POSITION) || fileAttributeEvent.getFile().isFolder() && string.indexOf(47) != -1;
    }
}

