#ifndef _EFL_UI_COLLECTION_VIEW_EO_H_
#define _EFL_UI_COLLECTION_VIEW_EO_H_

#ifndef _EFL_UI_COLLECTION_VIEW_EO_CLASS_TYPE
#define _EFL_UI_COLLECTION_VIEW_EO_CLASS_TYPE

typedef Eo Efl_Ui_Collection_View;

#endif

#ifndef _EFL_UI_COLLECTION_VIEW_EO_TYPES
#define _EFL_UI_COLLECTION_VIEW_EO_TYPES


#endif
/**
 * @brief This widget displays a list of items in an arrangement controlled by
 * an external @ref efl_ui_collection_view_position_manager_get object. By
 * using different @ref efl_ui_collection_view_position_manager_get objects
 * this widget can show unidimensional lists or two-dimensional grids of items,
 * for example.
 *
 * This class is intended to act as a base for widgets like List_View or
 * @ref Efl_Ui_Grid_View, which hide this complexity from the user.
 *
 * Items are generated by the @ref Efl_Ui_Factory defined with .factory.set to
 * match the content of the @ref Efl_Model defined with
 * @ref efl_ui_view_model_set. They are dynamically created/destroyed to only
 * have the one that are necessary to display all the one that are to far out
 * of the viewport will not be created to lighten the usage for very large
 * list.
 *
 * The direction of the arrangement can be controlled through
 * @ref efl_ui_layout_orientation_get.
 *
 * If all items do not fit in the current widget size scrolling facilities are
 * provided.
 *
 * Items inside this widget can be selected according to the
 * @ref efl_ui_multi_selectable_async_select_mode_get policy, and the selection
 * can be retrieved with
 * @ref efl_ui_multi_selectable_async_selected_iterator_new.
 *
 * @ingroup Efl_Ui_Collection_View
 */
#define EFL_UI_COLLECTION_VIEW_CLASS efl_ui_collection_view_class_get()

EWAPI const Efl_Class *efl_ui_collection_view_class_get(void);

/**
 * @brief Define the factory used to create all the items.
 *
 * @param[in] obj The object.
 * @param[in] factory The factory.
 *
 * @ingroup Efl_Ui_Collection_View
 */
EOAPI void efl_ui_collection_view_factory_set(Eo *obj, Efl_Ui_Factory *factory);

/**
 * @brief Define the factory used to create all the items.
 *
 * @param[in] obj The object.
 *
 * @return The factory.
 *
 * @ingroup Efl_Ui_Collection_View
 */
EOAPI Efl_Ui_Factory *efl_ui_collection_view_factory_get(const Eo *obj);

#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief Position manager object that handles placement of items.
 *
 * @param[in] obj The object.
 * @param[in] position_manager The objects ownership is passed to the item
 * container.
 *
 * @ingroup Efl_Ui_Collection_View
 */
EOAPI void efl_ui_collection_view_position_manager_set(Eo *obj, Efl_Ui_Position_Manager_Entity *position_manager EFL_TRANSFER_OWNERSHIP);
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief Position manager object that handles placement of items.
 *
 * @param[in] obj The object.
 *
 * @return The objects ownership is passed to the item container.
 *
 * @ingroup Efl_Ui_Collection_View
 */
EOAPI Efl_Ui_Position_Manager_Entity *efl_ui_collection_view_position_manager_get(const Eo *obj) EFL_TRANSFER_OWNERSHIP;
#endif /* EFL_BETA_API_SUPPORT */

EWAPI extern const Efl_Event_Description _EFL_UI_COLLECTION_VIEW_EVENT_ITEM_REALIZED;

/** Event triggered when an @ref Efl_Ui_Item has been provided by the
 * @ref Efl_Ui_Factory and is about to be used.
 * @return Efl_Ui_Item *
 *
 * @ingroup Efl_Ui_Collection_View
 */
#define EFL_UI_COLLECTION_VIEW_EVENT_ITEM_REALIZED (&(_EFL_UI_COLLECTION_VIEW_EVENT_ITEM_REALIZED))

EWAPI extern const Efl_Event_Description _EFL_UI_COLLECTION_VIEW_EVENT_ITEM_UNREALIZED;

/** Event triggered when the @ref Efl_Ui_Collection_View is about to give an
 * @ref Efl_Ui_Item back to the @ref Efl_Ui_Factory.
 * @return Efl_Ui_Item *
 *
 * @ingroup Efl_Ui_Collection_View
 */
#define EFL_UI_COLLECTION_VIEW_EVENT_ITEM_UNREALIZED (&(_EFL_UI_COLLECTION_VIEW_EVENT_ITEM_UNREALIZED))

#endif
