/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;

public class NavigationHistoryManager {
    private HeapFragmentWalker heapFragmentWalker;
    private List<NavigationHistoryItem> backHistory;
    private List<NavigationHistoryItem> forwardHistory;

    public NavigationHistoryManager(HeapFragmentWalker heapFragmentWalker) {
        this.heapFragmentWalker = heapFragmentWalker;
        this.backHistory = new ArrayList<NavigationHistoryItem>();
        this.forwardHistory = new ArrayList<NavigationHistoryItem>();
    }

    public boolean isNavigationBackAvailable() {
        return !this.backHistory.isEmpty();
    }

    public boolean isNavigationForwardAvailable() {
        return !this.forwardHistory.isEmpty();
    }

    public void createNavigationHistoryPoint() {
        NavigationHistoryCapable navigationHistoryCapable;
        NavigationHistoryItem navigationHistoryItem = this.createCurrentHistoryItem();
        if (navigationHistoryItem != null) {
            this.backHistory.add(navigationHistoryItem);
        }
        if ((navigationHistoryCapable = this.heapFragmentWalker.getNavigationHistorySource()) != null) {
            this.forwardHistory.clear();
        }
    }

    public void navigateBack() {
        if (!this.isNavigationBackAvailable()) {
            return;
        }
        NavigationHistoryItem navigationHistoryItem = this.backHistory.remove(this.backHistory.size() - 1);
        NavigationHistoryItem navigationHistoryItem2 = this.createCurrentHistoryItem();
        if (navigationHistoryItem2 != null) {
            this.forwardHistory.add(navigationHistoryItem2);
        }
        try {
            navigationHistoryItem.getSource().configure(navigationHistoryItem.getConfiguration());
        }
        catch (Exception exception) {
            ProfilerLogger.log((Exception)exception);
        }
    }

    public void navigateForward() {
        if (!this.isNavigationForwardAvailable()) {
            return;
        }
        NavigationHistoryItem navigationHistoryItem = this.forwardHistory.remove(this.forwardHistory.size() - 1);
        NavigationHistoryItem navigationHistoryItem2 = this.createCurrentHistoryItem();
        if (navigationHistoryItem2 != null) {
            this.backHistory.add(navigationHistoryItem2);
        }
        try {
            navigationHistoryItem.getSource().configure(navigationHistoryItem.getConfiguration());
        }
        catch (Exception exception) {
            ProfilerLogger.log((Exception)exception);
        }
    }

    private NavigationHistoryItem createCurrentHistoryItem() {
        Configuration configuration;
        NavigationHistoryCapable navigationHistoryCapable = this.heapFragmentWalker.getNavigationHistorySource();
        if (navigationHistoryCapable != null && (configuration = navigationHistoryCapable.getCurrentConfiguration()) != null) {
            return new NavigationHistoryItem(navigationHistoryCapable, configuration);
        }
        return null;
    }

    private static class NavigationHistoryItem {
        private Configuration configuration;
        private NavigationHistoryCapable source;

        public NavigationHistoryItem(NavigationHistoryCapable navigationHistoryCapable, Configuration configuration) {
            this.source = navigationHistoryCapable;
            this.configuration = configuration;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public NavigationHistoryCapable getSource() {
            return this.source;
        }
    }

    public static class Configuration {
    }

    public static interface NavigationHistoryCapable {
        public Configuration getCurrentConfiguration();

        public void configure(Configuration var1);
    }
}

