/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.jnlp.PluginParameters;

class PluginParameterParser {
    private static final char DELIMITER_ESCAPE = ':';
    private static final String KEY_VALUE_DELIMITER = ";";

    PluginParameterParser() {
    }

    static String unescapeString(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char chr = str.charAt(i);
            if (chr != '\\') {
                sb.append(chr);
                continue;
            }
            if ((chr = str.charAt(++i)) == 'n') {
                sb.append('\n');
                continue;
            }
            if (chr == '\\') {
                sb.append('\\');
                continue;
            }
            if (chr != ':') continue;
            sb.append(KEY_VALUE_DELIMITER);
        }
        return sb.toString();
    }

    static Map<String, String> parseEscapedKeyValuePairs(String keyvalString) {
        String[] strs = keyvalString.split(KEY_VALUE_DELIMITER, -1);
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (int i = 0; i < strs.length - 1; i += 2) {
            String key = PluginParameterParser.unescapeString(strs[i]).toLowerCase();
            String value = PluginParameterParser.unescapeString(strs[i + 1]);
            attributes.put(key, value);
        }
        return attributes;
    }

    static boolean isInt(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public PluginParameters parse(String width, String height, String parameterString) {
        Map<String, String> params = PluginParameterParser.parseEscapedKeyValuePairs(parameterString);
        if (params.get("width") == null || !PluginParameterParser.isInt(params.get("width"))) {
            params.put("width", width);
        }
        if (params.get("height") == null || !PluginParameterParser.isInt(params.get("height"))) {
            params.put("height", height);
        }
        return new PluginParameters(params);
    }
}

