/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.split;

import java.util.Map;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.split.SplitAfterPredefinedSetOfPagesRadioButton;
import org.pdfsam.split.SplitAfterRadioButton;
import org.pdfsam.split.SplitByEveryRadioButton;
import org.pdfsam.split.SplitParametersBuilderCreator;
import org.pdfsam.support.KeyStringValueItem;
import org.pdfsam.support.params.SinglePdfSourceMultipleOutputParametersBuilder;
import org.pdfsam.ui.ResettableView;
import org.pdfsam.ui.commons.RadioButtonDrivenTextFieldsPane;
import org.pdfsam.ui.commons.ValidableTextField;
import org.pdfsam.ui.help.HelpUtils;
import org.pdfsam.ui.support.Style;
import org.pdfsam.ui.workspace.RestorableView;
import org.sejda.model.parameter.AbstractSplitByPageParameters;
import org.sejda.model.pdf.page.PredefinedSetOfPages;

class SplitOptionsPane
extends VBox
implements SplitParametersBuilderCreator,
RestorableView,
ResettableView {
    private ToggleGroup group = new ToggleGroup();
    private SplitAfterPredefinedSetOfPagesRadioButton splitAfterPredefined;
    private SplitAfterRadioButton splitAfter;
    private SplitByEveryRadioButton splitByEvery;

    SplitOptionsPane() {
        super(5.0);
        ComboBox predefinedCombo = new ComboBox();
        predefinedCombo.getItems().add((Object)KeyStringValueItem.keyValue((Object)PredefinedSetOfPages.ALL_PAGES, (String)DefaultI18nContext.getInstance().i18n("Every page")));
        predefinedCombo.getItems().add((Object)KeyStringValueItem.keyValue((Object)PredefinedSetOfPages.EVEN_PAGES, (String)DefaultI18nContext.getInstance().i18n("Even pages")));
        predefinedCombo.getItems().add((Object)KeyStringValueItem.keyValue((Object)PredefinedSetOfPages.ODD_PAGES, (String)DefaultI18nContext.getInstance().i18n("Odd pages")));
        this.splitAfterPredefined = new SplitAfterPredefinedSetOfPagesRadioButton((ComboBox<KeyStringValueItem<PredefinedSetOfPages>>)predefinedCombo);
        ValidableTextField splitAfterField = new ValidableTextField();
        this.splitAfter = new SplitAfterRadioButton(splitAfterField);
        ValidableTextField splitByEveryField = new ValidableTextField();
        this.splitByEvery = new SplitByEveryRadioButton(splitByEveryField);
        RadioButtonDrivenTextFieldsPane grid = new RadioButtonDrivenTextFieldsPane(this.group);
        this.splitAfterPredefined.setToggleGroup(this.group);
        this.splitAfter.setToggleGroup(this.group);
        this.splitByEvery.setToggleGroup(this.group);
        grid.addRow((RadioButton)this.splitAfterPredefined, (Region)predefinedCombo, HelpUtils.helpIcon((String)DefaultI18nContext.getInstance().i18n("Split the document after the given page numbers")));
        grid.addRow((RadioButton)this.splitAfter, (Region)splitAfterField, HelpUtils.helpIcon((String)DefaultI18nContext.getInstance().i18n("Split the document after the given page numbers")));
        grid.addRow((RadioButton)this.splitByEvery, (Region)splitByEveryField, HelpUtils.helpIcon((String)DefaultI18nContext.getInstance().i18n("Splits the PDF every \"n\" pages creating documents of \"n\" pages each")));
        this.splitAfterPredefined.setSelected(true);
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.getChildren().addAll((Object[])new Node[]{grid});
    }

    void setMaxPages(Integer value) {
        this.splitByEvery.setMaxPages(value);
    }

    @Override
    public SinglePdfSourceMultipleOutputParametersBuilder<? extends AbstractSplitByPageParameters> getBuilder(Consumer<String> onError) {
        return ((SplitParametersBuilderCreator)this.group.getSelectedToggle()).getBuilder(onError);
    }

    public void saveStateTo(Map<String, String> data) {
        this.splitAfterPredefined.saveStateTo(data);
        this.splitAfter.saveStateTo(data);
        this.splitByEvery.saveStateTo(data);
    }

    public void restoreStateFrom(Map<String, String> data) {
        this.splitAfterPredefined.restoreStateFrom(data);
        this.splitAfter.restoreStateFrom(data);
        this.splitByEvery.restoreStateFrom(data);
    }

    public void resetView() {
        this.splitAfterPredefined.resetView();
        this.splitAfter.resetView();
        this.splitByEvery.resetView();
        this.splitAfterPredefined.setSelected(true);
    }
}

