/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component.image;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.PageImageWriter;
import org.sejda.impl.sambox.component.image.ExifHelper;
import org.sejda.model.PageOrientation;
import org.sejda.model.PageSize;
import org.sejda.model.exception.TaskException;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.input.ImageMergeInput;
import org.sejda.model.input.MergeInput;
import org.sejda.model.input.PdfFileSource;
import org.sejda.model.input.PdfMergeInput;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.Source;
import org.sejda.model.parameter.BaseMergeParameters;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.graphics.image.PDImageXObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImagesToPdfDocumentConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ImagesToPdfDocumentConverter.class);
    private PDRectangle defaultPageSize = PDRectangle.A4;
    private boolean shouldPageSizeMatchImageSize = false;
    private PageOrientation pageOrientation = PageOrientation.AUTO;
    private float marginInches = 0.0f;

    public PDDocumentHandler convert(List<Source<?>> sourceList) throws TaskException {
        return this.convert(sourceList, new ArrayList<PDRectangle>());
    }

    public PDDocumentHandler convert(List<Source<?>> sourceList, List<PDRectangle> pageSizeList) throws TaskException {
        PDDocumentHandler documentHandler = new PDDocumentHandler();
        documentHandler.setCreatorOnPDDocument();
        PageImageWriter imageWriter = new PageImageWriter(documentHandler.getUnderlyingPDDocument());
        for (int i = 0; i < sourceList.size(); ++i) {
            Source<?> source = sourceList.get(i);
            this.beforeImage(source);
            try {
                float ratio;
                PDImageXObject image = PageImageWriter.toPDXImageObject(source);
                PDRectangle mediaBox = this.defaultPageSize;
                if (!pageSizeList.isEmpty()) {
                    mediaBox = pageSizeList.get(i);
                }
                if (this.shouldPageSizeMatchImageSize) {
                    mediaBox = new PDRectangle((float)image.getWidth(), (float)image.getHeight());
                }
                if (this.pageOrientation == PageOrientation.LANDSCAPE) {
                    mediaBox = new PDRectangle(mediaBox.getHeight(), mediaBox.getWidth());
                } else if (this.pageOrientation == PageOrientation.AUTO && image.getWidth() > image.getHeight() && (float)image.getWidth() > mediaBox.getWidth()) {
                    LOG.debug("Switching to landscape, image dimensions are {}x{}", (Object)image.getWidth(), (Object)image.getHeight());
                    mediaBox = new PDRectangle(mediaBox.getHeight(), mediaBox.getWidth());
                }
                PDPage page = documentHandler.addBlankPage(mediaBox);
                float width = image.getWidth();
                float height = image.getHeight();
                if (width > mediaBox.getWidth()) {
                    int targetWidth = (int)mediaBox.getWidth();
                    LOG.debug("Scaling image down to fit by width {} vs {}", (Object)Float.valueOf(width), (Object)targetWidth);
                    ratio = width / (float)targetWidth;
                    width = targetWidth;
                    height = Math.round(height / ratio);
                }
                if (height > mediaBox.getHeight()) {
                    int targetHeight = (int)mediaBox.getHeight();
                    LOG.debug("Scaling image down to fit by height {} vs {}", (Object)Float.valueOf(height), (Object)targetHeight);
                    ratio = height / (float)targetHeight;
                    height = targetHeight;
                    width = Math.round(width / ratio);
                }
                if (this.marginInches > 0.0f) {
                    float newWidth = width - this.marginInches * 72.0f;
                    float newHeight = height * newWidth / width;
                    width = newWidth;
                    height = newHeight;
                }
                float x = (mediaBox.getWidth() - width) / 2.0f;
                float y = ((float)((int)mediaBox.getHeight()) - height) / 2.0f;
                imageWriter.append(page, image, (Point2D)new Point((int)x, (int)y), width, height, null, 0);
                int rotation = ExifHelper.getRotationBasedOnExifOrientation(source);
                page.setRotation(rotation);
                this.afterImage(image);
                continue;
            }
            catch (TaskIOException e) {
                this.failedImage(source, e);
            }
        }
        return documentHandler;
    }

    public void beforeImage(Source<?> source) throws TaskException {
    }

    public void afterImage(PDImageXObject image) throws TaskException {
    }

    public void failedImage(Source<?> source, TaskIOException e) throws TaskException {
        throw e;
    }

    public void setDefaultPageSize(PageSize defaultPageSize) {
        this.defaultPageSize = new PDRectangle(defaultPageSize.getWidth(), defaultPageSize.getHeight());
    }

    public void setPageSize(PDRectangle pageSize) {
        this.defaultPageSize = pageSize;
    }

    public void setShouldPageSizeMatchImageSize(boolean shouldPageSizeMatchImageSize) {
        this.shouldPageSizeMatchImageSize = shouldPageSizeMatchImageSize;
    }

    public void setPageOrientation(PageOrientation pageOrientation) {
        this.pageOrientation = pageOrientation;
    }

    public void setMarginInches(float marginInches) {
        this.marginInches = marginInches;
    }

    public static void convertImageMergeInputToPdf(BaseMergeParameters<MergeInput> parameters, TaskExecutionContext context) throws TaskException {
        ArrayList<Object> newInputList = new ArrayList<Object>();
        for (MergeInput input : parameters.getInputList()) {
            if (input instanceof ImageMergeInput) {
                newInputList.add(ImagesToPdfDocumentConverter.convertImagesToPdfMergeInput((ImageMergeInput)input, context));
                continue;
            }
            newInputList.add(input);
        }
        parameters.setInputList(newInputList);
    }

    private static PdfMergeInput convertImagesToPdfMergeInput(ImageMergeInput image, final TaskExecutionContext context) throws TaskException {
        List<Source<?>> sources = Collections.singletonList(image.getSource());
        ImagesToPdfDocumentConverter converter = new ImagesToPdfDocumentConverter(){

            @Override
            public void failedImage(Source<?> source, TaskIOException e) throws TaskException {
                context.assertTaskIsLenient((Exception)((Object)e));
                ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)context.notifiableTaskMetadata()).taskWarning(String.format("Image %s was skipped, could not be processed", source.getName()), (Exception)((Object)e));
            }
        };
        converter.setDefaultPageSize(image.getPageSize());
        converter.setShouldPageSizeMatchImageSize(image.isShouldPageSizeMatchImageSize());
        converter.setPageOrientation(image.getPageOrientation());
        PDDocumentHandler converted = converter.convert(sources);
        String basename = FilenameUtils.getBaseName((String)image.getSource().getName());
        String filename = String.format("%s.pdf", basename);
        File convertedTmpFile = IOUtils.createTemporaryBufferWithName((String)filename);
        converted.setDocumentTitle(basename);
        converted.savePDDocument(convertedTmpFile);
        return new PdfMergeInput((PdfSource)PdfFileSource.newInstanceNoPassword((File)convertedTmpFile));
    }
}

