/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.webapp;

import org.eclipse.jetty.plus.annotation.InjectionCollection;
import org.eclipse.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.eclipse.jetty.plus.annotation.RunAsCollection;
import org.eclipse.jetty.util.Decorator;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.WebAppContext;

public class PlusDecorator
implements Decorator {
    private static final Logger LOG = Log.getLogger(PlusDecorator.class);
    protected WebAppContext _context;

    public PlusDecorator(WebAppContext context) {
        this._context = context;
    }

    public Object decorate(Object o) {
        LifeCycleCallbackCollection callbacks;
        InjectionCollection injections;
        RunAsCollection runAses = (RunAsCollection)this._context.getAttribute("org.eclipse.jetty.runAsCollection");
        if (runAses != null) {
            runAses.setRunAs(o);
        }
        if ((injections = (InjectionCollection)this._context.getAttribute("org.eclipse.jetty.injectionCollection")) != null) {
            injections.inject(o);
        }
        if ((callbacks = (LifeCycleCallbackCollection)this._context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")) != null) {
            try {
                callbacks.callPostConstructCallback(o);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return o;
    }

    public void destroy(Object o) {
        LifeCycleCallbackCollection callbacks = (LifeCycleCallbackCollection)this._context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection");
        if (callbacks != null) {
            try {
                callbacks.callPreDestroyCallback(o);
            }
            catch (Exception e) {
                LOG.warn("Destroying instance of " + o.getClass(), (Throwable)e);
            }
        }
    }
}

