import { getApplicativeComposition } from './Applicative';
import { none as optionNone, option, some as optionSome } from './Option';
export function fold(F) {
    return (onNone, onSome, fa) => F.map(fa, o => (o.isNone() ? onNone : onSome(o.value)));
}
export function getOptionT2v(M) {
    const applicativeComposition = getApplicativeComposition(M, option);
    return Object.assign({}, applicativeComposition, { chain: (fa, f) => M.chain(fa, o => (o.isNone() ? M.of(optionNone) : f(o.value))) });
}
/** @deprecated */
// tslint:disable-next-line: deprecation
export function chain(F) {
    return (f, fa) => F.chain(fa, o => (o.isNone() ? F.of(optionNone) : f(o.value)));
}
// tslint:disable-next-line: deprecation
export function getOptionT(M) {
    const applicativeComposition = getApplicativeComposition(M, option);
    return Object.assign({}, applicativeComposition, { 
        // tslint:disable-next-line: deprecation
        chain: chain(M) });
}
/** @deprecated */
export function some(F) {
    return a => F.of(optionSome(a));
}
/** @deprecated */
export function none(F) {
    return () => F.of(optionNone);
}
/** @deprecated */
export function fromOption(F) {
    return F.of;
}
/** @deprecated */
export function liftF(F) {
    return fa => F.map(fa, optionSome);
}
/** @deprecated */
export function getOrElse(F) {
    return a => fa => F.map(fa, o => o.getOrElse(a));
}
