"use strict";
var __values = (this && this.__values) || function (o) {
    var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
    if (m) return m.call(o);
    return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var mobx_1 = require("mobx");
var uuid = __importStar(require("uuid"));
var axis_utils_1 = require("../utils/axis_utils");
var canvas_text_bbox_calculator_1 = require("../../../utils/bbox/canvas_text_bbox_calculator");
var legend_1 = require("../legend/legend");
var scales_1 = require("../utils/scales");
var series_1 = require("../utils/series");
var specs_1 = require("../utils/specs");
var tooltip_1 = require("../tooltip/tooltip");
var theme_1 = require("../../../utils/themes/theme");
var commons_1 = require("../../../utils/commons");
var dimensions_1 = require("../utils/dimensions");
var interactions_1 = require("../utils/interactions");
var scales_2 = require("../../../utils/scales/scales");
var settings_1 = require("../../../specs/settings");
var annotation_utils_1 = require("../annotations/annotation_utils");
var crosshair_utils_1 = require("../crosshair/crosshair_utils");
var utils_1 = require("./utils");
var light_theme_1 = require("../../../utils/themes/light_theme");
var ChartStore = /** @class */ (function () {
    function ChartStore(id) {
        var _this = this;
        this.debug = false;
        this.id = uuid.v4();
        this.specsInitialized = mobx_1.observable.box(false);
        this.chartInitialized = mobx_1.observable.box(false);
        this.legendInitialized = mobx_1.observable.box(false);
        this.enableHistogramMode = mobx_1.observable.box(false);
        this.parentDimensions = {
            width: 0,
            height: 0,
            top: 0,
            left: 0,
        };
        this.chartDimensions = {
            width: 0,
            height: 0,
            top: 0,
            left: 0,
        };
        this.chartTransform = {
            x: 0,
            y: 0,
            rotate: 0,
        };
        this.isBrushing = mobx_1.observable.box(false);
        this.brushExtent = {
            minX: 0,
            minY: 0,
            maxX: 0,
            maxY: 0,
        };
        this.resizeDebounce = 10;
        this.chartRotation = 0; // updated from jsx
        this.chartRendering = 'canvas'; // updated from jsx
        this.chartTheme = light_theme_1.LIGHT_THEME;
        this.axesSpecs = new Map(); // readed from jsx
        this.axesTicksDimensions = new Map(); // computed
        this.axesPositions = new Map(); // computed
        this.axesVisibleTicks = new Map(); // computed
        this.axesTicks = new Map(); // computed
        this.axesGridLinesPositions = new Map(); // computed
        this.annotationSpecs = new Map(); // read from jsx
        this.annotationDimensions = mobx_1.observable.map(new Map());
        this.seriesSpecs = new Map(); // readed from jsx
        this.isChartEmpty = mobx_1.observable.box(false);
        this.legendItems = new Map();
        this.highlightedLegendItemKey = mobx_1.observable.box(null);
        this.selectedLegendItemKey = mobx_1.observable.box(null);
        // deselected/hidden data series from the legend
        this.deselectedDataSeries = null;
        this.customSeriesColors = new Map();
        this.seriesColorMap = new Map();
        this.tooltipData = mobx_1.observable.array([], { deep: false });
        this.tooltipType = mobx_1.observable.box(settings_1.DEFAULT_TOOLTIP_TYPE);
        this.tooltipSnap = mobx_1.observable.box(settings_1.DEFAULT_TOOLTIP_SNAP);
        this.tooltipPosition = mobx_1.observable.object({ transform: '' });
        /** cursorPosition is used by tooltip, so this is a way to expose the position for other uses */
        this.rawCursorPosition = mobx_1.observable.object({ x: -1, y: -1 }, undefined, {
            deep: false,
        });
        /** position of the cursor relative to the chart */
        this.cursorPosition = mobx_1.observable.object({ x: -1, y: -1 }, undefined, {
            deep: false,
        });
        this.cursorBandPosition = mobx_1.observable.object({ top: -1, left: -1, height: -1, width: -1, visible: false }, undefined, {
            deep: false,
        });
        this.cursorLinePosition = mobx_1.observable.object({ top: -1, left: -1, height: -1, width: -1 }, undefined, {
            deep: false,
        });
        this.externalCursorShown = mobx_1.observable.box(false);
        this.geometries = null;
        this.geometriesIndex = new Map();
        this.geometriesIndexKeys = [];
        this.highlightedGeometries = mobx_1.observable.array([], { deep: false });
        this.animateData = false;
        /**
         * Define if the chart can be animated or not depending
         * on the global configuration and on the number of elements per series
         */
        this.canDataBeAnimated = false;
        this.showLegend = mobx_1.observable.box(false);
        this.legendPosition = mobx_1.observable.box(specs_1.Position.Right);
        this.showLegendDisplayValue = mobx_1.observable.box(true);
        this.isCursorOnChart = mobx_1.observable.box(false);
        this.chartCursor = mobx_1.computed(function () {
            var _a = _this.cursorPosition, xPos = _a.x, yPos = _a.y;
            if (yPos < 0 || xPos < 0) {
                return 'default';
            }
            if (_this.highlightedGeometries.length > 0 && (_this.onElementClickListener || _this.onElementOverListener)) {
                return 'pointer';
            }
            return _this.isBrushEnabled() ? 'crosshair' : 'default';
        });
        /**
         * determine if chart is currently active
         */
        this.isActiveChart = mobx_1.computed(function () {
            return !_this.activeChartId ? true : _this.activeChartId === _this.id;
        });
        /**
         * set activeChartId
         */
        this.setActiveChartId = function (chartId) {
            _this.activeChartId = chartId;
        };
        /**
         * set the x value of the cursor
         */
        this.setCursorValue = mobx_1.action(function (value) {
            _this.externalCursorShown.set(true);
            _this.isCursorOnChart.set(true);
            if (!_this.xScale) {
                return;
            }
            var xPosition = _this.xScale.pureScale(value);
            if (xPosition == null || xPosition > _this.chartDimensions.width + _this.chartDimensions.left) {
                _this.clearTooltipAndHighlighted();
                return;
            }
            var isLineAreaOnly = utils_1.isLineAreaOnlyChart(_this.seriesSpecs);
            var updatedCursorBand = crosshair_utils_1.getCursorBandPosition(_this.chartRotation, _this.chartDimensions, { x: xPosition, y: 0 }, {
                value: value,
                withinBandwidth: true,
            }, _this.isTooltipSnapEnabled.get(), _this.xScale, isLineAreaOnly ? 1 : _this.totalBarsInCluster);
            Object.assign(_this.cursorBandPosition, updatedCursorBand);
            var tooltipAndHighlight = tooltip_1.getTooltipAndHighlightFromXValue({ x: xPosition, y: 0 }, _this.seriesSpecs, _this.axesSpecs, _this.geometriesIndex, {
                value: value,
                withinBandwidth: true,
            }, _this.isActiveChart.get(), _this.tooltipType.get(), _this.chartRotation, _this.yScales, _this.tooltipHeaderFormatter);
            if (!tooltipAndHighlight || tooltipAndHighlight.tooltipData.length === 0) {
                _this.clearTooltipAndHighlighted(false);
                return;
            }
            // update tooltip visibility
            if (tooltipAndHighlight.tooltipData.length === 0) {
                _this.tooltipData.clear();
            }
            else {
                _this.tooltipData.replace(tooltipAndHighlight.tooltipData);
            }
        });
        /**
         * x and y values are relative to the container.
         */
        this.setCursorPosition = mobx_1.action(function (x, y, updateCursor) {
            if (updateCursor === void 0) { updateCursor = true; }
            _this.isCursorOnChart.set(true);
            _this.rawCursorPosition.x = x;
            _this.rawCursorPosition.y = y;
            if (!_this.seriesDomainsAndData || _this.tooltipType.get() === interactions_1.TooltipType.None) {
                return;
            }
            _this.externalCursorShown.set(false);
            // get positions relative to chart
            var xPos = x - _this.chartDimensions.left;
            var yPos = y - _this.chartDimensions.top;
            // limit cursorPosition to chartDimensions
            // note: to debug and inspect tooltip html, just comment the following ifs
            if (xPos < 0 || xPos >= _this.chartDimensions.width) {
                xPos = -1;
            }
            if (yPos < 0 || yPos >= _this.chartDimensions.height) {
                yPos = -1;
            }
            _this.cursorPosition.x = xPos;
            _this.cursorPosition.y = yPos;
            // hide tooltip if outside chart dimensions
            if (yPos === -1 || xPos === -1) {
                _this.isCursorOnChart.set(false);
                if (_this.onCursorUpdateListener && _this.isActiveChart.get()) {
                    _this.onCursorUpdateListener();
                }
                _this.clearTooltipAndHighlighted();
                return;
            }
            // get the cursor position depending on the chart rotation
            var xAxisCursorPosition = interactions_1.getValidXPosition(xPos, yPos, _this.chartRotation, _this.chartDimensions);
            var yAxisCursorPosition = interactions_1.getValidYPosition(xPos, yPos, _this.chartRotation, _this.chartDimensions);
            var axisCursorPosition = { x: xAxisCursorPosition, y: yAxisCursorPosition };
            // only if we have a valid cursor position and the necessary scale
            if (xAxisCursorPosition < 0 || !_this.xScale || !_this.yScales) {
                _this.clearTooltipAndHighlighted();
                return;
            }
            // invert the cursor position to get the scale value
            var xValue = _this.xScale.invertWithStep(xAxisCursorPosition, _this.geometriesIndexKeys);
            if (updateCursor && _this.onCursorUpdateListener) {
                _this.onCursorUpdateListener({
                    chartId: _this.id,
                    scale: _this.xScale.type,
                    unit: _this.xScale.unit,
                    value: xValue.value,
                });
            }
            // update che cursorBandPosition based on chart configuration
            var isLineAreaOnly = utils_1.isLineAreaOnlyChart(_this.seriesSpecs);
            var updatedCursorBand = crosshair_utils_1.getCursorBandPosition(_this.chartRotation, _this.chartDimensions, axisCursorPosition, {
                value: xValue.value,
                withinBandwidth: true,
            }, _this.isTooltipSnapEnabled.get(), _this.xScale, isLineAreaOnly ? 1 : _this.totalBarsInCluster);
            Object.assign(_this.cursorBandPosition, updatedCursorBand);
            var updatedCursorLine = crosshair_utils_1.getCursorLinePosition(_this.chartRotation, _this.chartDimensions, _this.cursorPosition);
            Object.assign(_this.cursorLinePosition, updatedCursorLine);
            var isSingleValueXScale = _this.xScale.isSingleValue();
            _this.tooltipPosition.transform = crosshair_utils_1.getTooltipPosition(_this.chartDimensions, _this.chartRotation, _this.cursorBandPosition, _this.cursorPosition, isSingleValueXScale);
            var tooltipAndHighlight = tooltip_1.getTooltipAndHighlightFromXValue(axisCursorPosition, _this.seriesSpecs, _this.axesSpecs, _this.geometriesIndex, xValue, _this.isActiveChart.get(), _this.tooltipType.get(), _this.chartRotation, _this.yScales, _this.tooltipHeaderFormatter);
            // if no element, hide everything keep crosshair
            if (!tooltipAndHighlight || tooltipAndHighlight.tooltipData.length === 0) {
                _this.clearTooltipAndHighlighted(false);
                return;
            }
            var highlightedGeometries = tooltipAndHighlight.highlightedGeometries, tooltipData = tooltipAndHighlight.tooltipData;
            // if there's an annotation rect tooltip & there isn't a single highlighted element, hide
            var annotationTooltip = _this.annotationTooltipState.get();
            var hasRectAnnotationToolip = annotationTooltip && annotationTooltip.annotationType === specs_1.AnnotationTypes.Rectangle;
            if (hasRectAnnotationToolip && highlightedGeometries.length === 0) {
                _this.clearTooltipAndHighlighted();
                return;
            }
            // check if we already have send out an over/out event on highlighted elements
            if (_this.onElementOverListener &&
                !interactions_1.areIndexedGeometryArraysEquals(highlightedGeometries, _this.highlightedGeometries.toJS())) {
                if (highlightedGeometries.length > 0) {
                    _this.onElementOverListener(highlightedGeometries.map(function (_a) {
                        var value = _a.value;
                        return value;
                    }));
                }
                else {
                    if (_this.onElementOutListener) {
                        _this.onElementOutListener();
                    }
                }
            }
            // update highlighted geometries observer
            _this.highlightedGeometries.replace(highlightedGeometries);
            // update tooltip visibility
            if (tooltipData.length === 0) {
                _this.tooltipData.clear();
            }
            else {
                _this.tooltipData.replace(tooltipData);
            }
        });
        this.legendItemTooltipValues = mobx_1.computed(function () {
            var xPos = _this.rawCursorPosition.x - _this.chartDimensions.left;
            var yPos = _this.rawCursorPosition.y - _this.chartDimensions.top;
            if (xPos > 0 && xPos <= _this.chartDimensions.width && yPos > 0 && yPos <= _this.chartDimensions.height) {
                return tooltip_1.getSeriesTooltipValues(_this.tooltipData, '');
            }
            // update legend items with value to display
            return tooltip_1.getSeriesTooltipValues(_this.tooltipData);
        });
        this.annotationTooltipState = mobx_1.computed(function () {
            var e_1, _a;
            // get positions relative to chart
            var xPos = _this.rawCursorPosition.x - _this.chartDimensions.left;
            var yPos = _this.rawCursorPosition.y - _this.chartDimensions.top;
            // only if we have a valid cursor position and the necessary scale
            if (!_this.xScale || !_this.yScales) {
                return null;
            }
            var cursorPosition = {
                x: xPos,
                y: yPos,
            };
            var tooltipState = annotation_utils_1.computeAnnotationTooltipState(cursorPosition, _this.annotationDimensions, _this.annotationSpecs, _this.chartRotation, _this.axesSpecs, _this.chartDimensions);
            // If there's a highlighted chart element tooltip value, don't show annotation tooltip
            if (tooltipState && tooltipState.annotationType === specs_1.AnnotationTypes.Rectangle) {
                try {
                    for (var _b = __values(_this.tooltipData), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var tooltipValue = _c.value;
                        if (tooltipValue.isHighlighted) {
                            return null;
                        }
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
            }
            return tooltipState;
        });
        this.isTooltipVisible = mobx_1.computed(function () {
            return (!_this.isBrushing.get() &&
                _this.tooltipType.get() !== interactions_1.TooltipType.None &&
                _this.cursorPosition.x > -1 &&
                _this.cursorPosition.y > -1 &&
                _this.tooltipData.length > 0 &&
                _this.isActiveChart.get());
        });
        this.isCrosshairVisible = mobx_1.computed(function () {
            return (!_this.isBrushing.get() &&
                interactions_1.isCrosshairTooltipType(_this.tooltipType.get()) &&
                !_this.isChartEmpty.get() &&
                (_this.externalCursorShown.get() || (_this.cursorPosition.x > -1 && _this.cursorPosition.y > -1)));
        });
        this.isTooltipSnapEnabled = mobx_1.computed(function () {
            return (_this.xScale && _this.xScale.bandwidth > 0) || _this.tooltipSnap.get();
        });
        this.clearTooltipAndHighlighted = mobx_1.action(function (clearCursorBand) {
            if (clearCursorBand === void 0) { clearCursorBand = true; }
            // if exist any highlighted geometry, send an out element event
            if (_this.onElementOutListener && _this.highlightedGeometries.length > 0) {
                _this.onElementOutListener();
            }
            // clear highlight geoms
            _this.highlightedGeometries.clear();
            _this.tooltipData.clear();
            if (clearCursorBand) {
                Object.assign(_this.cursorBandPosition, { visible: false });
            }
        });
        this.setShowLegend = mobx_1.action(function (showLegend) {
            _this.showLegend.set(showLegend);
        });
        this.highlightedLegendItem = mobx_1.computed(function () {
            var key = _this.highlightedLegendItemKey.get();
            return key == null ? null : _this.legendItems.get(key);
        });
        this.selectedLegendItem = mobx_1.computed(function () {
            var key = _this.selectedLegendItemKey.get();
            return key == null ? null : _this.legendItems.get(key);
        });
        this.onLegendItemOver = mobx_1.action(function (legendItemKey) {
            _this.highlightedLegendItemKey.set(legendItemKey);
            if (_this.onLegendItemOverListener) {
                var currentLegendItem = _this.highlightedLegendItem.get();
                var listenerData = currentLegendItem ? currentLegendItem.value : null;
                _this.onLegendItemOverListener(listenerData);
            }
        });
        this.onLegendItemOut = mobx_1.action(function () {
            _this.highlightedLegendItemKey.set(null);
            if (_this.onLegendItemOutListener) {
                _this.onLegendItemOutListener();
            }
        });
        this.onLegendItemClick = mobx_1.action(function (legendItemKey) {
            // Disabling the select until we implement the right contextual menu
            // with extend possibility
            // if (legendItemKey !== this.selectedLegendItemKey.get()) {
            // this.selectedLegendItemKey.set(legendItemKey);
            // } else {
            //   this.selectedLegendItemKey.set(null);
            // }
            if (_this.onLegendItemClickListener) {
                var currentLegendItem = legendItemKey == null ? null : _this.legendItems.get(legendItemKey);
                var listenerData = currentLegendItem ? currentLegendItem.value : null;
                _this.onLegendItemClickListener(listenerData);
            }
        });
        this.onLegendItemPlusClick = mobx_1.action(function () {
            if (_this.onLegendItemPlusClickListener) {
                var currentLegendItem = _this.selectedLegendItem.get();
                var listenerData = currentLegendItem ? currentLegendItem.value : null;
                _this.onLegendItemPlusClickListener(listenerData);
            }
        });
        this.onLegendItemMinusClick = mobx_1.action(function () {
            if (_this.onLegendItemMinusClickListener) {
                var currentLegendItem = _this.selectedLegendItem.get();
                var listenerData = currentLegendItem ? currentLegendItem.value : null;
                _this.onLegendItemMinusClickListener(listenerData);
            }
        });
        this.toggleSingleSeries = mobx_1.action(function (legendItemKey) {
            var legendItem = _this.legendItems.get(legendItemKey);
            if (legendItem) {
                if (series_1.findDataSeriesByColorValues(_this.deselectedDataSeries, legendItem.value) > -1) {
                    _this.deselectedDataSeries = __spread(_this.legendItems.values()).filter(function (item) { return item.key !== legendItemKey; })
                        .map(function (item) { return item.value; });
                }
                else {
                    _this.deselectedDataSeries = [legendItem.value];
                }
                _this.computeChart();
            }
        });
        this.toggleSeriesVisibility = mobx_1.action(function (legendItemKey) {
            var legendItem = _this.legendItems.get(legendItemKey);
            if (legendItem) {
                _this.deselectedDataSeries = utils_1.updateDeselectedDataSeries(_this.deselectedDataSeries, legendItem.value);
                _this.computeChart();
            }
        });
        this.setSeriesColor = mobx_1.action(function (legendItemKey, color) {
            var legendItem = _this.legendItems.get(legendItemKey);
            if (legendItem) {
                var specId = legendItem.value.specId;
                var spec = _this.seriesSpecs.get(specId);
                if (spec) {
                    if (spec.customSeriesColors) {
                        spec.customSeriesColors.set(legendItem.value, color);
                    }
                    else {
                        var specCustomSeriesColors = new Map();
                        spec.customSeriesColors = specCustomSeriesColors;
                        spec.customSeriesColors.set(legendItem.value, color);
                    }
                }
                _this.computeChart();
            }
        });
        this.onBrushStart = mobx_1.action(function () {
            if (!_this.onBrushEndListener) {
                return;
            }
            _this.isBrushing.set(true);
        });
        this.onBrushEnd = mobx_1.action(function (start, end) {
            if (!_this.onBrushEndListener) {
                return;
            }
            _this.isBrushing.set(false);
            var minValue = Math.min(start.x, end.x);
            var maxValue = Math.max(start.x, end.x);
            if (maxValue === minValue) {
                // if 0 size brush, avoid computing the value
                return;
            }
            var min = _this.xScale.invert(minValue - _this.chartDimensions.left);
            var max = _this.xScale.invert(maxValue - _this.chartDimensions.left);
            _this.onBrushEndListener(min, max);
        });
        this.id = id || uuid.v4();
    }
    ChartStore.prototype.handleChartClick = function () {
        if (this.highlightedGeometries.length > 0 && this.onElementClickListener) {
            this.onElementClickListener(this.highlightedGeometries.toJS().map(function (_a) {
                var value = _a.value;
                return value;
            }));
        }
    };
    ChartStore.prototype.resetDeselectedDataSeries = function () {
        this.deselectedDataSeries = null;
    };
    ChartStore.prototype.setOnElementClickListener = function (listener) {
        this.onElementClickListener = listener;
    };
    ChartStore.prototype.setOnElementOverListener = function (listener) {
        this.onElementOverListener = listener;
    };
    ChartStore.prototype.setOnElementOutListener = function (listener) {
        this.onElementOutListener = listener;
    };
    ChartStore.prototype.setOnBrushEndListener = function (listener) {
        this.onBrushEndListener = listener;
    };
    ChartStore.prototype.setOnLegendItemOverListener = function (listener) {
        this.onLegendItemOverListener = listener;
    };
    ChartStore.prototype.setOnLegendItemOutListener = function (listener) {
        this.onLegendItemOutListener = listener;
    };
    ChartStore.prototype.setOnLegendItemClickListener = function (listener) {
        this.onLegendItemClickListener = listener;
    };
    ChartStore.prototype.setOnLegendItemPlusClickListener = function (listener) {
        this.onLegendItemPlusClickListener = listener;
    };
    ChartStore.prototype.setOnLegendItemMinusClickListener = function (listener) {
        this.onLegendItemMinusClickListener = listener;
    };
    ChartStore.prototype.setOnCursorUpdateListener = function (listener) {
        this.onCursorUpdateListener = listener;
    };
    ChartStore.prototype.setOnRenderChangeListener = function (listener) {
        var _this = this;
        this.onRenderChangeListener = listener;
        this.chartInitialized.observe(function (_a) {
            var newValue = _a.newValue, oldValue = _a.oldValue;
            if (_this.onRenderChangeListener && newValue !== oldValue) {
                _this.onRenderChangeListener(newValue);
            }
        });
    };
    ChartStore.prototype.removeElementClickListener = function () {
        this.onElementClickListener = undefined;
    };
    ChartStore.prototype.removeElementOverListener = function () {
        this.onElementOverListener = undefined;
    };
    ChartStore.prototype.removeElementOutListener = function () {
        this.onElementOutListener = undefined;
    };
    ChartStore.prototype.removeOnLegendItemOverListener = function () {
        this.onLegendItemOverListener = undefined;
    };
    ChartStore.prototype.removeOnLegendItemOutListener = function () {
        this.onLegendItemOutListener = undefined;
    };
    ChartStore.prototype.removeOnLegendItemPlusClickListener = function () {
        this.onLegendItemPlusClickListener = undefined;
    };
    ChartStore.prototype.removeOnLegendItemMinusClickListener = function () {
        this.onLegendItemMinusClickListener = undefined;
    };
    ChartStore.prototype.removeOnCursorUpdateListener = function () {
        this.onCursorUpdateListener = undefined;
    };
    ChartStore.prototype.removeOnRenderChangeListener = function () {
        this.onRenderChangeListener = undefined;
    };
    ChartStore.prototype.isBrushEnabled = function () {
        if (!this.xScale) {
            return false;
        }
        return this.xScale.type !== scales_2.ScaleType.Ordinal && Boolean(this.onBrushEndListener);
    };
    ChartStore.prototype.updateParentDimensions = function (width, height, top, left) {
        var isChanged = false;
        if (width !== this.parentDimensions.width) {
            isChanged = true;
            this.parentDimensions.width = width;
        }
        if (height !== this.parentDimensions.height) {
            isChanged = true;
            this.parentDimensions.height = height;
        }
        if (top !== this.parentDimensions.top) {
            isChanged = true;
            this.parentDimensions.top = top;
        }
        if (left !== this.parentDimensions.left) {
            isChanged = true;
            this.parentDimensions.left = left;
        }
        if (isChanged) {
            this.computeChart();
        }
    };
    ChartStore.prototype.addSeriesSpec = function (seriesSpec) {
        this.seriesSpecs.set(seriesSpec.id, seriesSpec);
        var isEnabled = utils_1.isHistogramModeEnabled(this.seriesSpecs);
        this.enableHistogramMode.set(isEnabled);
        utils_1.setBarSeriesAccessors(isEnabled, this.seriesSpecs);
    };
    ChartStore.prototype.removeSeriesSpec = function (specId) {
        this.seriesSpecs.delete(specId);
        var isEnabled = utils_1.isHistogramModeEnabled(this.seriesSpecs);
        this.enableHistogramMode.set(isEnabled);
        utils_1.setBarSeriesAccessors(isEnabled, this.seriesSpecs);
    };
    /**
     * Add an axis spec to the store
     * @param axisSpec an axis spec
     */
    ChartStore.prototype.addAxisSpec = function (axisSpec) {
        this.axesSpecs.set(axisSpec.id, axisSpec);
    };
    ChartStore.prototype.removeAxisSpec = function (axisId) {
        this.axesSpecs.delete(axisId);
    };
    ChartStore.prototype.addAnnotationSpec = function (annotationSpec) {
        if (specs_1.isLineAnnotation(annotationSpec)) {
            var style = annotationSpec.style;
            var mergedLineStyle = theme_1.mergeWithDefaultAnnotationLine(style);
            annotationSpec.style = mergedLineStyle;
        }
        if (specs_1.isRectAnnotation(annotationSpec)) {
            var style = annotationSpec.style;
            var mergedRectStyle = theme_1.mergeWithDefaultAnnotationRect(style);
            annotationSpec.style = mergedRectStyle;
        }
        this.annotationSpecs.set(annotationSpec.annotationId, annotationSpec);
    };
    ChartStore.prototype.removeAnnotationSpec = function (annotationId) {
        this.annotationSpecs.delete(annotationId);
    };
    ChartStore.prototype.computeChart = function () {
        var _this = this;
        this.chartInitialized.set(false);
        // compute only if parent dimensions are computed
        if (this.parentDimensions.width === 0 || this.parentDimensions.height === 0) {
            return;
        }
        // avoid compute if no specs are specified
        if (this.seriesSpecs.size === 0) {
            return;
        }
        // When specs are not initialized, reset selectedDataSeries to null
        if (!this.specsInitialized.get()) {
            this.deselectedDataSeries = null;
        }
        // merge Y custom domains specified on the axis
        var customYDomainsByGroupId = axis_utils_1.mergeYCustomDomainsByGroupId(this.axesSpecs, this.chartRotation);
        // compute general X and Y domains, split series based on split accessors
        // process stacked and non-stacked values series formatting the data
        this.seriesDomainsAndData = utils_1.computeSeriesDomains(this.seriesSpecs, customYDomainsByGroupId, this.customXDomain, this.deselectedDataSeries);
        // Merge all series spec custom colors with state custom colors map
        var updatedCustomSeriesColors = utils_1.getUpdatedCustomSeriesColors(this.seriesSpecs);
        this.customSeriesColors = new Map(__spread(this.customSeriesColors, updatedCustomSeriesColors));
        this.seriesColorMap = series_1.getSeriesColorMap(this.seriesDomainsAndData.seriesColors, this.chartTheme.colors, this.customSeriesColors);
        this.legendItems = legend_1.computeLegend(this.seriesDomainsAndData.seriesColors, this.seriesColorMap, this.seriesSpecs, this.chartTheme.colors.defaultVizColor, this.axesSpecs, this.deselectedDataSeries);
        if (!this.legendInitialized.get()) {
            this.legendInitialized.set(true);
            if (this.legendItems.size > 0 && this.showLegend.get()) {
                return;
            }
        }
        this.isChartEmpty.set(utils_1.isAllSeriesDeselected(this.legendItems));
        var _a = this.seriesDomainsAndData, xDomain = _a.xDomain, yDomain = _a.yDomain, formattedDataSeries = _a.formattedDataSeries;
        // compute how many bar series are clustered
        var totalBarsInCluster = scales_1.countBarsInCluster(formattedDataSeries.stacked, formattedDataSeries.nonStacked).totalBarsInCluster;
        this.totalBarsInCluster = totalBarsInCluster;
        // compute axis dimensions
        var bboxCalculator = new canvas_text_bbox_calculator_1.CanvasTextBBoxCalculator();
        var barsPadding = this.enableHistogramMode.get()
            ? this.chartTheme.scales.histogramPadding
            : this.chartTheme.scales.barsPadding;
        this.axesTicksDimensions.clear();
        this.axesSpecs.forEach(function (axisSpec) {
            var id = axisSpec.id;
            var dimensions = axis_utils_1.computeAxisTicksDimensions(axisSpec, xDomain, yDomain, totalBarsInCluster, bboxCalculator, _this.chartRotation, _this.chartTheme.axes, barsPadding, _this.enableHistogramMode.get());
            if (dimensions) {
                _this.axesTicksDimensions.set(id, dimensions);
            }
        });
        bboxCalculator.destroy();
        // compute chart dimensions
        var computedChartDims = dimensions_1.computeChartDimensions(this.parentDimensions, this.chartTheme, this.axesTicksDimensions, this.axesSpecs);
        this.chartDimensions = computedChartDims.chartDimensions;
        this.chartTransform = utils_1.computeChartTransform(this.chartDimensions, this.chartRotation);
        this.brushExtent = utils_1.computeBrushExtent(this.chartDimensions, this.chartRotation, this.chartTransform);
        var seriesGeometries = utils_1.computeSeriesGeometries(this.seriesSpecs, xDomain, yDomain, formattedDataSeries, this.seriesColorMap, this.chartTheme, this.chartDimensions, this.chartRotation, this.axesSpecs, this.enableHistogramMode.get());
        this.geometries = seriesGeometries.geometries;
        this.xScale = seriesGeometries.scales.xScale;
        var isSingleValueXScale = this.xScale.isSingleValue();
        if (isSingleValueXScale && !interactions_1.isNoneTooltipType(this.tooltipType.get())) {
            this.tooltipType.set(interactions_1.TooltipType.Follow);
        }
        this.yScales = seriesGeometries.scales.yScales;
        this.geometriesIndex = seriesGeometries.geometriesIndex;
        this.geometriesIndexKeys = __spread(this.geometriesIndex.keys()).sort(commons_1.compareByValueAsc);
        // compute visible ticks and their positions
        var axisTicksPositions = axis_utils_1.getAxisTicksPositions(computedChartDims, this.chartTheme, this.chartRotation, this.axesSpecs, this.axesTicksDimensions, xDomain, yDomain, totalBarsInCluster, this.enableHistogramMode.get(), barsPadding);
        this.axesPositions = axisTicksPositions.axisPositions;
        this.axesTicks = axisTicksPositions.axisTicks;
        this.axesVisibleTicks = axisTicksPositions.axisVisibleTicks;
        this.axesGridLinesPositions = axisTicksPositions.axisGridLinesPositions;
        // annotation computations
        var updatedAnnotationDimensions = annotation_utils_1.computeAnnotationDimensions(this.annotationSpecs, this.chartDimensions, this.chartRotation, this.yScales, this.xScale, this.axesSpecs, this.totalBarsInCluster, this.enableHistogramMode.get());
        this.annotationDimensions.replace(updatedAnnotationDimensions);
        this.canDataBeAnimated = utils_1.isChartAnimatable(seriesGeometries.geometriesCounts, this.animateData);
        // temporary disabled until
        // https://github.com/elastic/elastic-charts/issues/89 and https://github.com/elastic/elastic-charts/issues/41
        this.canDataBeAnimated = false;
        this.chartInitialized.set(true);
    };
    return ChartStore;
}());
exports.ChartStore = ChartStore;
//# sourceMappingURL=chart_state.js.map