/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.common.util.ServerCookie;

public class CookieHelper {
    private static final Logger logger = Logger.getLogger(CookieHelper.class);

    public static void addCookie(String name, String value, String path, String domain, String comment, int maxAge, boolean secure, boolean httpOnly) {
        HttpResponse response = (HttpResponse)ResteasyProviderFactory.getContextData(HttpResponse.class);
        StringBuffer cookieBuf = new StringBuffer();
        ServerCookie.appendCookieValue((StringBuffer)cookieBuf, (int)1, (String)name, (String)value, (String)path, (String)domain, (String)comment, (int)maxAge, (boolean)secure, (boolean)httpOnly);
        String cookie = cookieBuf.toString();
        response.getOutputHeaders().add((Object)"Set-Cookie", (Object)cookie);
    }

    public static Set<String> getCookieValue(String name) {
        Cookie cookie;
        HttpHeaders headers = (HttpHeaders)ResteasyProviderFactory.getContextData(HttpHeaders.class);
        HashSet<String> cookiesVal = new HashSet<String>();
        List cookieHeader = (List)headers.getRequestHeaders().get((Object)"Cookie");
        if (cookieHeader != null) {
            logger.debugv("{1} cookie found in the request's header", (Object)name);
            cookieHeader.stream().map(s -> CookieHelper.parseCookie(s, name)).forEach(cookiesVal::addAll);
        }
        if ((cookie = (Cookie)headers.getCookies().get(name)) != null) {
            logger.debugv("{1} cookie found in the cookie's field", (Object)name);
            cookiesVal.add(cookie.getValue());
        }
        return cookiesVal;
    }

    public static Set<String> parseCookie(String cookieHeader, String name) {
        String[] parts = cookieHeader.split("[;,]");
        Set<String> cookies = Arrays.stream(parts).filter(part -> part.startsWith(name + "=")).map(part -> part.substring(part.indexOf(61) + 1)).collect(Collectors.toSet());
        return cookies;
    }
}

