/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import org.jboss.remoting3._private.Messages;
import org.xnio.Buffers;
import org.xnio.ByteBufferPool;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.conduits.ConduitStreamSourceChannel;

final class MessageReader {
    private final ConduitStreamSourceChannel sourceChannel;
    private final ArrayDeque<ByteBuffer> queue = new ArrayDeque();
    private final Object lock;
    private final ByteBuffer[] array = new ByteBuffer[16];
    static final Pooled<ByteBuffer> EOF_MARKER = Buffers.emptyPooledByteBuffer();

    MessageReader(ConduitStreamSourceChannel sourceChannel, Object lock) {
        this.sourceChannel = sourceChannel;
        this.lock = lock;
    }

    ConduitStreamSourceChannel getSourceChannel() {
        return this.sourceChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Pooled<ByteBuffer> getMessage() throws IOException {
        var1_1 = this.lock;
        synchronized (var1_1) {
            block9: while (true) {
                block39: {
                    block40: {
                        block41: {
                            if ((first = this.queue.peekFirst()) == null) break block40;
                            if (first.remaining() < 4) break block41;
                            size = first.getInt(first.position());
                            if (this.remaining(size + 4)) {
                                message = ByteBufferPool.MEDIUM_HEAP.allocate();
                                first.getInt();
                                for (cnt = 0; cnt < size; cnt += Buffers.copy((int)(size - cnt), (ByteBuffer)message, (ByteBuffer)first)) {
                                    if (first.hasRemaining()) continue;
                                    ByteBufferPool.free((ByteBuffer)first);
                                    this.queue.pollFirst();
                                    first = this.queue.peekFirst();
                                }
                                message.flip();
                                if (first != null && first.position() + 4 > first.limit()) {
                                    first.compact();
                                    first.flip();
                                }
                                Messages.conn.tracef("Received message %s", message);
                                return Buffers.globalPooledWrapper((ByteBuffer)message);
                            }
                            if (Messages.conn.isTraceEnabled()) {
                                Messages.conn.tracef("Not enough buffered bytes for message of size %d+4 (%s)", size, first);
                            }
                            break block39;
                        }
                        if (this.queue.peekLast() == first) {
                            first.compact().flip();
                            break block39;
                        } else {
                            first.compact();
                            try {
                                iterator = this.queue.iterator();
                                iterator.next();
                                if (!MessageReader.$assertionsDisabled && !iterator.hasNext()) {
                                    throw new AssertionError();
                                }
                                do {
                                    if ((next = iterator.next()).remaining() > 4) {
                                        first.putInt(next.getInt());
                                        continue;
                                    }
                                    Buffers.copy((ByteBuffer)first, (ByteBuffer)next);
                                    iterator.remove();
                                } while (first.position() < 4 && iterator.hasNext());
                                if (first.position() >= 4) {
                                }
                                break block39;
                            }
                            finally {
                                first.flip();
                            }
                            continue;
                        }
                    }
                    Messages.conn.trace("No buffers in queue for message header");
                }
                b = this.array;
                last = this.queue.pollLast();
                if (last != null) {
                    last.compact();
                    b[0] = last;
                    ByteBufferPool.MEDIUM_DIRECT.allocate(b, 1);
                    Messages.conn.tracef("Compacted existing buffer %s", last);
                } else {
                    ByteBufferPool.MEDIUM_DIRECT.allocate(b, 0);
                    Messages.conn.tracef("Allocated fresh buffers", new Object[0]);
                }
                try {
                    res = this.sourceChannel.read(b);
                    if (res == -1L) {
                        Messages.conn.trace("Received EOF");
                        var7_11 = MessageReader.EOF_MARKER;
                        i = 0;
                    }
                    ** GOTO lbl-1000
                }
                catch (Throwable var10_17) {
                    i = 0;
                    while (true) {
                        if (i >= b.length) {
                            throw var10_17;
                        }
                        buffer = b[i];
                        if (buffer.position() > 0) {
                            buffer.flip();
                            this.queue.addLast(buffer);
                        } else {
                            ByteBufferPool.free((ByteBuffer)buffer);
                        }
                        b[i] = null;
                        ++i;
                    }
                }
                while (true) {
                    if (i >= b.length) {
                        return var7_11;
                    }
                    buffer = b[i];
                    if (buffer.position() > 0) {
                        buffer.flip();
                        this.queue.addLast(buffer);
                    } else {
                        ByteBufferPool.free((ByteBuffer)buffer);
                    }
                    b[i] = null;
                    ++i;
                }
lbl-1000:
                // 1 sources

                {
                    if (res != 0L) ** GOTO lbl-1000
                    Messages.conn.trace("No read bytes available");
                    var7_12 = null;
                    i = 0;
                }
                while (true) {
                    if (i >= b.length) {
                        return var7_12;
                    }
                    buffer = b[i];
                    if (buffer.position() > 0) {
                        buffer.flip();
                        this.queue.addLast(buffer);
                    } else {
                        ByteBufferPool.free((ByteBuffer)buffer);
                    }
                    b[i] = null;
                    ++i;
                }
lbl-1000:
                // 1 sources

                {
                    if (Messages.conn.isTraceEnabled()) {
                        Messages.conn.tracef("Received %d bytes", res);
                    }
                    i = 0;
                }
                while (true) {
                    if (i < b.length) ** break;
                    continue block9;
                    buffer = b[i];
                    if (buffer.position() > 0) {
                        buffer.flip();
                        this.queue.addLast(buffer);
                    } else {
                        ByteBufferPool.free((ByteBuffer)buffer);
                    }
                    b[i] = null;
                    ++i;
                }
                break;
            }
        }
    }

    private boolean remaining(int cnt) {
        int rem = 0;
        for (ByteBuffer buffer : this.queue) {
            if ((rem += buffer.remaining()) < cnt) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            ByteBuffer buffer;
            IoUtils.safeClose((Closeable)this.sourceChannel);
            while ((buffer = this.queue.pollFirst()) != null) {
                ByteBufferPool.free((ByteBuffer)buffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadListener(ChannelListener<? super ConduitStreamSourceChannel> readListener) {
        Object object = this.lock;
        synchronized (object) {
            this.sourceChannel.setReadListener(readListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendReads() {
        Object object = this.lock;
        synchronized (object) {
            this.getSourceChannel().suspendReads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeReads() {
        Object object = this.lock;
        synchronized (object) {
            this.getSourceChannel().resumeReads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeupReads() {
        Object object = this.lock;
        synchronized (object) {
            this.getSourceChannel().wakeupReads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownReads() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.getSourceChannel().shutdownReads();
        }
    }
}

