/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.aesh;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jboss.aesh.console.AeshConsoleImpl;

public class ValveInputStream
extends InputStream {
    private BlockingQueue<InputStream> queue = new LinkedBlockingQueue<InputStream>(10);
    private InputStream current;
    private AeshConsoleImpl console;

    @Override
    public int read() throws IOException {
        int c;
        if (this.current == null) {
            try {
                this.current = this.queue.take();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("Signalled to exit");
            }
        }
        if ((c = this.current.read()) == -1 && this.console != null) {
            this.console.stop();
        }
        return c;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int c = this.read();
        if (c == -1) {
            return c;
        }
        b[off] = (byte)c;
        return 1;
    }

    public void setInputStream(InputStream is) {
        if (this.queue.contains(is)) {
            return;
        }
        this.queue.add(is);
    }

    public void setConsole(AeshConsoleImpl console) {
        this.console = console;
    }

    public boolean isStdinAvailable() {
        return this.console.isRunning();
    }
}

