/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health.deployment;

import io.smallrye.health.SmallRyeHealthReporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.Unmanaged;
import javax.enterprise.inject.spi.WithAnnotations;
import org.eclipse.microprofile.health.Health;
import org.eclipse.microprofile.health.HealthCheck;
import org.wildfly.extension.microprofile.health._private.MicroProfileHealthLogger;

public class CDIExtension
implements Extension {
    private final SmallRyeHealthReporter healthReporter;
    private List<AnnotatedType<? extends HealthCheck>> delegates = new ArrayList<AnnotatedType<? extends HealthCheck>>();
    private Collection<Unmanaged.UnmanagedInstance<HealthCheck>> healthCheckInstances = new ArrayList<Unmanaged.UnmanagedInstance<HealthCheck>>();

    public CDIExtension(SmallRyeHealthReporter healthReporter) {
        this.healthReporter = healthReporter;
    }

    public void observeResources(@Observes @WithAnnotations(value={Health.class}) ProcessAnnotatedType<? extends HealthCheck> event) {
        AnnotatedType annotatedType = event.getAnnotatedType();
        Class javaClass = annotatedType.getJavaClass();
        MicroProfileHealthLogger.LOGGER.infof("Discovered health check procedure %s", javaClass);
        this.delegates.add((AnnotatedType<? extends HealthCheck>)annotatedType);
    }

    private void afterDeploymentValidation(@Observes AfterDeploymentValidation avd, BeanManager bm) {
        for (AnnotatedType<? extends HealthCheck> delegate : this.delegates) {
            try {
                Unmanaged unmanagedHealthCheck = new Unmanaged(bm, delegate.getJavaClass());
                Unmanaged.UnmanagedInstance healthCheckInstance = unmanagedHealthCheck.newInstance();
                HealthCheck healthCheck = (HealthCheck)healthCheckInstance.produce().inject().postConstruct().get();
                this.healthCheckInstances.add((Unmanaged.UnmanagedInstance<HealthCheck>)healthCheckInstance);
                this.healthReporter.addHealthCheck(healthCheck);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to register health bean", e);
            }
        }
    }

    public void close(@Observes BeforeShutdown bs) {
        this.healthCheckInstances.forEach(healthCheck -> {
            this.healthReporter.removeHealthCheck((HealthCheck)healthCheck.get());
            healthCheck.preDestroy().dispose();
        });
        this.healthCheckInstances.clear();
    }
}

