/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.function.Function;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.HTTPAcceptorAdd;
import org.wildfly.extension.messaging.activemq.HTTPAcceptorRemove;
import org.wildfly.extension.messaging.activemq.HTTPUpgradeService;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.MessagingServices;

public class HTTPAcceptorDefinition
extends PersistentResourceDefinition {
    static final SimpleAttributeDefinition HTTP_LISTENER = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"http-listener", (ModelType)ModelType.STRING).setRequired(true)).build();
    static final SimpleAttributeDefinition UPGRADE_LEGACY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"upgrade-legacy", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(true))).setRequired(false)).setAllowExpression(true)).build();
    static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.messaging.activemq", (boolean)true, HTTPUpgradeService.class).setDynamicNameMapper((Function)new MessagingServices.ServerNameMapper("http-upgrade-service")).addRequirements(new String[]{"org.wildfly.remoting.http-listener-registry"}).addAdditionalRequiredPackages(new String[]{"io.undertow.core", "org.jboss.as.remoting", "org.jboss.xnio", "org.jboss.xnio.netty.netty-xnio-transport"}).build();
    static AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{HTTP_LISTENER, CommonAttributes.PARAMS, UPGRADE_LEGACY};
    static final HTTPAcceptorDefinition INSTANCE = new HTTPAcceptorDefinition();

    private HTTPAcceptorDefinition() {
        super(new SimpleResourceDefinition.Parameters(MessagingExtension.HTTP_ACCEPTOR_PATH, (ResourceDescriptionResolver)new StandardResourceDescriptionResolver("acceptor", MessagingExtension.RESOURCE_NAME, MessagingExtension.class.getClassLoader(), true, false){

            public String getResourceDescription(Locale locale, ResourceBundle bundle) {
                return bundle.getString("http-acceptor");
            }
        }).addCapabilities(new RuntimeCapability[]{CAPABILITY}).setAddHandler((OperationStepHandler)HTTPAcceptorAdd.INSTANCE).setRemoveHandler((OperationStepHandler)HTTPAcceptorRemove.INSTANCE));
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        ReloadRequiredWriteAttributeHandler attributeHandler = new ReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attr : ATTRIBUTES) {
            if (attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)attributeHandler);
        }
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }
}

