/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.connector.ByteBufferPool;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.servlet.api.CrawlerSessionManagerConfig;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletStackTraces;
import io.undertow.servlet.api.SessionPersistenceManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.JSPConfig;
import org.wildfly.extension.undertow.SessionCookieConfig;
import org.xnio.XnioWorker;

public class ServletContainerService
implements Service<ServletContainerService> {
    private final boolean allowNonStandardWrappers;
    private final ServletStackTraces stackTraces;
    private final SessionCookieConfig sessionCookieConfig;
    private final JSPConfig jspConfig;
    private volatile ServletContainer servletContainer;
    private final InjectedValue<DirectBufferCache> bufferCacheInjectedValue = new InjectedValue();
    private final InjectedValue<SessionPersistenceManager> sessionPersistenceManagerInjectedValue = new InjectedValue();
    private final String defaultEncoding;
    private final boolean useListenerEncoding;
    private final boolean ignoreFlush;
    private final boolean eagerFilterInit;
    private final int defaultSessionTimeout;
    private final boolean disableCachingForSecuredPages;
    private final Boolean directoryListingEnabled;
    private final int sessionIdLength;
    private final CrawlerSessionManagerConfig crawlerSessionManagerConfig;
    private final boolean websocketsEnabled;
    private final InjectedValue<ByteBufferPool> websocketsBufferPool = new InjectedValue();
    private final InjectedValue<XnioWorker> websocketsWorker = new InjectedValue();
    private final boolean dispatchWebsocketInvocationToWorker;
    private final boolean perMessageDeflate;
    private final int deflaterLevel;
    private final Map<String, String> mimeMappings;
    private final List<String> welcomeFiles;
    private final boolean proactiveAuth;
    private final Map<String, AuthenticationMechanismFactory> authenticationMechanisms;
    private final Integer maxSessions;
    private final boolean disableFileWatchService;
    private final boolean disableSessionIdReuse;
    private final int fileCacheMetadataSize;
    private final int fileCacheMaxFileSize;
    private final Integer fileCacheTimeToLive;
    private final int defaultCookieVersion;

    public ServletContainerService(boolean allowNonStandardWrappers, ServletStackTraces stackTraces, SessionCookieConfig sessionCookieConfig, JSPConfig jspConfig, String defaultEncoding, boolean useListenerEncoding, boolean ignoreFlush, boolean eagerFilterInit, int defaultSessionTimeout, boolean disableCachingForSecuredPages, boolean websocketsEnabled, boolean dispatchWebsocketInvocationToWorker, boolean perMessageDeflate, int deflaterLevel, Map<String, String> mimeMappings, List<String> welcomeFiles, Boolean directoryListingEnabled, boolean proactiveAuth, int sessionIdLength, Map<String, AuthenticationMechanismFactory> authenticationMechanisms, Integer maxSessions, CrawlerSessionManagerConfig crawlerSessionManagerConfig, boolean disableFileWatchService, boolean disableSessionIdReuse, int fileCacheMetadataSize, int fileCacheMaxFileSize, Integer fileCacheTimeToLive, int defaultCookieVersion) {
        this.allowNonStandardWrappers = allowNonStandardWrappers;
        this.stackTraces = stackTraces;
        this.sessionCookieConfig = sessionCookieConfig;
        this.jspConfig = jspConfig;
        this.defaultEncoding = defaultEncoding;
        this.useListenerEncoding = useListenerEncoding;
        this.ignoreFlush = ignoreFlush;
        this.eagerFilterInit = eagerFilterInit;
        this.defaultSessionTimeout = defaultSessionTimeout;
        this.disableCachingForSecuredPages = disableCachingForSecuredPages;
        this.websocketsEnabled = websocketsEnabled;
        this.dispatchWebsocketInvocationToWorker = dispatchWebsocketInvocationToWorker;
        this.perMessageDeflate = perMessageDeflate;
        this.deflaterLevel = deflaterLevel;
        this.directoryListingEnabled = directoryListingEnabled;
        this.proactiveAuth = proactiveAuth;
        this.maxSessions = maxSessions;
        this.crawlerSessionManagerConfig = crawlerSessionManagerConfig;
        this.disableFileWatchService = disableFileWatchService;
        this.welcomeFiles = new ArrayList<String>(welcomeFiles);
        this.mimeMappings = new HashMap<String, String>(mimeMappings);
        this.sessionIdLength = sessionIdLength;
        this.authenticationMechanisms = authenticationMechanisms;
        this.disableSessionIdReuse = disableSessionIdReuse;
        this.fileCacheMetadataSize = fileCacheMetadataSize;
        this.fileCacheMaxFileSize = fileCacheMaxFileSize;
        this.fileCacheTimeToLive = fileCacheTimeToLive;
        this.defaultCookieVersion = defaultCookieVersion;
    }

    public void start(StartContext context) throws StartException {
        this.servletContainer = ServletContainer.Factory.newInstance();
    }

    public void stop(StopContext context) {
    }

    public ServletContainerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public Map<String, AuthenticationMechanismFactory> getAuthenticationMechanisms() {
        return this.authenticationMechanisms;
    }

    public ServletContainer getServletContainer() {
        return this.servletContainer;
    }

    public boolean isAllowNonStandardWrappers() {
        return this.allowNonStandardWrappers;
    }

    public JSPConfig getJspConfig() {
        return this.jspConfig;
    }

    public ServletStackTraces getStackTraces() {
        return this.stackTraces;
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this.sessionCookieConfig;
    }

    InjectedValue<DirectBufferCache> getBufferCacheInjectedValue() {
        return this.bufferCacheInjectedValue;
    }

    public DirectBufferCache getBufferCache() {
        return (DirectBufferCache)this.bufferCacheInjectedValue.getOptionalValue();
    }

    public boolean isDisableCachingForSecuredPages() {
        return this.disableCachingForSecuredPages;
    }

    public boolean isDispatchWebsocketInvocationToWorker() {
        return this.dispatchWebsocketInvocationToWorker;
    }

    public InjectedValue<XnioWorker> getWebsocketsWorker() {
        return this.websocketsWorker;
    }

    public InjectedValue<ByteBufferPool> getWebsocketsBufferPool() {
        return this.websocketsBufferPool;
    }

    public boolean isPerMessageDeflate() {
        return this.perMessageDeflate;
    }

    public int getDeflaterLevel() {
        return this.deflaterLevel;
    }

    public boolean isWebsocketsEnabled() {
        return this.websocketsEnabled;
    }

    public boolean isDisableSessionIdReuse() {
        return this.disableSessionIdReuse;
    }

    InjectedValue<SessionPersistenceManager> getSessionPersistenceManagerInjectedValue() {
        return this.sessionPersistenceManagerInjectedValue;
    }

    public SessionPersistenceManager getSessionPersistenceManager() {
        return (SessionPersistenceManager)this.sessionPersistenceManagerInjectedValue.getOptionalValue();
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public boolean isUseListenerEncoding() {
        return this.useListenerEncoding;
    }

    public boolean isIgnoreFlush() {
        return this.ignoreFlush;
    }

    public boolean isEagerFilterInit() {
        return this.eagerFilterInit;
    }

    public int getDefaultSessionTimeout() {
        return this.defaultSessionTimeout;
    }

    public Map<String, String> getMimeMappings() {
        return Collections.unmodifiableMap(this.mimeMappings);
    }

    public List<String> getWelcomeFiles() {
        return this.welcomeFiles;
    }

    public Boolean getDirectoryListingEnabled() {
        return this.directoryListingEnabled;
    }

    public boolean isProactiveAuth() {
        return this.proactiveAuth;
    }

    public int getSessionIdLength() {
        return this.sessionIdLength;
    }

    public Integer getMaxSessions() {
        return this.maxSessions;
    }

    public boolean isDisableFileWatchService() {
        return this.disableFileWatchService;
    }

    public CrawlerSessionManagerConfig getCrawlerSessionManagerConfig() {
        return this.crawlerSessionManagerConfig;
    }

    public int getFileCacheMetadataSize() {
        return this.fileCacheMetadataSize;
    }

    public int getFileCacheMaxFileSize() {
        return this.fileCacheMaxFileSize;
    }

    public Integer getFileCacheTimeToLive() {
        return this.fileCacheTimeToLive;
    }

    public int getDefaultCookieVersion() {
        return this.defaultCookieVersion;
    }
}

