/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.keystore;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.CertificateException;
import org.wildfly.security.keystore.AtomicLoadKeyStoreSpi;
import org.wildfly.security.keystore.ElytronMessages;

public class AtomicLoadKeyStore
extends KeyStore {
    private final AtomicLoadKeyStoreSpi keyStoreSpi;

    private AtomicLoadKeyStore(AtomicLoadKeyStoreSpi keyStoreSpi, Provider provider, String type) {
        super(keyStoreSpi, provider, type);
        this.keyStoreSpi = keyStoreSpi;
    }

    public static AtomicLoadKeyStore newInstance(String type, Provider provider) {
        AtomicLoadKeyStoreSpi keyStoreSpi = new AtomicLoadKeyStoreSpi(() -> KeyStore.getInstance(type, provider));
        ElytronMessages.tls.tracef("AtomicLoadKeyStore creating:  type = %s,  provider =  %s", type, provider);
        return new AtomicLoadKeyStore(keyStoreSpi, provider, type);
    }

    public static AtomicLoadKeyStore newInstance(String type, String provider) throws KeyStoreException, NoSuchProviderException {
        KeyStore keyStore = provider != null ? KeyStore.getInstance(type, provider) : KeyStore.getInstance(type);
        Provider resolvedProvider = keyStore.getProvider();
        return AtomicLoadKeyStore.newInstance(type, resolvedProvider);
    }

    public static AtomicLoadKeyStore newInstance(String type) throws KeyStoreException {
        try {
            return AtomicLoadKeyStore.newInstance(type, (String)null);
        }
        catch (NoSuchProviderException e) {
            throw new KeyStoreException(e);
        }
    }

    public static AtomicLoadKeyStore atomize(KeyStore keyStore) throws CertificateException, NoSuchAlgorithmException, IOException {
        String type = keyStore.getType();
        Provider provider = keyStore.getProvider();
        AtomicLoadKeyStoreSpi keyStoreSpi = new AtomicLoadKeyStoreSpi(() -> KeyStore.getInstance(type, provider));
        AtomicLoadKeyStore result = new AtomicLoadKeyStore(keyStoreSpi, provider, type);
        result.load(null, null);
        result.setKeyStore(keyStore);
        return result;
    }

    private void setKeyStore(KeyStore keyStore) {
        this.keyStoreSpi.restoreKeyStore(keyStore);
    }

    public LoadKey revertibleLoad(InputStream inputStream, char[] password) throws NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore current = this.keyStoreSpi.getCurrentKeyStore();
        if (current == null) {
            throw ElytronMessages.log.reversibleLoadNotPossible();
        }
        this.load(inputStream, password);
        return new LoadKey(current);
    }

    public void revert(LoadKey key) {
        this.keyStoreSpi.restoreKeyStore(key.keyStore);
    }

    public class LoadKey {
        private final KeyStore keyStore;

        private LoadKey(KeyStore keyStore) {
            this.keyStore = keyStore;
        }
    }
}

