/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.jpa.JpaModel;
import org.keycloak.models.jpa.entities.RoleAttributeEntity;
import org.keycloak.models.jpa.entities.RoleEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public class RoleAdapter
implements RoleModel,
JpaModel<RoleEntity> {
    protected RoleEntity role;
    protected EntityManager em;
    protected RealmModel realm;
    protected KeycloakSession session;

    public RoleAdapter(KeycloakSession session, RealmModel realm, EntityManager em, RoleEntity role) {
        this.em = em;
        this.realm = realm;
        this.role = role;
        this.session = session;
    }

    @Override
    public RoleEntity getEntity() {
        return this.role;
    }

    public void setRole(RoleEntity role) {
        this.role = role;
    }

    public String getName() {
        return this.role.getName();
    }

    public String getDescription() {
        return this.role.getDescription();
    }

    public void setDescription(String description) {
        this.role.setDescription(description);
    }

    public String getId() {
        return this.role.getId();
    }

    public void setName(String name) {
        this.role.setName(name);
    }

    public boolean isComposite() {
        return this.getComposites().size() > 0;
    }

    public void addCompositeRole(RoleModel role) {
        RoleEntity entity = RoleAdapter.toRoleEntity(role, this.em);
        for (RoleEntity composite : this.getEntity().getCompositeRoles()) {
            if (!composite.equals(entity)) continue;
            return;
        }
        this.getEntity().getCompositeRoles().add(entity);
    }

    public void removeCompositeRole(RoleModel role) {
        RoleEntity entity = RoleAdapter.toRoleEntity(role, this.em);
        this.getEntity().getCompositeRoles().remove(entity);
    }

    public Set<RoleModel> getComposites() {
        HashSet<RoleModel> set = new HashSet<RoleModel>();
        for (RoleEntity composite : this.getEntity().getCompositeRoles()) {
            set.add(new RoleAdapter(this.session, this.realm, this.em, composite));
        }
        return set;
    }

    public boolean hasRole(RoleModel role) {
        return this.equals(role) || KeycloakModelUtils.searchFor((RoleModel)role, (RoleModel)this, new HashSet());
    }

    private void persistAttributeValue(String name, String value) {
        RoleAttributeEntity attr = new RoleAttributeEntity();
        attr.setId(KeycloakModelUtils.generateId());
        attr.setName(name);
        attr.setValue(value);
        attr.setRole(this.role);
        this.em.persist((Object)attr);
        this.role.getAttributes().add(attr);
    }

    public void setSingleAttribute(String name, String value) {
        this.setAttribute(name, Collections.singletonList(value));
    }

    public void setAttribute(String name, Collection<String> values) {
        this.removeAttribute(name);
        for (String value : values) {
            this.persistAttributeValue(name, value);
        }
    }

    public void removeAttribute(String name) {
        Collection<RoleAttributeEntity> attributes = this.role.getAttributes();
        if (attributes == null) {
            return;
        }
        Query query = this.em.createNamedQuery("deleteRoleAttributesByNameAndUser");
        query.setParameter("name", (Object)name);
        query.setParameter("roleId", (Object)this.role.getId());
        query.executeUpdate();
        attributes.removeIf(attribute -> attribute.getName().equals(name));
    }

    public String getFirstAttribute(String name) {
        for (RoleAttributeEntity attribute : this.role.getAttributes()) {
            if (!attribute.getName().equals(name)) continue;
            return attribute.getValue();
        }
        return null;
    }

    public List<String> getAttribute(String name) {
        ArrayList<String> attributes = new ArrayList<String>();
        for (RoleAttributeEntity attribute : this.role.getAttributes()) {
            if (!attribute.getName().equals(name)) continue;
            attributes.add(attribute.getValue());
        }
        return attributes;
    }

    public Map<String, List<String>> getAttributes() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (RoleAttributeEntity attribute : this.role.getAttributes()) {
            map.computeIfAbsent(attribute.getName(), name -> new ArrayList()).add(attribute.getValue());
        }
        return map;
    }

    public boolean isClientRole() {
        return this.role.isClientRole();
    }

    public String getContainerId() {
        if (this.isClientRole()) {
            return this.role.getClient().getId();
        }
        return this.realm.getId();
    }

    public RoleContainerModel getContainer() {
        if (this.role.isClientRole()) {
            return this.realm.getClientById(this.role.getClient().getId());
        }
        return this.realm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RoleModel)) {
            return false;
        }
        RoleModel that = (RoleModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public static RoleEntity toRoleEntity(RoleModel model, EntityManager em) {
        if (model instanceof RoleAdapter) {
            return ((RoleAdapter)model).getEntity();
        }
        return (RoleEntity)em.getReference(RoleEntity.class, (Object)model.getId());
    }
}

