#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: clash-prelude
version: 0.99.3
id: clash-prelude-0.99.3-PkfzfYP0Yc2XpfastYhEm
key: clash-prelude-0.99.3-PkfzfYP0Yc2XpfastYhEm
license: BSD-2-Clause
copyright: Copyright © 2013-2016, University of Twente,
           2016-2017, Myrtle Software Ltd,
           2017     , QBayLogic, Google Inc.
maintainer: Christiaan Baaij <christiaan.baaij@gmail.com>
author: Christiaan Baaij
homepage: http://www.clash-lang.org/
synopsis: CAES Language for Synchronous Hardware - Prelude library
description:
    CλaSH (pronounced ‘clash’) is a functional hardware description language that
    borrows both its syntax and semantics from the functional programming language
    Haskell. The CλaSH compiler transforms these high-level descriptions to
    low-level synthesizable VHDL, Verilog, or SystemVerilog.
    .
    Features of CλaSH:
    .
    * Strongly typed, but with a very high degree of type inference, enabling both
    safe and fast prototyping using concise descriptions.
    .
    * Interactive REPL: load your designs in an interpreter and easily test all
    your component without needing to setup a test bench.
    .
    * Higher-order functions, with type inference, result in designs that are
    fully parametric by default.
    .
    * Synchronous sequential circuit design based on streams of values, called
    @Signal@s, lead to natural descriptions of feedback loops.
    .
    * Support for multiple clock domains, with type safe clock domain crossing.
    .
    .
    This package provides:
    .
    * Prelude library containing datatypes and functions for circuit design
    .
    To use the library:
    .
    * Import "Clash.Prelude"
    .
    * Alternatively, if you want to explicitly route clock and reset ports,
    for more straightforward multi-clock designs, you can import the
    "Clash.Explicit.Prelude" module. Note that you should not import
    "Clash.Prelude" and "Clash.Explicit.Prelude" at the same time as they
    have overlapping definitions.
    .
    A preliminary version of a tutorial can be found in "Clash.Tutorial", for a
    general overview of the library you should however check out "Clash.Prelude".
    Some circuit examples can be found in "Clash.Examples".
category: Hardware
abi: 11b152408d426c311ab7b23703301cce
exposed: True
exposed-modules:
    Clash.Annotations.Primitive Clash.Annotations.TopEntity
    Clash.Class.BitPack Clash.Class.Num Clash.Class.Resize
    Clash.Examples Clash.Explicit.BlockRam Clash.Explicit.BlockRam.File
    Clash.Explicit.DDR Clash.Explicit.Mealy Clash.Explicit.Moore
    Clash.Explicit.Prelude Clash.Explicit.Prelude.Safe
    Clash.Explicit.RAM Clash.Explicit.ROM Clash.Explicit.ROM.File
    Clash.Explicit.Signal Clash.Explicit.Signal.Delayed
    Clash.Explicit.Synchronizer Clash.Explicit.Testbench Clash.Hidden
    Clash.Intel.ClockGen Clash.Intel.DDR Clash.NamedTypes Clash.Prelude
    Clash.Prelude.BitIndex Clash.Prelude.BitReduction
    Clash.Prelude.BlockRam Clash.Prelude.BlockRam.File
    Clash.Prelude.DataFlow Clash.Prelude.Mealy Clash.Prelude.Moore
    Clash.Prelude.RAM Clash.Prelude.ROM Clash.Prelude.ROM.File
    Clash.Prelude.Safe Clash.Prelude.Testbench Clash.Promoted.Nat
    Clash.Promoted.Nat.Literals Clash.Promoted.Nat.TH
    Clash.Promoted.Nat.Unsafe Clash.Promoted.Symbol Clash.Signal
    Clash.Signal.Bundle Clash.Signal.Delayed Clash.Signal.Internal
    Clash.Sized.BitVector Clash.Sized.Fixed Clash.Sized.Index
    Clash.Sized.Internal.BitVector Clash.Sized.Internal.Index
    Clash.Sized.Internal.Signed Clash.Sized.Internal.Unsigned
    Clash.Sized.RTree Clash.Sized.Signed Clash.Sized.Unsigned
    Clash.Sized.Vector Clash.Tutorial Clash.XException
    Clash.Xilinx.ClockGen Clash.Xilinx.DDR
hidden-modules: Clash.Class.BitPack.Internal
                Clash.Signal.Bundle.Internal
import-dirs: /usr/lib/ghc-8.6.5/site-local/clash-prelude-0.99.3
library-dirs: /usr/lib/ghc-8.6.5/site-local/clash-prelude-0.99.3
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/x86_64-linux-ghc-8.6.5/clash-prelude-0.99.3
hs-libraries: HSclash-prelude-0.99.3-PkfzfYP0Yc2XpfastYhEm
depends:
    QuickCheck-2.13.2-C3chvSwT3GSBClgQ9bo1MW array-0.5.3.0
    base-4.12.0.0 bifunctors-5.5.5-B9uCrLlHHzRLLgqunxnstR
    constraints-0.11-D4xGLU6RJE9EfLT4cxltwW
    data-binary-ieee754-0.4.4-Jh3qq4jPu7AAxCF7JMXnJo
    data-default-0.7.1.1-5JZ15VDIkjR94TfgciXLrQ deepseq-1.4.4.0
    ghc-prim-0.5.3 ghc-typelits-extra-0.3.1-1DK8I3v2bvQN64Lrpi4cn
    ghc-typelits-knownnat-0.6-560x8qSwYIZ7BMNOLKommZ
    ghc-typelits-natnormalise-0.6.2-FWs6Dh9aCE36E9A1OWqilx
    half-0.3-9XTNcd6tfGML6nFcoqjujT integer-gmp-1.0.2.0
    lens-4.17.1-LAhRbmSla4gFq61XVUqFfx
    reflection-2.1.5-HiermeVVK3ZBGBqwwJKCPI
    singletons-2.5.1-CeJR1cyijsQ8Bj03hwMyX template-haskell-2.14.0.0
    transformers-0.5.6.2 vector-0.12.0.3-2LEYu9M2i7lERDtz76XG3n
haddock-interfaces: /usr/share/doc/haskell-clash-prelude/html/clash-prelude.haddock
haddock-html: /usr/share/doc/haskell-clash-prelude/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

