/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.ClassNodeResolver;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.ResolveVisitor;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.trait.Traits;

public class GradleResolveVisitor
extends ResolveVisitor {
    private static final String[] DEFAULT_IMPORTS = new String[]{"java.lang.", "java.io.", "java.net.", "java.util.", "groovy.lang.", "groovy.util.", "java.time."};
    private static final String SCRIPTS_PACKAGE = "org.gradle.groovy.scripts";
    private ClassNode currentClass;
    private final Map<String, List<String>> simpleNameToFQN;
    private CompilationUnit compilationUnit;
    private SourceUnit source;
    private VariableScope currentScope;
    private boolean isTopLevelProperty = true;
    private boolean inPropertyExpression;
    private boolean inClosure;
    private Map<String, GenericsType> genericParameterNames = new HashMap<String, GenericsType>();
    private Set<FieldNode> fieldTypesChecked = new HashSet<FieldNode>();
    private boolean checkingVariableTypeInDeclaration;
    private ImportNode currImportNode;
    private MethodNode currentMethod;
    private ClassNodeResolver classNodeResolver;
    private static final ClassNode NO_CLASS;

    private static String replacePoints(String name) {
        return name.replace('.', '$');
    }

    public GradleResolveVisitor(CompilationUnit cu, Map<String, List<String>> simpleNameToFQN) {
        super(cu);
        this.compilationUnit = cu;
        this.classNodeResolver = new ClassNodeResolver();
        this.simpleNameToFQN = simpleNameToFQN;
    }

    public void startResolving(ClassNode node, SourceUnit source) {
        this.source = source;
        this.visitClass(node);
    }

    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        ClassNode[] exceptions;
        Parameter[] paras;
        VariableScope oldScope = this.currentScope;
        this.currentScope = node.getVariableScope();
        Map<String, GenericsType> oldPNames = this.genericParameterNames;
        this.genericParameterNames = new HashMap<String, GenericsType>(this.genericParameterNames);
        this.resolveGenericsHeader(node.getGenericsTypes());
        for (Parameter p : paras = node.getParameters()) {
            p.setInitialExpression(this.transform(p.getInitialExpression()));
            this.resolveOrFail(p.getType(), (ASTNode)p.getType());
            this.visitAnnotations((AnnotatedNode)p);
        }
        for (ClassNode t : exceptions = node.getExceptions()) {
            this.resolveOrFail(t, (ASTNode)node);
        }
        this.resolveOrFail(node.getReturnType(), (ASTNode)node);
        MethodNode oldCurrentMethod = this.currentMethod;
        this.currentMethod = node;
        super.visitConstructorOrMethod(node, isConstructor);
        this.currentMethod = oldCurrentMethod;
        this.genericParameterNames = oldPNames;
        this.currentScope = oldScope;
    }

    public void visitField(FieldNode node) {
        ClassNode t = node.getType();
        if (!this.fieldTypesChecked.contains(node)) {
            this.resolveOrFail(t, (ASTNode)node);
        }
        super.visitField(node);
    }

    public void visitProperty(PropertyNode node) {
        ClassNode t = node.getType();
        this.resolveOrFail(t, (ASTNode)node);
        super.visitProperty(node);
        this.fieldTypesChecked.add(node.getField());
    }

    private boolean resolveToInner(ClassNode type) {
        int len;
        String name;
        if (type instanceof ConstructedClassWithPackage) {
            return false;
        }
        if (type instanceof ConstructedNestedClass) {
            return false;
        }
        String saved = name = type.getName();
        while ((len = name.lastIndexOf(46)) != -1) {
            name = name.substring(0, len) + "$" + name.substring(len + 1);
            type.setName(name);
            if (!this.resolve(type)) continue;
            return true;
        }
        if (this.resolveToNestedOfCurrent(type)) {
            return true;
        }
        type.setName(saved);
        return false;
    }

    private boolean resolveToNestedOfCurrent(ClassNode type) {
        ConstructedNestedClass tmp;
        if (type instanceof ConstructedNestedClass) {
            return false;
        }
        String name = type.getName();
        if (this.currentClass != type && !name.contains(".") && type.getClass().equals(ClassNode.class) && this.resolve(tmp = new ConstructedNestedClass(this.currentClass, name))) {
            type.setRedirect((ClassNode)tmp);
            return true;
        }
        return false;
    }

    private void resolveOrFail(ClassNode type, String msg, ASTNode node) {
        if (this.resolve(type)) {
            return;
        }
        if (this.resolveToInner(type)) {
            return;
        }
        this.addError("unable to resolve class " + type.getName() + " " + msg, node);
    }

    private void resolveOrFail(ClassNode type, ASTNode node, boolean preferImports) {
        this.resolveGenericsTypes(type.getGenericsTypes());
        if (preferImports && this.resolveAliasFromModule(type)) {
            return;
        }
        this.resolveOrFail(type, node);
    }

    private void resolveOrFail(ClassNode type, ASTNode node) {
        this.resolveOrFail(type, "", node);
    }

    private boolean resolve(ClassNode type) {
        return this.resolve(type, true, true, true);
    }

    private boolean resolve(ClassNode type, boolean testModuleImports, boolean testDefaultImports, boolean testStaticInnerClasses) {
        this.resolveGenericsTypes(type.getGenericsTypes());
        if (type.isResolved() || type.isPrimaryClassNode()) {
            return true;
        }
        if (type.isArray()) {
            ClassNode element = type.getComponentType();
            boolean resolved = this.resolve(element, testModuleImports, testDefaultImports, testStaticInnerClasses);
            if (resolved) {
                ClassNode cn = element.makeArray();
                type.setRedirect(cn);
            }
            return resolved;
        }
        if (this.currentClass == type) {
            return true;
        }
        String name = type.getName();
        if (this.genericParameterNames.get(name) != null) {
            GenericsType gt = this.genericParameterNames.get(name);
            type.setRedirect(gt.getType());
            type.setGenericsTypes(new GenericsType[]{gt});
            type.setGenericsPlaceHolder(true);
            return true;
        }
        if (this.currentClass.getNameWithoutPackage().equals(name)) {
            type.setRedirect(this.currentClass);
            return true;
        }
        if (type.hasPackageName() && this.resolveFromResolver(type, name)) {
            return true;
        }
        return this.resolveNestedClass(type) || this.resolveFromModule(type, testModuleImports) || this.resolveFromCompileUnit(type) || this.resolveFromDefaultImports(type, testDefaultImports) || this.resolveFromStaticInnerClasses(type, testStaticInnerClasses) || this.resolveToOuter(type);
    }

    private boolean resolveFromResolver(ClassNode type, String name) {
        ClassNodeResolver.LookupResult result = this.classNodeResolver.resolveName(name, this.compilationUnit);
        if (result != null && result.isClassNode()) {
            type.setRedirect(result.getClassNode());
            return true;
        }
        return false;
    }

    private boolean resolveNestedClass(ClassNode type) {
        ConstructedNestedClass val;
        if (type instanceof ConstructedNestedClass) {
            return false;
        }
        LinkedHashMap<String, Object> classHierarchy = new LinkedHashMap<String, Object>();
        for (Object classToCheck = this.currentClass; classToCheck != null && classToCheck != ClassHelper.OBJECT_TYPE && !SCRIPTS_PACKAGE.equals(classToCheck.getPackageName()) && !classHierarchy.containsKey(classToCheck.getName()); classToCheck = classToCheck.getSuperClass()) {
            classHierarchy.put(classToCheck.getName(), classToCheck);
        }
        for (ClassNode classToCheck : classHierarchy.values()) {
            val = new ConstructedNestedClass(classToCheck, type.getName());
            if (this.resolveFromCompileUnit(val)) {
                type.setRedirect((ClassNode)val);
                return true;
            }
            for (ClassNode next : classToCheck.getAllInterfaces()) {
                if (type.getName().contains(next.getName()) || !this.resolve(val = new ConstructedNestedClass(next, type.getName()), false, false, false)) continue;
                type.setRedirect((ClassNode)val);
                return true;
            }
        }
        if (!(this.currentClass instanceof InnerClassNode)) {
            return false;
        }
        LinkedList<ClassNode> outerClasses = new LinkedList<ClassNode>();
        for (ClassNode outer = this.currentClass.getOuterClass(); outer != null; outer = outer.getOuterClass()) {
            outerClasses.addFirst(outer);
        }
        for (ClassNode testNode : outerClasses) {
            val = new ConstructedNestedClass(testNode, type.getName());
            if (this.resolveFromCompileUnit(val)) {
                type.setRedirect((ClassNode)val);
                return true;
            }
            for (ClassNode next : testNode.getAllInterfaces()) {
                if (type.getName().contains(next.getName()) || !this.resolve(val = new ConstructedNestedClass(next, type.getName()), false, false, false)) continue;
                type.setRedirect((ClassNode)val);
                return true;
            }
        }
        return false;
    }

    private static String replaceLastPoint(String name) {
        int lastPoint = name.lastIndexOf(46);
        if (lastPoint > 0) {
            name = name.substring(0, lastPoint) + "$" + name.substring(lastPoint + 1);
        }
        return name;
    }

    private boolean resolveFromStaticInnerClasses(ClassNode type, boolean testStaticInnerClasses) {
        if (type instanceof ConstructedNestedClass) {
            return false;
        }
        if (type instanceof LowerCaseClass) {
            return false;
        }
        if (testStaticInnerClasses &= type.hasPackageName()) {
            if (type instanceof ConstructedClassWithPackage) {
                ConstructedClassWithPackage tmp = (ConstructedClassWithPackage)type;
                String savedName = tmp.className;
                tmp.className = GradleResolveVisitor.replaceLastPoint(savedName);
                if (this.resolve(tmp, false, true, false)) {
                    type.setRedirect(tmp.redirect());
                    return true;
                }
                tmp.className = savedName;
            } else {
                String savedName = type.getName();
                String replacedPointType = GradleResolveVisitor.replaceLastPoint(savedName);
                type.setName(replacedPointType);
                if (this.resolve(type, false, true, false)) {
                    return true;
                }
                type.setName(savedName);
            }
        }
        return false;
    }

    private boolean resolveFromDefaultImports(ClassNode type, boolean testDefaultImports) {
        testDefaultImports &= !type.hasPackageName();
        if (testDefaultImports &= !(type instanceof LowerCaseClass)) {
            String name = type.getName();
            List<String> fqn = this.simpleNameToFQN.get(type.getName());
            if (fqn != null && this.resolveFromResolver(type, fqn.get(0))) {
                return true;
            }
            for (String packagePrefix : DEFAULT_IMPORTS) {
                ConstructedClassWithPackage tmp = new ConstructedClassWithPackage(packagePrefix, name);
                if (!this.resolve(tmp, false, false, false)) continue;
                type.setRedirect(tmp.redirect());
                return true;
            }
            if (name.equals("BigInteger")) {
                type.setRedirect(ClassHelper.BigInteger_TYPE);
                return true;
            }
            if (name.equals("BigDecimal")) {
                type.setRedirect(ClassHelper.BigDecimal_TYPE);
                return true;
            }
        }
        return false;
    }

    private boolean resolveFromCompileUnit(ClassNode type) {
        CompileUnit compileUnit = this.currentClass.getCompileUnit();
        if (compileUnit == null) {
            return false;
        }
        ClassNode cuClass = compileUnit.getClass(type.getName());
        if (cuClass != null) {
            if (type != cuClass) {
                type.setRedirect(cuClass);
            }
            return true;
        }
        return false;
    }

    private void ambiguousClass(ClassNode type, ClassNode iType, String name) {
        if (type.getName().equals(iType.getName())) {
            this.addError("reference to " + name + " is ambiguous, both class " + type.getName() + " and " + iType.getName() + " match", (ASTNode)type);
        } else {
            type.setRedirect(iType);
        }
    }

    private boolean resolveAliasFromModule(ClassNode type) {
        String name;
        if (type instanceof ConstructedClassWithPackage) {
            return false;
        }
        ModuleNode module = this.currentClass.getModule();
        if (module == null) {
            return false;
        }
        String pname = name = type.getName();
        int index = name.length();
        do {
            ConstructedNestedClass tmp;
            pname = name.substring(0, index);
            ClassNode aliasedNode = null;
            ImportNode importNode = module.getImport(pname);
            if (importNode != null && importNode != this.currImportNode) {
                aliasedNode = importNode.getType();
            }
            if (aliasedNode == null && (importNode = (ImportNode)module.getStaticImports().get(pname)) != null && importNode != this.currImportNode && this.resolve(tmp = new ConstructedNestedClass(importNode.getType(), importNode.getFieldName()), false, false, true) && (tmp.getModifiers() & 8) != 0) {
                type.setRedirect(tmp.redirect());
                return true;
            }
            if (aliasedNode == null) continue;
            if (pname.length() == name.length()) {
                type.setRedirect(aliasedNode);
                return true;
            }
            String className = aliasedNode.getNameWithoutPackage() + '$' + name.substring(pname.length() + 1).replace('.', '$');
            ConstructedClassWithPackage tmp2 = new ConstructedClassWithPackage(aliasedNode.getPackageName() + ".", className);
            if (!this.resolve(tmp2, true, true, false)) continue;
            type.setRedirect(tmp2.redirect());
            return true;
        } while ((index = pname.lastIndexOf(46)) != -1);
        return false;
    }

    private boolean resolveFromModule(ClassNode type, boolean testModuleImports) {
        if (type instanceof ConstructedNestedClass) {
            return false;
        }
        if (type instanceof LowerCaseClass) {
            return this.resolveAliasFromModule(type);
        }
        String name = type.getName();
        ModuleNode module = this.currentClass.getModule();
        if (module == null) {
            return false;
        }
        boolean newNameUsed = false;
        if (!type.hasPackageName() && module.hasPackageName() && !(type instanceof ConstructedClassWithPackage)) {
            type.setName(module.getPackageName() + name);
            newNameUsed = true;
        }
        List moduleClasses = module.getClasses();
        for (ClassNode mClass : moduleClasses) {
            if (!mClass.getName().equals(type.getName())) continue;
            if (mClass != type) {
                type.setRedirect(mClass);
            }
            return true;
        }
        if (newNameUsed) {
            type.setName(name);
        }
        if (testModuleImports) {
            ConstructedClassWithPackage tmp;
            if (this.resolveAliasFromModule(type)) {
                return true;
            }
            if (module.hasPackageName() && this.resolve(tmp = new ConstructedClassWithPackage(module.getPackageName(), name), false, false, false)) {
                this.ambiguousClass(type, tmp, name);
                type.setRedirect(tmp.redirect());
                return true;
            }
            if (!name.contains(".")) {
                ConstructedNestedClass tmp2;
                for (ImportNode importNode : module.getStaticImports().values()) {
                    if (!importNode.getFieldName().equals(name) || !this.resolve(tmp2 = new ConstructedNestedClass(importNode.getType(), name), false, false, true) || (tmp2.getModifiers() & 8) == 0) continue;
                    type.setRedirect(tmp2.redirect());
                    return true;
                }
                for (ImportNode importNode : module.getStarImports()) {
                    String packagePrefix = importNode.getPackageName();
                    ConstructedClassWithPackage tmp3 = new ConstructedClassWithPackage(packagePrefix, name);
                    if (!this.resolve(tmp3, false, false, true)) continue;
                    this.ambiguousClass(type, tmp3, name);
                    type.setRedirect(tmp3.redirect());
                    return true;
                }
                for (ImportNode importNode : module.getStaticStarImports().values()) {
                    tmp2 = new ConstructedNestedClass(importNode.getType(), name);
                    if (!this.resolve(tmp2, false, false, true) || (tmp2.getModifiers() & 8) == 0) continue;
                    this.ambiguousClass(type, tmp2, name);
                    type.setRedirect(tmp2.redirect());
                    return true;
                }
            }
        }
        return false;
    }

    private boolean resolveToOuter(ClassNode type) {
        String name = type.getName();
        if (type instanceof LowerCaseClass) {
            this.classNodeResolver.cacheClass(name, NO_CLASS);
            return false;
        }
        if (name.contains("$")) {
            return false;
        }
        if (this.currentClass.getModule().hasPackageName() && name.indexOf(46) == -1) {
            return false;
        }
        ClassNodeResolver.LookupResult lr = null;
        lr = this.classNodeResolver.resolveName(name, this.compilationUnit);
        if (lr != null) {
            if (lr.isSourceUnit()) {
                SourceUnit su = lr.getSourceUnit();
                this.currentClass.getCompileUnit().addClassNodeToCompile(type, su);
            } else {
                type.setRedirect(lr.getClassNode());
            }
            return true;
        }
        return false;
    }

    public Expression transform(Expression exp) {
        if (exp == null) {
            return null;
        }
        Expression ret = null;
        if (exp instanceof VariableExpression) {
            ret = this.transformVariableExpression((VariableExpression)exp);
        } else if (exp.getClass() == PropertyExpression.class) {
            ret = this.transformPropertyExpression((PropertyExpression)exp);
        } else if (exp instanceof DeclarationExpression) {
            ret = this.transformDeclarationExpression((DeclarationExpression)exp);
        } else if (exp instanceof BinaryExpression) {
            ret = this.transformBinaryExpression((BinaryExpression)exp);
        } else if (exp instanceof MethodCallExpression) {
            ret = this.transformMethodCallExpression((MethodCallExpression)exp);
        } else if (exp instanceof ClosureExpression) {
            ret = this.transformClosureExpression((ClosureExpression)exp);
        } else if (exp instanceof ConstructorCallExpression) {
            ret = this.transformConstructorCallExpression((ConstructorCallExpression)exp);
        } else if (exp instanceof AnnotationConstantExpression) {
            ret = this.transformAnnotationConstantExpression((AnnotationConstantExpression)exp);
        } else {
            this.resolveOrFail(exp.getType(), (ASTNode)exp);
            ret = exp.transformExpression((ExpressionTransformer)this);
        }
        if (ret != null && ret != exp) {
            ret.setSourcePosition((ASTNode)exp);
        }
        return ret;
    }

    private String lookupClassName(PropertyExpression pe) {
        boolean doInitialClassTest = true;
        String name = "";
        for (PropertyExpression it = pe; it != null; it = it.getObjectExpression()) {
            if (it instanceof VariableExpression) {
                VariableExpression ve = (VariableExpression)it;
                if (ve.isSuperExpression() || ve.isThisExpression()) {
                    return null;
                }
                String varName = ve.getName();
                if (doInitialClassTest) {
                    if (!this.testVanillaNameForClass(varName)) {
                        return null;
                    }
                    doInitialClassTest = false;
                    name = varName;
                    break;
                }
                name = varName + "." + name;
                break;
            }
            if (it.getClass() != PropertyExpression.class) {
                return null;
            }
            PropertyExpression current = it;
            String propertyPart = current.getPropertyAsString();
            if (propertyPart == null || propertyPart.equals("class")) {
                return null;
            }
            if (doInitialClassTest) {
                if (!this.testVanillaNameForClass(propertyPart)) {
                    return null;
                }
                doInitialClassTest = false;
                name = propertyPart;
                continue;
            }
            name = propertyPart + "." + name;
        }
        if (name.length() == 0) {
            return null;
        }
        return name;
    }

    private Expression correctClassClassChain(PropertyExpression pe) {
        LinkedList<PropertyExpression> stack = new LinkedList<PropertyExpression>();
        ClassExpression found = null;
        for (PropertyExpression it = pe; it != null; it = it.getObjectExpression()) {
            if (it instanceof ClassExpression) {
                found = (ClassExpression)it;
                break;
            }
            if (it.getClass() != PropertyExpression.class) {
                return pe;
            }
            stack.addFirst(it);
        }
        if (found == null) {
            return pe;
        }
        if (stack.isEmpty()) {
            return pe;
        }
        Object stackElement = stack.removeFirst();
        if (stackElement.getClass() != PropertyExpression.class) {
            return pe;
        }
        PropertyExpression classPropertyExpression = (PropertyExpression)stackElement;
        String propertyNamePart = classPropertyExpression.getPropertyAsString();
        if (propertyNamePart == null || !propertyNamePart.equals("class")) {
            return pe;
        }
        found.setSourcePosition((ASTNode)classPropertyExpression);
        if (stack.isEmpty()) {
            return found;
        }
        stackElement = stack.removeFirst();
        if (stackElement.getClass() != PropertyExpression.class) {
            return pe;
        }
        PropertyExpression classPropertyExpressionContainer = (PropertyExpression)stackElement;
        classPropertyExpressionContainer.setObjectExpression((Expression)found);
        return pe;
    }

    protected Expression transformPropertyExpression(PropertyExpression pe) {
        ClassExpression ce;
        ConstructedNestedClass type;
        ClassNode type2;
        boolean itlp = this.isTopLevelProperty;
        boolean ipe = this.inPropertyExpression;
        Expression objectExpression = pe.getObjectExpression();
        this.inPropertyExpression = true;
        this.isTopLevelProperty = objectExpression.getClass() != PropertyExpression.class;
        objectExpression = this.transform(objectExpression);
        this.inPropertyExpression = false;
        Expression property = this.transform(pe.getProperty());
        this.isTopLevelProperty = itlp;
        this.inPropertyExpression = ipe;
        boolean spreadSafe = pe.isSpreadSafe();
        PropertyExpression old = pe;
        pe = new PropertyExpression(objectExpression, property, pe.isSafe());
        pe.setSpreadSafe(spreadSafe);
        pe.setSourcePosition((ASTNode)old);
        String className = this.lookupClassName(pe);
        if (className != null && this.resolve(type2 = ClassHelper.make((String)className))) {
            ClassExpression ret = new ClassExpression(type2);
            ret.setSourcePosition((ASTNode)pe);
            return ret;
        }
        if (objectExpression instanceof ClassExpression && pe.getPropertyAsString() != null && this.resolve(type = new ConstructedNestedClass((ce = (ClassExpression)objectExpression).getType(), pe.getPropertyAsString()), false, false, false)) {
            ClassExpression ret = new ClassExpression((ClassNode)type);
            ret.setSourcePosition((ASTNode)ce);
            return ret;
        }
        PropertyExpression ret = pe;
        this.checkThisAndSuperAsPropertyAccess(pe);
        if (this.isTopLevelProperty) {
            ret = this.correctClassClassChain(pe);
        }
        return ret;
    }

    private boolean directlyImplementsTrait(ClassNode trait) {
        ClassNode[] interfaces = this.currentClass.getInterfaces();
        if (interfaces == null) {
            return this.currentClass.getSuperClass().equals((Object)trait);
        }
        for (ClassNode node : interfaces) {
            if (!node.equals((Object)trait)) continue;
            return true;
        }
        return this.currentClass.getSuperClass().equals((Object)trait);
    }

    private void checkThisAndSuperAsPropertyAccess(PropertyExpression expression) {
        if (expression.isImplicitThis()) {
            return;
        }
        String prop = expression.getPropertyAsString();
        if (prop == null) {
            return;
        }
        if (!prop.equals("this") && !prop.equals("super")) {
            return;
        }
        ClassNode type = expression.getObjectExpression().getType();
        if (expression.getObjectExpression() instanceof ClassExpression) {
            ClassNode iterType;
            if (!(this.currentClass instanceof InnerClassNode) && !Traits.isTrait((ClassNode)type)) {
                this.addError("The usage of 'Class.this' and 'Class.super' is only allowed in nested/inner classes.", (ASTNode)expression);
                return;
            }
            if (this.currentScope != null && !this.currentScope.isInStaticContext() && Traits.isTrait((ClassNode)type) && "super".equals(prop) && this.directlyImplementsTrait(type)) {
                return;
            }
            for (iterType = this.currentClass; iterType != null && !iterType.equals((Object)type); iterType = iterType.getOuterClass()) {
            }
            if (iterType == null) {
                this.addError("The class '" + type.getName() + "' needs to be an outer class of '" + this.currentClass.getName() + "' when using '.this' or '.super'.", (ASTNode)expression);
            }
            if ((this.currentClass.getModifiers() & 8) == 0) {
                return;
            }
            if (this.currentScope != null && !this.currentScope.isInStaticContext()) {
                return;
            }
            this.addError("The usage of 'Class.this' and 'Class.super' within static nested class '" + this.currentClass.getName() + "' is not allowed in a static context.", (ASTNode)expression);
        }
    }

    protected Expression transformVariableExpression(VariableExpression ve) {
        this.visitAnnotations((AnnotatedNode)ve);
        Variable v = ve.getAccessedVariable();
        if (!(v instanceof DynamicVariable) && !this.checkingVariableTypeInDeclaration) {
            return ve;
        }
        if (v instanceof DynamicVariable) {
            String name = ve.getName();
            ClassNode t = ClassHelper.make((String)name);
            boolean isClass = t.isResolved();
            if (!isClass) {
                if (Character.isLowerCase(name.charAt(0))) {
                    t = new LowerCaseClass(name);
                }
                if (!(isClass = this.resolve(t))) {
                    isClass = this.resolveToNestedOfCurrent(t);
                }
            }
            if (isClass) {
                for (VariableScope scope = this.currentScope; scope != null && !scope.isRoot() && !scope.isRoot() && scope.removeReferencedClassVariable(ve.getName()) != null; scope = scope.getParent()) {
                }
                ClassExpression ce = new ClassExpression(t);
                ce.setSourcePosition((ASTNode)ve);
                return ce;
            }
        }
        this.resolveOrFail(ve.getType(), (ASTNode)ve);
        ClassNode origin = ve.getOriginType();
        if (origin != ve.getType()) {
            this.resolveOrFail(origin, (ASTNode)ve);
        }
        return ve;
    }

    private boolean testVanillaNameForClass(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        return !Character.isLowerCase(name.charAt(0));
    }

    private boolean isLeftSquareBracket(int op) {
        return op == 1905 || op == 30 || op == 810 || op == 811;
    }

    protected Expression transformBinaryExpression(BinaryExpression be) {
        Expression left = this.transform(be.getLeftExpression());
        int type = be.getOperation().getType();
        if ((type == 1100 || type == 100) && left instanceof ClassExpression) {
            ClassExpression ce = (ClassExpression)left;
            String error = "you tried to assign a value to the class '" + ce.getType().getName() + "'";
            if (ce.getType().isScript()) {
                error = error + ". Do you have a script with this name?";
            }
            this.addError(error, (ASTNode)be.getLeftExpression());
            return be;
        }
        if (left instanceof ClassExpression && this.isLeftSquareBracket(type)) {
            if (be.getRightExpression() instanceof ListExpression) {
                ListExpression list = (ListExpression)be.getRightExpression();
                if (list.getExpressions().isEmpty()) {
                    ClassExpression ce = new ClassExpression(left.getType().makeArray());
                    ce.setSourcePosition((ASTNode)be);
                    return ce;
                }
                boolean map = true;
                for (Object expression : list.getExpressions()) {
                    if (expression instanceof MapEntryExpression) continue;
                    map = false;
                    break;
                }
                if (map) {
                    MapExpression me = new MapExpression();
                    for (Expression expression : list.getExpressions()) {
                        me.addMapEntryExpression((MapEntryExpression)this.transform(expression));
                    }
                    me.setSourcePosition((ASTNode)list);
                    CastExpression ce = new CastExpression(left.getType(), (Expression)me);
                    ce.setSourcePosition((ASTNode)be);
                    return ce;
                }
            } else if (be.getRightExpression() instanceof SpreadMapExpression) {
                SpreadMapExpression mapExpression = (SpreadMapExpression)be.getRightExpression();
                Expression right = this.transform(mapExpression.getExpression());
                CastExpression ce = new CastExpression(left.getType(), right);
                ce.setSourcePosition((ASTNode)be);
                return ce;
            }
            if (be.getRightExpression() instanceof MapEntryExpression) {
                MapExpression me = new MapExpression();
                me.addMapEntryExpression((MapEntryExpression)this.transform(be.getRightExpression()));
                me.setSourcePosition((ASTNode)be.getRightExpression());
                CastExpression ce = new CastExpression(left.getType(), (Expression)me);
                ce.setSourcePosition((ASTNode)be);
                return ce;
            }
        }
        Expression right = this.transform(be.getRightExpression());
        be.setLeftExpression(left);
        be.setRightExpression(right);
        return be;
    }

    protected Expression transformClosureExpression(ClosureExpression ce) {
        Statement code;
        boolean oldInClosure = this.inClosure;
        this.inClosure = true;
        Parameter[] paras = ce.getParameters();
        if (paras != null) {
            for (Parameter para : paras) {
                Expression initialVal;
                ClassNode t = para.getType();
                this.resolveOrFail(t, (ASTNode)ce);
                this.visitAnnotations((AnnotatedNode)para);
                if (para.hasInitialExpression() && (initialVal = para.getInitialExpression()) instanceof Expression) {
                    para.setInitialExpression(this.transform(initialVal));
                }
                this.visitAnnotations((AnnotatedNode)para);
            }
        }
        if ((code = ce.getCode()) != null) {
            code.visit((GroovyCodeVisitor)this);
        }
        this.inClosure = oldInClosure;
        return ce;
    }

    protected Expression transformConstructorCallExpression(ConstructorCallExpression cce) {
        ClassNode type = cce.getType();
        this.resolveOrFail(type, (ASTNode)cce);
        if (Modifier.isAbstract(type.getModifiers())) {
            this.addError("You cannot create an instance from the abstract " + this.getDescription(type) + ".", (ASTNode)cce);
        }
        Expression ret = cce.transformExpression((ExpressionTransformer)this);
        return ret;
    }

    private String getDescription(ClassNode node) {
        return (node.isInterface() ? "interface" : "class") + " '" + node.getName() + "'";
    }

    protected Expression transformMethodCallExpression(MethodCallExpression mce) {
        Expression args = this.transform(mce.getArguments());
        Expression method = this.transform(mce.getMethod());
        Expression object = this.transform(mce.getObjectExpression());
        this.resolveGenericsTypes(mce.getGenericsTypes());
        MethodCallExpression result = new MethodCallExpression(object, method, args);
        result.setSafe(mce.isSafe());
        result.setImplicitThis(mce.isImplicitThis());
        result.setSpreadSafe(mce.isSpreadSafe());
        result.setSourcePosition((ASTNode)mce);
        result.setGenericsTypes(mce.getGenericsTypes());
        result.setMethodTarget(mce.getMethodTarget());
        return result;
    }

    protected Expression transformDeclarationExpression(DeclarationExpression de) {
        this.visitAnnotations((AnnotatedNode)de);
        Expression oldLeft = de.getLeftExpression();
        this.checkingVariableTypeInDeclaration = true;
        Expression left = this.transform(oldLeft);
        this.checkingVariableTypeInDeclaration = false;
        if (left instanceof ClassExpression) {
            ClassExpression ce = (ClassExpression)left;
            this.addError("you tried to assign a value to the class " + ce.getType().getName(), (ASTNode)oldLeft);
            return de;
        }
        Expression right = this.transform(de.getRightExpression());
        if (right == de.getRightExpression()) {
            this.fixDeclaringClass(de);
            return de;
        }
        DeclarationExpression newDeclExpr = new DeclarationExpression(left, de.getOperation(), right);
        newDeclExpr.setDeclaringClass(de.getDeclaringClass());
        this.fixDeclaringClass(newDeclExpr);
        newDeclExpr.setSourcePosition((ASTNode)de);
        newDeclExpr.addAnnotations(de.getAnnotations());
        return newDeclExpr;
    }

    private void fixDeclaringClass(DeclarationExpression newDeclExpr) {
        if (newDeclExpr.getDeclaringClass() == null && this.currentMethod != null) {
            newDeclExpr.setDeclaringClass(this.currentMethod.getDeclaringClass());
        }
    }

    protected Expression transformAnnotationConstantExpression(AnnotationConstantExpression ace) {
        AnnotationNode an = (AnnotationNode)ace.getValue();
        ClassNode type = an.getClassNode();
        this.resolveOrFail(type, ", unable to find class for annotation", (ASTNode)an);
        for (Map.Entry entry : an.getMembers().entrySet()) {
            entry.setValue(this.transform((Expression)entry.getValue()));
        }
        return ace;
    }

    public void visitAnnotations(AnnotatedNode node) {
        List annotations = node.getAnnotations();
        if (annotations.isEmpty()) {
            return;
        }
        HashMap<String, AnnotationNode> tmpAnnotations = new HashMap<String, AnnotationNode>();
        for (AnnotationNode an : annotations) {
            AnnotationNode anyPrevAnnNode;
            Class annTypeClass;
            Retention retention;
            if (an.isBuiltIn()) continue;
            ClassNode annType = an.getClassNode();
            this.resolveOrFail(annType, ",  unable to find class for annotation", (ASTNode)an);
            for (Map.Entry entry : an.getMembers().entrySet()) {
                Expression newValue = this.transform((Expression)entry.getValue());
                newValue = this.transformInlineConstants(newValue);
                entry.setValue(newValue);
                this.checkAnnotationMemberValue(newValue);
            }
            if (!annType.isResolved() || (retention = (annTypeClass = annType.getTypeClass()).getAnnotation(Retention.class)) == null || !retention.value().equals((Object)RetentionPolicy.RUNTIME) || (anyPrevAnnNode = tmpAnnotations.put(annTypeClass.getName(), an)) == null) continue;
            this.addError("Cannot specify duplicate annotation on the same member : " + annType.getName(), (ASTNode)an);
        }
    }

    private Expression transformInlineConstants(Expression exp) {
        if (exp instanceof PropertyExpression) {
            PropertyExpression pe = (PropertyExpression)exp;
            if (pe.getObjectExpression() instanceof ClassExpression) {
                ClassExpression ce = (ClassExpression)pe.getObjectExpression();
                ClassNode type = ce.getType();
                if (type.isEnum()) {
                    return exp;
                }
                FieldNode fieldNode = type.getField(pe.getPropertyAsString());
                if (fieldNode != null && !fieldNode.isEnum() && fieldNode.isStatic() && fieldNode.isFinal() && fieldNode.getInitialValueExpression() instanceof ConstantExpression) {
                    return fieldNode.getInitialValueExpression();
                }
            }
        } else {
            ConstantExpression ce;
            if (exp instanceof ListExpression) {
                ListExpression le = (ListExpression)exp;
                ListExpression result = new ListExpression();
                for (Expression expression : le.getExpressions()) {
                    result.addExpression(this.transformInlineConstants(expression));
                }
                return result;
            }
            if (exp instanceof AnnotationConstantExpression && (ce = (ConstantExpression)exp).getValue() instanceof AnnotationNode) {
                AnnotationNode an = (AnnotationNode)ce.getValue();
                for (Map.Entry entry : an.getMembers().entrySet()) {
                    entry.setValue(this.transformInlineConstants((Expression)entry.getValue()));
                }
            }
        }
        return exp;
    }

    private void checkAnnotationMemberValue(Expression newValue) {
        if (newValue instanceof PropertyExpression) {
            PropertyExpression pe = (PropertyExpression)newValue;
            if (!(pe.getObjectExpression() instanceof ClassExpression)) {
                this.addError("unable to find class '" + pe.getText() + "' for annotation attribute constant", (ASTNode)pe.getObjectExpression());
            }
        } else if (newValue instanceof ListExpression) {
            ListExpression le = (ListExpression)newValue;
            for (Expression e : le.getExpressions()) {
                this.checkAnnotationMemberValue(e);
            }
        }
    }

    public void visitClass(ClassNode node) {
        ClassNode sn;
        ClassNode oldNode = this.currentClass;
        if (node instanceof InnerClassNode) {
            if (Modifier.isStatic(node.getModifiers())) {
                this.genericParameterNames = new HashMap<String, GenericsType>();
            }
        } else {
            this.genericParameterNames = new HashMap<String, GenericsType>();
        }
        this.currentClass = node;
        this.resolveGenericsHeader(node.getGenericsTypes());
        ModuleNode module = node.getModule();
        if (!module.hasImportsResolved()) {
            ClassNode type;
            Iterator<Object> iterator = module.getImports().iterator();
            while (iterator.hasNext()) {
                ImportNode importNode;
                this.currImportNode = importNode = (ImportNode)iterator.next();
                type = importNode.getType();
                if (this.resolve(type, false, false, true)) {
                    this.currImportNode = null;
                    continue;
                }
                this.currImportNode = null;
                this.addError("unable to resolve class " + type.getName(), (ASTNode)type);
            }
            for (ImportNode importNode : module.getStaticStarImports().values()) {
                type = importNode.getType();
                if (this.resolve(type, false, false, true)) continue;
                if (type.getPackageName() == null && node.getPackageName() != null) {
                    String oldTypeName = type.getName();
                    type.setName(node.getPackageName() + "." + oldTypeName);
                    if (this.resolve(type, false, false, true)) continue;
                    type.setName(oldTypeName);
                }
                this.addError("unable to resolve class " + type.getName(), (ASTNode)type);
            }
            for (ImportNode importNode : module.getStaticImports().values()) {
                type = importNode.getType();
                if (this.resolve(type, true, true, true)) continue;
                this.addError("unable to resolve class " + type.getName(), (ASTNode)type);
            }
            for (ImportNode importNode : module.getStaticStarImports().values()) {
                type = importNode.getType();
                if (this.resolve(type, true, true, true)) continue;
                this.addError("unable to resolve class " + type.getName(), (ASTNode)type);
            }
            module.setImportsResolved(true);
        }
        if ((sn = node.getUnresolvedSuperClass()) != null) {
            this.resolveOrFail(sn, (ASTNode)node, true);
        }
        for (ClassNode anInterface : node.getInterfaces()) {
            this.resolveOrFail(anInterface, (ASTNode)node, true);
        }
        this.checkCyclicInheritance(node, node.getUnresolvedSuperClass(), node.getInterfaces());
        super.visitClass(node);
        this.currentClass = oldNode;
    }

    private void checkCyclicInheritance(ClassNode originalNode, ClassNode parentToCompare, ClassNode[] interfacesToCompare) {
        if (!originalNode.isInterface()) {
            if (parentToCompare == null) {
                return;
            }
            if (originalNode == parentToCompare.redirect()) {
                this.addError("Cyclic inheritance involving " + parentToCompare.getName() + " in class " + originalNode.getName(), (ASTNode)originalNode);
                return;
            }
            if (interfacesToCompare != null && interfacesToCompare.length > 0) {
                for (ClassNode intfToCompare : interfacesToCompare) {
                    if (originalNode != intfToCompare.redirect()) continue;
                    this.addError("Cycle detected: the type " + originalNode.getName() + " cannot implement itself", (ASTNode)originalNode);
                    return;
                }
            }
            if (parentToCompare == ClassHelper.OBJECT_TYPE) {
                return;
            }
            this.checkCyclicInheritance(originalNode, parentToCompare.getUnresolvedSuperClass(), null);
        } else if (interfacesToCompare != null && interfacesToCompare.length > 0) {
            for (ClassNode intfToCompare : interfacesToCompare) {
                if (originalNode != intfToCompare.redirect()) continue;
                this.addError("Cyclic inheritance involving " + intfToCompare.getName() + " in interface " + originalNode.getName(), (ASTNode)originalNode);
                return;
            }
            for (ClassNode intf : interfacesToCompare) {
                this.checkCyclicInheritance(originalNode, null, intf.getInterfaces());
            }
        } else {
            return;
        }
    }

    public void visitCatchStatement(CatchStatement cs) {
        this.resolveOrFail(cs.getExceptionType(), (ASTNode)cs);
        if (cs.getExceptionType() == ClassHelper.DYNAMIC_TYPE) {
            cs.getVariable().setType(ClassHelper.make(Exception.class));
        }
        super.visitCatchStatement(cs);
    }

    public void visitForLoop(ForStatement forLoop) {
        this.resolveOrFail(forLoop.getVariableType(), (ASTNode)forLoop);
        super.visitForLoop(forLoop);
    }

    public void visitBlockStatement(BlockStatement block) {
        VariableScope oldScope = this.currentScope;
        this.currentScope = block.getVariableScope();
        super.visitBlockStatement(block);
        this.currentScope = oldScope;
    }

    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    private boolean resolveGenericsTypes(GenericsType[] types) {
        if (types == null) {
            return true;
        }
        this.currentClass.setUsingGenerics(true);
        boolean resolved = true;
        for (GenericsType type : types) {
            resolved = this.resolveGenericsType(type) && resolved;
        }
        return resolved;
    }

    private void resolveGenericsHeader(GenericsType[] types) {
        if (types == null) {
            return;
        }
        this.currentClass.setUsingGenerics(true);
        for (GenericsType type : types) {
            ClassNode classNode = type.getType();
            String name = type.getName();
            ClassNode[] bounds = type.getUpperBounds();
            if (bounds != null) {
                boolean nameAdded = false;
                for (ClassNode upperBound : bounds) {
                    if (!nameAdded && upperBound != null || !this.resolve(classNode)) {
                        this.genericParameterNames.put(name, type);
                        type.setPlaceholder(true);
                        classNode.setRedirect(upperBound);
                        nameAdded = true;
                    }
                    this.resolveOrFail(upperBound, (ASTNode)classNode);
                }
                continue;
            }
            this.genericParameterNames.put(name, type);
            classNode.setRedirect(ClassHelper.OBJECT_TYPE);
            type.setPlaceholder(true);
        }
    }

    private boolean resolveGenericsType(GenericsType genericsType) {
        if (genericsType.isResolved()) {
            return true;
        }
        this.currentClass.setUsingGenerics(true);
        ClassNode type = genericsType.getType();
        String name = type.getName();
        ClassNode[] bounds = genericsType.getUpperBounds();
        if (!this.genericParameterNames.containsKey(name)) {
            if (bounds != null) {
                for (ClassNode upperBound : bounds) {
                    this.resolveOrFail(upperBound, (ASTNode)genericsType);
                    type.setRedirect(upperBound);
                    this.resolveGenericsTypes(upperBound.getGenericsTypes());
                }
            } else if (genericsType.isWildcard()) {
                type.setRedirect(ClassHelper.OBJECT_TYPE);
            } else {
                this.resolveOrFail(type, (ASTNode)genericsType);
            }
        } else {
            GenericsType gt = this.genericParameterNames.get(name);
            type.setRedirect(gt.getType());
            genericsType.setPlaceholder(true);
        }
        if (genericsType.getLowerBound() != null) {
            this.resolveOrFail(genericsType.getLowerBound(), (ASTNode)genericsType);
        }
        if (this.resolveGenericsTypes(type.getGenericsTypes())) {
            genericsType.setResolved(genericsType.getType().isResolved());
        }
        return genericsType.isResolved();
    }

    public void setClassNodeResolver(ClassNodeResolver classNodeResolver) {
        this.classNodeResolver = classNodeResolver;
    }

    static {
        ClassNode cn = null;
        try {
            try {
                cn = (ClassNode)ClassNodeResolver.class.getDeclaredField("NO_CLASS").get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                cn = null;
            }
        }
        finally {
            NO_CLASS = cn;
        }
    }

    private static class LowerCaseClass
    extends ClassNode {
        private final String className;

        public LowerCaseClass(String name) {
            super(name, 1, ClassHelper.OBJECT_TYPE);
            this.isPrimaryNode = false;
            this.className = name;
        }

        public String getName() {
            if (this.redirect() != this) {
                return super.getName();
            }
            return this.className;
        }

        public boolean hasPackageName() {
            if (this.redirect() != this) {
                return super.hasPackageName();
            }
            return false;
        }

        public String setName(String name) {
            if (this.redirect() != this) {
                return super.setName(name);
            }
            throw new GroovyBugError("LowerCaseClass#setName should not be called");
        }
    }

    private static class ConstructedClassWithPackage
    extends ClassNode {
        private final String prefix;
        private String className;

        public ConstructedClassWithPackage(String pkg, String name) {
            super(pkg + name, 1, ClassHelper.OBJECT_TYPE);
            this.isPrimaryNode = false;
            this.prefix = pkg;
            this.className = name;
        }

        public String getName() {
            if (this.redirect() != this) {
                return super.getName();
            }
            return this.prefix + this.className;
        }

        public boolean hasPackageName() {
            if (this.redirect() != this) {
                return super.hasPackageName();
            }
            return this.getName().indexOf(46) != -1;
        }

        public String setName(String name) {
            if (this.redirect() != this) {
                return super.setName(name);
            }
            throw new GroovyBugError("ConstructedClassWithPackage#setName should not be called");
        }
    }

    private static class ConstructedNestedClass
    extends ClassNode {
        private final ClassNode knownEnclosingType;

        public ConstructedNestedClass(ClassNode outer, String inner) {
            super(outer.getName() + "$" + GradleResolveVisitor.replacePoints(inner), 1, ClassHelper.OBJECT_TYPE);
            this.knownEnclosingType = outer;
            this.isPrimaryNode = false;
        }

        public boolean hasPackageName() {
            if (this.redirect() != this) {
                return super.hasPackageName();
            }
            return this.knownEnclosingType.hasPackageName();
        }

        public String setName(String name) {
            if (this.redirect() != this) {
                return super.setName(name);
            }
            throw new GroovyBugError("ConstructedNestedClass#setName should not be called");
        }
    }
}

