/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.base.Equivalence;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.properties.TypeMetadata;

public abstract class AbstractPropertyNode<T> {
    private final String propertyName;
    private final AbstractPropertyNode<T> parentNode;
    private final TypeMetadata typeMetadata;

    public AbstractPropertyNode(@Nullable AbstractPropertyNode<T> parentNode, @Nullable String propertyName, TypeMetadata typeMetadata) {
        this.propertyName = propertyName;
        this.parentNode = parentNode;
        this.typeMetadata = typeMetadata;
    }

    protected String getQualifiedPropertyName(String childPropertyName) {
        return this.propertyName == null ? childPropertyName : this.propertyName + "." + childPropertyName;
    }

    @Nullable
    public String getPropertyName() {
        return this.propertyName;
    }

    public TypeMetadata getTypeMetadata() {
        return this.typeMetadata;
    }

    @Nullable
    protected AbstractPropertyNode<T> findNodeCreatingCycle(T childValue, Equivalence<? super T> nodeEquivalence) {
        if (nodeEquivalence.equivalent(this.getNodeValue(), childValue)) {
            return this;
        }
        if (this.parentNode == null) {
            return null;
        }
        return this.parentNode.findNodeCreatingCycle((T)childValue, nodeEquivalence);
    }

    protected abstract T getNodeValue();

    public String toString() {
        return this.propertyName == null ? "<root>" : this.getPropertyName();
    }
}

