/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.internal;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Transformer;
import org.gradle.util.CollectionUtils;

public class XcodeUtils {
    private XcodeUtils() {
    }

    public static String toSpaceSeparatedList(File ... files) {
        return XcodeUtils.toSpaceSeparatedList(Arrays.asList(files));
    }

    public static String toSpaceSeparatedList(Iterable<File> it) {
        return StringUtils.join((Collection)CollectionUtils.collect(it, (Transformer)new Transformer<String, File>(){

            public String transform(File file) {
                return XcodeUtils.quote(file.getAbsolutePath());
            }
        }), (char)' ');
    }

    private static String quote(String value) {
        return "\"" + value + "\"";
    }
}

