# -*- encoding:utf-8; warn-indent:false; frozen_string_literal: true  -*-

# line 1 "lib/parser/lexer.rl"

# line 3 "lib/parser/lexer.rl"
#
# === BEFORE YOU START ===
#
# Read the Ruby Hacking Guide chapter 11, available in English at
# http://whitequark.org/blog/2013/04/01/ruby-hacking-guide-ch-11-finite-state-lexer/
#
# Remember two things about Ragel scanners:
#
#   1) Longest match wins.
#
#   2) If two matches have the same length, the first
#      in source code wins.
#
# General rules of making Ragel and Bison happy:
#
#  * `p` (position) and `@te` contain the index of the character
#    they're pointing to ("current"), plus one. `@ts` contains the index
#    of the corresponding character. The code for extracting matched token is:
#
#       @source_buffer.slice(@ts...@te)
#
#  * If your input is `foooooooobar` and the rule is:
#
#       'f' 'o'+
#
#    the result will be:
#
#       foooooooobar
#       ^ ts=0   ^ p=te=9
#
#  * A Ragel lexer action should not emit more than one token, unless
#    you know what you are doing.
#
#  * All Ragel commands (fnext, fgoto, ...) end with a semicolon.
#
#  * If an action emits the token and transitions to another state, use
#    these Ragel commands:
#
#       emit($whatever)
#       fnext $next_state; fbreak;
#
#    If you perform `fgoto` in an action which does not emit a token nor
#    rewinds the stream pointer, the parser's side-effectful,
#    context-sensitive lookahead actions will break in a hard to detect
#    and debug way.
#
#  * If an action does not emit a token:
#
#       fgoto $next_state;
#
#  * If an action features lookbehind, i.e. matches characters with the
#    intent of passing them to another action:
#
#       p = @ts - 1
#       fgoto $next_state;
#
#    or, if the lookbehind consists of a single character:
#
#       fhold; fgoto $next_state;
#
#  * Ragel merges actions. So, if you have `e_lparen = '(' %act` and
#    `c_lparen = '('` and a lexer action `e_lparen | c_lparen`, the result
#    _will_ invoke the action `act`.
#
#    e_something stands for "something with **e**mbedded action".
#
#  * EOF is explicit and is matched by `c_eof`. If you want to introspect
#    the state of the lexer, add this rule to the state:
#
#       c_eof => do_eof;
#
#  * If you proceed past EOF, the lexer will complain:
#
#       NoMethodError: undefined method `ord' for nil:NilClass
#

class Parser::Lexer

  
# line 85 "lib/parser/lexer.rb"
class << self
	attr_accessor :_lex_trans_keys
	private :_lex_trans_keys, :_lex_trans_keys=
end
self._lex_trans_keys = [
	0, 0, 101, 101, 103, 103, 
	105, 105, 110, 110, 69, 
	69, 78, 78, 68, 68, 
	95, 95, 95, 95, 0, 26, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 45, 
	0, 77, 0, 77, 0, 92, 
	0, 26, 0, 26, 0, 
	45, 0, 99, 0, 26, 
	67, 99, 45, 45, 0, 92, 
	0, 77, 0, 102, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 45, 0, 77, 
	0, 77, 0, 92, 0, 
	26, 0, 26, 0, 45, 
	0, 99, 0, 26, 67, 99, 
	45, 45, 0, 92, 0, 
	77, 0, 102, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 26, 0, 
	127, 58, 58, 58, 58, 
	0, 127, 58, 58, 60, 60, 
	62, 62, 10, 10, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 115, 115, 
	99, 99, 117, 117, 101, 101, 
	108, 116, 101, 101, 115, 
	115, 115, 115, 105, 105, 
	108, 108, 105, 105, 108, 108, 
	58, 58, 0, 127, 10, 
	10, 0, 127, 9, 92, 
	10, 10, 9, 92, 58, 58, 
	98, 98, 101, 101, 103, 
	103, 105, 105, 110, 110, 
	0, 122, 61, 61, 9, 92, 
	9, 92, 9, 92, 9, 
	92, 9, 92, 10, 10, 
	0, 127, 0, 127, 61, 126, 
	0, 127, 0, 127, 93, 
	93, 0, 127, 0, 127, 
	10, 10, 34, 34, 10, 10, 
	39, 39, 0, 127, 96, 
	96, 0, 45, 0, 77, 
	0, 77, 0, 92, 0, 26, 
	0, 26, 0, 45, 0, 
	99, 0, 26, 67, 99, 
	45, 45, 0, 92, 0, 77, 
	0, 102, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 58, 58, 
	58, 58, 0, 127, 43, 
	57, 48, 57, 48, 57, 
	10, 10, 48, 57, 48, 57, 
	115, 115, 99, 99, 117, 
	117, 101, 101, 99, 99, 
	117, 117, 101, 101, 0, 127, 
	58, 58, 9, 92, 9, 
	92, 9, 92, 9, 92, 
	9, 92, 9, 92, 60, 60, 
	10, 10, 9, 46, 46, 
	46, 0, 95, 9, 32, 
	0, 0, 10, 10, 10, 10, 
	98, 98, 9, 32, 10, 
	10, 95, 95, 0, 92, 
	9, 32, 36, 123, 0, 127, 
	48, 57, 0, 120, 0, 
	0, 0, 0, 48, 55, 
	48, 55, 0, 0, 0, 0, 
	0, 92, 0, 0, 0, 
	0, 0, 0, 0, 92, 
	45, 45, 0, 0, 0, 0, 
	0, 0, 0, 92, 0, 
	45, 0, 92, 0, 92, 
	0, 0, 0, 0, 0, 92, 
	0, 45, 10, 10, 0, 
	92, 48, 123, 48, 102, 
	48, 102, 48, 102, 0, 0, 
	0, 125, 0, 125, 0, 
	0, 0, 125, 0, 0, 
	0, 125, 0, 125, 0, 125, 
	0, 125, 0, 0, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 0, 0, 0, 48, 
	102, 0, 0, 0, 92, 
	36, 123, 0, 127, 48, 57, 
	0, 120, 0, 0, 0, 
	0, 48, 55, 48, 55, 
	0, 0, 0, 0, 0, 92, 
	0, 0, 0, 0, 0, 
	0, 0, 92, 45, 45, 
	0, 0, 0, 0, 0, 0, 
	0, 92, 0, 45, 0, 
	92, 0, 92, 0, 0, 
	0, 0, 0, 92, 0, 45, 
	10, 10, 0, 92, 48, 
	123, 48, 102, 48, 102, 
	48, 102, 0, 0, 0, 125, 
	0, 125, 0, 0, 0, 
	125, 0, 0, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 0, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 0, 
	0, 0, 48, 102, 0, 
	0, 0, 92, 9, 32, 
	0, 26, 0, 92, 0, 26, 
	0, 35, 36, 123, 0, 
	127, 48, 57, 0, 26, 
	0, 35, 9, 32, 36, 123, 
	0, 127, 48, 57, 0, 
	32, 9, 32, 65, 122, 
	65, 122, 36, 64, 0, 127, 
	48, 57, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	9, 32, 0, 0, 61, 126, 
	10, 10, 10, 10, 0, 
	127, 0, 127, 48, 57, 
	115, 115, 38, 38, 42, 42, 
	64, 64, 58, 58, 60, 
	61, 62, 62, 61, 126, 
	61, 61, 61, 62, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 93, 93, 10, 10, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 124, 124, 0, 127, 
	0, 127, 9, 32, 10, 10, 
	10, 10, 10, 10, 0, 
	0, 0, 127, 0, 127, 
	61, 61, 0, 0, 9, 32, 
	0, 0, 61, 126, 10, 
	10, 10, 10, 38, 38, 
	42, 42, 64, 64, 60, 61, 
	62, 62, 61, 126, 61, 
	61, 61, 62, 0, 127, 
	93, 93, 10, 10, 124, 124, 
	0, 126, 0, 127, 0, 
	61, 9, 61, 9, 61, 
	0, 0, 9, 61, 9, 62, 
	46, 46, 46, 46, 58, 
	58, 9, 32, 0, 0, 
	0, 127, 0, 0, 9, 124, 
	0, 0, 10, 10, 10, 
	10, 0, 0, 9, 61, 
	58, 58, 60, 60, 62, 62, 
	9, 32, 10, 10, 0, 
	127, 102, 102, 101, 101, 
	110, 110, 104, 104, 0, 127, 
	0, 127, 0, 127, 0, 
	0, 0, 127, 10, 10, 
	0, 123, 9, 32, 10, 10, 
	10, 10, 10, 10, 0, 
	0, 111, 111, 0, 0, 
	0, 127, 0, 127, 9, 32, 
	0, 0, 10, 10, 10, 
	10, 10, 10, 0, 0, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 58, 61, 
	0, 0, 61, 126, 61, 
	61, 0, 0, 0, 0, 
	0, 0, 9, 32, 61, 61, 
	9, 32, 61, 126, 10, 
	10, 10, 10, 65, 122, 
	0, 122, 38, 61, 0, 0, 
	42, 61, 61, 61, 9, 
	92, 9, 92, 9, 92, 
	46, 46, 46, 46, 0, 26, 
	0, 127, 0, 127, 61, 
	61, 0, 0, 61, 126, 
	61, 62, 0, 0, 0, 0, 
	0, 0, 0, 0, 61, 
	126, 0, 127, 48, 57, 
	38, 38, 42, 42, 64, 64, 
	60, 61, 62, 62, 61, 
	61, 61, 62, 124, 124, 
	64, 64, 60, 61, 0, 0, 
	62, 62, 61, 126, 61, 
	62, 0, 122, 0, 0, 
	0, 127, 0, 127, 0, 120, 
	0, 0, 0, 0, 48, 
	55, 48, 55, 0, 0, 
	0, 0, 0, 92, 0, 0, 
	0, 0, 0, 0, 0, 
	92, 45, 45, 0, 0, 
	0, 0, 0, 0, 0, 92, 
	0, 45, 0, 92, 0, 
	92, 0, 0, 0, 0, 
	0, 92, 0, 45, 10, 10, 
	0, 92, 48, 123, 48, 
	102, 48, 102, 48, 102, 
	0, 0, 0, 125, 0, 125, 
	0, 0, 0, 125, 0, 
	0, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 0, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 
	125, 0, 0, 0, 0, 
	48, 102, 0, 0, 0, 127, 
	0, 127, 0, 127, 0, 
	0, 10, 10, 0, 0, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 61, 
	126, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 0, 
	61, 124, 0, 92, 9, 32, 
	0, 0, 10, 10, 10, 
	10, 10, 10, 0, 0, 
	0, 127, 0, 127, 9, 32, 
	0, 0, 10, 10, 10, 
	10, 10, 10, 0, 0, 
	0, 127, 0, 127, 61, 61, 
	0, 0, 9, 32, 0, 
	0, 61, 126, 10, 10, 
	10, 10, 0, 127, 0, 127, 
	48, 57, 61, 61, 38, 
	61, 0, 0, 0, 0, 
	42, 61, 61, 62, 46, 58, 
	46, 46, 48, 101, 48, 
	95, 9, 92, 9, 92, 
	46, 120, 48, 114, 43, 57, 
	48, 105, 102, 102, 0, 
	0, 101, 105, 0, 0, 
	0, 0, 48, 114, 48, 114, 
	48, 114, 48, 114, 105, 
	114, 102, 102, 0, 0, 
	101, 105, 115, 115, 0, 0, 
	0, 0, 48, 114, 48, 
	114, 48, 114, 48, 114, 
	48, 114, 48, 114, 48, 114, 
	48, 114, 46, 114, 48, 
	114, 46, 114, 48, 114, 
	58, 58, 60, 61, 62, 62, 
	61, 126, 61, 61, 61, 
	62, 0, 127, 0, 127, 
	0, 0, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 0, 
	10, 10, 0, 0, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 9, 92, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 0, 61, 124, 
	0, 0, 9, 46, 9, 
	46, 46, 46, 10, 61, 
	10, 10, 10, 101, 10, 110, 
	10, 100, 10, 10, 0
]

class << self
	attr_accessor :_lex_key_spans
	private :_lex_key_spans, :_lex_key_spans=
end
self._lex_key_spans = [
	0, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 27, 128, 128, 128, 128, 46, 
	78, 78, 93, 27, 27, 46, 100, 27, 
	33, 1, 93, 78, 103, 128, 128, 128, 
	128, 46, 78, 78, 93, 27, 27, 46, 
	100, 27, 33, 1, 93, 78, 103, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 27, 128, 1, 1, 
	128, 1, 1, 1, 1, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 1, 
	1, 1, 1, 9, 1, 1, 1, 1, 
	1, 1, 1, 1, 128, 1, 128, 84, 
	1, 84, 1, 1, 1, 1, 1, 1, 
	123, 1, 84, 84, 84, 84, 84, 1, 
	128, 128, 66, 128, 128, 1, 128, 128, 
	1, 1, 1, 1, 128, 1, 46, 78, 
	78, 93, 27, 27, 46, 100, 27, 33, 
	1, 93, 78, 103, 128, 128, 128, 128, 
	128, 128, 1, 1, 128, 15, 10, 10, 
	1, 10, 10, 1, 1, 1, 1, 1, 
	1, 1, 128, 1, 84, 84, 84, 84, 
	84, 84, 1, 1, 38, 1, 96, 24, 
	0, 1, 1, 1, 24, 1, 1, 93, 
	24, 88, 128, 10, 121, 0, 0, 8, 
	8, 0, 0, 93, 0, 0, 0, 93, 
	1, 0, 0, 0, 93, 46, 93, 93, 
	0, 0, 93, 46, 1, 93, 76, 55, 
	55, 55, 0, 126, 126, 0, 126, 0, 
	126, 126, 126, 126, 0, 126, 126, 126, 
	126, 126, 126, 0, 0, 55, 0, 93, 
	88, 128, 10, 121, 0, 0, 8, 8, 
	0, 0, 93, 0, 0, 0, 93, 1, 
	0, 0, 0, 93, 46, 93, 93, 0, 
	0, 93, 46, 1, 93, 76, 55, 55, 
	55, 0, 126, 126, 0, 126, 0, 126, 
	126, 126, 126, 0, 126, 126, 126, 126, 
	126, 126, 0, 0, 55, 0, 93, 24, 
	27, 93, 27, 36, 88, 128, 10, 27, 
	36, 24, 88, 128, 10, 33, 24, 58, 
	58, 29, 128, 10, 128, 128, 128, 128, 
	24, 0, 66, 1, 1, 128, 128, 10, 
	1, 1, 1, 1, 1, 2, 1, 66, 
	1, 2, 128, 128, 128, 128, 128, 128, 
	128, 1, 1, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 1, 128, 
	128, 24, 1, 1, 1, 0, 128, 128, 
	1, 0, 24, 0, 66, 1, 1, 1, 
	1, 1, 2, 1, 66, 1, 2, 128, 
	1, 1, 1, 127, 128, 62, 53, 53, 
	0, 53, 54, 1, 1, 1, 24, 0, 
	128, 0, 116, 0, 1, 1, 0, 53, 
	1, 1, 1, 24, 1, 128, 1, 1, 
	1, 1, 128, 128, 128, 0, 128, 1, 
	124, 24, 1, 1, 1, 0, 1, 0, 
	128, 128, 24, 0, 1, 1, 1, 0, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 4, 0, 66, 1, 0, 0, 
	0, 24, 1, 24, 66, 1, 1, 58, 
	123, 24, 0, 20, 1, 84, 84, 84, 
	1, 1, 27, 128, 128, 1, 0, 66, 
	2, 0, 0, 0, 0, 66, 128, 10, 
	1, 1, 1, 2, 1, 1, 2, 1, 
	1, 2, 0, 1, 66, 2, 123, 0, 
	128, 128, 121, 0, 0, 8, 8, 0, 
	0, 93, 0, 0, 0, 93, 1, 0, 
	0, 0, 93, 46, 93, 93, 0, 0, 
	93, 46, 1, 93, 76, 55, 55, 55, 
	0, 126, 126, 0, 126, 0, 126, 126, 
	126, 126, 0, 126, 126, 126, 126, 126, 
	126, 126, 126, 126, 126, 126, 126, 126, 
	126, 126, 126, 126, 126, 126, 0, 0, 
	55, 0, 128, 128, 128, 0, 1, 0, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 66, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 0, 
	64, 93, 24, 0, 1, 1, 1, 0, 
	128, 128, 24, 0, 1, 1, 1, 0, 
	128, 128, 1, 0, 24, 0, 66, 1, 
	1, 128, 128, 10, 1, 24, 0, 0, 
	20, 2, 13, 1, 54, 48, 84, 84, 
	75, 67, 15, 58, 1, 0, 5, 0, 
	0, 67, 67, 67, 67, 10, 1, 0, 
	5, 1, 0, 0, 67, 67, 67, 67, 
	67, 67, 67, 67, 69, 67, 69, 67, 
	1, 2, 1, 66, 1, 2, 128, 128, 
	0, 128, 128, 128, 128, 128, 128, 0, 
	1, 0, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 84, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 0, 64, 0, 38, 38, 1, 52, 
	1, 92, 101, 91, 1
]

class << self
	attr_accessor :_lex_index_offsets
	private :_lex_index_offsets, :_lex_index_offsets=
end
self._lex_index_offsets = [
	0, 0, 2, 4, 6, 8, 10, 12, 
	14, 16, 18, 46, 175, 304, 433, 562, 
	609, 688, 767, 861, 889, 917, 964, 1065, 
	1093, 1127, 1129, 1223, 1302, 1406, 1535, 1664, 
	1793, 1922, 1969, 2048, 2127, 2221, 2249, 2277, 
	2324, 2425, 2453, 2487, 2489, 2583, 2662, 2766, 
	2895, 3024, 3153, 3282, 3411, 3540, 3669, 3798, 
	3927, 4056, 4185, 4314, 4443, 4471, 4600, 4602, 
	4604, 4733, 4735, 4737, 4739, 4741, 4870, 4999, 
	5128, 5257, 5386, 5515, 5644, 5773, 5902, 6031, 
	6160, 6289, 6418, 6547, 6676, 6805, 6934, 7063, 
	7065, 7067, 7069, 7071, 7081, 7083, 7085, 7087, 
	7089, 7091, 7093, 7095, 7097, 7226, 7228, 7357, 
	7442, 7444, 7529, 7531, 7533, 7535, 7537, 7539, 
	7541, 7665, 7667, 7752, 7837, 7922, 8007, 8092, 
	8094, 8223, 8352, 8419, 8548, 8677, 8679, 8808, 
	8937, 8939, 8941, 8943, 8945, 9074, 9076, 9123, 
	9202, 9281, 9375, 9403, 9431, 9478, 9579, 9607, 
	9641, 9643, 9737, 9816, 9920, 10049, 10178, 10307, 
	10436, 10565, 10694, 10696, 10698, 10827, 10843, 10854, 
	10865, 10867, 10878, 10889, 10891, 10893, 10895, 10897, 
	10899, 10901, 10903, 11032, 11034, 11119, 11204, 11289, 
	11374, 11459, 11544, 11546, 11548, 11587, 11589, 11686, 
	11711, 11712, 11714, 11716, 11718, 11743, 11745, 11747, 
	11841, 11866, 11955, 12084, 12095, 12217, 12218, 12219, 
	12228, 12237, 12238, 12239, 12333, 12334, 12335, 12336, 
	12430, 12432, 12433, 12434, 12435, 12529, 12576, 12670, 
	12764, 12765, 12766, 12860, 12907, 12909, 13003, 13080, 
	13136, 13192, 13248, 13249, 13376, 13503, 13504, 13631, 
	13632, 13759, 13886, 14013, 14140, 14141, 14268, 14395, 
	14522, 14649, 14776, 14903, 14904, 14905, 14961, 14962, 
	15056, 15145, 15274, 15285, 15407, 15408, 15409, 15418, 
	15427, 15428, 15429, 15523, 15524, 15525, 15526, 15620, 
	15622, 15623, 15624, 15625, 15719, 15766, 15860, 15954, 
	15955, 15956, 16050, 16097, 16099, 16193, 16270, 16326, 
	16382, 16438, 16439, 16566, 16693, 16694, 16821, 16822, 
	16949, 17076, 17203, 17330, 17331, 17458, 17585, 17712, 
	17839, 17966, 18093, 18094, 18095, 18151, 18152, 18246, 
	18271, 18299, 18393, 18421, 18458, 18547, 18676, 18687, 
	18715, 18752, 18777, 18866, 18995, 19006, 19040, 19065, 
	19124, 19183, 19213, 19342, 19353, 19482, 19611, 19740, 
	19869, 19894, 19895, 19962, 19964, 19966, 20095, 20224, 
	20235, 20237, 20239, 20241, 20243, 20245, 20248, 20250, 
	20317, 20319, 20322, 20451, 20580, 20709, 20838, 20967, 
	21096, 21225, 21227, 21229, 21358, 21487, 21616, 21745, 
	21874, 22003, 22132, 22261, 22390, 22519, 22648, 22777, 
	22906, 23035, 23164, 23293, 23422, 23551, 23680, 23809, 
	23938, 24067, 24196, 24325, 24454, 24583, 24712, 24841, 
	24970, 25099, 25228, 25357, 25486, 25615, 25744, 25873, 
	26002, 26131, 26260, 26389, 26518, 26647, 26776, 26905, 
	27034, 27163, 27292, 27421, 27550, 27679, 27808, 27937, 
	28066, 28195, 28324, 28453, 28582, 28711, 28840, 28969, 
	29098, 29227, 29356, 29485, 29614, 29743, 29872, 30001, 
	30130, 30259, 30388, 30517, 30646, 30775, 30904, 31033, 
	31162, 31291, 31420, 31549, 31678, 31807, 31936, 31938, 
	32067, 32196, 32221, 32223, 32225, 32227, 32228, 32357, 
	32486, 32488, 32489, 32514, 32515, 32582, 32584, 32586, 
	32588, 32590, 32592, 32595, 32597, 32664, 32666, 32669, 
	32798, 32800, 32802, 32804, 32932, 33061, 33124, 33178, 
	33232, 33233, 33287, 33342, 33344, 33346, 33348, 33373, 
	33374, 33503, 33504, 33621, 33622, 33624, 33626, 33627, 
	33681, 33683, 33685, 33687, 33712, 33714, 33843, 33845, 
	33847, 33849, 33851, 33980, 34109, 34238, 34239, 34368, 
	34370, 34495, 34520, 34522, 34524, 34526, 34527, 34529, 
	34530, 34659, 34788, 34813, 34814, 34816, 34818, 34820, 
	34821, 34950, 35079, 35208, 35337, 35466, 35595, 35724, 
	35853, 35982, 36111, 36240, 36369, 36498, 36627, 36756, 
	36885, 37014, 37143, 37148, 37149, 37216, 37218, 37219, 
	37220, 37221, 37246, 37248, 37273, 37340, 37342, 37344, 
	37403, 37527, 37552, 37553, 37574, 37576, 37661, 37746, 
	37831, 37833, 37835, 37863, 37992, 38121, 38123, 38124, 
	38191, 38194, 38195, 38196, 38197, 38198, 38265, 38394, 
	38405, 38407, 38409, 38411, 38414, 38416, 38418, 38421, 
	38423, 38425, 38428, 38429, 38431, 38498, 38501, 38625, 
	38626, 38755, 38884, 39006, 39007, 39008, 39017, 39026, 
	39027, 39028, 39122, 39123, 39124, 39125, 39219, 39221, 
	39222, 39223, 39224, 39318, 39365, 39459, 39553, 39554, 
	39555, 39649, 39696, 39698, 39792, 39869, 39925, 39981, 
	40037, 40038, 40165, 40292, 40293, 40420, 40421, 40548, 
	40675, 40802, 40929, 40930, 41057, 41184, 41311, 41438, 
	41565, 41692, 41819, 41946, 42073, 42200, 42327, 42454, 
	42581, 42708, 42835, 42962, 43089, 43216, 43343, 43344, 
	43345, 43401, 43402, 43531, 43660, 43789, 43790, 43792, 
	43793, 43922, 44051, 44180, 44309, 44438, 44567, 44696, 
	44825, 44954, 45083, 45212, 45341, 45470, 45599, 45728, 
	45857, 45986, 46115, 46244, 46373, 46502, 46631, 46760, 
	46889, 47018, 47147, 47276, 47405, 47534, 47663, 47792, 
	47921, 48050, 48179, 48308, 48437, 48566, 48695, 48824, 
	48953, 49082, 49211, 49340, 49469, 49598, 49727, 49856, 
	49985, 50114, 50243, 50372, 50501, 50630, 50759, 50888, 
	51017, 51146, 51275, 51404, 51533, 51662, 51729, 51858, 
	51987, 52116, 52245, 52374, 52503, 52632, 52761, 52890, 
	53019, 53148, 53277, 53406, 53535, 53664, 53793, 53922, 
	54051, 54180, 54309, 54438, 54567, 54696, 54825, 54954, 
	54955, 55020, 55114, 55139, 55140, 55142, 55144, 55146, 
	55147, 55276, 55405, 55430, 55431, 55433, 55435, 55437, 
	55438, 55567, 55696, 55698, 55699, 55724, 55725, 55792, 
	55794, 55796, 55925, 56054, 56065, 56067, 56092, 56093, 
	56094, 56115, 56118, 56132, 56134, 56189, 56238, 56323, 
	56408, 56484, 56552, 56568, 56627, 56629, 56630, 56636, 
	56637, 56638, 56706, 56774, 56842, 56910, 56921, 56923, 
	56924, 56930, 56932, 56933, 56934, 57002, 57070, 57138, 
	57206, 57274, 57342, 57410, 57478, 57548, 57616, 57686, 
	57754, 57756, 57759, 57761, 57828, 57830, 57833, 57962, 
	58091, 58092, 58221, 58350, 58479, 58608, 58737, 58866, 
	58867, 58869, 58870, 58999, 59128, 59257, 59386, 59515, 
	59644, 59773, 59902, 60031, 60160, 60289, 60418, 60547, 
	60676, 60805, 60934, 61063, 61192, 61321, 61450, 61579, 
	61708, 61837, 61966, 62095, 62224, 62353, 62482, 62611, 
	62740, 62869, 62998, 63127, 63256, 63385, 63514, 63643, 
	63728, 63857, 63986, 64115, 64244, 64373, 64502, 64631, 
	64760, 64889, 65018, 65147, 65276, 65405, 65534, 65663, 
	65792, 65921, 66050, 66179, 66308, 66437, 66566, 66695, 
	66824, 66953, 67082, 67211, 67340, 67469, 67598, 67727, 
	67856, 67985, 68114, 68243, 68372, 68501, 68630, 68759, 
	68888, 69017, 69146, 69275, 69404, 69533, 69662, 69791, 
	69920, 70049, 70178, 70307, 70436, 70565, 70694, 70823, 
	70952, 71081, 71210, 71339, 71468, 71597, 71726, 71855, 
	71984, 72113, 72114, 72179, 72180, 72219, 72258, 72260, 
	72313, 72315, 72408, 72510, 72602
]

class << self
	attr_accessor :_lex_indicies
	private :_lex_indicies, :_lex_indicies=
end
self._lex_indicies = [
	1, 0, 2, 0, 3, 0, 4, 0, 
	5, 0, 6, 0, 7, 0, 8, 0, 
	9, 0, 10, 0, 0, 0, 10, 0, 
	0, 0, 0, 0, 11, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 10, 0, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 14, 
	14, 12, 14, 12, 14, 14, 12, 12, 
	14, 14, 14, 15, 14, 14, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	14, 14, 14, 14, 14, 14, 14, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 12, 14, 12, 12, 13, 14, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 12, 12, 12, 14, 12, 13, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 12, 12, 12, 12, 12, 12, 12, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 12, 12, 12, 12, 14, 12, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 12, 12, 12, 12, 12, 14, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 12, 12, 12, 12, 12, 12, 
	17, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 12, 12, 12, 12, 13, 
	12, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 12, 12, 12, 12, 12, 
	13, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 12, 12, 12, 12, 12, 
	12, 12, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 12, 12, 12, 12, 
	13, 12, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 12, 12, 12, 12, 
	12, 13, 18, 19, 19, 19, 18, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 18, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 20, 
	19, 18, 21, 21, 21, 18, 21, 21, 
	21, 21, 21, 22, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 18, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 23, 21, 
	18, 21, 21, 21, 18, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 18, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 24, 21, 18, 
	25, 25, 25, 18, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 18, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 26, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 27, 25, 18, 28, 28, 
	28, 18, 28, 28, 28, 28, 28, 29, 
	28, 28, 28, 28, 28, 28, 28, 28, 
	28, 28, 28, 28, 28, 28, 28, 18, 
	28, 18, 28, 28, 28, 18, 28, 28, 
	28, 28, 28, 28, 28, 28, 28, 28, 
	28, 28, 28, 28, 28, 28, 28, 28, 
	28, 28, 28, 18, 28, 18, 19, 19, 
	19, 18, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 18, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 30, 19, 18, 31, 31, 31, 
	18, 31, 31, 31, 31, 31, 32, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 18, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 33, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	34, 31, 31, 31, 31, 31, 31, 35, 
	31, 18, 31, 31, 31, 18, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 18, 31, 36, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 37, 18, 37, 
	18, 18, 38, 38, 38, 18, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 18, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	39, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 40, 38, 18, 
	21, 21, 21, 18, 21, 21, 21, 21, 
	21, 22, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 18, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 24, 21, 18, 41, 
	41, 41, 18, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	18, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	41, 41, 41, 41, 41, 41, 41, 42, 
	42, 42, 42, 42, 42, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 42, 
	42, 42, 42, 42, 42, 41, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 45, 
	45, 43, 45, 43, 45, 45, 43, 43, 
	45, 45, 45, 46, 45, 45, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	45, 45, 45, 45, 45, 45, 45, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 43, 45, 43, 43, 44, 45, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 43, 43, 43, 45, 43, 44, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 43, 43, 43, 43, 43, 43, 43, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 43, 43, 43, 43, 45, 43, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 43, 43, 43, 43, 43, 45, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 43, 43, 43, 43, 43, 43, 
	48, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 43, 43, 43, 43, 44, 
	43, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 43, 43, 43, 43, 43, 
	44, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 43, 43, 43, 43, 43, 
	43, 43, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 43, 43, 43, 43, 
	44, 43, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 43, 43, 43, 43, 
	43, 44, 49, 50, 50, 50, 49, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 49, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 51, 
	50, 49, 52, 52, 52, 49, 52, 52, 
	52, 52, 52, 53, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 49, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 54, 52, 
	49, 52, 52, 52, 49, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 49, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 55, 52, 49, 
	56, 56, 56, 49, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 49, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 57, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 58, 56, 49, 59, 59, 
	59, 49, 59, 59, 59, 59, 59, 60, 
	59, 59, 59, 59, 59, 59, 59, 59, 
	59, 59, 59, 59, 59, 59, 59, 49, 
	59, 49, 59, 59, 59, 49, 59, 59, 
	59, 59, 59, 59, 59, 59, 59, 59, 
	59, 59, 59, 59, 59, 59, 59, 59, 
	59, 59, 59, 49, 59, 49, 50, 50, 
	50, 49, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 49, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 61, 50, 49, 62, 62, 62, 
	49, 62, 62, 62, 62, 62, 63, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 49, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 64, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	65, 62, 62, 62, 62, 62, 62, 66, 
	62, 49, 62, 62, 62, 49, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 49, 62, 67, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 68, 49, 68, 
	49, 49, 69, 69, 69, 49, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 49, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	70, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 71, 69, 49, 
	52, 52, 52, 49, 52, 52, 52, 52, 
	52, 53, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 49, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 55, 52, 49, 72, 
	72, 72, 49, 72, 72, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 72, 72, 
	49, 72, 72, 72, 72, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 73, 73, 
	73, 73, 73, 73, 73, 73, 73, 73, 
	72, 72, 72, 72, 72, 72, 72, 73, 
	73, 73, 73, 73, 73, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 72, 73, 
	73, 73, 73, 73, 73, 72, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 76, 
	76, 74, 76, 74, 76, 76, 74, 74, 
	76, 76, 76, 77, 76, 76, 78, 78, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	76, 76, 76, 76, 76, 76, 76, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 74, 76, 74, 74, 75, 76, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 74, 74, 74, 76, 74, 75, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 74, 74, 74, 74, 74, 74, 74, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 74, 74, 74, 74, 76, 74, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 74, 74, 74, 74, 74, 76, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 74, 74, 74, 74, 74, 74, 
	79, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 74, 74, 74, 74, 75, 
	74, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 74, 74, 74, 74, 74, 
	75, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 74, 74, 74, 74, 74, 
	74, 74, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 74, 74, 74, 74, 
	75, 74, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 74, 74, 74, 74, 
	74, 75, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 82, 82, 80, 82, 80, 
	82, 82, 80, 80, 82, 82, 82, 83, 
	82, 82, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 82, 82, 82, 82, 
	82, 82, 82, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 80, 82, 80, 
	80, 81, 82, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 80, 80, 80, 
	82, 80, 81, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 80, 80, 80, 
	80, 80, 80, 80, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 80, 80, 
	80, 80, 82, 80, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 80, 80, 
	80, 80, 80, 82, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 80, 80, 
	80, 80, 80, 80, 85, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 80, 
	80, 80, 80, 81, 80, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 80, 
	80, 80, 80, 80, 81, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 80, 
	80, 80, 80, 80, 80, 80, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	80, 80, 80, 80, 81, 80, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	80, 80, 80, 80, 80, 81, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 87, 
	87, 88, 87, 88, 87, 87, 88, 88, 
	87, 87, 87, 89, 87, 87, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	87, 87, 87, 87, 87, 87, 87, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 88, 87, 88, 88, 86, 87, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 88, 88, 88, 87, 88, 86, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 88, 88, 88, 88, 88, 88, 88, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 88, 88, 88, 88, 87, 88, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 88, 88, 88, 88, 88, 87, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 88, 88, 88, 88, 88, 88, 
	92, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 88, 88, 88, 88, 91, 
	88, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 88, 88, 88, 88, 88, 
	91, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 88, 88, 88, 88, 88, 
	88, 88, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 88, 88, 88, 88, 
	93, 88, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 88, 88, 88, 88, 
	88, 93, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 94, 94, 94, 94, 
	94, 94, 94, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 94, 94, 94, 
	94, 95, 94, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 94, 94, 94, 
	94, 94, 95, 96, 97, 97, 97, 96, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 96, 97, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	100, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 101, 98, 98, 98, 98, 100, 98, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 98, 98, 98, 98, 99, 98, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 98, 98, 98, 98, 98, 99, 
	101, 98, 98, 102, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 105, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 106, 103, 
	103, 103, 103, 105, 103, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 103, 
	103, 103, 103, 104, 103, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 103, 
	103, 103, 103, 103, 104, 106, 103, 108, 
	107, 109, 107, 110, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 112, 107, 
	112, 112, 112, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 112, 107, 107, 
	107, 107, 113, 114, 107, 115, 107, 116, 
	117, 118, 119, 120, 113, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 121, 
	107, 122, 118, 123, 124, 107, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	125, 126, 118, 127, 111, 107, 111, 111, 
	111, 111, 111, 111, 111, 111, 128, 111, 
	111, 111, 111, 111, 111, 111, 111, 129, 
	111, 111, 130, 111, 131, 111, 111, 111, 
	132, 133, 107, 127, 107, 111, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 134, 
	107, 134, 134, 134, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 134, 107, 
	107, 107, 107, 135, 136, 107, 137, 107, 
	138, 139, 140, 141, 142, 135, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	143, 107, 144, 140, 145, 146, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 147, 148, 140, 109, 104, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 149, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	150, 104, 104, 151, 104, 152, 104, 104, 
	104, 153, 154, 107, 109, 107, 104, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	105, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 106, 107, 107, 107, 107, 105, 107, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 107, 107, 107, 107, 104, 107, 
	104, 104, 104, 104, 104, 155, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 107, 107, 107, 107, 107, 104, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 105, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 106, 107, 107, 107, 107, 105, 
	107, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 107, 107, 107, 107, 104, 
	107, 104, 104, 104, 104, 156, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 107, 107, 107, 107, 107, 
	104, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 105, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 106, 107, 107, 107, 107, 
	105, 107, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 107, 107, 107, 107, 
	104, 107, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 157, 104, 104, 104, 
	104, 104, 104, 104, 107, 107, 107, 107, 
	107, 104, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 105, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 106, 107, 107, 107, 
	107, 105, 107, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 107, 107, 107, 
	107, 104, 107, 104, 104, 158, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 107, 107, 107, 
	107, 107, 104, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 105, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 106, 107, 107, 
	107, 107, 105, 107, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 107, 107, 
	107, 107, 104, 107, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	159, 104, 104, 104, 104, 104, 107, 107, 
	107, 107, 107, 104, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 105, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 106, 107, 
	107, 107, 107, 105, 107, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 107, 
	107, 107, 107, 104, 107, 104, 104, 104, 
	104, 155, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 107, 
	107, 107, 107, 107, 104, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 105, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 106, 
	107, 107, 107, 107, 105, 107, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	107, 107, 107, 107, 104, 107, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 160, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	107, 107, 107, 107, 107, 104, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 105, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	106, 107, 107, 107, 107, 105, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 107, 107, 107, 107, 104, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 161, 104, 104, 104, 104, 104, 
	104, 104, 162, 104, 104, 104, 104, 104, 
	104, 107, 107, 107, 107, 107, 104, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	105, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 106, 107, 107, 107, 107, 105, 107, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 107, 107, 107, 107, 104, 107, 
	104, 104, 104, 104, 163, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 107, 107, 107, 107, 107, 104, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 105, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 106, 107, 107, 107, 107, 105, 
	107, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 107, 107, 107, 107, 104, 
	107, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 164, 104, 104, 104, 104, 
	104, 104, 104, 107, 107, 107, 107, 107, 
	104, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 105, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 106, 107, 107, 107, 107, 
	105, 107, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 107, 107, 107, 107, 
	104, 107, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 155, 104, 104, 104, 
	104, 104, 104, 104, 107, 107, 107, 107, 
	107, 104, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 105, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 106, 107, 107, 107, 
	107, 105, 107, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 107, 107, 107, 
	107, 104, 107, 104, 104, 104, 104, 104, 
	104, 104, 104, 165, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 107, 107, 107, 
	107, 107, 104, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 105, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 106, 107, 107, 
	107, 107, 105, 107, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 107, 107, 
	107, 107, 104, 107, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 155, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 107, 107, 
	107, 107, 107, 104, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 105, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 106, 107, 
	107, 107, 107, 105, 107, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 107, 
	107, 107, 107, 104, 107, 104, 104, 104, 
	104, 104, 104, 104, 166, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 107, 
	107, 107, 107, 107, 104, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 105, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 106, 
	107, 107, 107, 107, 105, 107, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	107, 107, 107, 107, 104, 107, 104, 104, 
	104, 104, 104, 104, 104, 104, 167, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	107, 107, 107, 107, 107, 104, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 105, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	106, 107, 107, 107, 107, 105, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 107, 107, 107, 107, 104, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 159, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 107, 107, 107, 107, 107, 104, 169, 
	168, 170, 168, 171, 168, 140, 168, 172, 
	168, 168, 168, 168, 168, 168, 168, 173, 
	168, 174, 168, 175, 168, 140, 168, 176, 
	168, 140, 168, 177, 168, 171, 168, 179, 
	178, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 182, 180, 182, 182, 182, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 182, 180, 180, 180, 180, 180, 180, 
	180, 183, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 180, 184, 180, 180, 
	181, 180, 181, 181, 181, 185, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 180, 180, 180, 180, 
	180, 181, 186, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 188, 180, 188, 
	188, 188, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 188, 180, 180, 180, 
	180, 180, 180, 180, 189, 180, 180, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 187, 187, 187, 
	187, 187, 187, 187, 187, 187, 187, 187, 
	187, 187, 187, 187, 187, 187, 187, 187, 
	187, 187, 187, 187, 187, 187, 187, 180, 
	190, 180, 180, 187, 180, 187, 187, 187, 
	191, 187, 187, 187, 187, 187, 187, 187, 
	187, 187, 187, 187, 187, 187, 187, 187, 
	187, 187, 187, 187, 187, 187, 187, 180, 
	180, 180, 180, 180, 187, 193, 192, 193, 
	193, 193, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 193, 192, 192, 192, 
	192, 192, 192, 192, 194, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	195, 192, 196, 192, 197, 192, 197, 197, 
	197, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 197, 192, 192, 192, 192, 
	192, 192, 192, 198, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 199, 
	192, 200, 201, 203, 202, 204, 202, 205, 
	202, 206, 202, 207, 202, 208, 209, 209, 
	209, 208, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 208, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 210, 210, 
	210, 210, 210, 210, 210, 210, 210, 210, 
	210, 210, 210, 210, 210, 210, 210, 210, 
	210, 210, 210, 210, 210, 210, 210, 210, 
	209, 209, 209, 209, 209, 209, 210, 210, 
	210, 210, 210, 210, 210, 210, 210, 210, 
	210, 210, 210, 210, 210, 210, 210, 210, 
	210, 210, 210, 210, 210, 210, 210, 210, 
	209, 211, 200, 212, 213, 212, 212, 212, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 212, 200, 200, 214, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 215, 215, 215, 215, 215, 215, 
	215, 215, 215, 215, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 216, 200, 
	217, 218, 217, 217, 217, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 217, 
	200, 200, 219, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 221, 200, 223, 224, 223, 
	223, 223, 222, 222, 222, 222, 222, 222, 
	222, 222, 222, 222, 222, 222, 222, 222, 
	222, 222, 222, 222, 223, 222, 222, 225, 
	222, 222, 222, 222, 222, 222, 222, 222, 
	222, 222, 222, 222, 226, 226, 226, 226, 
	226, 226, 226, 226, 226, 226, 222, 222, 
	222, 222, 222, 222, 222, 222, 222, 222, 
	222, 222, 222, 222, 222, 222, 222, 222, 
	222, 222, 222, 222, 222, 222, 222, 222, 
	222, 222, 222, 222, 222, 222, 222, 222, 
	227, 222, 229, 230, 229, 229, 229, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 229, 228, 228, 231, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 233, 228, 229, 
	234, 229, 229, 229, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 229, 228, 
	228, 231, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 233, 228, 213, 200, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 237, 
	237, 235, 237, 235, 237, 237, 235, 235, 
	237, 237, 237, 238, 237, 237, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	237, 237, 237, 237, 237, 237, 237, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 235, 237, 235, 235, 236, 237, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 235, 235, 235, 237, 235, 236, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 237, 
	237, 237, 237, 237, 237, 237, 237, 237, 
	237, 235, 235, 235, 235, 235, 235, 235, 
	237, 237, 237, 237, 237, 237, 237, 237, 
	237, 237, 237, 237, 237, 237, 237, 237, 
	237, 237, 237, 237, 237, 237, 237, 237, 
	237, 237, 235, 235, 235, 235, 237, 235, 
	237, 237, 237, 237, 237, 237, 237, 237, 
	237, 237, 237, 237, 237, 237, 237, 237, 
	237, 237, 237, 237, 237, 237, 237, 237, 
	237, 237, 235, 235, 235, 235, 235, 237, 
	240, 237, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 237, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 241, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 235, 235, 
	235, 235, 236, 235, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 235, 235, 
	235, 235, 235, 236, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 235, 
	235, 235, 235, 236, 235, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 235, 
	235, 235, 235, 235, 236, 240, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 243, 235, 235, 235, 235, 244, 235, 
	235, 235, 235, 235, 245, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 211, 235, 235, 235, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 235, 235, 235, 235, 242, 246, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 235, 235, 235, 245, 235, 242, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 249, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 248, 248, 248, 248, 248, 248, 
	248, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 248, 248, 248, 248, 247, 
	248, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 248, 248, 248, 248, 248, 
	247, 251, 250, 252, 243, 249, 248, 252, 
	244, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 243, 235, 235, 235, 235, 
	244, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 235, 235, 235, 235, 
	242, 246, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 235, 235, 235, 235, 
	235, 242, 252, 246, 253, 254, 254, 254, 
	253, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 253, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 255, 254, 253, 256, 256, 256, 253, 
	256, 256, 256, 256, 256, 257, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 253, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	258, 256, 253, 256, 256, 256, 253, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 253, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 259, 
	256, 253, 260, 260, 260, 253, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 253, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	261, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 262, 260, 253, 
	263, 263, 263, 253, 263, 263, 263, 263, 
	263, 264, 263, 263, 263, 263, 263, 263, 
	263, 263, 263, 263, 263, 263, 263, 263, 
	263, 253, 263, 253, 263, 263, 263, 253, 
	263, 263, 263, 263, 263, 263, 263, 263, 
	263, 263, 263, 263, 263, 263, 263, 263, 
	263, 263, 263, 263, 263, 253, 263, 253, 
	254, 254, 254, 253, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 253, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 265, 254, 253, 266, 
	266, 266, 253, 266, 266, 266, 266, 266, 
	267, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	253, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 268, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 269, 266, 266, 266, 266, 266, 
	266, 270, 266, 253, 266, 266, 266, 253, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 253, 266, 271, 
	253, 253, 253, 253, 253, 253, 253, 253, 
	253, 253, 253, 253, 253, 253, 253, 253, 
	253, 253, 253, 253, 253, 253, 253, 253, 
	253, 253, 253, 253, 253, 253, 253, 272, 
	253, 272, 253, 253, 273, 273, 273, 253, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 253, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 274, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 275, 
	273, 253, 256, 256, 256, 253, 256, 256, 
	256, 256, 256, 257, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 253, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 259, 256, 
	253, 276, 276, 276, 253, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 253, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 276, 276, 276, 276, 276, 276, 
	276, 277, 277, 277, 277, 277, 277, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 277, 277, 277, 277, 277, 277, 276, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 279, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 280, 200, 200, 281, 200, 279, 
	200, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 200, 200, 200, 200, 278, 
	200, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 200, 200, 200, 200, 200, 
	278, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 279, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 280, 235, 235, 281, 235, 
	279, 235, 278, 278, 278, 278, 278, 278, 
	282, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 235, 235, 235, 235, 
	278, 235, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 235, 235, 235, 235, 
	235, 278, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 279, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 280, 235, 235, 281, 
	235, 279, 235, 278, 278, 278, 278, 278, 
	278, 278, 278, 283, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 235, 235, 235, 
	235, 278, 235, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 235, 235, 235, 
	235, 235, 278, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 279, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 280, 235, 235, 
	281, 235, 279, 235, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 284, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 235, 235, 
	235, 235, 278, 235, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 235, 235, 
	235, 235, 235, 278, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 279, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 280, 235, 
	235, 281, 235, 279, 235, 278, 278, 278, 
	284, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 235, 
	235, 235, 235, 278, 235, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 235, 
	235, 235, 235, 235, 278, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 287, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 288, 
	285, 285, 285, 285, 287, 285, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	285, 285, 285, 285, 286, 285, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	285, 285, 285, 285, 285, 286, 288, 285, 
	285, 289, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 290, 290, 290, 290, 
	290, 290, 290, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 290, 290, 290, 
	290, 291, 290, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 290, 290, 290, 
	290, 290, 291, 293, 292, 293, 292, 292, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 292, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 292, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	292, 297, 296, 298, 298, 298, 298, 298, 
	298, 298, 298, 298, 298, 296, 299, 299, 
	299, 299, 299, 299, 299, 299, 299, 299, 
	296, 301, 300, 302, 300, 303, 300, 304, 
	300, 306, 305, 307, 305, 308, 305, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 290, 290, 290, 290, 290, 290, 290, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 290, 290, 290, 290, 309, 290, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 290, 290, 290, 290, 290, 309, 
	310, 296, 311, 312, 311, 311, 311, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 311, 296, 296, 313, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 314, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 315, 296, 316, 
	317, 316, 316, 316, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 316, 296, 
	296, 318, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 319, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 320, 296, 322, 323, 322, 322, 
	322, 321, 321, 321, 321, 321, 321, 321, 
	321, 321, 321, 321, 321, 321, 321, 321, 
	321, 321, 321, 322, 321, 321, 324, 321, 
	321, 321, 321, 321, 321, 321, 321, 321, 
	321, 321, 321, 321, 321, 321, 321, 321, 
	321, 321, 321, 321, 321, 321, 321, 325, 
	321, 321, 321, 321, 321, 321, 321, 321, 
	321, 321, 321, 321, 321, 321, 321, 321, 
	321, 321, 321, 321, 321, 321, 321, 321, 
	321, 321, 321, 321, 321, 321, 321, 326, 
	321, 328, 329, 328, 328, 328, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	328, 327, 327, 330, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 331, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 332, 327, 328, 329, 
	328, 328, 328, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 328, 327, 327, 
	330, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 333, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 332, 327, 328, 334, 328, 328, 328, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 328, 327, 327, 330, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 331, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 332, 327, 
	335, 296, 312, 296, 337, 336, 337, 337, 
	337, 336, 336, 336, 336, 336, 336, 336, 
	336, 336, 336, 336, 336, 336, 336, 336, 
	336, 336, 336, 337, 336, 336, 336, 336, 
	336, 338, 336, 336, 336, 336, 336, 336, 
	336, 339, 336, 340, 336, 342, 341, 341, 
	341, 342, 341, 341, 341, 341, 343, 344, 
	343, 343, 343, 341, 341, 341, 341, 341, 
	341, 341, 341, 341, 341, 341, 341, 342, 
	341, 341, 341, 341, 341, 343, 341, 341, 
	345, 341, 341, 341, 341, 341, 341, 341, 
	341, 341, 341, 341, 341, 341, 341, 341, 
	341, 341, 341, 341, 341, 341, 341, 341, 
	341, 341, 346, 341, 341, 341, 341, 341, 
	341, 341, 341, 341, 341, 341, 341, 341, 
	341, 341, 341, 341, 341, 341, 341, 341, 
	341, 341, 341, 341, 341, 341, 341, 341, 
	341, 347, 341, 341, 348, 341, 343, 349, 
	343, 343, 343, 349, 349, 349, 349, 349, 
	349, 349, 349, 349, 349, 349, 349, 349, 
	349, 349, 349, 349, 349, 343, 349, 350, 
	351, 352, 353, 354, 356, 355, 358, 359, 
	358, 358, 358, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 358, 357, 344, 
	355, 360, 355, 362, 361, 361, 361, 362, 
	361, 361, 361, 361, 363, 364, 363, 363, 
	363, 361, 361, 361, 361, 361, 361, 361, 
	361, 361, 361, 361, 361, 362, 361, 361, 
	361, 361, 361, 363, 361, 361, 365, 361, 
	361, 361, 361, 361, 361, 361, 361, 361, 
	361, 361, 361, 361, 361, 361, 361, 361, 
	361, 361, 361, 361, 361, 361, 361, 361, 
	361, 361, 361, 361, 361, 361, 361, 361, 
	361, 361, 361, 361, 361, 361, 361, 361, 
	361, 361, 361, 361, 361, 361, 361, 361, 
	361, 361, 361, 361, 361, 361, 361, 366, 
	361, 363, 367, 363, 363, 363, 367, 367, 
	367, 367, 367, 367, 367, 367, 367, 367, 
	367, 367, 367, 367, 367, 367, 367, 367, 
	363, 367, 369, 368, 368, 368, 368, 368, 
	368, 368, 368, 368, 368, 368, 368, 368, 
	368, 368, 368, 368, 368, 368, 368, 368, 
	368, 368, 368, 368, 368, 368, 370, 368, 
	368, 368, 368, 368, 368, 368, 368, 368, 
	368, 368, 368, 368, 368, 368, 368, 368, 
	368, 368, 368, 368, 368, 368, 368, 368, 
	368, 368, 368, 368, 368, 368, 368, 368, 
	368, 368, 368, 368, 368, 368, 368, 368, 
	368, 368, 368, 368, 368, 368, 368, 368, 
	368, 368, 368, 368, 368, 368, 368, 368, 
	368, 371, 368, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 372, 372, 372, 
	372, 372, 372, 372, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 372, 372, 
	372, 372, 13, 372, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 372, 372, 
	372, 372, 372, 13, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 372, 375, 
	374, 374, 374, 375, 374, 374, 374, 374, 
	374, 374, 374, 374, 374, 374, 374, 374, 
	374, 374, 374, 374, 374, 374, 374, 374, 
	374, 375, 374, 374, 374, 374, 374, 374, 
	374, 374, 374, 374, 374, 374, 374, 374, 
	374, 374, 374, 374, 374, 374, 374, 376, 
	376, 376, 376, 376, 376, 376, 376, 374, 
	374, 374, 374, 374, 374, 374, 374, 374, 
	374, 374, 377, 374, 374, 374, 374, 374, 
	374, 374, 374, 374, 378, 374, 374, 374, 
	374, 374, 374, 374, 374, 374, 374, 374, 
	374, 374, 374, 374, 374, 374, 374, 374, 
	374, 374, 379, 374, 374, 374, 374, 374, 
	374, 374, 374, 374, 374, 374, 374, 374, 
	374, 374, 374, 374, 380, 374, 374, 381, 
	374, 382, 383, 385, 385, 385, 385, 385, 
	385, 385, 385, 384, 386, 386, 386, 386, 
	386, 386, 386, 386, 384, 384, 387, 387, 
	38, 38, 38, 387, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 387, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 39, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 388, 38, 389, 390, 391, 
	391, 38, 38, 38, 391, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 391, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 39, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 392, 38, 37, 391, 
	393, 394, 395, 395, 25, 25, 25, 395, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 395, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 26, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 396, 
	25, 391, 19, 19, 19, 391, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 391, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 397, 19, 
	387, 25, 25, 25, 387, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 387, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 26, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 27, 25, 387, 398, 
	398, 398, 387, 398, 398, 398, 398, 398, 
	398, 398, 398, 398, 398, 398, 398, 398, 
	398, 398, 398, 398, 398, 398, 398, 398, 
	387, 398, 398, 398, 398, 398, 398, 398, 
	398, 398, 398, 398, 398, 398, 398, 398, 
	398, 398, 398, 398, 398, 398, 398, 398, 
	398, 398, 398, 398, 398, 398, 398, 398, 
	398, 398, 398, 398, 398, 398, 398, 398, 
	398, 398, 398, 398, 398, 398, 398, 398, 
	398, 398, 398, 398, 398, 398, 398, 398, 
	398, 398, 398, 398, 398, 398, 398, 398, 
	398, 398, 399, 398, 400, 401, 401, 398, 
	398, 398, 401, 398, 398, 398, 398, 398, 
	398, 398, 398, 398, 398, 398, 398, 398, 
	398, 398, 398, 398, 398, 398, 398, 398, 
	401, 398, 398, 398, 398, 398, 398, 398, 
	398, 398, 398, 398, 398, 398, 398, 398, 
	398, 398, 398, 398, 398, 398, 398, 398, 
	398, 398, 398, 398, 398, 398, 398, 398, 
	398, 398, 398, 398, 398, 398, 398, 398, 
	398, 398, 398, 398, 398, 398, 398, 398, 
	398, 398, 398, 398, 398, 398, 398, 398, 
	398, 398, 398, 398, 398, 398, 398, 398, 
	398, 398, 402, 398, 401, 19, 19, 19, 
	401, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 401, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 397, 19, 403, 401, 401, 25, 25, 
	25, 401, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 401, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 26, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 27, 25, 405, 405, 405, 405, 405, 
	405, 405, 405, 405, 405, 404, 404, 404, 
	404, 404, 404, 404, 405, 405, 405, 405, 
	405, 405, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 405, 405, 405, 405, 
	405, 405, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 406, 404, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 404, 404, 404, 404, 404, 404, 
	404, 407, 407, 407, 407, 407, 407, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 407, 407, 407, 407, 407, 407, 404, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 404, 404, 404, 404, 404, 404, 
	404, 408, 408, 408, 408, 408, 408, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 408, 408, 408, 408, 408, 408, 404, 
	409, 409, 409, 409, 409, 409, 409, 409, 
	409, 409, 404, 404, 404, 404, 404, 404, 
	404, 409, 409, 409, 409, 409, 409, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 409, 409, 409, 409, 409, 409, 404, 
	410, 413, 412, 412, 412, 413, 412, 412, 
	412, 412, 414, 412, 412, 412, 412, 412, 
	412, 412, 412, 412, 412, 412, 412, 412, 
	412, 412, 412, 413, 412, 412, 412, 412, 
	412, 414, 412, 412, 412, 412, 412, 412, 
	412, 412, 412, 412, 412, 412, 412, 412, 
	412, 415, 415, 415, 415, 415, 415, 415, 
	415, 415, 415, 412, 412, 412, 412, 412, 
	412, 412, 415, 415, 415, 415, 415, 415, 
	412, 412, 412, 412, 412, 412, 412, 412, 
	412, 412, 412, 412, 412, 412, 412, 412, 
	412, 412, 412, 412, 412, 412, 412, 412, 
	412, 412, 415, 415, 415, 415, 415, 415, 
	412, 412, 412, 412, 412, 412, 412, 412, 
	412, 412, 412, 412, 412, 412, 412, 412, 
	412, 412, 412, 412, 412, 412, 416, 412, 
	413, 412, 412, 412, 413, 412, 412, 412, 
	412, 411, 412, 412, 412, 412, 412, 412, 
	412, 412, 412, 412, 412, 412, 412, 412, 
	412, 412, 413, 412, 412, 412, 412, 412, 
	411, 412, 412, 412, 412, 412, 412, 412, 
	412, 412, 412, 412, 412, 412, 412, 412, 
	417, 417, 417, 417, 417, 417, 417, 417, 
	417, 417, 412, 412, 412, 412, 412, 412, 
	412, 417, 417, 417, 417, 417, 417, 412, 
	412, 412, 412, 412, 412, 412, 412, 412, 
	412, 412, 412, 412, 412, 412, 412, 412, 
	412, 412, 412, 412, 412, 412, 412, 412, 
	412, 417, 417, 417, 417, 417, 417, 412, 
	412, 412, 412, 412, 412, 412, 412, 412, 
	412, 412, 412, 412, 412, 412, 412, 412, 
	412, 412, 412, 412, 412, 418, 412, 411, 
	413, 417, 417, 417, 413, 417, 417, 417, 
	417, 411, 417, 417, 417, 417, 417, 417, 
	417, 417, 417, 417, 417, 417, 417, 417, 
	417, 417, 413, 417, 417, 417, 417, 417, 
	411, 417, 417, 417, 417, 417, 417, 417, 
	417, 417, 417, 417, 417, 417, 417, 417, 
	417, 417, 417, 417, 417, 417, 417, 417, 
	417, 417, 417, 417, 417, 417, 417, 417, 
	417, 417, 417, 417, 417, 417, 417, 417, 
	417, 417, 417, 417, 417, 417, 417, 417, 
	417, 417, 417, 417, 417, 417, 417, 417, 
	417, 417, 417, 417, 417, 417, 417, 417, 
	417, 417, 417, 417, 417, 417, 417, 417, 
	417, 417, 417, 417, 417, 417, 417, 417, 
	417, 417, 417, 417, 417, 417, 417, 417, 
	417, 417, 417, 417, 417, 411, 417, 419, 
	413, 420, 420, 420, 413, 420, 420, 420, 
	420, 414, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 413, 420, 420, 420, 420, 420, 
	414, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	415, 415, 415, 415, 415, 415, 415, 415, 
	415, 415, 420, 420, 420, 420, 420, 420, 
	420, 415, 415, 415, 415, 415, 415, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 415, 415, 415, 415, 415, 415, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 411, 420, 413, 
	420, 420, 420, 413, 420, 420, 420, 420, 
	411, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 413, 420, 420, 420, 420, 420, 411, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 417, 
	417, 417, 417, 417, 417, 417, 417, 417, 
	417, 420, 420, 420, 420, 420, 420, 420, 
	417, 417, 417, 417, 417, 417, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	417, 417, 417, 417, 417, 417, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 413, 420, 413, 420, 
	420, 420, 413, 420, 420, 420, 420, 421, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	413, 420, 420, 420, 420, 420, 421, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 422, 422, 
	422, 422, 422, 422, 422, 422, 422, 422, 
	420, 420, 420, 420, 420, 420, 420, 422, 
	422, 422, 422, 422, 422, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 422, 
	422, 422, 422, 422, 422, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 423, 420, 413, 420, 420, 
	420, 413, 420, 420, 420, 420, 421, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 413, 
	420, 420, 420, 420, 420, 421, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 415, 415, 415, 
	415, 415, 415, 415, 415, 415, 415, 420, 
	420, 420, 420, 420, 420, 420, 415, 415, 
	415, 415, 415, 415, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 415, 415, 
	415, 415, 415, 415, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 423, 420, 424, 413, 420, 420, 
	420, 413, 420, 420, 420, 420, 421, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 413, 
	420, 420, 420, 420, 420, 421, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 425, 425, 425, 
	425, 425, 425, 425, 425, 425, 425, 420, 
	420, 420, 420, 420, 420, 420, 425, 425, 
	425, 425, 425, 425, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 425, 425, 
	425, 425, 425, 425, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 423, 420, 413, 420, 420, 420, 
	413, 420, 420, 420, 420, 421, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 413, 420, 
	420, 420, 420, 420, 421, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 426, 426, 426, 426, 
	426, 426, 426, 426, 426, 426, 420, 420, 
	420, 420, 420, 420, 420, 426, 426, 426, 
	426, 426, 426, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 426, 426, 426, 
	426, 426, 426, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 423, 420, 413, 420, 420, 420, 413, 
	420, 420, 420, 420, 421, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 413, 420, 420, 
	420, 420, 420, 421, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 427, 427, 427, 427, 427, 
	427, 427, 427, 427, 427, 420, 420, 420, 
	420, 420, 420, 420, 427, 427, 427, 427, 
	427, 427, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 427, 427, 427, 427, 
	427, 427, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	423, 420, 413, 420, 420, 420, 413, 420, 
	420, 420, 420, 421, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 413, 420, 420, 420, 
	420, 420, 421, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 420, 420, 420, 420, 
	420, 420, 420, 428, 428, 428, 428, 428, 
	428, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 428, 428, 428, 428, 428, 
	428, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 423, 
	420, 413, 420, 420, 420, 413, 420, 420, 
	420, 420, 421, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 413, 420, 420, 420, 420, 
	420, 421, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 429, 420, 420, 420, 420, 420, 
	420, 420, 429, 429, 429, 429, 429, 429, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 429, 429, 429, 429, 429, 429, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 423, 420, 
	413, 420, 420, 420, 413, 420, 420, 420, 
	420, 411, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 413, 420, 420, 420, 420, 420, 
	411, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 420, 420, 420, 420, 420, 420, 
	420, 429, 429, 429, 429, 429, 429, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 429, 429, 429, 429, 429, 429, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 411, 420, 430, 
	431, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 432, 432, 432, 432, 432, 
	432, 432, 433, 433, 433, 433, 433, 433, 
	432, 432, 432, 432, 432, 432, 432, 432, 
	432, 432, 432, 432, 432, 432, 432, 432, 
	432, 432, 432, 432, 432, 432, 432, 432, 
	432, 432, 433, 433, 433, 433, 433, 433, 
	432, 432, 435, 434, 434, 434, 435, 434, 
	434, 434, 434, 434, 436, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 435, 434, 434, 434, 
	434, 434, 434, 434, 434, 437, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 438, 434, 
	440, 439, 439, 439, 439, 439, 439, 439, 
	439, 439, 439, 439, 439, 439, 439, 439, 
	439, 439, 439, 439, 439, 439, 439, 439, 
	439, 439, 439, 439, 441, 439, 439, 439, 
	439, 439, 439, 439, 439, 439, 439, 439, 
	439, 439, 439, 439, 439, 439, 439, 439, 
	439, 439, 439, 439, 439, 439, 439, 439, 
	439, 439, 439, 439, 439, 439, 439, 439, 
	439, 439, 439, 439, 439, 439, 439, 439, 
	439, 439, 439, 439, 439, 439, 439, 439, 
	439, 439, 439, 439, 439, 439, 439, 442, 
	439, 443, 443, 443, 443, 443, 443, 443, 
	443, 443, 443, 443, 443, 443, 443, 443, 
	443, 443, 443, 443, 443, 443, 443, 443, 
	443, 443, 443, 443, 443, 443, 443, 443, 
	443, 443, 443, 443, 443, 443, 443, 443, 
	443, 443, 443, 443, 443, 443, 443, 443, 
	443, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 443, 443, 443, 443, 443, 
	443, 443, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 443, 443, 443, 443, 
	44, 443, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 443, 443, 443, 443, 
	443, 44, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 443, 446, 445, 445, 
	445, 446, 445, 445, 445, 445, 445, 445, 
	445, 445, 445, 445, 445, 445, 445, 445, 
	445, 445, 445, 445, 445, 445, 445, 446, 
	445, 445, 445, 445, 445, 445, 445, 445, 
	445, 445, 445, 445, 445, 445, 445, 445, 
	445, 445, 445, 445, 445, 447, 447, 447, 
	447, 447, 447, 447, 447, 445, 445, 445, 
	445, 445, 445, 445, 445, 445, 445, 445, 
	448, 445, 445, 445, 445, 445, 445, 445, 
	445, 445, 449, 445, 445, 445, 445, 445, 
	445, 445, 445, 445, 445, 445, 445, 445, 
	445, 445, 445, 445, 445, 445, 445, 445, 
	450, 445, 445, 445, 445, 445, 445, 445, 
	445, 445, 445, 445, 445, 445, 445, 445, 
	445, 445, 451, 445, 445, 452, 445, 453, 
	454, 456, 456, 456, 456, 456, 456, 456, 
	456, 455, 457, 457, 457, 457, 457, 457, 
	457, 457, 455, 455, 458, 458, 69, 69, 
	69, 458, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 458, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 70, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 459, 69, 460, 461, 462, 462, 69, 
	69, 69, 462, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	462, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 70, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 463, 69, 68, 462, 464, 465, 
	466, 466, 56, 56, 56, 466, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 466, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	57, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 467, 56, 462, 
	50, 50, 50, 462, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 462, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 468, 50, 458, 56, 
	56, 56, 458, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	458, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 57, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 58, 56, 458, 469, 469, 469, 
	458, 469, 469, 469, 469, 469, 469, 469, 
	469, 469, 469, 469, 469, 469, 469, 469, 
	469, 469, 469, 469, 469, 469, 458, 469, 
	469, 469, 469, 469, 469, 469, 469, 469, 
	469, 469, 469, 469, 469, 469, 469, 469, 
	469, 469, 469, 469, 469, 469, 469, 469, 
	469, 469, 469, 469, 469, 469, 469, 469, 
	469, 469, 469, 469, 469, 469, 469, 469, 
	469, 469, 469, 469, 469, 469, 469, 469, 
	469, 469, 469, 469, 469, 469, 469, 469, 
	469, 469, 469, 469, 469, 469, 469, 469, 
	470, 469, 471, 472, 472, 469, 469, 469, 
	472, 469, 469, 469, 469, 469, 469, 469, 
	469, 469, 469, 469, 469, 469, 469, 469, 
	469, 469, 469, 469, 469, 469, 472, 469, 
	469, 469, 469, 469, 469, 469, 469, 469, 
	469, 469, 469, 469, 469, 469, 469, 469, 
	469, 469, 469, 469, 469, 469, 469, 469, 
	469, 469, 469, 469, 469, 469, 469, 469, 
	469, 469, 469, 469, 469, 469, 469, 469, 
	469, 469, 469, 469, 469, 469, 469, 469, 
	469, 469, 469, 469, 469, 469, 469, 469, 
	469, 469, 469, 469, 469, 469, 469, 469, 
	473, 469, 472, 50, 50, 50, 472, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 472, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 468, 
	50, 474, 472, 472, 56, 56, 56, 472, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 472, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 57, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 58, 
	56, 476, 476, 476, 476, 476, 476, 476, 
	476, 476, 476, 475, 475, 475, 475, 475, 
	475, 475, 476, 476, 476, 476, 476, 476, 
	475, 475, 475, 475, 475, 475, 475, 475, 
	475, 475, 475, 475, 475, 475, 475, 475, 
	475, 475, 475, 475, 475, 475, 475, 475, 
	475, 475, 476, 476, 476, 476, 476, 476, 
	475, 475, 475, 475, 475, 475, 475, 475, 
	475, 475, 475, 475, 475, 475, 475, 475, 
	475, 475, 475, 475, 477, 475, 478, 478, 
	478, 478, 478, 478, 478, 478, 478, 478, 
	475, 475, 475, 475, 475, 475, 475, 478, 
	478, 478, 478, 478, 478, 475, 475, 475, 
	475, 475, 475, 475, 475, 475, 475, 475, 
	475, 475, 475, 475, 475, 475, 475, 475, 
	475, 475, 475, 475, 475, 475, 475, 478, 
	478, 478, 478, 478, 478, 475, 479, 479, 
	479, 479, 479, 479, 479, 479, 479, 479, 
	475, 475, 475, 475, 475, 475, 475, 479, 
	479, 479, 479, 479, 479, 475, 475, 475, 
	475, 475, 475, 475, 475, 475, 475, 475, 
	475, 475, 475, 475, 475, 475, 475, 475, 
	475, 475, 475, 475, 475, 475, 475, 479, 
	479, 479, 479, 479, 479, 475, 480, 480, 
	480, 480, 480, 480, 480, 480, 480, 480, 
	475, 475, 475, 475, 475, 475, 475, 480, 
	480, 480, 480, 480, 480, 475, 475, 475, 
	475, 475, 475, 475, 475, 475, 475, 475, 
	475, 475, 475, 475, 475, 475, 475, 475, 
	475, 475, 475, 475, 475, 475, 475, 480, 
	480, 480, 480, 480, 480, 475, 481, 484, 
	483, 483, 483, 484, 483, 483, 483, 483, 
	485, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 484, 483, 483, 483, 483, 483, 485, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 483, 483, 483, 483, 483, 483, 483, 
	486, 486, 486, 486, 486, 486, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	486, 486, 486, 486, 486, 486, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 487, 483, 484, 483, 
	483, 483, 484, 483, 483, 483, 483, 482, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	484, 483, 483, 483, 483, 483, 482, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	483, 483, 483, 483, 483, 483, 483, 488, 
	488, 488, 488, 488, 488, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 488, 
	488, 488, 488, 488, 488, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 489, 483, 482, 484, 488, 
	488, 488, 484, 488, 488, 488, 488, 482, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	484, 488, 488, 488, 488, 488, 482, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 482, 488, 490, 484, 491, 
	491, 491, 484, 491, 491, 491, 491, 485, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	484, 491, 491, 491, 491, 491, 485, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	491, 491, 491, 491, 491, 491, 491, 486, 
	486, 486, 486, 486, 486, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 486, 
	486, 486, 486, 486, 486, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 482, 491, 484, 491, 491, 
	491, 484, 491, 491, 491, 491, 482, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 484, 
	491, 491, 491, 491, 491, 482, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 491, 
	491, 491, 491, 491, 491, 491, 488, 488, 
	488, 488, 488, 488, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 488, 488, 
	488, 488, 488, 488, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 484, 491, 484, 491, 491, 491, 
	484, 491, 491, 491, 491, 492, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 484, 491, 
	491, 491, 491, 491, 492, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 493, 493, 493, 493, 
	493, 493, 493, 493, 493, 493, 491, 491, 
	491, 491, 491, 491, 491, 493, 493, 493, 
	493, 493, 493, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 493, 493, 493, 
	493, 493, 493, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 494, 491, 484, 491, 491, 491, 484, 
	491, 491, 491, 491, 492, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 484, 491, 491, 
	491, 491, 491, 492, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 491, 491, 491, 
	491, 491, 491, 491, 486, 486, 486, 486, 
	486, 486, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 486, 486, 486, 486, 
	486, 486, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	494, 491, 495, 484, 491, 491, 491, 484, 
	491, 491, 491, 491, 492, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 484, 491, 491, 
	491, 491, 491, 492, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 496, 496, 496, 496, 496, 
	496, 496, 496, 496, 496, 491, 491, 491, 
	491, 491, 491, 491, 496, 496, 496, 496, 
	496, 496, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 496, 496, 496, 496, 
	496, 496, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	494, 491, 484, 491, 491, 491, 484, 491, 
	491, 491, 491, 492, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 484, 491, 491, 491, 
	491, 491, 492, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 497, 497, 497, 497, 497, 497, 
	497, 497, 497, 497, 491, 491, 491, 491, 
	491, 491, 491, 497, 497, 497, 497, 497, 
	497, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 497, 497, 497, 497, 497, 
	497, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 494, 
	491, 484, 491, 491, 491, 484, 491, 491, 
	491, 491, 492, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 484, 491, 491, 491, 491, 
	491, 492, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 498, 498, 498, 498, 498, 498, 498, 
	498, 498, 498, 491, 491, 491, 491, 491, 
	491, 491, 498, 498, 498, 498, 498, 498, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 498, 498, 498, 498, 498, 498, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 494, 491, 
	484, 491, 491, 491, 484, 491, 491, 491, 
	491, 492, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 484, 491, 491, 491, 491, 491, 
	492, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	499, 499, 499, 499, 499, 499, 499, 499, 
	499, 499, 491, 491, 491, 491, 491, 491, 
	491, 499, 499, 499, 499, 499, 499, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 499, 499, 499, 499, 499, 499, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 494, 491, 484, 
	491, 491, 491, 484, 491, 491, 491, 491, 
	492, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 484, 491, 491, 491, 491, 491, 492, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 500, 
	500, 500, 500, 500, 500, 500, 500, 500, 
	500, 491, 491, 491, 491, 491, 491, 491, 
	500, 500, 500, 500, 500, 500, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	500, 500, 500, 500, 500, 500, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 494, 491, 484, 491, 
	491, 491, 484, 491, 491, 491, 491, 482, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	484, 491, 491, 491, 491, 491, 482, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 500, 500, 
	500, 500, 500, 500, 500, 500, 500, 500, 
	491, 491, 491, 491, 491, 491, 491, 500, 
	500, 500, 500, 500, 500, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 500, 
	500, 500, 500, 500, 500, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 491, 491, 491, 491, 491, 
	491, 491, 491, 482, 491, 501, 502, 504, 
	504, 504, 504, 504, 504, 504, 504, 504, 
	504, 503, 503, 503, 503, 503, 503, 503, 
	504, 504, 504, 504, 504, 504, 503, 503, 
	503, 503, 503, 503, 503, 503, 503, 503, 
	503, 503, 503, 503, 503, 503, 503, 503, 
	503, 503, 503, 503, 503, 503, 503, 503, 
	504, 504, 504, 504, 504, 504, 503, 503, 
	506, 505, 505, 505, 506, 505, 505, 505, 
	505, 507, 508, 507, 507, 507, 505, 505, 
	505, 505, 505, 505, 505, 505, 505, 505, 
	505, 505, 506, 505, 505, 505, 505, 505, 
	507, 505, 505, 505, 505, 505, 505, 505, 
	505, 505, 505, 505, 505, 505, 505, 505, 
	505, 505, 505, 505, 505, 505, 505, 505, 
	505, 505, 505, 505, 505, 505, 505, 505, 
	505, 505, 505, 505, 505, 505, 505, 505, 
	505, 505, 505, 505, 505, 505, 505, 505, 
	505, 505, 505, 505, 505, 505, 505, 505, 
	505, 505, 505, 505, 509, 505, 507, 510, 
	507, 507, 507, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 507, 510, 511, 
	512, 512, 512, 511, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 511, 512, 514, 513, 513, 513, 514, 
	513, 513, 513, 513, 513, 515, 513, 513, 
	513, 513, 513, 513, 513, 513, 513, 513, 
	513, 513, 513, 513, 513, 514, 513, 513, 
	513, 513, 513, 513, 513, 513, 513, 513, 
	513, 513, 513, 513, 513, 513, 513, 513, 
	513, 513, 513, 513, 513, 513, 513, 513, 
	513, 513, 513, 513, 513, 513, 513, 513, 
	513, 513, 513, 513, 513, 513, 513, 513, 
	513, 513, 513, 513, 513, 513, 513, 513, 
	513, 513, 513, 513, 513, 513, 513, 513, 
	513, 513, 513, 513, 513, 513, 513, 516, 
	513, 517, 518, 518, 518, 517, 518, 518, 
	518, 518, 518, 519, 518, 518, 518, 518, 
	518, 518, 518, 518, 518, 518, 518, 518, 
	518, 518, 518, 517, 518, 521, 520, 520, 
	520, 521, 520, 520, 520, 520, 520, 522, 
	520, 520, 520, 520, 520, 520, 520, 520, 
	520, 520, 520, 520, 520, 520, 520, 521, 
	520, 520, 520, 520, 520, 520, 520, 520, 
	523, 520, 525, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 526, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 527, 524, 528, 528, 528, 528, 528, 
	528, 528, 528, 528, 528, 528, 528, 528, 
	528, 528, 528, 528, 528, 528, 528, 528, 
	528, 528, 528, 528, 528, 528, 528, 528, 
	528, 528, 528, 528, 528, 528, 528, 528, 
	528, 528, 528, 528, 528, 528, 528, 528, 
	528, 528, 528, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 528, 528, 528, 
	528, 528, 528, 528, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 528, 528, 
	528, 528, 75, 528, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 528, 528, 
	528, 528, 528, 75, 78, 78, 78, 78, 
	78, 78, 78, 78, 78, 78, 528, 530, 
	529, 529, 529, 530, 529, 529, 529, 529, 
	529, 531, 529, 529, 529, 529, 529, 529, 
	529, 529, 529, 529, 529, 529, 529, 529, 
	529, 530, 529, 533, 532, 532, 532, 533, 
	532, 532, 532, 532, 534, 535, 534, 534, 
	534, 532, 532, 532, 532, 532, 532, 532, 
	532, 532, 532, 532, 532, 533, 532, 532, 
	532, 532, 532, 534, 532, 532, 536, 532, 
	534, 537, 534, 534, 534, 537, 537, 537, 
	537, 537, 537, 537, 537, 537, 537, 537, 
	537, 537, 537, 537, 537, 537, 537, 534, 
	537, 539, 538, 538, 538, 538, 538, 538, 
	538, 538, 538, 538, 538, 538, 538, 538, 
	538, 538, 538, 538, 538, 538, 538, 538, 
	538, 538, 538, 538, 538, 540, 538, 538, 
	538, 538, 538, 538, 538, 538, 538, 538, 
	538, 538, 538, 538, 538, 538, 538, 538, 
	538, 538, 538, 538, 538, 538, 538, 538, 
	538, 538, 538, 538, 538, 538, 538, 538, 
	538, 538, 538, 538, 538, 538, 538, 538, 
	538, 538, 538, 538, 538, 538, 538, 538, 
	538, 538, 538, 538, 538, 538, 538, 538, 
	541, 538, 542, 542, 542, 542, 542, 542, 
	542, 542, 542, 542, 542, 542, 542, 542, 
	542, 542, 542, 542, 542, 542, 542, 542, 
	542, 542, 542, 542, 542, 542, 542, 542, 
	542, 542, 542, 542, 542, 542, 542, 542, 
	542, 542, 542, 542, 542, 542, 542, 542, 
	542, 542, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 542, 542, 542, 542, 
	542, 542, 542, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 542, 542, 542, 
	542, 81, 542, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 542, 542, 542, 
	542, 542, 81, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 542, 544, 543, 
	543, 543, 544, 543, 543, 543, 543, 545, 
	546, 545, 545, 545, 543, 543, 543, 543, 
	543, 543, 543, 543, 543, 543, 543, 543, 
	544, 543, 543, 543, 543, 543, 545, 543, 
	545, 547, 545, 545, 545, 547, 547, 547, 
	547, 547, 547, 547, 547, 547, 547, 547, 
	547, 547, 547, 547, 547, 547, 547, 545, 
	547, 549, 549, 549, 549, 549, 549, 549, 
	549, 549, 549, 549, 549, 549, 549, 549, 
	549, 549, 549, 549, 549, 549, 549, 549, 
	549, 549, 549, 548, 548, 548, 548, 548, 
	548, 549, 549, 549, 549, 549, 549, 549, 
	549, 549, 549, 549, 549, 549, 549, 549, 
	549, 549, 549, 549, 549, 549, 549, 549, 
	549, 549, 549, 548, 549, 549, 549, 549, 
	549, 549, 549, 549, 549, 549, 549, 549, 
	549, 549, 549, 549, 549, 549, 549, 549, 
	549, 549, 549, 549, 549, 549, 550, 550, 
	550, 550, 550, 550, 549, 549, 549, 549, 
	549, 549, 549, 549, 549, 549, 549, 549, 
	549, 549, 549, 549, 549, 549, 549, 549, 
	549, 549, 549, 549, 549, 549, 550, 551, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 552, 88, 553, 553, 553, 
	553, 553, 553, 553, 553, 553, 553, 553, 
	553, 553, 553, 553, 553, 553, 553, 553, 
	553, 553, 553, 553, 553, 553, 553, 553, 
	553, 553, 553, 553, 553, 553, 553, 553, 
	553, 553, 553, 553, 553, 553, 553, 553, 
	553, 553, 553, 553, 553, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 553, 
	553, 553, 553, 553, 553, 553, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	553, 553, 553, 553, 86, 553, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	553, 553, 553, 553, 553, 86, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	553, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 554, 554, 554, 554, 554, 
	554, 554, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 554, 554, 554, 554, 
	91, 554, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 554, 554, 554, 554, 
	554, 91, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 555, 555, 555, 555, 
	555, 555, 555, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 555, 555, 555, 
	555, 93, 555, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 555, 555, 555, 
	555, 555, 93, 557, 558, 558, 558, 557, 
	558, 558, 558, 558, 559, 560, 559, 559, 
	559, 558, 558, 558, 558, 558, 558, 558, 
	558, 558, 558, 558, 558, 557, 558, 558, 
	558, 558, 558, 559, 561, 558, 562, 563, 
	564, 565, 558, 558, 558, 566, 567, 558, 
	567, 558, 568, 558, 558, 558, 558, 558, 
	558, 558, 558, 558, 558, 569, 558, 570, 
	571, 572, 558, 558, 573, 574, 573, 573, 
	575, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 576, 577, 
	558, 568, 578, 568, 579, 580, 581, 582, 
	583, 584, 556, 556, 585, 556, 556, 556, 
	586, 587, 588, 556, 556, 589, 590, 591, 
	592, 556, 593, 556, 594, 556, 558, 595, 
	558, 567, 558, 556, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 597, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 596, 596, 
	596, 597, 596, 597, 596, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 596, 
	596, 596, 596, 556, 596, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 596, 
	596, 596, 596, 596, 556, 559, 598, 559, 
	559, 559, 598, 598, 598, 598, 598, 598, 
	598, 598, 598, 598, 598, 598, 598, 598, 
	598, 598, 598, 598, 559, 598, 599, 568, 
	600, 600, 568, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 
	600, 600, 600, 600, 600, 600, 600, 600, 
	568, 600, 601, 602, 603, 604, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 95, 
	95, 605, 95, 605, 95, 95, 605, 605, 
	95, 95, 95, 607, 95, 95, 608, 608, 
	608, 608, 608, 608, 608, 608, 608, 608, 
	95, 95, 95, 95, 95, 95, 95, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 605, 95, 605, 605, 606, 95, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 605, 605, 605, 95, 605, 606, 609, 
	609, 609, 609, 609, 609, 609, 609, 609, 
	609, 609, 609, 609, 609, 609, 609, 609, 
	609, 609, 609, 609, 609, 609, 609, 609, 
	609, 609, 609, 609, 609, 609, 609, 609, 
	609, 609, 609, 609, 609, 609, 609, 609, 
	609, 609, 609, 609, 609, 609, 609, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 609, 609, 609, 609, 609, 609, 609, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 609, 609, 609, 609, 606, 609, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 609, 609, 609, 609, 609, 606, 
	608, 608, 608, 608, 608, 608, 608, 608, 
	608, 608, 609, 610, 600, 568, 600, 568, 
	600, 568, 600, 612, 611, 568, 613, 600, 
	568, 600, 614, 568, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 568, 605, 568, 600, 568, 
	568, 600, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 597, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 596, 596, 596, 597, 
	596, 597, 596, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 596, 596, 596, 
	596, 573, 596, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 596, 596, 596, 
	596, 596, 573, 615, 615, 615, 615, 615, 
	615, 615, 615, 615, 615, 615, 615, 615, 
	615, 615, 615, 615, 615, 615, 615, 615, 
	615, 615, 615, 615, 615, 615, 615, 615, 
	615, 615, 615, 615, 597, 615, 615, 615, 
	615, 615, 615, 615, 615, 615, 615, 615, 
	615, 615, 615, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 615, 615, 615, 
	597, 615, 597, 615, 573, 573, 573, 573, 
	616, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 615, 615, 
	615, 615, 573, 615, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 615, 615, 
	615, 615, 615, 573, 615, 615, 615, 615, 
	615, 615, 615, 615, 615, 615, 615, 615, 
	615, 615, 615, 615, 615, 615, 615, 615, 
	615, 615, 615, 615, 615, 615, 615, 615, 
	615, 615, 615, 615, 615, 597, 615, 615, 
	615, 615, 615, 615, 615, 615, 615, 615, 
	615, 615, 615, 615, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 615, 615, 
	615, 597, 615, 597, 615, 573, 573, 573, 
	573, 573, 573, 617, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 615, 
	615, 615, 615, 573, 615, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 615, 
	615, 615, 615, 615, 573, 615, 615, 615, 
	615, 615, 615, 615, 615, 615, 615, 615, 
	615, 615, 615, 615, 615, 615, 615, 615, 
	615, 615, 615, 615, 615, 615, 615, 615, 
	615, 615, 615, 615, 615, 615, 597, 615, 
	615, 615, 615, 615, 615, 615, 615, 615, 
	615, 615, 615, 615, 615, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 615, 
	615, 615, 597, 615, 597, 615, 573, 573, 
	573, 573, 573, 573, 573, 573, 618, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	615, 615, 615, 615, 573, 615, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	615, 615, 615, 615, 615, 573, 615, 615, 
	615, 615, 615, 615, 615, 615, 615, 615, 
	615, 615, 615, 615, 615, 615, 615, 615, 
	615, 615, 615, 615, 615, 615, 615, 615, 
	615, 615, 615, 615, 615, 615, 615, 597, 
	615, 615, 615, 615, 615, 615, 615, 615, 
	615, 615, 615, 615, 615, 615, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	615, 615, 615, 597, 615, 597, 615, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 619, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 615, 615, 615, 615, 573, 615, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 615, 615, 615, 615, 615, 573, 615, 
	615, 615, 615, 615, 615, 615, 615, 615, 
	615, 615, 615, 615, 615, 615, 615, 615, 
	615, 615, 615, 615, 615, 615, 615, 615, 
	615, 615, 615, 615, 615, 615, 615, 615, 
	597, 615, 615, 615, 615, 615, 615, 615, 
	615, 615, 615, 615, 615, 615, 615, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 615, 615, 615, 597, 615, 597, 615, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 620, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 615, 615, 615, 615, 573, 615, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 615, 615, 615, 615, 615, 573, 
	615, 615, 615, 615, 615, 615, 615, 615, 
	615, 615, 615, 615, 615, 615, 615, 615, 
	615, 615, 615, 615, 615, 615, 615, 615, 
	615, 615, 615, 615, 615, 615, 615, 615, 
	615, 597, 615, 615, 615, 615, 615, 615, 
	615, 615, 615, 615, 615, 615, 615, 615, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 615, 615, 615, 597, 615, 597, 
	615, 573, 573, 573, 619, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 615, 615, 615, 615, 573, 
	615, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 615, 615, 615, 615, 615, 
	573, 614, 605, 560, 605, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 597, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 597, 621, 597, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 621, 622, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 621, 621, 556, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 597, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 597, 621, 597, 621, 556, 
	556, 556, 556, 623, 624, 556, 556, 556, 
	556, 556, 625, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 621, 556, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 621, 621, 556, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	597, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 597, 621, 597, 621, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 626, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 621, 556, 621, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 621, 621, 556, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 597, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 597, 621, 597, 
	621, 556, 556, 627, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 621, 621, 621, 621, 556, 
	621, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 621, 621, 621, 621, 621, 
	556, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 597, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 621, 621, 621, 597, 621, 
	597, 621, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	628, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 621, 
	556, 621, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 621, 
	621, 556, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 597, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 597, 
	621, 597, 621, 556, 556, 556, 629, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	621, 556, 621, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	621, 621, 556, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 597, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	597, 621, 597, 621, 556, 556, 556, 556, 
	556, 556, 556, 556, 630, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 621, 556, 621, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 621, 621, 556, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 597, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 597, 621, 597, 621, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 631, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 621, 556, 621, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 621, 621, 556, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 597, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 597, 621, 597, 621, 556, 556, 
	556, 556, 556, 556, 632, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 621, 556, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 621, 621, 556, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 597, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 597, 621, 597, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 621, 633, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 621, 621, 556, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	597, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 597, 621, 597, 621, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 621, 634, 621, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 621, 621, 556, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 597, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 597, 621, 597, 
	621, 556, 556, 556, 556, 556, 556, 556, 
	556, 635, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 621, 621, 621, 621, 556, 
	621, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 621, 621, 621, 621, 621, 
	556, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 597, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 621, 621, 621, 597, 621, 
	597, 621, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 636, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 621, 
	556, 621, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 621, 
	621, 556, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 597, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 597, 
	621, 597, 621, 556, 556, 556, 556, 632, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	621, 556, 621, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	621, 621, 556, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 597, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	597, 621, 597, 621, 556, 556, 556, 556, 
	556, 556, 556, 556, 637, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 621, 556, 621, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 621, 621, 556, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 597, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 597, 621, 597, 621, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 636, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 621, 556, 621, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 621, 621, 556, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 597, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 597, 621, 597, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 621, 556, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 638, 556, 639, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 621, 621, 556, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 597, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 597, 621, 597, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 621, 556, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 640, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 621, 621, 556, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	597, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 597, 621, 597, 621, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 621, 556, 621, 
	641, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 621, 621, 556, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 597, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 597, 621, 597, 
	621, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 621, 621, 621, 621, 556, 
	621, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 634, 556, 556, 556, 556, 
	556, 556, 556, 621, 621, 621, 621, 621, 
	556, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 597, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 621, 621, 621, 597, 621, 
	597, 621, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 621, 
	556, 621, 556, 556, 556, 634, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 621, 
	621, 556, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 597, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 597, 
	621, 597, 621, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	621, 556, 621, 556, 556, 556, 556, 642, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 643, 556, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	621, 621, 556, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 597, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	597, 621, 597, 621, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 621, 556, 621, 556, 556, 556, 556, 
	556, 556, 644, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 621, 621, 556, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 597, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 597, 621, 597, 621, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 621, 556, 621, 556, 556, 556, 
	556, 556, 556, 556, 556, 645, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 621, 621, 556, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 597, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 597, 621, 597, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 621, 556, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 634, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 621, 621, 556, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 597, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 597, 621, 597, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 621, 556, 621, 556, 
	556, 556, 556, 646, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 621, 621, 556, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	597, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 597, 621, 597, 621, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 621, 556, 621, 
	647, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 621, 621, 556, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 597, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 597, 621, 597, 
	621, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 621, 621, 621, 621, 556, 
	621, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 634, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 621, 621, 621, 621, 621, 
	556, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 597, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 621, 621, 621, 597, 621, 
	597, 621, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 621, 
	556, 621, 648, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 649, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 621, 
	621, 556, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 597, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 597, 
	621, 597, 621, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	621, 556, 621, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 650, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	621, 621, 556, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 597, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	597, 621, 597, 621, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 621, 556, 621, 556, 556, 556, 556, 
	634, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 621, 621, 556, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 597, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 597, 621, 597, 621, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 621, 556, 621, 651, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 621, 621, 556, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 597, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 597, 621, 597, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 621, 556, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	641, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 621, 621, 556, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 597, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 597, 621, 597, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 621, 556, 621, 556, 
	556, 556, 556, 652, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 634, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 621, 621, 556, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	597, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 597, 621, 597, 621, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 621, 556, 621, 
	556, 556, 556, 556, 556, 653, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 621, 621, 556, 
	654, 654, 654, 654, 654, 654, 654, 654, 
	654, 654, 654, 654, 654, 654, 654, 654, 
	654, 654, 654, 654, 654, 654, 654, 654, 
	654, 654, 654, 654, 654, 654, 654, 654, 
	654, 597, 654, 654, 654, 654, 654, 654, 
	654, 654, 654, 654, 654, 654, 654, 654, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 654, 654, 654, 597, 654, 597, 
	654, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 654, 654, 654, 654, 556, 
	654, 556, 556, 556, 556, 556, 556, 556, 
	556, 655, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 654, 654, 654, 654, 654, 
	556, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 597, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 621, 621, 621, 597, 621, 
	597, 621, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 621, 
	556, 621, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 656, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 621, 
	621, 556, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 597, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 597, 
	621, 597, 621, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	621, 556, 621, 556, 556, 556, 556, 657, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	621, 621, 556, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 597, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	597, 621, 597, 621, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 621, 556, 621, 556, 556, 556, 658, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 621, 621, 556, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 597, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 597, 621, 659, 621, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 621, 556, 621, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 621, 621, 556, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 597, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 597, 621, 597, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 621, 556, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 660, 556, 661, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 621, 621, 556, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 597, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 597, 621, 597, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 621, 556, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 662, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 621, 621, 556, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	597, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 597, 621, 597, 621, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 621, 556, 621, 
	556, 556, 556, 556, 634, 556, 556, 556, 
	663, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 621, 621, 556, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 597, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 597, 621, 597, 
	621, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 621, 621, 621, 621, 556, 
	621, 556, 556, 556, 556, 556, 634, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 621, 621, 621, 621, 621, 
	556, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 597, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 621, 621, 621, 597, 621, 
	597, 621, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 621, 
	556, 621, 556, 556, 556, 634, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 664, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 621, 
	621, 556, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 597, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 597, 
	621, 597, 621, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	621, 556, 621, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 665, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	621, 621, 556, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 597, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	597, 621, 597, 621, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 621, 556, 621, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 650, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 621, 621, 556, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 597, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 597, 621, 597, 621, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 621, 556, 621, 666, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 588, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 621, 621, 556, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 597, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 597, 621, 597, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 621, 556, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 648, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 621, 621, 556, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 597, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 597, 621, 597, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 621, 556, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	634, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 621, 621, 556, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	597, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 597, 621, 597, 621, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 621, 556, 621, 
	556, 556, 556, 556, 556, 634, 556, 556, 
	556, 556, 556, 556, 556, 634, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 621, 621, 556, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 597, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 597, 621, 597, 
	621, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 621, 621, 621, 621, 556, 
	621, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 667, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 621, 621, 621, 621, 621, 
	556, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 597, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 621, 621, 621, 597, 621, 
	597, 621, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 621, 
	556, 621, 556, 556, 556, 668, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 621, 
	621, 556, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 597, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 597, 
	621, 597, 621, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	621, 556, 621, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 669, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	621, 621, 556, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 597, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	597, 621, 597, 621, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 621, 556, 621, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 650, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 621, 621, 556, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 597, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 597, 621, 597, 621, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 621, 556, 621, 556, 556, 556, 
	556, 670, 556, 556, 556, 671, 556, 556, 
	556, 556, 556, 672, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 621, 621, 556, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 597, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 597, 621, 597, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 621, 556, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 672, 556, 556, 
	621, 621, 621, 621, 621, 556, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 597, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 597, 621, 597, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 621, 556, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 634, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 621, 621, 556, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	597, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 597, 621, 597, 621, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 621, 556, 621, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 634, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 621, 621, 556, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 597, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 597, 621, 597, 
	621, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 621, 621, 621, 621, 556, 
	621, 556, 556, 556, 556, 673, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 621, 621, 621, 621, 621, 
	556, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 597, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 621, 621, 621, 597, 621, 
	597, 621, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 621, 
	556, 621, 556, 556, 556, 674, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 675, 676, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 621, 
	621, 556, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 597, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 597, 
	621, 597, 621, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	621, 556, 621, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 634, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	621, 621, 556, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 597, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	597, 621, 597, 621, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 621, 556, 621, 556, 556, 677, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 621, 621, 556, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 597, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 597, 621, 597, 621, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 621, 556, 621, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 650, 556, 556, 556, 556, 556, 621, 
	621, 621, 621, 621, 556, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 597, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 597, 621, 597, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 621, 556, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 678, 
	556, 556, 679, 556, 556, 556, 556, 556, 
	621, 621, 621, 621, 621, 556, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 597, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 597, 621, 597, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 621, 556, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 634, 
	556, 621, 621, 621, 621, 621, 556, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	597, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 597, 621, 597, 621, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 621, 556, 621, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 645, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 621, 621, 556, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 597, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 597, 621, 597, 
	621, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 621, 621, 621, 621, 556, 
	621, 556, 556, 556, 556, 680, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 681, 556, 556, 
	556, 556, 556, 621, 621, 621, 621, 621, 
	556, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 597, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 621, 621, 621, 597, 621, 
	597, 621, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 621, 
	556, 621, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 663, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 621, 
	621, 556, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 597, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 597, 
	621, 597, 621, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	621, 556, 621, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 682, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	621, 621, 556, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 597, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	597, 621, 597, 621, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 621, 556, 621, 556, 556, 556, 556, 
	588, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 621, 621, 556, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 597, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 597, 621, 597, 621, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 621, 556, 621, 556, 556, 556, 
	556, 556, 556, 556, 683, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 677, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 621, 621, 556, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 597, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 597, 621, 597, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 621, 556, 621, 556, 556, 
	556, 556, 645, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 621, 621, 556, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 597, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 597, 621, 597, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 621, 556, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 684, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 621, 621, 556, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	597, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 597, 621, 597, 621, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 621, 556, 621, 
	556, 556, 556, 685, 556, 556, 556, 556, 
	556, 556, 556, 686, 556, 556, 556, 556, 
	556, 556, 556, 687, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 621, 621, 556, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 597, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 597, 621, 597, 
	621, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 621, 621, 621, 621, 556, 
	621, 556, 556, 556, 556, 663, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 621, 621, 621, 621, 621, 
	556, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 597, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 621, 621, 621, 597, 621, 
	597, 621, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 621, 
	556, 621, 556, 556, 556, 556, 651, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 621, 
	621, 556, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 597, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 621, 621, 621, 597, 
	621, 597, 621, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	621, 556, 621, 556, 556, 556, 556, 556, 
	556, 556, 556, 671, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	621, 621, 556, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 597, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 621, 621, 621, 
	597, 621, 597, 621, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 621, 556, 621, 556, 556, 556, 556, 
	556, 556, 556, 688, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 621, 621, 556, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 597, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 621, 621, 
	621, 597, 621, 597, 621, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 621, 556, 621, 556, 556, 556, 
	556, 645, 556, 556, 556, 669, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 621, 621, 556, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 597, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 621, 
	621, 621, 597, 621, 597, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 621, 556, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 689, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 621, 621, 556, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 597, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	621, 621, 621, 597, 621, 597, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 621, 556, 621, 556, 
	556, 556, 556, 690, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 621, 621, 556, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	597, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 621, 621, 621, 597, 621, 597, 621, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 621, 556, 621, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 556, 639, 556, 556, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 621, 621, 621, 621, 621, 556, 
	568, 600, 692, 693, 693, 693, 692, 693, 
	693, 693, 693, 694, 693, 694, 694, 694, 
	693, 693, 693, 693, 693, 693, 693, 693, 
	693, 693, 693, 693, 692, 693, 693, 693, 
	693, 693, 694, 693, 693, 695, 693, 693, 
	693, 693, 693, 693, 693, 693, 693, 693, 
	693, 693, 693, 693, 693, 693, 693, 693, 
	693, 693, 693, 693, 693, 693, 693, 693, 
	693, 693, 693, 691, 691, 691, 691, 691, 
	691, 691, 691, 691, 691, 691, 691, 691, 
	691, 691, 691, 691, 691, 691, 691, 691, 
	691, 691, 691, 691, 691, 693, 696, 693, 
	693, 691, 693, 691, 691, 691, 691, 691, 
	691, 691, 691, 691, 691, 691, 691, 691, 
	691, 691, 691, 691, 691, 691, 691, 691, 
	691, 691, 691, 691, 691, 693, 693, 693, 
	693, 693, 691, 697, 697, 697, 697, 697, 
	697, 697, 697, 697, 697, 697, 697, 697, 
	697, 697, 697, 697, 697, 697, 697, 697, 
	697, 697, 697, 697, 697, 697, 697, 697, 
	697, 697, 697, 697, 100, 697, 697, 697, 
	697, 697, 697, 697, 697, 697, 697, 697, 
	697, 697, 697, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 101, 697, 697, 
	697, 697, 100, 697, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 697, 697, 
	697, 697, 99, 697, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 697, 697, 
	697, 697, 697, 99, 694, 698, 694, 694, 
	694, 698, 698, 698, 698, 698, 698, 698, 
	698, 698, 698, 698, 698, 698, 698, 698, 
	698, 698, 698, 694, 698, 699, 700, 701, 
	702, 703, 697, 704, 706, 707, 707, 707, 
	706, 707, 707, 707, 707, 708, 709, 708, 
	708, 708, 707, 707, 707, 707, 707, 707, 
	707, 707, 707, 707, 707, 707, 706, 707, 
	707, 707, 707, 707, 708, 710, 707, 711, 
	707, 712, 713, 707, 707, 707, 714, 715, 
	707, 715, 707, 712, 707, 707, 707, 707, 
	707, 707, 707, 707, 707, 707, 707, 707, 
	716, 717, 718, 707, 707, 719, 719, 719, 
	719, 719, 719, 719, 719, 719, 719, 719, 
	719, 719, 719, 719, 719, 719, 719, 719, 
	719, 719, 719, 719, 719, 719, 719, 720, 
	721, 707, 712, 705, 712, 705, 705, 705, 
	705, 705, 705, 705, 705, 705, 705, 705, 
	705, 705, 705, 705, 705, 705, 705, 705, 
	705, 705, 705, 705, 705, 705, 705, 707, 
	722, 707, 715, 707, 705, 723, 723, 723, 
	723, 723, 723, 723, 723, 723, 723, 723, 
	723, 723, 723, 723, 723, 723, 723, 723, 
	723, 723, 723, 723, 723, 723, 723, 723, 
	723, 723, 723, 723, 723, 723, 724, 723, 
	723, 723, 723, 723, 723, 723, 723, 723, 
	723, 723, 723, 723, 723, 705, 705, 705, 
	705, 705, 705, 705, 705, 705, 705, 723, 
	723, 723, 723, 723, 724, 723, 705, 705, 
	705, 705, 705, 705, 705, 705, 705, 705, 
	705, 705, 705, 705, 705, 705, 705, 705, 
	705, 705, 705, 705, 705, 705, 705, 705, 
	723, 723, 723, 723, 705, 723, 705, 705, 
	705, 705, 705, 705, 705, 705, 705, 705, 
	705, 705, 705, 705, 705, 705, 705, 705, 
	705, 705, 705, 705, 705, 705, 705, 705, 
	723, 723, 723, 723, 723, 705, 726, 725, 
	727, 708, 728, 708, 708, 708, 728, 728, 
	728, 728, 728, 728, 728, 728, 728, 728, 
	728, 728, 728, 728, 728, 728, 728, 728, 
	708, 728, 729, 712, 730, 730, 712, 730, 
	730, 730, 730, 730, 730, 730, 730, 730, 
	730, 730, 730, 730, 730, 730, 730, 730, 
	730, 730, 730, 730, 730, 730, 730, 730, 
	730, 730, 730, 730, 730, 730, 730, 730, 
	730, 730, 730, 730, 730, 730, 730, 730, 
	730, 730, 730, 730, 730, 730, 730, 730, 
	730, 730, 730, 730, 730, 730, 730, 730, 
	730, 730, 730, 730, 712, 730, 731, 732, 
	733, 734, 712, 730, 712, 730, 712, 730, 
	712, 735, 730, 712, 730, 737, 712, 736, 
	736, 736, 736, 736, 736, 736, 736, 736, 
	736, 736, 736, 736, 736, 736, 736, 736, 
	736, 736, 736, 736, 736, 736, 736, 736, 
	736, 736, 736, 736, 736, 736, 736, 736, 
	736, 736, 736, 736, 736, 736, 736, 736, 
	736, 736, 736, 736, 736, 736, 736, 736, 
	736, 736, 736, 736, 736, 736, 736, 736, 
	736, 736, 736, 736, 736, 736, 712, 736, 
	712, 730, 712, 712, 730, 738, 738, 738, 
	738, 738, 738, 738, 738, 738, 738, 738, 
	738, 738, 738, 738, 738, 738, 738, 738, 
	738, 738, 738, 738, 738, 738, 738, 738, 
	738, 738, 738, 738, 738, 738, 724, 738, 
	738, 738, 738, 738, 738, 738, 738, 738, 
	738, 738, 738, 738, 738, 719, 719, 719, 
	719, 719, 719, 719, 719, 719, 719, 738, 
	738, 738, 738, 738, 724, 738, 719, 719, 
	719, 719, 719, 719, 719, 719, 719, 719, 
	719, 719, 719, 719, 719, 719, 719, 719, 
	719, 719, 719, 719, 719, 719, 719, 719, 
	738, 738, 738, 738, 719, 738, 719, 719, 
	719, 719, 719, 719, 719, 719, 719, 719, 
	719, 719, 719, 719, 719, 719, 719, 719, 
	719, 719, 719, 719, 719, 719, 719, 719, 
	738, 738, 738, 738, 738, 719, 737, 736, 
	709, 736, 712, 730, 740, 739, 739, 739, 
	740, 739, 739, 739, 739, 741, 742, 741, 
	741, 741, 739, 739, 739, 739, 739, 739, 
	739, 739, 739, 739, 739, 739, 740, 739, 
	739, 739, 739, 739, 741, 739, 739, 743, 
	739, 109, 744, 739, 745, 739, 746, 109, 
	140, 747, 142, 109, 739, 739, 739, 739, 
	739, 739, 739, 739, 739, 739, 748, 739, 
	749, 140, 750, 751, 739, 739, 739, 739, 
	739, 739, 739, 739, 739, 739, 739, 739, 
	739, 739, 739, 739, 739, 739, 739, 739, 
	739, 739, 739, 739, 739, 739, 739, 140, 
	752, 140, 109, 739, 739, 739, 739, 739, 
	739, 739, 739, 739, 739, 753, 739, 739, 
	739, 739, 739, 739, 739, 739, 754, 739, 
	739, 755, 739, 756, 739, 739, 739, 153, 
	154, 739, 109, 739, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 741, 757, 741, 
	741, 741, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 741, 757, 757, 757, 
	757, 135, 136, 757, 137, 757, 138, 139, 
	140, 141, 142, 135, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 143, 757, 
	144, 140, 145, 146, 757, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 147, 
	148, 140, 109, 104, 757, 104, 104, 104, 
	104, 104, 104, 104, 104, 149, 104, 104, 
	104, 104, 104, 104, 104, 104, 150, 104, 
	104, 151, 104, 152, 104, 104, 104, 153, 
	154, 757, 109, 757, 104, 758, 759, 759, 
	759, 758, 759, 759, 759, 759, 140, 760, 
	140, 140, 140, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 758, 
	759, 759, 759, 759, 759, 140, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 140, 759, 140, 760, 140, 140, 
	140, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 140, 103, 103, 103, 103, 
	103, 109, 103, 103, 103, 103, 103, 103, 
	103, 140, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	140, 103, 140, 760, 140, 140, 140, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 140, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 140, 103, 
	761, 140, 760, 140, 140, 140, 762, 762, 
	762, 762, 762, 762, 762, 762, 762, 762, 
	762, 762, 762, 762, 762, 762, 762, 762, 
	140, 762, 762, 762, 762, 762, 762, 762, 
	762, 762, 763, 762, 762, 762, 762, 762, 
	762, 762, 762, 762, 762, 762, 762, 762, 
	762, 762, 762, 762, 762, 140, 762, 140, 
	760, 140, 140, 140, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 140, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 140, 140, 103, 764, 758, 
	140, 758, 766, 765, 768, 769, 768, 768, 
	768, 767, 767, 767, 767, 767, 767, 767, 
	767, 767, 767, 767, 767, 767, 767, 767, 
	767, 767, 767, 768, 767, 770, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 105, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	106, 758, 758, 758, 758, 105, 758, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 758, 758, 758, 758, 104, 758, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 758, 758, 758, 758, 758, 104, 771, 
	140, 760, 140, 140, 140, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 140, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 140, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 758, 109, 758, 772, 773, 774, 
	775, 776, 777, 140, 760, 140, 140, 140, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 140, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 109, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 140, 
	758, 140, 765, 109, 778, 109, 778, 779, 
	780, 779, 779, 779, 767, 767, 767, 767, 
	767, 767, 767, 767, 767, 767, 767, 767, 
	767, 767, 767, 767, 767, 767, 779, 767, 
	781, 778, 782, 782, 782, 782, 782, 782, 
	782, 782, 782, 112, 782, 112, 112, 112, 
	782, 782, 782, 782, 782, 782, 782, 782, 
	782, 782, 782, 782, 782, 782, 782, 782, 
	782, 782, 112, 782, 782, 782, 782, 113, 
	114, 782, 115, 782, 116, 117, 118, 119, 
	120, 113, 782, 782, 782, 782, 782, 782, 
	782, 782, 782, 782, 121, 782, 122, 118, 
	123, 124, 782, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 125, 126, 118, 
	127, 111, 782, 111, 111, 111, 111, 111, 
	111, 111, 111, 128, 111, 111, 111, 111, 
	111, 111, 111, 111, 129, 111, 111, 130, 
	111, 131, 111, 111, 111, 132, 133, 782, 
	127, 782, 111, 140, 778, 783, 778, 784, 
	778, 785, 778, 786, 179, 179, 179, 786, 
	179, 179, 179, 179, 787, 179, 787, 787, 
	787, 179, 179, 179, 179, 179, 179, 179, 
	179, 179, 179, 179, 179, 786, 179, 179, 
	179, 179, 179, 787, 179, 179, 179, 179, 
	179, 179, 179, 179, 179, 179, 179, 179, 
	179, 179, 179, 179, 179, 179, 179, 179, 
	179, 179, 179, 179, 179, 179, 179, 179, 
	179, 179, 179, 179, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 179, 788, 
	179, 179, 181, 179, 181, 181, 181, 185, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 179, 179, 
	179, 179, 179, 181, 178, 178, 178, 178, 
	178, 178, 178, 178, 178, 178, 178, 178, 
	178, 178, 178, 178, 178, 178, 178, 178, 
	178, 178, 178, 178, 178, 178, 178, 178, 
	178, 178, 178, 178, 178, 789, 178, 178, 
	178, 178, 178, 178, 178, 178, 178, 178, 
	178, 178, 178, 178, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 179, 178, 
	178, 178, 178, 789, 178, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 178, 
	178, 178, 178, 181, 178, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 178, 
	178, 178, 178, 178, 181, 790, 790, 790, 
	790, 790, 790, 790, 790, 790, 182, 790, 
	182, 182, 182, 790, 790, 790, 790, 790, 
	790, 790, 790, 790, 790, 790, 790, 790, 
	790, 790, 790, 790, 790, 182, 790, 790, 
	790, 790, 790, 790, 790, 183, 790, 790, 
	790, 790, 790, 790, 790, 790, 790, 790, 
	790, 790, 790, 790, 790, 790, 790, 790, 
	790, 790, 790, 790, 790, 790, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	790, 184, 790, 790, 181, 790, 181, 181, 
	181, 185, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	790, 790, 790, 790, 790, 181, 791, 790, 
	790, 790, 790, 790, 790, 790, 790, 790, 
	790, 790, 790, 790, 790, 790, 790, 790, 
	790, 790, 790, 790, 790, 790, 790, 790, 
	790, 790, 790, 790, 790, 790, 790, 790, 
	789, 790, 790, 790, 790, 790, 790, 790, 
	790, 790, 790, 790, 790, 790, 790, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 179, 790, 790, 790, 790, 789, 790, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 790, 790, 790, 790, 181, 790, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 792, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 790, 790, 790, 790, 790, 181, 
	186, 790, 794, 793, 793, 793, 794, 793, 
	793, 793, 793, 795, 793, 795, 795, 795, 
	793, 793, 793, 793, 793, 793, 793, 793, 
	793, 793, 793, 793, 794, 793, 793, 793, 
	793, 793, 795, 793, 793, 796, 793, 793, 
	793, 793, 793, 793, 793, 793, 793, 793, 
	793, 793, 793, 793, 793, 793, 793, 793, 
	793, 793, 793, 793, 793, 793, 793, 793, 
	793, 793, 793, 793, 793, 793, 793, 793, 
	793, 793, 793, 793, 793, 793, 793, 793, 
	793, 793, 793, 793, 793, 793, 793, 793, 
	793, 793, 793, 793, 793, 793, 797, 793, 
	793, 793, 793, 793, 793, 793, 798, 793, 
	793, 793, 793, 793, 793, 793, 793, 793, 
	793, 793, 793, 793, 793, 793, 793, 793, 
	793, 793, 793, 793, 793, 799, 793, 795, 
	800, 795, 795, 795, 800, 800, 800, 800, 
	800, 800, 800, 800, 800, 800, 800, 800, 
	800, 800, 800, 800, 800, 800, 795, 800, 
	801, 802, 803, 804, 806, 805, 807, 808, 
	805, 809, 811, 812, 812, 812, 811, 812, 
	812, 812, 812, 813, 814, 813, 813, 813, 
	812, 812, 812, 812, 812, 812, 812, 812, 
	812, 812, 812, 812, 811, 812, 812, 812, 
	812, 812, 813, 812, 812, 815, 812, 812, 
	812, 812, 812, 812, 812, 812, 812, 812, 
	812, 812, 812, 812, 812, 812, 812, 812, 
	812, 812, 812, 812, 812, 812, 812, 812, 
	812, 812, 812, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 812, 816, 812, 
	812, 810, 812, 810, 810, 810, 810, 810, 
	810, 810, 810, 817, 810, 810, 810, 810, 
	810, 810, 810, 810, 818, 810, 810, 819, 
	810, 820, 810, 810, 810, 812, 812, 812, 
	812, 812, 810, 821, 821, 821, 821, 821, 
	821, 821, 821, 821, 821, 821, 821, 821, 
	821, 821, 821, 821, 821, 821, 821, 821, 
	821, 821, 821, 821, 821, 821, 821, 821, 
	821, 821, 821, 821, 821, 821, 821, 821, 
	821, 821, 821, 821, 821, 821, 821, 821, 
	821, 821, 821, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 821, 821, 821, 
	821, 821, 821, 821, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 821, 821, 
	821, 821, 810, 821, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 821, 821, 
	821, 821, 821, 810, 813, 822, 813, 813, 
	813, 822, 822, 822, 822, 822, 822, 822, 
	822, 822, 822, 822, 822, 822, 822, 822, 
	822, 822, 822, 813, 822, 823, 824, 825, 
	826, 827, 829, 828, 830, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 831, 
	831, 831, 831, 831, 831, 831, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	831, 831, 831, 831, 810, 831, 810, 810, 
	810, 810, 810, 832, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	831, 831, 831, 831, 831, 810, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	831, 831, 831, 831, 831, 831, 831, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 831, 831, 831, 831, 810, 831, 810, 
	810, 810, 810, 833, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 831, 831, 831, 831, 831, 810, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 831, 831, 831, 831, 831, 831, 831, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 831, 831, 831, 831, 810, 831, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 834, 810, 810, 810, 810, 810, 
	810, 810, 831, 831, 831, 831, 831, 810, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 831, 831, 831, 831, 831, 831, 
	831, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 831, 831, 831, 831, 810, 
	831, 810, 810, 835, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 831, 831, 831, 831, 831, 
	810, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 831, 831, 831, 831, 831, 
	831, 831, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 831, 831, 831, 831, 
	810, 831, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 836, 810, 
	810, 810, 810, 810, 831, 831, 831, 831, 
	831, 810, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 831, 831, 831, 831, 
	831, 831, 831, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 831, 831, 831, 
	831, 810, 831, 810, 810, 810, 810, 832, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 831, 831, 831, 
	831, 831, 810, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 831, 831, 831, 
	831, 831, 831, 831, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 831, 831, 
	831, 831, 810, 831, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 837, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 831, 831, 
	831, 831, 831, 810, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 831, 831, 
	831, 831, 831, 831, 831, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 831, 
	831, 831, 831, 810, 831, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	838, 810, 810, 810, 810, 810, 810, 810, 
	839, 810, 810, 810, 810, 810, 810, 831, 
	831, 831, 831, 831, 810, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 831, 
	831, 831, 831, 831, 831, 831, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	831, 831, 831, 831, 810, 831, 810, 810, 
	810, 810, 840, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	831, 831, 831, 831, 831, 810, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	831, 831, 831, 831, 831, 831, 831, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 831, 831, 831, 831, 810, 831, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 841, 810, 810, 810, 810, 810, 810, 
	810, 831, 831, 831, 831, 831, 810, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 831, 831, 831, 831, 831, 831, 831, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 831, 831, 831, 831, 810, 831, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 832, 810, 810, 810, 810, 810, 
	810, 810, 831, 831, 831, 831, 831, 810, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 831, 831, 831, 831, 831, 831, 
	831, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 831, 831, 831, 831, 810, 
	831, 810, 810, 810, 810, 810, 810, 810, 
	810, 842, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 831, 831, 831, 831, 831, 
	810, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 831, 831, 831, 831, 831, 
	831, 831, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 831, 831, 831, 831, 
	810, 831, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 832, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 831, 831, 831, 831, 
	831, 810, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 831, 831, 831, 831, 
	831, 831, 831, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 831, 831, 831, 
	831, 810, 831, 810, 810, 810, 810, 810, 
	810, 810, 843, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 831, 831, 831, 
	831, 831, 810, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 831, 831, 831, 
	831, 831, 831, 831, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 831, 831, 
	831, 831, 810, 831, 810, 810, 810, 810, 
	810, 810, 810, 810, 844, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 831, 831, 
	831, 831, 831, 810, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 831, 831, 
	831, 831, 831, 831, 831, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 831, 
	831, 831, 831, 810, 831, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	836, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 831, 
	831, 831, 831, 831, 810, 846, 211, 211, 
	211, 846, 211, 211, 211, 211, 847, 848, 
	847, 847, 847, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 846, 
	211, 211, 211, 211, 211, 847, 849, 211, 
	850, 211, 851, 852, 211, 853, 211, 854, 
	855, 211, 856, 857, 858, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 859, 
	211, 860, 861, 862, 863, 211, 864, 865, 
	864, 864, 866, 864, 864, 864, 864, 864, 
	864, 864, 864, 864, 864, 864, 864, 864, 
	864, 864, 864, 864, 864, 864, 864, 864, 
	867, 868, 211, 869, 870, 211, 871, 872, 
	873, 874, 875, 876, 845, 845, 877, 845, 
	845, 845, 878, 879, 880, 845, 845, 881, 
	882, 883, 884, 845, 885, 845, 886, 845, 
	887, 888, 211, 869, 211, 845, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 890, 
	889, 890, 890, 890, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 890, 279, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	280, 889, 889, 281, 889, 279, 889, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 889, 891, 889, 889, 845, 889, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 889, 889, 889, 889, 889, 845, 893, 
	892, 892, 894, 892, 895, 897, 898, 896, 
	896, 896, 896, 896, 896, 896, 896, 896, 
	896, 896, 896, 896, 896, 896, 896, 896, 
	896, 896, 896, 896, 896, 896, 896, 896, 
	896, 896, 896, 896, 896, 896, 896, 896, 
	896, 896, 896, 896, 896, 896, 896, 896, 
	896, 896, 896, 896, 896, 896, 896, 896, 
	896, 896, 896, 896, 896, 896, 896, 896, 
	896, 896, 896, 896, 896, 896, 899, 896, 
	901, 900, 902, 903, 904, 847, 905, 847, 
	847, 847, 905, 905, 905, 905, 905, 905, 
	905, 905, 905, 905, 905, 905, 905, 905, 
	905, 905, 905, 905, 847, 905, 907, 906, 
	909, 910, 909, 909, 909, 908, 908, 908, 
	908, 908, 908, 908, 908, 908, 908, 908, 
	908, 908, 908, 908, 908, 908, 908, 909, 
	908, 211, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 211, 911, 912, 913, 914, 915, 
	918, 918, 918, 918, 918, 918, 918, 918, 
	918, 918, 918, 918, 918, 918, 918, 918, 
	918, 918, 918, 918, 918, 918, 918, 918, 
	918, 918, 917, 917, 917, 917, 917, 917, 
	918, 918, 918, 918, 918, 918, 918, 918, 
	918, 918, 918, 918, 918, 918, 918, 918, 
	918, 918, 918, 918, 918, 918, 918, 918, 
	918, 918, 917, 919, 209, 209, 209, 919, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 919, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 210, 210, 210, 210, 
	210, 210, 210, 210, 210, 210, 210, 210, 
	210, 210, 210, 210, 210, 210, 210, 210, 
	210, 210, 210, 210, 210, 210, 209, 209, 
	209, 209, 209, 209, 210, 210, 210, 210, 
	210, 210, 210, 210, 210, 210, 210, 210, 
	210, 210, 210, 210, 210, 210, 210, 210, 
	210, 210, 210, 210, 210, 210, 209, 921, 
	920, 920, 920, 920, 920, 920, 920, 920, 
	920, 920, 920, 920, 920, 920, 920, 920, 
	920, 920, 920, 920, 920, 920, 211, 920, 
	922, 924, 923, 923, 923, 923, 923, 923, 
	923, 923, 923, 923, 923, 923, 923, 923, 
	923, 923, 923, 923, 211, 923, 211, 200, 
	212, 213, 212, 212, 212, 920, 920, 920, 
	920, 920, 920, 920, 920, 920, 920, 920, 
	920, 920, 920, 920, 920, 920, 920, 212, 
	920, 920, 214, 920, 920, 920, 920, 920, 
	920, 920, 920, 920, 920, 920, 920, 215, 
	215, 215, 215, 215, 215, 215, 215, 215, 
	215, 920, 920, 920, 211, 920, 920, 920, 
	920, 920, 920, 920, 920, 920, 920, 920, 
	920, 920, 920, 920, 920, 920, 920, 920, 
	920, 920, 920, 920, 920, 920, 920, 920, 
	920, 920, 920, 216, 920, 229, 230, 229, 
	229, 229, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 229, 228, 228, 231, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	233, 228, 212, 213, 212, 212, 212, 920, 
	920, 920, 920, 920, 920, 920, 920, 920, 
	920, 920, 920, 920, 920, 920, 920, 920, 
	920, 212, 920, 920, 214, 920, 920, 920, 
	920, 920, 920, 920, 920, 920, 920, 920, 
	920, 215, 215, 215, 215, 215, 215, 215, 
	215, 215, 215, 920, 920, 920, 211, 211, 
	920, 920, 920, 920, 920, 920, 920, 920, 
	920, 920, 920, 920, 920, 920, 920, 920, 
	920, 920, 920, 920, 920, 920, 920, 920, 
	920, 920, 920, 920, 920, 216, 920, 926, 
	911, 928, 927, 911, 929, 929, 929, 911, 
	929, 929, 929, 929, 929, 929, 929, 929, 
	929, 929, 929, 929, 929, 929, 929, 929, 
	929, 929, 929, 929, 929, 911, 929, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	931, 932, 911, 933, 237, 934, 932, 911, 
	911, 935, 936, 911, 936, 911, 237, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 937, 911, 938, 939, 940, 911, 941, 
	930, 930, 930, 930, 930, 930, 930, 930, 
	930, 930, 930, 930, 930, 930, 930, 930, 
	930, 930, 930, 930, 930, 930, 930, 930, 
	930, 930, 942, 911, 911, 237, 930, 237, 
	930, 930, 930, 930, 930, 930, 930, 930, 
	930, 930, 930, 930, 930, 930, 930, 930, 
	930, 930, 930, 930, 930, 930, 930, 930, 
	930, 930, 911, 943, 911, 944, 911, 930, 
	945, 945, 945, 945, 945, 945, 945, 945, 
	945, 945, 945, 945, 945, 945, 945, 945, 
	945, 945, 945, 945, 945, 945, 945, 945, 
	945, 945, 945, 945, 945, 945, 945, 945, 
	945, 946, 945, 945, 945, 945, 945, 945, 
	945, 945, 945, 945, 945, 945, 945, 945, 
	930, 930, 930, 930, 930, 930, 930, 930, 
	930, 930, 945, 945, 945, 947, 945, 946, 
	945, 930, 930, 930, 930, 930, 930, 930, 
	930, 930, 930, 930, 930, 930, 930, 930, 
	930, 930, 930, 930, 930, 930, 930, 930, 
	930, 930, 930, 945, 945, 945, 945, 930, 
	945, 930, 930, 930, 930, 930, 930, 930, 
	930, 930, 930, 930, 930, 930, 930, 930, 
	930, 930, 930, 930, 930, 930, 930, 930, 
	930, 930, 930, 945, 945, 945, 945, 945, 
	930, 949, 948, 950, 952, 953, 951, 951, 
	951, 951, 951, 951, 951, 951, 951, 951, 
	951, 951, 951, 951, 951, 951, 951, 951, 
	951, 951, 951, 951, 951, 951, 951, 951, 
	951, 951, 951, 951, 951, 951, 951, 951, 
	951, 951, 951, 951, 951, 951, 951, 951, 
	951, 951, 951, 951, 951, 951, 951, 951, 
	951, 951, 951, 951, 951, 951, 951, 951, 
	951, 951, 951, 951, 951, 954, 951, 956, 
	957, 955, 958, 959, 960, 961, 237, 945, 
	945, 962, 945, 945, 945, 945, 945, 945, 
	945, 945, 945, 945, 945, 945, 945, 945, 
	945, 945, 945, 945, 945, 945, 945, 945, 
	945, 945, 945, 945, 945, 945, 945, 945, 
	945, 945, 945, 945, 945, 945, 945, 945, 
	945, 945, 945, 945, 945, 945, 945, 945, 
	945, 945, 945, 945, 945, 945, 945, 945, 
	945, 945, 945, 945, 945, 945, 945, 237, 
	945, 945, 945, 945, 945, 945, 945, 945, 
	945, 945, 945, 945, 945, 945, 945, 945, 
	945, 945, 945, 945, 945, 945, 945, 945, 
	945, 945, 945, 945, 945, 945, 945, 945, 
	945, 945, 945, 945, 945, 945, 945, 945, 
	945, 945, 945, 945, 945, 945, 945, 945, 
	945, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 945, 945, 945, 945, 945, 
	945, 945, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 945, 945, 945, 945, 
	236, 945, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 945, 945, 945, 945, 
	945, 236, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 945, 963, 945, 237, 
	945, 237, 945, 237, 964, 945, 237, 945, 
	237, 945, 237, 237, 945, 963, 945, 962, 
	945, 965, 966, 911, 967, 211, 911, 869, 
	211, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	211, 911, 211, 921, 911, 970, 969, 969, 
	969, 970, 969, 969, 969, 969, 971, 972, 
	971, 971, 971, 969, 969, 969, 969, 969, 
	969, 969, 969, 969, 969, 969, 969, 970, 
	969, 969, 969, 969, 969, 971, 969, 969, 
	969, 969, 969, 969, 969, 969, 969, 969, 
	969, 969, 969, 969, 969, 969, 969, 969, 
	969, 969, 969, 969, 969, 969, 969, 969, 
	969, 969, 969, 969, 969, 969, 973, 973, 
	973, 973, 973, 973, 973, 973, 973, 973, 
	973, 973, 973, 973, 973, 973, 973, 973, 
	973, 973, 973, 973, 973, 973, 973, 973, 
	969, 974, 969, 969, 973, 969, 973, 973, 
	973, 973, 973, 973, 973, 973, 973, 973, 
	973, 973, 973, 973, 973, 973, 973, 973, 
	973, 973, 973, 973, 973, 973, 973, 973, 
	969, 975, 975, 975, 975, 975, 975, 975, 
	975, 975, 975, 975, 975, 975, 975, 975, 
	975, 975, 975, 975, 975, 975, 975, 975, 
	975, 975, 975, 975, 975, 975, 975, 975, 
	975, 975, 975, 975, 975, 975, 975, 975, 
	975, 975, 975, 975, 975, 975, 975, 975, 
	975, 975, 975, 975, 975, 975, 975, 975, 
	975, 975, 975, 975, 975, 975, 975, 975, 
	975, 975, 975, 976, 976, 976, 976, 976, 
	976, 976, 976, 976, 976, 976, 976, 976, 
	976, 976, 976, 976, 976, 976, 976, 976, 
	976, 976, 976, 976, 976, 975, 975, 975, 
	975, 976, 975, 976, 976, 976, 976, 976, 
	976, 976, 976, 976, 976, 976, 976, 976, 
	976, 976, 976, 976, 976, 976, 976, 976, 
	976, 976, 976, 976, 976, 975, 975, 975, 
	975, 975, 976, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 978, 978, 978, 978, 978, 
	978, 978, 978, 978, 978, 977, 977, 977, 
	977, 977, 977, 977, 978, 978, 978, 978, 
	978, 978, 978, 978, 978, 978, 978, 978, 
	978, 978, 978, 978, 978, 978, 978, 978, 
	978, 978, 978, 978, 978, 978, 977, 977, 
	977, 977, 978, 977, 978, 978, 978, 978, 
	978, 978, 978, 978, 978, 978, 978, 978, 
	978, 978, 978, 978, 978, 978, 978, 978, 
	978, 978, 978, 978, 978, 978, 977, 977, 
	977, 977, 977, 978, 981, 980, 980, 980, 
	981, 980, 980, 980, 980, 980, 980, 980, 
	980, 980, 980, 980, 980, 980, 980, 980, 
	980, 980, 980, 980, 980, 980, 981, 980, 
	980, 980, 980, 980, 980, 980, 980, 980, 
	980, 980, 980, 980, 980, 980, 980, 980, 
	980, 980, 980, 980, 982, 982, 982, 982, 
	982, 982, 982, 982, 980, 980, 980, 980, 
	980, 980, 980, 980, 980, 980, 980, 983, 
	980, 980, 980, 980, 980, 980, 980, 980, 
	980, 984, 980, 980, 980, 980, 980, 980, 
	980, 980, 980, 980, 980, 980, 980, 980, 
	980, 980, 980, 980, 980, 980, 980, 985, 
	980, 980, 980, 980, 980, 980, 980, 980, 
	980, 980, 980, 980, 980, 980, 980, 980, 
	980, 986, 980, 980, 987, 980, 988, 989, 
	991, 991, 991, 991, 991, 991, 991, 991, 
	990, 992, 992, 992, 992, 992, 992, 992, 
	992, 990, 990, 993, 993, 273, 273, 273, 
	993, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 993, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 274, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	994, 273, 995, 996, 997, 997, 273, 273, 
	273, 997, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 997, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 274, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 998, 273, 272, 997, 999, 1000, 1001, 
	1001, 260, 260, 260, 1001, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 1001, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 261, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 1002, 260, 997, 254, 
	254, 254, 997, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	997, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 1003, 254, 993, 260, 260, 
	260, 993, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 993, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 261, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 262, 260, 993, 1004, 1004, 1004, 993, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 993, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1005, 
	1004, 1006, 1007, 1007, 1004, 1004, 1004, 1007, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1007, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1008, 
	1004, 1007, 254, 254, 254, 1007, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 1007, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 1003, 254, 
	1009, 1007, 1007, 260, 260, 260, 1007, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 1007, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 261, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 262, 260, 
	1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 
	1011, 1011, 1010, 1010, 1010, 1010, 1010, 1010, 
	1010, 1011, 1011, 1011, 1011, 1011, 1011, 1010, 
	1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 
	1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 
	1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 
	1010, 1011, 1011, 1011, 1011, 1011, 1011, 1010, 
	1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 
	1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 
	1010, 1010, 1010, 1012, 1010, 1013, 1013, 1013, 
	1013, 1013, 1013, 1013, 1013, 1013, 1013, 1010, 
	1010, 1010, 1010, 1010, 1010, 1010, 1013, 1013, 
	1013, 1013, 1013, 1013, 1010, 1010, 1010, 1010, 
	1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 
	1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 
	1010, 1010, 1010, 1010, 1010, 1010, 1013, 1013, 
	1013, 1013, 1013, 1013, 1010, 1014, 1014, 1014, 
	1014, 1014, 1014, 1014, 1014, 1014, 1014, 1010, 
	1010, 1010, 1010, 1010, 1010, 1010, 1014, 1014, 
	1014, 1014, 1014, 1014, 1010, 1010, 1010, 1010, 
	1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 
	1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 
	1010, 1010, 1010, 1010, 1010, 1010, 1014, 1014, 
	1014, 1014, 1014, 1014, 1010, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1010, 
	1010, 1010, 1010, 1010, 1010, 1010, 1015, 1015, 
	1015, 1015, 1015, 1015, 1010, 1010, 1010, 1010, 
	1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 
	1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 
	1010, 1010, 1010, 1010, 1010, 1010, 1015, 1015, 
	1015, 1015, 1015, 1015, 1010, 1016, 1019, 1018, 
	1018, 1018, 1019, 1018, 1018, 1018, 1018, 1020, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1019, 1018, 1018, 1018, 1018, 1018, 1020, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1021, 
	1021, 1021, 1021, 1021, 1021, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1021, 
	1021, 1021, 1021, 1021, 1021, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1022, 1018, 1019, 1018, 1018, 
	1018, 1019, 1018, 1018, 1018, 1018, 1017, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1019, 
	1018, 1018, 1018, 1018, 1018, 1017, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1023, 1023, 
	1023, 1023, 1023, 1023, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1023, 1023, 
	1023, 1023, 1023, 1023, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1024, 1018, 1017, 1019, 1023, 1023, 
	1023, 1019, 1023, 1023, 1023, 1023, 1017, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1019, 
	1023, 1023, 1023, 1023, 1023, 1017, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1017, 1023, 1025, 1019, 1026, 1026, 
	1026, 1019, 1026, 1026, 1026, 1026, 1020, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1019, 
	1026, 1026, 1026, 1026, 1026, 1020, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1027, 1027, 1027, 
	1027, 1027, 1027, 1027, 1027, 1027, 1027, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1027, 1027, 
	1027, 1027, 1027, 1027, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1027, 1027, 
	1027, 1027, 1027, 1027, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1017, 1026, 1019, 1026, 1026, 1026, 
	1019, 1026, 1026, 1026, 1026, 1017, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1019, 1026, 
	1026, 1026, 1026, 1026, 1017, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1023, 1023, 1023, 
	1023, 1023, 1023, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1023, 1023, 1023, 
	1023, 1023, 1023, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1019, 1026, 1019, 1026, 1026, 1026, 1019, 
	1026, 1026, 1026, 1026, 1028, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1019, 1026, 1026, 
	1026, 1026, 1026, 1028, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1029, 1029, 1029, 1029, 1029, 
	1029, 1029, 1029, 1029, 1029, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1029, 1029, 1029, 1029, 
	1029, 1029, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1029, 1029, 1029, 1029, 
	1029, 1029, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1030, 1026, 1019, 1026, 1026, 1026, 1019, 1026, 
	1026, 1026, 1026, 1028, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1019, 1026, 1026, 1026, 
	1026, 1026, 1028, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1027, 1027, 1027, 1027, 1027, 1027, 
	1027, 1027, 1027, 1027, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1027, 1027, 1027, 1027, 1027, 
	1027, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1027, 1027, 1027, 1027, 1027, 
	1027, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1030, 
	1026, 1031, 1019, 1026, 1026, 1026, 1019, 1026, 
	1026, 1026, 1026, 1028, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1019, 1026, 1026, 1026, 
	1026, 1026, 1028, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1032, 1032, 1032, 1032, 1032, 1032, 
	1032, 1032, 1032, 1032, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1032, 1032, 1032, 1032, 1032, 
	1032, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1032, 1032, 1032, 1032, 1032, 
	1032, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1030, 
	1026, 1019, 1026, 1026, 1026, 1019, 1026, 1026, 
	1026, 1026, 1028, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1019, 1026, 1026, 1026, 1026, 
	1026, 1028, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1033, 1033, 1033, 1033, 1033, 1033, 1033, 
	1033, 1033, 1033, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1033, 1033, 1033, 1033, 1033, 1033, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1033, 1033, 1033, 1033, 1033, 1033, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1030, 1026, 
	1019, 1026, 1026, 1026, 1019, 1026, 1026, 1026, 
	1026, 1028, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1019, 1026, 1026, 1026, 1026, 1026, 
	1028, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1034, 1034, 1034, 1034, 1034, 1034, 1034, 1034, 
	1034, 1034, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1034, 1034, 1034, 1034, 1034, 1034, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1034, 1034, 1034, 1034, 1034, 1034, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1030, 1026, 1019, 
	1026, 1026, 1026, 1019, 1026, 1026, 1026, 1026, 
	1028, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1019, 1026, 1026, 1026, 1026, 1026, 1028, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1035, 
	1035, 1035, 1035, 1035, 1035, 1035, 1035, 1035, 
	1035, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1035, 1035, 1035, 1035, 1035, 1035, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1035, 1035, 1035, 1035, 1035, 1035, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1030, 1026, 1019, 1026, 
	1026, 1026, 1019, 1026, 1026, 1026, 1026, 1028, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1019, 1026, 1026, 1026, 1026, 1026, 1028, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1036, 1036, 
	1036, 1036, 1036, 1036, 1036, 1036, 1036, 1036, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1036, 
	1036, 1036, 1036, 1036, 1036, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1036, 
	1036, 1036, 1036, 1036, 1036, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1030, 1026, 1019, 1026, 1026, 
	1026, 1019, 1026, 1026, 1026, 1026, 1017, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1019, 
	1026, 1026, 1026, 1026, 1026, 1017, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1036, 1036, 1036, 
	1036, 1036, 1036, 1036, 1036, 1036, 1036, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1036, 1036, 
	1036, 1036, 1036, 1036, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1036, 1036, 
	1036, 1036, 1036, 1036, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1017, 1026, 1019, 1026, 1026, 1026, 
	1019, 1026, 1026, 1026, 1026, 1037, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1019, 1026, 
	1026, 1026, 1026, 1026, 1037, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1038, 1038, 1038, 1038, 
	1038, 1038, 1038, 1038, 1038, 1038, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1038, 1038, 1038, 
	1038, 1038, 1038, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1038, 1038, 1038, 
	1038, 1038, 1038, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1030, 1026, 1019, 1026, 1026, 1026, 1019, 
	1026, 1026, 1026, 1026, 1037, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1019, 1026, 1026, 
	1026, 1026, 1026, 1037, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1039, 1039, 1039, 1039, 1039, 
	1039, 1039, 1039, 1039, 1039, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1039, 1039, 1039, 1039, 
	1039, 1039, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1039, 1039, 1039, 1039, 
	1039, 1039, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1030, 1026, 1019, 1026, 1026, 1026, 1019, 1026, 
	1026, 1026, 1026, 1037, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1019, 1026, 1026, 1026, 
	1026, 1026, 1037, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1040, 1040, 1040, 1040, 1040, 1040, 
	1040, 1040, 1040, 1040, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1040, 1040, 1040, 1040, 1040, 
	1040, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1040, 1040, 1040, 1040, 1040, 
	1040, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1017, 
	1026, 1019, 1026, 1026, 1026, 1019, 1026, 1026, 
	1026, 1026, 1037, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1019, 1026, 1026, 1026, 1026, 
	1026, 1037, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 
	1041, 1041, 1041, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1041, 1041, 1041, 1041, 1041, 1041, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1041, 1041, 1041, 1041, 1041, 1041, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1017, 1026, 
	1019, 1026, 1026, 1026, 1019, 1026, 1026, 1026, 
	1026, 1037, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1019, 1026, 1026, 1026, 1026, 1026, 
	1037, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1042, 1042, 1042, 1042, 1042, 1042, 1042, 1042, 
	1042, 1042, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1042, 1042, 1042, 1042, 1042, 1042, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1042, 1042, 1042, 1042, 1042, 1042, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1017, 1026, 1019, 
	1026, 1026, 1026, 1019, 1026, 1026, 1026, 1026, 
	1037, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1019, 1026, 1026, 1026, 1026, 1026, 1037, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1043, 
	1043, 1043, 1043, 1043, 1043, 1043, 1043, 1043, 
	1043, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1043, 1043, 1043, 1043, 1043, 1043, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1043, 1043, 1043, 1043, 1043, 1043, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1017, 1026, 1019, 1026, 
	1026, 1026, 1019, 1026, 1026, 1026, 1026, 1037, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1019, 1026, 1026, 1026, 1026, 1026, 1037, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1044, 1044, 
	1044, 1044, 1044, 1044, 1044, 1044, 1044, 1044, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1044, 
	1044, 1044, 1044, 1044, 1044, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1044, 
	1044, 1044, 1044, 1044, 1044, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1017, 1026, 1019, 1026, 1026, 
	1026, 1019, 1026, 1026, 1026, 1026, 1037, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1019, 
	1026, 1026, 1026, 1026, 1026, 1037, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1036, 1036, 1036, 
	1036, 1036, 1036, 1036, 1036, 1036, 1036, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1036, 1036, 
	1036, 1036, 1036, 1036, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1036, 1036, 
	1036, 1036, 1036, 1036, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1017, 1026, 1019, 1026, 1026, 1026, 
	1019, 1026, 1026, 1026, 1026, 1037, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1019, 1026, 
	1026, 1026, 1026, 1026, 1037, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1045, 1045, 1045, 1045, 
	1045, 1045, 1045, 1045, 1045, 1045, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1045, 1045, 1045, 
	1045, 1045, 1045, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1045, 1045, 1045, 
	1045, 1045, 1045, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1030, 1026, 1019, 1026, 1026, 1026, 1019, 
	1026, 1026, 1026, 1026, 1037, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1019, 1026, 1026, 
	1026, 1026, 1026, 1037, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1046, 1046, 1046, 1046, 
	1046, 1046, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1046, 1046, 1046, 1046, 
	1046, 1046, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1030, 1026, 1019, 1026, 1026, 1026, 1019, 1026, 
	1026, 1026, 1026, 1037, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1019, 1026, 1026, 1026, 
	1026, 1026, 1037, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1047, 1047, 1047, 1047, 1047, 1047, 
	1047, 1047, 1047, 1047, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1047, 1047, 1047, 1047, 1047, 
	1047, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1047, 1047, 1047, 1047, 1047, 
	1047, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1030, 
	1026, 1019, 1026, 1026, 1026, 1019, 1026, 1026, 
	1026, 1026, 1037, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1019, 1026, 1026, 1026, 1026, 
	1026, 1037, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 
	1048, 1048, 1048, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1048, 1048, 1048, 1048, 1048, 1048, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1048, 1048, 1048, 1048, 1048, 1048, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1030, 1026, 
	1019, 1026, 1026, 1026, 1019, 1026, 1026, 1026, 
	1026, 1037, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1019, 1026, 1026, 1026, 1026, 1026, 
	1037, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1036, 1036, 1036, 1036, 1036, 1036, 1036, 1036, 
	1036, 1036, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1036, 1036, 1036, 1036, 1036, 1036, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1036, 1036, 1036, 1036, 1036, 1036, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1030, 1026, 1049, 
	1050, 1052, 1052, 1052, 1052, 1052, 1052, 1052, 
	1052, 1052, 1052, 1051, 1051, 1051, 1051, 1051, 
	1051, 1051, 1052, 1052, 1052, 1052, 1052, 1052, 
	1051, 1051, 1051, 1051, 1051, 1051, 1051, 1051, 
	1051, 1051, 1051, 1051, 1051, 1051, 1051, 1051, 
	1051, 1051, 1051, 1051, 1051, 1051, 1051, 1051, 
	1051, 1051, 1052, 1052, 1052, 1052, 1052, 1052, 
	1051, 1051, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 279, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 280, 200, 200, 281, 
	200, 279, 200, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 200, 200, 200, 
	200, 278, 200, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 200, 200, 200, 
	200, 200, 278, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 279, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 280, 911, 911, 
	281, 911, 279, 911, 278, 278, 278, 278, 
	1053, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 911, 911, 
	911, 911, 278, 911, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 911, 911, 
	911, 911, 911, 278, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 279, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 280, 911, 
	911, 281, 911, 279, 911, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 1054, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 911, 
	911, 911, 911, 278, 911, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 911, 
	911, 911, 911, 911, 278, 1055, 1056, 911, 
	906, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 890, 889, 890, 890, 890, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 890, 279, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 280, 889, 889, 281, 889, 
	279, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 889, 891, 889, 889, 
	1057, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 889, 889, 889, 889, 
	889, 845, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 890, 889, 890, 890, 890, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 890, 279, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 280, 889, 889, 281, 
	889, 279, 889, 845, 845, 845, 845, 1058, 
	1059, 845, 845, 845, 845, 845, 1060, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 889, 891, 889, 
	889, 845, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 889, 889, 889, 
	889, 889, 845, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 890, 889, 890, 890, 
	890, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 890, 279, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 280, 889, 889, 
	281, 889, 279, 889, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 1061, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 889, 891, 
	889, 889, 845, 889, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 889, 889, 
	889, 889, 889, 845, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 890, 889, 890, 
	890, 890, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 890, 279, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 280, 889, 
	889, 281, 889, 279, 889, 845, 845, 1062, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 889, 
	891, 889, 889, 845, 889, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 889, 
	889, 889, 889, 889, 845, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 890, 889, 
	890, 890, 890, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 890, 279, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 280, 
	889, 889, 281, 889, 279, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 1063, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	889, 891, 889, 889, 845, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	889, 889, 889, 889, 889, 845, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 890, 
	889, 890, 890, 890, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 890, 279, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	280, 889, 889, 281, 889, 279, 889, 845, 
	845, 845, 1064, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 889, 891, 889, 889, 845, 889, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 889, 889, 889, 889, 889, 845, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	890, 889, 890, 890, 890, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 890, 
	279, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 280, 889, 889, 281, 889, 279, 889, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	1065, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 889, 891, 889, 889, 845, 889, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 889, 889, 889, 889, 889, 845, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 890, 889, 890, 890, 890, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	890, 279, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 280, 889, 889, 281, 889, 279, 
	889, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 1066, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 889, 891, 889, 889, 845, 
	889, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 889, 889, 889, 889, 889, 
	845, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 890, 889, 890, 890, 890, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 890, 279, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 280, 889, 889, 281, 889, 
	279, 889, 845, 845, 845, 845, 845, 845, 
	1067, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 889, 891, 889, 889, 
	845, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 889, 889, 889, 889, 
	889, 845, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 890, 889, 890, 890, 890, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 890, 279, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 280, 889, 889, 281, 
	889, 279, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 889, 891, 889, 
	889, 1068, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 889, 889, 889, 
	889, 889, 845, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 890, 889, 890, 890, 
	890, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 890, 279, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 280, 889, 889, 
	281, 889, 279, 889, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 889, 891, 
	889, 889, 1069, 889, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 889, 889, 
	889, 889, 889, 845, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 279, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 280, 200, 
	200, 281, 200, 279, 200, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 200, 
	200, 200, 200, 845, 200, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 200, 
	200, 200, 200, 200, 845, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 890, 889, 
	890, 890, 890, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 890, 279, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 280, 
	889, 889, 281, 889, 279, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 1070, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	889, 891, 889, 889, 845, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	889, 889, 889, 889, 889, 845, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 890, 
	889, 890, 890, 890, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 890, 279, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	280, 889, 889, 281, 889, 279, 889, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 1071, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 889, 891, 889, 889, 845, 889, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 889, 889, 889, 889, 889, 845, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	890, 889, 890, 890, 890, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 890, 
	279, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 280, 889, 889, 281, 889, 279, 889, 
	845, 845, 845, 845, 1067, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 889, 891, 889, 889, 845, 889, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 889, 889, 889, 889, 889, 845, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 890, 889, 890, 890, 890, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	890, 279, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 280, 889, 889, 281, 889, 279, 
	889, 845, 845, 845, 845, 845, 845, 845, 
	845, 1072, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 889, 891, 889, 889, 845, 
	889, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 889, 889, 889, 889, 889, 
	845, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 890, 889, 890, 890, 890, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 890, 279, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 280, 889, 889, 281, 889, 
	279, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 1071, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 889, 891, 889, 889, 
	845, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 889, 889, 889, 889, 
	889, 845, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 890, 889, 890, 890, 890, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 890, 279, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 280, 889, 889, 281, 
	889, 279, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 889, 891, 889, 
	889, 845, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 1073, 845, 
	1074, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 889, 889, 889, 
	889, 889, 845, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 890, 889, 890, 890, 
	890, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 890, 279, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 280, 889, 889, 
	281, 889, 279, 889, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 889, 891, 
	889, 889, 845, 889, 845, 845, 845, 845, 
	845, 845, 845, 845, 1075, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 889, 889, 
	889, 889, 889, 845, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 890, 889, 890, 
	890, 890, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 890, 279, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 280, 889, 
	889, 281, 889, 279, 889, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 889, 
	891, 889, 889, 845, 889, 1076, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 889, 
	889, 889, 889, 889, 845, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 890, 889, 
	890, 890, 890, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 890, 279, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 280, 
	889, 889, 281, 889, 279, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	889, 891, 889, 889, 845, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	1069, 845, 845, 845, 845, 845, 845, 845, 
	889, 889, 889, 889, 889, 845, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 890, 
	889, 890, 890, 890, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 890, 279, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	280, 889, 889, 281, 889, 279, 889, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 889, 891, 889, 889, 845, 889, 845, 
	845, 845, 1069, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 889, 889, 889, 889, 889, 845, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	890, 889, 890, 890, 890, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 890, 
	279, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 280, 889, 889, 281, 889, 279, 889, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 889, 891, 889, 889, 845, 889, 
	845, 845, 845, 845, 1077, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 1078, 845, 845, 845, 845, 845, 845, 
	845, 845, 889, 889, 889, 889, 889, 845, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 890, 889, 890, 890, 890, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	890, 279, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 280, 889, 889, 281, 889, 279, 
	889, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 889, 891, 889, 889, 845, 
	889, 845, 845, 845, 845, 845, 845, 1079, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 889, 889, 889, 889, 889, 
	845, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 890, 889, 890, 890, 890, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 890, 279, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 280, 889, 889, 281, 889, 
	279, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 889, 891, 889, 889, 
	845, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 1080, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 889, 889, 889, 889, 
	889, 845, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 890, 889, 890, 890, 890, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 890, 279, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 280, 889, 889, 281, 
	889, 279, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 889, 891, 889, 
	889, 845, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	1069, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 889, 889, 889, 
	889, 889, 845, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 890, 889, 890, 890, 
	890, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 890, 279, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 280, 889, 889, 
	281, 889, 279, 889, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 889, 891, 
	889, 889, 845, 889, 845, 845, 845, 845, 
	1081, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 889, 889, 
	889, 889, 889, 845, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 890, 889, 890, 
	890, 890, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 890, 279, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 280, 889, 
	889, 281, 889, 279, 889, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 889, 
	891, 889, 889, 845, 889, 1082, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 889, 
	889, 889, 889, 889, 845, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 890, 889, 
	890, 890, 890, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 890, 279, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 280, 
	889, 889, 281, 889, 279, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	889, 891, 889, 889, 845, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	1069, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	889, 889, 889, 889, 889, 845, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 890, 
	889, 890, 890, 890, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 890, 279, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	280, 889, 889, 281, 889, 279, 889, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 889, 891, 889, 889, 845, 889, 1083, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 1084, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 889, 889, 889, 889, 889, 845, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	890, 889, 890, 890, 890, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 890, 
	279, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 280, 889, 889, 281, 889, 279, 889, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 889, 891, 889, 889, 845, 889, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 1085, 845, 845, 845, 845, 845, 
	845, 845, 889, 889, 889, 889, 889, 845, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 890, 889, 890, 890, 890, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	890, 279, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 280, 889, 889, 281, 889, 279, 
	889, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 889, 891, 889, 889, 845, 
	889, 845, 845, 845, 845, 1069, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 889, 889, 889, 889, 889, 
	845, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 890, 889, 890, 890, 890, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 890, 279, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 280, 889, 889, 281, 889, 
	279, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 889, 891, 889, 889, 
	845, 889, 1086, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 889, 889, 889, 889, 
	889, 845, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 890, 889, 890, 890, 890, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 890, 279, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 280, 889, 889, 281, 
	889, 279, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 889, 891, 889, 
	889, 845, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 1076, 845, 845, 
	845, 845, 845, 845, 845, 889, 889, 889, 
	889, 889, 845, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 890, 889, 890, 890, 
	890, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 890, 279, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 280, 889, 889, 
	281, 889, 279, 889, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 889, 891, 
	889, 889, 845, 889, 845, 845, 845, 845, 
	1087, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 1069, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 889, 889, 
	889, 889, 889, 845, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 890, 889, 890, 
	890, 890, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 890, 279, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 280, 889, 
	889, 281, 889, 279, 889, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 889, 
	891, 889, 889, 845, 889, 845, 845, 845, 
	845, 845, 1069, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 889, 
	889, 889, 889, 889, 845, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 890, 889, 
	890, 890, 890, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 890, 279, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 280, 
	889, 889, 281, 889, 279, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	889, 891, 889, 889, 845, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 1088, 845, 1089, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	889, 889, 889, 889, 889, 845, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 890, 
	889, 890, 890, 890, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 890, 279, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	280, 889, 889, 281, 889, 279, 889, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 889, 891, 889, 889, 845, 889, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 1090, 845, 845, 845, 845, 845, 845, 
	845, 889, 889, 889, 889, 889, 845, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	890, 889, 890, 890, 890, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 890, 
	279, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 280, 889, 889, 281, 889, 279, 889, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 889, 891, 889, 889, 845, 889, 
	845, 845, 845, 845, 1069, 845, 845, 845, 
	1087, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 889, 889, 889, 889, 889, 845, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 890, 889, 890, 890, 890, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	890, 279, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 280, 889, 889, 281, 889, 279, 
	889, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 889, 891, 889, 889, 845, 
	889, 845, 845, 845, 1069, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 1091, 845, 845, 845, 845, 
	845, 845, 845, 889, 889, 889, 889, 889, 
	845, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 890, 889, 890, 890, 890, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 890, 279, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 280, 889, 889, 281, 889, 
	279, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 889, 891, 889, 889, 
	845, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 1092, 845, 
	845, 845, 845, 845, 889, 889, 889, 889, 
	889, 845, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 890, 889, 890, 890, 890, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 890, 279, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 280, 889, 889, 281, 
	889, 279, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 889, 891, 889, 
	889, 845, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 1085, 845, 845, 845, 
	845, 845, 845, 845, 845, 889, 889, 889, 
	889, 889, 845, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 890, 889, 890, 890, 
	890, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 890, 279, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 280, 889, 889, 
	281, 889, 279, 889, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 889, 891, 
	889, 889, 845, 889, 1093, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 880, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 889, 889, 
	889, 889, 889, 845, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 890, 889, 890, 
	890, 890, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 890, 279, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 280, 889, 
	889, 281, 889, 279, 889, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 889, 
	891, 889, 889, 845, 889, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	1083, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 889, 
	889, 889, 889, 889, 845, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 890, 889, 
	890, 890, 890, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 890, 279, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 280, 
	889, 889, 281, 889, 279, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	889, 891, 889, 889, 845, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 1069, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	889, 889, 889, 889, 889, 845, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 890, 
	889, 890, 890, 890, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 890, 279, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	280, 889, 889, 281, 889, 279, 889, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 889, 891, 889, 889, 845, 889, 845, 
	845, 845, 845, 845, 1094, 845, 845, 845, 
	845, 845, 845, 845, 1069, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 889, 889, 889, 889, 889, 845, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	890, 889, 890, 890, 890, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 890, 
	279, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 280, 889, 889, 281, 889, 279, 889, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 889, 891, 889, 889, 845, 889, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 1095, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 889, 889, 889, 889, 889, 845, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 890, 889, 890, 890, 890, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	890, 279, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 280, 889, 889, 281, 889, 279, 
	889, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 889, 891, 889, 889, 845, 
	889, 845, 845, 845, 1096, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 889, 889, 889, 889, 889, 
	845, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 890, 889, 890, 890, 890, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 890, 279, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 280, 889, 889, 281, 889, 
	279, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 889, 891, 889, 889, 
	845, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 1097, 845, 
	845, 845, 845, 845, 889, 889, 889, 889, 
	889, 845, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 890, 889, 890, 890, 890, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 890, 279, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 280, 889, 889, 281, 
	889, 279, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 889, 891, 889, 
	889, 845, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 1085, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 889, 889, 889, 
	889, 889, 845, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 890, 889, 890, 890, 
	890, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 890, 279, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 280, 889, 889, 
	281, 889, 279, 889, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 889, 891, 
	889, 889, 845, 889, 845, 845, 845, 845, 
	1098, 845, 845, 845, 1099, 845, 845, 845, 
	845, 845, 1100, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 889, 889, 
	889, 889, 889, 845, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 890, 889, 890, 
	890, 890, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 890, 279, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 280, 889, 
	889, 281, 889, 279, 889, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 889, 
	891, 889, 889, 845, 889, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 1100, 845, 845, 889, 
	889, 889, 889, 889, 845, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 890, 889, 
	890, 890, 890, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 890, 279, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 280, 
	889, 889, 281, 889, 279, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	889, 891, 889, 889, 845, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 1069, 845, 845, 845, 845, 845, 845, 
	889, 889, 889, 889, 889, 845, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 890, 
	889, 890, 890, 890, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 890, 279, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	280, 889, 889, 281, 889, 279, 889, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 889, 891, 889, 889, 845, 889, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 1069, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 889, 889, 889, 889, 889, 845, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	890, 889, 890, 890, 890, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 890, 
	279, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 280, 889, 889, 281, 889, 279, 889, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 889, 891, 889, 889, 845, 889, 
	845, 845, 845, 845, 1101, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 889, 889, 889, 889, 889, 845, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 890, 889, 890, 890, 890, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	890, 279, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 280, 889, 889, 281, 889, 279, 
	889, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 889, 891, 889, 889, 845, 
	889, 845, 845, 845, 1102, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 1103, 1104, 845, 845, 845, 
	845, 845, 845, 889, 889, 889, 889, 889, 
	845, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 890, 889, 890, 890, 890, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 890, 279, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 280, 889, 889, 281, 889, 
	279, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 889, 891, 889, 889, 
	845, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	1069, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 889, 889, 889, 889, 
	889, 845, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 890, 889, 890, 890, 890, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 890, 279, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 280, 889, 889, 281, 
	889, 279, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 889, 891, 889, 
	889, 845, 889, 845, 845, 1105, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 889, 889, 889, 
	889, 889, 845, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 890, 889, 890, 890, 
	890, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 890, 279, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 280, 889, 889, 
	281, 889, 279, 889, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 889, 891, 
	889, 889, 845, 889, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	1106, 845, 845, 845, 845, 845, 889, 889, 
	889, 889, 889, 845, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 890, 889, 890, 
	890, 890, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 890, 279, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 280, 889, 
	889, 281, 889, 279, 889, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 889, 
	891, 889, 889, 845, 889, 845, 845, 845, 
	845, 1107, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 889, 
	889, 889, 889, 889, 845, 1108, 1108, 1108, 
	1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 
	1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 
	1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 
	1108, 1108, 1108, 1108, 1108, 1108, 1110, 1108, 
	1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 
	1108, 1108, 1108, 1108, 1108, 1109, 1109, 1109, 
	1109, 1109, 1109, 1109, 1109, 1109, 1109, 1111, 
	1108, 1108, 1112, 1108, 1110, 1108, 1109, 1109, 
	1109, 1109, 1109, 1109, 1109, 1109, 1109, 1109, 
	1109, 1109, 1109, 1109, 1109, 1109, 1109, 1109, 
	1109, 1109, 1109, 1109, 1109, 1109, 1109, 1109, 
	1108, 1108, 1108, 1108, 1109, 1108, 1109, 1109, 
	1109, 1109, 1109, 1109, 1109, 1109, 1109, 1109, 
	1109, 1109, 1109, 1109, 1109, 1109, 1109, 1109, 
	1109, 1109, 1109, 1109, 1109, 1109, 1109, 1109, 
	1108, 1108, 1108, 1108, 1108, 1109, 897, 1113, 
	896, 896, 896, 896, 896, 896, 896, 896, 
	896, 896, 896, 896, 896, 896, 896, 896, 
	896, 896, 896, 896, 896, 896, 896, 896, 
	896, 896, 896, 896, 896, 896, 896, 896, 
	896, 896, 896, 896, 896, 896, 896, 896, 
	896, 896, 896, 896, 896, 896, 896, 896, 
	896, 896, 896, 896, 896, 896, 896, 896, 
	896, 896, 896, 896, 896, 896, 896, 899, 
	896, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 890, 889, 890, 890, 890, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 890, 279, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 280, 889, 889, 281, 889, 
	279, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 889, 891, 889, 889, 
	845, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 1114, 845, 845, 1115, 845, 
	845, 845, 845, 845, 889, 889, 889, 889, 
	889, 845, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 890, 889, 890, 890, 890, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 890, 279, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 280, 889, 889, 281, 
	889, 279, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 889, 891, 889, 
	889, 845, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 1069, 845, 889, 889, 889, 
	889, 889, 845, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 890, 889, 890, 890, 
	890, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 890, 279, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 280, 889, 889, 
	281, 889, 279, 889, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 889, 891, 
	889, 889, 845, 889, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 1080, 845, 845, 
	845, 845, 845, 845, 845, 845, 889, 889, 
	889, 889, 889, 845, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 890, 889, 890, 
	890, 890, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 890, 279, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 280, 889, 
	889, 281, 889, 279, 889, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 889, 
	891, 889, 889, 845, 889, 845, 845, 845, 
	845, 1116, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 1117, 845, 845, 845, 845, 845, 889, 
	889, 889, 889, 889, 845, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 890, 889, 
	890, 890, 890, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 890, 279, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 280, 
	889, 889, 281, 889, 279, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	889, 891, 889, 889, 845, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 1087, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	889, 889, 889, 889, 889, 845, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 890, 
	889, 890, 890, 890, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 890, 279, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	280, 889, 889, 281, 889, 279, 889, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 889, 891, 889, 889, 845, 889, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 1118, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 889, 889, 889, 889, 889, 845, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	890, 889, 890, 890, 890, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 890, 
	279, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 280, 889, 889, 281, 889, 279, 889, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 889, 891, 889, 889, 845, 889, 
	845, 845, 845, 845, 880, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 889, 889, 889, 889, 889, 845, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 890, 889, 890, 890, 890, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	890, 279, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 280, 889, 889, 281, 889, 279, 
	889, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 889, 891, 889, 889, 845, 
	889, 845, 845, 845, 845, 845, 845, 845, 
	1119, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 1120, 845, 845, 845, 845, 845, 
	845, 845, 845, 889, 889, 889, 889, 889, 
	845, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 890, 889, 890, 890, 890, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 890, 279, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 280, 889, 889, 281, 889, 
	279, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 889, 891, 889, 889, 
	845, 889, 845, 845, 845, 845, 1080, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 889, 889, 889, 889, 
	889, 845, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 890, 889, 890, 890, 890, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 890, 279, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 280, 889, 889, 281, 
	889, 279, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 889, 891, 889, 
	889, 845, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 1085, 
	845, 845, 845, 845, 845, 889, 889, 889, 
	889, 889, 845, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 890, 889, 890, 890, 
	890, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 890, 279, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 280, 889, 889, 
	281, 889, 279, 889, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 889, 891, 
	889, 889, 845, 889, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 1121, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 889, 889, 
	889, 889, 889, 845, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 890, 889, 890, 
	890, 890, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 890, 279, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 280, 889, 
	889, 281, 889, 279, 889, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 889, 
	891, 889, 889, 845, 889, 845, 845, 845, 
	1122, 845, 845, 845, 845, 845, 845, 845, 
	1123, 845, 845, 845, 845, 845, 845, 845, 
	1124, 845, 845, 845, 845, 845, 845, 889, 
	889, 889, 889, 889, 845, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 890, 889, 
	890, 890, 890, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 890, 279, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 280, 
	889, 889, 281, 889, 279, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	889, 891, 889, 889, 845, 889, 845, 845, 
	845, 845, 1087, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	889, 889, 889, 889, 889, 845, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 890, 
	889, 890, 890, 890, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 890, 279, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	280, 889, 889, 281, 889, 279, 889, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 889, 891, 889, 889, 845, 889, 845, 
	845, 845, 845, 1125, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 889, 889, 889, 889, 889, 845, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	890, 889, 890, 890, 890, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 890, 
	279, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 280, 889, 889, 281, 889, 279, 889, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 889, 891, 889, 889, 845, 889, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 1126, 845, 845, 845, 845, 845, 
	845, 845, 889, 889, 889, 889, 889, 845, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 890, 889, 890, 890, 890, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	890, 279, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 280, 889, 889, 281, 889, 279, 
	889, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 889, 891, 889, 889, 845, 
	889, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 1094, 845, 845, 845, 845, 
	845, 845, 845, 889, 889, 889, 889, 889, 
	845, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 890, 889, 890, 890, 890, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 890, 279, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 280, 889, 889, 281, 889, 
	279, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 889, 891, 889, 889, 
	845, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 1127, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 889, 889, 889, 889, 
	889, 845, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 890, 889, 890, 890, 890, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 890, 279, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 280, 889, 889, 281, 
	889, 279, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 889, 891, 889, 
	889, 845, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 1094, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 889, 889, 889, 
	889, 889, 845, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 890, 889, 890, 890, 
	890, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 890, 279, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 280, 889, 889, 
	281, 889, 279, 889, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 889, 891, 
	889, 889, 845, 889, 845, 845, 845, 845, 
	845, 845, 845, 1128, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 889, 889, 
	889, 889, 889, 845, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 890, 889, 890, 
	890, 890, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 890, 279, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 280, 889, 
	889, 281, 889, 279, 889, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 889, 
	891, 889, 889, 845, 889, 845, 845, 845, 
	845, 1080, 845, 845, 845, 1129, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 889, 
	889, 889, 889, 889, 845, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 890, 889, 
	890, 890, 890, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 890, 279, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 280, 
	889, 889, 281, 889, 279, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	889, 891, 889, 889, 845, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 1130, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	889, 889, 889, 889, 889, 845, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 890, 
	889, 890, 890, 890, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 890, 279, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	280, 889, 889, 281, 889, 279, 889, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 889, 891, 889, 889, 845, 889, 845, 
	845, 845, 845, 1094, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 889, 889, 889, 889, 889, 845, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	890, 889, 890, 890, 890, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 890, 
	279, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 280, 889, 889, 281, 889, 279, 889, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 889, 891, 889, 889, 845, 889, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	1131, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 889, 889, 889, 889, 889, 845, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 890, 889, 890, 890, 890, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	890, 279, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 280, 889, 889, 281, 889, 279, 
	889, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 889, 891, 889, 889, 845, 
	889, 845, 845, 845, 845, 1132, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 889, 889, 889, 889, 889, 
	845, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 890, 889, 890, 890, 890, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 890, 279, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 280, 889, 889, 281, 889, 
	279, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 889, 891, 889, 889, 
	845, 889, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 1074, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 889, 889, 889, 889, 
	889, 845, 1133, 211, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 911, 911, 911, 911, 911, 911, 
	911, 911, 921, 911, 1135, 1134, 1134, 1134, 
	1135, 1134, 1134, 1134, 1134, 1136, 1137, 1136, 
	1136, 1136, 1134, 1134, 1134, 1134, 1134, 1134, 
	1134, 1134, 1134, 1134, 1134, 1134, 1135, 1134, 
	1134, 1134, 1134, 1134, 1136, 1134, 1134, 1138, 
	1134, 1134, 1134, 1134, 1134, 1134, 1134, 1134, 
	1134, 1134, 1134, 1134, 1134, 1134, 1134, 1134, 
	1134, 1134, 1134, 1134, 1134, 1134, 1134, 1134, 
	1134, 1134, 1134, 1134, 1134, 1134, 1134, 1134, 
	1134, 1134, 1134, 1134, 1134, 1134, 1134, 1134, 
	1134, 1134, 1134, 1134, 1134, 1134, 1134, 1134, 
	1134, 1134, 1134, 1134, 1134, 1134, 1134, 1134, 
	1139, 1134, 1136, 1140, 1136, 1136, 1136, 1140, 
	1140, 1140, 1140, 1140, 1140, 1140, 1140, 1140, 
	1140, 1140, 1140, 1140, 1140, 1140, 1140, 1140, 
	1140, 1136, 1140, 1141, 1142, 1143, 1144, 1145, 
	1147, 1146, 1148, 1150, 1151, 1151, 1151, 1150, 
	1151, 1151, 1151, 1151, 1152, 1153, 1152, 1152, 
	1152, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 
	1151, 1151, 1151, 1151, 1151, 1150, 1151, 1151, 
	1151, 1151, 1151, 1152, 1151, 1154, 1155, 1151, 
	1151, 1151, 1154, 1151, 1151, 1151, 1151, 1151, 
	1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 
	1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 
	1151, 1151, 1151, 1151, 1149, 1149, 1149, 1149, 
	1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 
	1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 
	1149, 1149, 1149, 1149, 1149, 1149, 1151, 1156, 
	1151, 1151, 1149, 1151, 1149, 1149, 1149, 1149, 
	1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 
	1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 
	1149, 1149, 1149, 1149, 1149, 1149, 1151, 1151, 
	1151, 1151, 1151, 1149, 1157, 1157, 1157, 1157, 
	1157, 1157, 1157, 1157, 1157, 1157, 1157, 1157, 
	1157, 1157, 1157, 1157, 1157, 1157, 1157, 1157, 
	1157, 1157, 1157, 1157, 1157, 1157, 1157, 1157, 
	1157, 1157, 1157, 1157, 1157, 287, 1157, 1157, 
	1157, 1157, 1157, 1157, 1157, 1157, 1157, 1157, 
	1157, 1157, 1157, 1157, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 288, 1157, 
	1157, 1157, 1157, 287, 1157, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 1157, 
	1157, 1157, 1157, 286, 1157, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 1157, 
	1157, 1157, 1157, 1157, 286, 1152, 1158, 1152, 
	1152, 1152, 1158, 1158, 1158, 1158, 1158, 1158, 
	1158, 1158, 1158, 1158, 1158, 1158, 1158, 1158, 
	1158, 1158, 1158, 1158, 1152, 1158, 1159, 1160, 
	1161, 1162, 1163, 1164, 1157, 1165, 1167, 1168, 
	1168, 1168, 1167, 1168, 1168, 1168, 1168, 1169, 
	1170, 1169, 1169, 1169, 1168, 1168, 1168, 1168, 
	1168, 1168, 1168, 1168, 1168, 1168, 1168, 1168, 
	1167, 1168, 1168, 1168, 1168, 1168, 1169, 1171, 
	1172, 1173, 1174, 1175, 1176, 1172, 1177, 1178, 
	1179, 1175, 1180, 1181, 1182, 1175, 1183, 1184, 
	1184, 1184, 1184, 1184, 1184, 1184, 1184, 1184, 
	1185, 1186, 1187, 1188, 1189, 1190, 1191, 1192, 
	1193, 1192, 1192, 1194, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1195, 1196, 1197, 1175, 1198, 1172, 1199, 
	1200, 1201, 1202, 1203, 1204, 1166, 1166, 1205, 
	1166, 1166, 1166, 1206, 1207, 1208, 1166, 1166, 
	1209, 1210, 1211, 1212, 1166, 1213, 1166, 1214, 
	1166, 1215, 1216, 1217, 1218, 1168, 1166, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	1219, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 296, 296, 296, 296, 296, 1219, 296, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 296, 296, 296, 296, 1166, 296, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 296, 296, 296, 296, 296, 1166, 
	1221, 1220, 1222, 1169, 1223, 1169, 1169, 1169, 
	1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 
	1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 
	1223, 1223, 1169, 1223, 1224, 1226, 1225, 1225, 
	1225, 1225, 1225, 1225, 1225, 1225, 1225, 1225, 
	1225, 1225, 1225, 1225, 1225, 1225, 1225, 1225, 
	1225, 1225, 1225, 1225, 1225, 1225, 1225, 1225, 
	1225, 1225, 1225, 1225, 1225, 1225, 1225, 1225, 
	1225, 1225, 1225, 1225, 1225, 1225, 1225, 1225, 
	1225, 1225, 1225, 1225, 1225, 1225, 1225, 1225, 
	1225, 1225, 1225, 1225, 1225, 1225, 1225, 1225, 
	1225, 1225, 1225, 1225, 1225, 1225, 1226, 1225, 
	1227, 1228, 1229, 1230, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 291, 291, 1231, 
	291, 1231, 291, 291, 1231, 1231, 291, 291, 
	291, 1232, 291, 291, 1233, 1233, 1233, 1233, 
	1233, 1233, 1233, 1233, 1233, 1233, 291, 291, 
	291, 291, 291, 291, 291, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 1231, 
	291, 1231, 1231, 309, 291, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 1231, 
	1231, 1231, 291, 1231, 309, 1234, 1234, 1234, 
	1234, 1234, 1234, 1234, 1234, 1234, 1234, 1234, 
	1234, 1234, 1234, 1234, 1234, 1234, 1234, 1234, 
	1234, 1234, 1234, 1234, 1234, 1234, 1234, 1234, 
	1234, 1234, 1234, 1234, 1234, 1234, 1234, 1234, 
	1234, 1234, 1234, 1234, 1234, 1234, 1234, 1234, 
	1234, 1234, 1234, 1234, 1234, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 1234, 
	1234, 1234, 1234, 1234, 1234, 1234, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	1234, 1234, 1234, 1234, 309, 1234, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	1234, 1234, 1234, 1234, 1234, 309, 1233, 1233, 
	1233, 1233, 1233, 1233, 1233, 1233, 1233, 1233, 
	1234, 1235, 296, 1175, 1236, 1236, 1236, 1236, 
	1236, 1236, 1236, 1237, 1236, 1236, 1236, 1236, 
	1236, 1236, 1236, 1236, 1236, 1236, 1236, 1236, 
	1236, 1236, 1235, 1236, 1238, 1239, 1175, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
	1240, 1235, 1240, 1235, 1241, 1236, 1243, 1242, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 1244, 1242, 1180, 1245, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	1246, 1246, 1246, 1246, 1246, 1246, 1246, 1246, 
	1246, 1246, 1246, 1247, 1246, 1246, 1246, 1246, 
	1246, 1246, 1246, 1246, 1246, 1246, 1246, 1246, 
	1246, 1246, 1246, 1246, 1246, 1246, 1246, 1246, 
	1246, 1246, 1246, 1246, 1246, 1248, 1246, 1246, 
	1246, 1246, 1246, 1247, 1246, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 1246, 
	1246, 1246, 1246, 1246, 1246, 1246, 1246, 1246, 
	1246, 1246, 1246, 1246, 1246, 1246, 1246, 1246, 
	1246, 1246, 1246, 1246, 1246, 1246, 1246, 1246, 
	1246, 1246, 1246, 1246, 1246, 1246, 1246, 1246, 
	1246, 1246, 1246, 1246, 293, 1246, 1249, 296, 
	1249, 1249, 1249, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 1249, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 1250, 296, 1252, 1251, 1252, 1252, 1252, 
	1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 
	1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 
	1251, 1251, 1252, 1251, 1251, 1251, 1251, 1251, 
	1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 
	1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 
	1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 
	1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 
	1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 
	1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 
	1251, 1251, 1251, 1251, 1251, 1251, 1253, 1251, 
	1255, 1254, 1256, 1256, 1256, 1256, 1256, 1256, 
	1256, 1256, 1256, 1256, 1254, 1254, 1254, 1254, 
	1254, 1254, 1254, 1254, 1257, 1254, 1258, 1259, 
	1254, 1254, 1254, 1254, 1254, 1254, 1254, 1254, 
	1254, 1260, 1254, 1254, 1254, 1254, 1254, 1254, 
	1254, 1254, 1261, 1254, 1254, 1254, 1254, 1254, 
	1254, 1262, 1254, 1254, 1257, 1254, 1258, 1259, 
	1254, 1254, 1254, 1263, 1254, 1254, 1254, 1254, 
	1254, 1260, 1254, 1254, 1264, 1254, 1254, 1254, 
	1254, 1254, 1261, 1254, 298, 298, 298, 298, 
	298, 298, 298, 298, 298, 298, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1266, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1267, 1265, 1265, 1265, 1265, 
	1265, 1266, 1265, 1265, 1265, 1268, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1269, 1265, 
	1270, 296, 1270, 296, 296, 299, 299, 299, 
	299, 299, 299, 299, 299, 299, 299, 296, 
	299, 299, 299, 299, 299, 299, 299, 299, 
	299, 299, 1271, 1271, 1271, 1271, 1271, 1271, 
	1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271, 
	1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271, 
	1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271, 
	1271, 1271, 1271, 1271, 1271, 1271, 1271, 1270, 
	1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271, 
	1271, 1272, 1271, 1274, 1273, 1275, 1277, 1276, 
	1276, 1276, 1278, 1276, 1279, 1280, 1256, 1256, 
	1256, 1256, 1256, 1256, 1256, 1256, 1256, 1256, 
	1254, 1254, 1254, 1254, 1254, 1254, 1254, 1254, 
	1254, 1254, 1254, 1254, 1254, 1254, 1254, 1254, 
	1254, 1254, 1254, 1254, 1254, 1254, 1254, 1254, 
	1254, 1254, 1254, 1254, 1254, 1254, 1254, 1254, 
	1254, 1254, 1254, 1254, 1254, 1262, 1254, 1254, 
	1254, 1254, 1254, 1254, 1254, 1254, 1254, 1263, 
	1254, 1254, 1254, 1254, 1254, 1254, 1254, 1254, 
	1264, 1254, 1281, 1281, 1281, 1281, 1281, 1281, 
	1281, 1281, 1281, 1281, 1254, 1254, 1254, 1254, 
	1254, 1254, 1254, 1254, 1254, 1254, 1254, 1254, 
	1254, 1254, 1254, 1254, 1254, 1254, 1254, 1254, 
	1254, 1254, 1254, 1254, 1254, 1254, 1254, 1254, 
	1254, 1254, 1254, 1254, 1254, 1254, 1254, 1254, 
	1254, 1282, 1254, 1254, 1254, 1254, 1254, 1254, 
	1254, 1254, 1254, 1263, 1254, 1254, 1254, 1254, 
	1254, 1254, 1254, 1254, 1264, 1254, 1284, 1284, 
	1284, 1284, 1284, 1284, 1284, 1284, 1284, 1284, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1285, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1286, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1287, 1283, 1284, 1284, 1284, 1284, 1284, 1284, 
	1284, 1284, 1284, 1284, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1288, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1286, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1287, 1283, 1286, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1287, 
	1283, 1290, 1289, 1291, 1293, 1292, 1292, 1292, 
	1294, 1292, 1296, 1295, 1297, 1298, 1300, 1300, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1301, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1302, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1303, 1299, 1304, 1304, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1305, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1286, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1287, 1283, 1304, 1304, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1288, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1286, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1287, 1283, 1307, 1307, 1307, 1307, 1307, 1307, 
	1307, 1307, 1307, 1307, 1306, 1306, 1306, 1306, 
	1306, 1306, 1306, 1306, 1306, 1306, 1306, 1306, 
	1306, 1306, 1306, 1306, 1306, 1306, 1306, 1306, 
	1306, 1306, 1306, 1306, 1306, 1306, 1306, 1306, 
	1306, 1306, 1306, 1306, 1306, 1306, 1306, 1306, 
	1306, 1308, 1306, 1306, 1306, 1306, 1306, 1306, 
	1306, 1306, 1306, 1309, 1306, 1306, 1306, 1306, 
	1306, 1306, 1306, 1306, 1310, 1306, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1313, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1314, 
	1311, 1311, 1311, 1311, 1311, 1311, 1311, 1311, 
	1315, 1311, 1317, 1317, 1317, 1317, 1317, 1317, 
	1317, 1317, 1317, 1317, 1316, 1316, 1316, 1316, 
	1316, 1316, 1316, 1317, 1317, 1317, 1317, 1317, 
	1317, 1316, 1316, 1316, 1316, 1316, 1316, 1316, 
	1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316, 
	1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316, 
	1316, 1318, 1316, 1317, 1317, 1317, 1317, 1317, 
	1317, 1316, 1316, 1319, 1316, 1316, 1316, 1316, 
	1316, 1316, 1316, 1316, 1320, 1316, 1321, 1321, 
	1321, 1321, 1321, 1321, 1321, 1321, 1321, 1321, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1321, 
	1321, 1321, 1321, 1321, 1321, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1322, 1283, 1321, 
	1321, 1321, 1321, 1321, 1321, 1283, 1283, 1286, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1287, 1283, 1321, 1321, 1321, 1321, 1321, 1321, 
	1321, 1321, 1321, 1321, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1321, 1321, 1321, 1321, 1321, 
	1321, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1288, 1283, 1321, 1321, 1321, 1321, 1321, 
	1321, 1283, 1283, 1286, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1287, 1283, 1324, 1323, 
	1325, 1325, 1325, 1325, 1325, 1325, 1325, 1325, 
	1325, 1325, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1326, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1323, 1327, 
	1323, 1323, 1323, 1323, 1323, 1326, 1323, 1323, 
	1323, 1328, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1329, 1323, 1330, 1330, 1330, 1330, 
	1330, 1330, 1330, 1330, 1330, 1330, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1323, 1331, 1323, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1328, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1329, 1323, 
	1332, 1283, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1333, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1334, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1335, 1283, 1283, 1283, 1283, 1283, 1334, 
	1283, 1283, 1283, 1286, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1287, 1283, 1333, 1333, 
	1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1288, 1283, 1283, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1286, 
	1283, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1287, 1283, 1237, 1245, 1175, 1336, 1236, 1226, 
	1236, 1337, 1338, 1245, 1245, 1245, 1245, 1245, 
	1245, 1245, 1245, 1245, 1245, 1245, 1245, 1245, 
	1245, 1245, 1245, 1245, 1245, 1245, 1245, 1245, 
	1245, 1245, 1245, 1245, 1245, 1245, 1245, 1245, 
	1245, 1245, 1245, 1245, 1245, 1245, 1245, 1245, 
	1245, 1245, 1245, 1245, 1245, 1245, 1245, 1245, 
	1245, 1245, 1245, 1245, 1245, 1245, 1245, 1245, 
	1245, 1245, 1245, 1245, 1245, 1245, 1245, 1245, 
	1245, 1245, 1226, 1245, 1226, 1236, 1226, 1175, 
	1236, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 
	1231, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 1231, 1231, 1231, 1231, 1231, 
	1231, 1339, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 1231, 1231, 1231, 1231, 
	309, 1231, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 1231, 1231, 1231, 1231, 
	1231, 309, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 1219, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1340, 296, 296, 296, 
	296, 1219, 296, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 296, 296, 296, 
	296, 1192, 296, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 296, 296, 296, 
	296, 296, 1192, 1341, 1342, 1342, 1342, 1342, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1342, 1342, 1342, 1342, 1342, 1219, 1342, 1342, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1342, 1342, 1342, 1342, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1340, 1342, 
	1342, 1342, 1342, 1219, 1342, 1192, 1192, 1192, 
	1192, 1343, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1342, 
	1342, 1342, 1342, 1192, 1342, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1342, 
	1342, 1342, 1342, 1342, 1192, 1342, 1342, 1342, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1342, 1342, 1342, 1342, 1342, 1342, 1219, 1342, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1342, 1342, 1342, 1342, 1342, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1340, 
	1342, 1342, 1342, 1342, 1219, 1342, 1192, 1192, 
	1192, 1192, 1192, 1192, 1344, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1342, 1342, 1342, 1342, 1192, 1342, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1342, 1342, 1342, 1342, 1342, 1192, 1342, 1342, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1219, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1342, 1342, 1342, 1342, 1342, 1342, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1340, 1342, 1342, 1342, 1342, 1219, 1342, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1345, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1342, 1342, 1342, 1342, 1192, 1342, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1342, 1342, 1342, 1342, 1342, 1192, 1342, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1219, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1340, 1342, 1342, 1342, 1342, 1219, 1342, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1346, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1342, 1342, 1342, 1342, 1192, 1342, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1342, 1342, 1342, 1342, 1342, 1192, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1342, 1219, 1342, 1342, 1342, 1342, 1342, 1342, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1340, 1342, 1342, 1342, 1342, 1219, 
	1342, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1347, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1342, 1342, 1342, 1342, 1192, 
	1342, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1342, 1342, 1342, 1342, 1342, 
	1192, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1342, 1342, 1219, 1342, 1342, 1342, 1342, 1342, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1342, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1340, 1342, 1342, 1342, 1342, 
	1219, 1342, 1192, 1192, 1192, 1346, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1342, 1342, 1342, 1342, 
	1192, 1342, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1342, 1342, 1342, 1342, 
	1342, 1192, 1348, 1350, 1349, 1351, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1219, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1352, 1219, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1353, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1352, 1166, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1219, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1352, 1219, 1352, 
	1166, 1166, 1166, 1166, 1354, 1355, 1166, 1166, 
	1166, 1166, 1166, 1356, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1166, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1352, 1166, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1219, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1352, 1219, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1357, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1166, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1352, 
	1166, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1219, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1352, 
	1219, 1352, 1166, 1166, 1358, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1166, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1352, 1166, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1219, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1352, 1219, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1359, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1166, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1352, 1166, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1219, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1352, 1219, 1352, 1166, 1166, 1166, 1360, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1166, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1352, 1166, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1219, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1352, 1219, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1361, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1166, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1352, 1166, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1219, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1352, 1219, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1362, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1166, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1352, 1166, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1219, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1352, 1219, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1363, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1166, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1352, 1166, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1219, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1352, 1219, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1364, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1352, 1166, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1219, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1352, 1219, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1365, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1352, 
	1166, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1219, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1352, 
	1219, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1366, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1166, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1352, 1166, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1219, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1352, 1219, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1367, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1166, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1352, 1166, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1219, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1352, 1219, 1352, 1166, 1166, 1166, 1166, 
	1368, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1166, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1352, 1166, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1219, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1352, 1219, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1369, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1352, 1166, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1219, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1352, 1219, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1370, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1352, 1166, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1219, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1352, 1219, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1371, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1166, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1352, 1166, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1219, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1352, 1219, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1367, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1166, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1352, 1166, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1219, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1352, 1219, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1166, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1372, 1166, 1373, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1352, 
	1166, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1219, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1352, 
	1219, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1166, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1374, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1352, 1166, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1219, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1352, 1219, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1166, 1352, 1375, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1352, 1166, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1219, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1352, 1219, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1166, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1376, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1352, 1166, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1219, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1352, 1219, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1166, 1352, 1166, 1166, 1166, 
	1377, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1352, 1166, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1219, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1352, 1219, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1166, 1352, 1166, 1166, 
	1166, 1166, 1378, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1379, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1352, 1166, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1219, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1352, 1219, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1166, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1380, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1352, 1166, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1219, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1352, 1219, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1166, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1381, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1352, 1166, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1219, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1352, 1219, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1166, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1377, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1352, 
	1166, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1219, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1352, 
	1219, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1166, 1352, 1166, 1166, 1166, 1166, 1382, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1352, 1166, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1219, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1352, 1219, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1166, 1352, 1383, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1352, 1166, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1219, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1352, 1219, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1166, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1384, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1352, 1166, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1219, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1352, 1219, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1166, 1352, 1385, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1386, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1352, 1166, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1219, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1352, 1219, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1166, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1387, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1352, 1166, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1219, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1352, 1219, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1166, 1352, 1166, 
	1166, 1166, 1166, 1377, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1352, 1166, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1219, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1352, 1219, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1166, 1352, 
	1388, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1352, 1166, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1219, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1352, 1219, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1166, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1389, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1352, 
	1166, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1219, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1352, 
	1219, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1166, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1390, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1352, 1166, 1391, 1391, 1391, 1391, 1391, 1391, 
	1391, 1391, 1391, 311, 312, 311, 311, 311, 
	1391, 1391, 1391, 1391, 1391, 1391, 1391, 1391, 
	1391, 1391, 1391, 1391, 1391, 1391, 1391, 1391, 
	1391, 1391, 311, 1219, 1391, 313, 1391, 1391, 
	1391, 1391, 1391, 1391, 1391, 1391, 1391, 1391, 
	1391, 1391, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1391, 1391, 314, 1391, 
	1391, 1219, 1391, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1391, 315, 1391, 
	1391, 1166, 1391, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1391, 1391, 1391, 
	1391, 1391, 1166, 328, 329, 328, 328, 328, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 328, 327, 327, 330, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 333, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 332, 327, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1219, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1352, 1219, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1166, 
	1352, 1166, 1166, 1166, 1166, 1393, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1394, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1352, 
	1166, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1219, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1352, 
	1219, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1166, 1352, 1166, 1166, 1166, 1166, 1166, 1395, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1352, 1166, 1396, 1396, 1396, 1396, 1396, 1396, 
	1396, 1396, 1396, 1396, 1396, 1396, 1396, 1396, 
	1396, 1396, 1396, 1396, 1396, 1396, 1396, 1396, 
	1396, 1396, 1396, 1396, 1396, 1396, 1396, 1396, 
	1396, 1396, 1396, 1219, 1396, 1396, 1396, 1396, 
	1396, 1396, 1396, 1396, 1396, 1396, 1396, 1396, 
	1396, 1396, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1396, 1396, 1396, 1396, 
	1396, 1219, 1396, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1396, 1396, 1396, 
	1396, 1166, 1396, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1397, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1396, 1396, 1396, 
	1396, 1396, 1166, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1219, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1352, 1219, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1166, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1398, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1352, 1166, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1219, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1352, 1219, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1166, 1352, 1166, 1166, 1166, 
	1166, 1399, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1352, 1166, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1219, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1352, 1219, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1166, 1352, 1166, 1166, 
	1166, 1400, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1352, 1166, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1219, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1352, 1401, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1166, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1352, 1166, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1219, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1352, 1219, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1166, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1402, 1166, 1403, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1352, 1166, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1219, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1352, 1219, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1166, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1404, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1352, 
	1166, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1219, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1352, 
	1219, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1166, 1352, 1166, 1166, 1166, 1166, 1377, 1166, 
	1166, 1166, 1405, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1352, 1166, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1219, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1352, 1219, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1166, 1352, 1166, 1166, 1166, 1166, 1166, 
	1377, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1352, 1166, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1219, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1352, 1219, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1166, 1352, 1166, 1166, 1166, 1370, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1406, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1352, 1166, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1219, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1352, 1219, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1166, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1407, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1352, 1166, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1219, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1352, 1219, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1166, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1387, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1352, 1166, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1219, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1352, 1219, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1166, 1352, 1408, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1208, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1352, 1166, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1219, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1352, 1219, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1166, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1409, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1352, 1166, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1219, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1352, 1219, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1166, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1410, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1352, 
	1166, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1219, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1352, 
	1219, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1166, 1352, 1166, 1166, 1166, 1166, 1370, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1352, 1166, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1219, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1352, 1219, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1166, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1377, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1352, 1166, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1219, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1352, 1219, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1166, 1352, 1166, 1166, 1166, 1166, 
	1166, 1411, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1377, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1352, 1166, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1219, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1352, 1219, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1166, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1412, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1352, 1166, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1219, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1352, 1219, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1166, 1352, 1166, 1166, 
	1166, 1413, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1352, 1166, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1219, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1352, 1219, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1166, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1414, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1352, 1166, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1219, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1352, 1219, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1166, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1387, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1352, 1166, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1219, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1352, 1219, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1166, 
	1352, 1166, 1166, 1166, 1166, 1415, 1166, 1166, 
	1166, 1416, 1166, 1166, 1166, 1166, 1166, 1417, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1352, 
	1166, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1219, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1352, 
	1219, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1166, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1418, 1166, 1166, 1352, 1352, 1352, 1352, 
	1352, 1166, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1219, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1352, 1219, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1166, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1384, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1352, 1166, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1219, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1352, 1219, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1166, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1370, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1352, 1166, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1219, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1352, 1219, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1166, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1419, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1352, 1166, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1219, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1352, 1219, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1166, 1352, 1166, 1166, 
	1166, 1166, 1420, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1352, 1166, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1219, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1352, 1219, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1166, 1352, 1166, 
	1166, 1166, 1421, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1422, 1423, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1352, 1166, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1219, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1352, 1219, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1166, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1370, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1352, 1166, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1219, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1352, 1219, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1166, 
	1352, 1166, 1166, 1424, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1352, 
	1166, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1219, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1352, 
	1219, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1166, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1425, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1352, 1166, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1219, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1352, 1219, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1166, 1352, 1166, 1166, 1166, 1166, 1411, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1352, 1166, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1219, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1352, 1219, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1166, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1426, 1166, 1166, 
	1427, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1352, 1166, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1219, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1352, 1219, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1166, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1370, 1166, 1352, 
	1352, 1352, 1352, 1352, 1166, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1219, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1352, 1219, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1166, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1428, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1352, 1166, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1219, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1352, 1219, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1166, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1384, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1352, 1166, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1219, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1352, 1219, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1166, 1352, 
	1166, 1166, 1166, 1166, 1429, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1430, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1352, 1166, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1219, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1352, 1219, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1166, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1431, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1352, 
	1166, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1219, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1352, 
	1219, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1166, 1352, 1166, 1166, 1166, 1166, 1166, 1370, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1352, 1166, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1219, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1352, 1219, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1166, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1432, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1352, 1166, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1219, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1352, 1219, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1166, 1352, 1166, 1166, 1166, 1166, 
	1433, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1352, 1166, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1219, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1352, 1219, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1166, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1419, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1352, 1166, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1219, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1352, 1219, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1166, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1434, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1435, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1352, 1166, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1219, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1352, 1219, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1166, 1352, 1166, 
	1166, 1166, 1166, 1381, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1352, 1166, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1219, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1352, 1219, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1166, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1410, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1352, 1166, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1219, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1352, 1219, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1166, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1436, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1352, 
	1166, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1219, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1352, 
	1219, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1166, 1352, 1166, 1166, 1166, 1437, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1438, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1439, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1352, 1166, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1219, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1352, 1219, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1166, 1352, 1166, 1166, 1166, 1166, 1440, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1352, 1166, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1219, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1352, 1219, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1166, 1352, 1166, 1166, 1166, 1166, 
	1166, 1376, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1352, 1166, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1219, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1352, 1219, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1166, 1352, 1166, 1166, 1166, 
	1166, 1441, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1352, 1166, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1219, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1352, 1219, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1166, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1442, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1352, 1166, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1219, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1352, 1219, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1166, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1411, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1352, 1166, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1219, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1352, 1219, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1166, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1443, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1352, 1166, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1219, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1352, 1219, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1166, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1411, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1352, 
	1166, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1219, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1352, 
	1219, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1166, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1444, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1352, 1166, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1219, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1352, 1352, 1352, 1352, 
	1352, 1219, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1166, 1352, 1166, 1166, 1166, 1166, 1381, 
	1166, 1166, 1166, 1445, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1352, 1166, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1219, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1352, 1352, 1352, 
	1352, 1352, 1219, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1166, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1446, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1352, 1166, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1219, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1352, 1352, 
	1352, 1352, 1352, 1219, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1166, 1352, 1166, 1166, 1166, 
	1166, 1411, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1352, 1166, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1219, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1352, 
	1352, 1352, 1352, 1352, 1219, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1166, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1447, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1352, 1166, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1219, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1352, 1352, 1352, 1352, 1352, 1219, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1166, 1352, 1166, 
	1166, 1166, 1166, 1448, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1352, 1166, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1219, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1352, 1352, 1352, 1352, 1352, 1219, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1166, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1449, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1352, 1166, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1219, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1352, 1352, 1352, 1352, 1352, 1219, 
	1352, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1166, 
	1352, 1166, 1166, 1166, 1419, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 
	1166, 1166, 1166, 1352, 1352, 1352, 1352, 1352, 
	1166, 1450, 1235, 1225, 1225, 1225, 1225, 1225, 
	1225, 1225, 1225, 1225, 1225, 1225, 1225, 1225, 
	1225, 1225, 1225, 1225, 1225, 1225, 1225, 1225, 
	1225, 1225, 1225, 1225, 1225, 1225, 1225, 1225, 
	1225, 1225, 1225, 1225, 1225, 1225, 1225, 1225, 
	1225, 1225, 1225, 1225, 1225, 1225, 1225, 1225, 
	1225, 1225, 1225, 1225, 1225, 1225, 1225, 1225, 
	1225, 1225, 1225, 1225, 1225, 1225, 1225, 1225, 
	1225, 1175, 1225, 1451, 1453, 1452, 1453, 1453, 
	1453, 1452, 1452, 1452, 1452, 1452, 1452, 1452, 
	1452, 1452, 1452, 1452, 1452, 1452, 1452, 1452, 
	1452, 1452, 1452, 1453, 1452, 1452, 1452, 1452, 
	1452, 1454, 1452, 1452, 1452, 1452, 1452, 1452, 
	1452, 339, 1452, 337, 1455, 337, 337, 337, 
	1455, 1455, 1455, 1455, 1455, 1455, 1455, 1455, 
	1455, 1455, 1455, 1455, 1455, 1455, 1455, 1455, 
	1455, 1455, 337, 1455, 1455, 1455, 1455, 1455, 
	338, 1455, 1455, 1455, 1455, 1455, 1455, 1455, 
	339, 1455, 340, 1455, 1457, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1458, 
	1456, 1457, 1456, 1457, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1460, 1456, 
	1457, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1461, 1456, 1457, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1456, 1456, 1456, 1456, 1456, 1456, 1456, 1456, 
	1462, 1456, 1464, 1462, 0
]

class << self
	attr_accessor :_lex_trans_targs
	private :_lex_trans_targs, :_lex_trans_targs=
end
self._lex_trans_targs = [
	182, 2, 3, 4, 188, 6, 7, 8, 
	9, 10, 182, 182, 191, 194, 191, 12, 
	195, 14, 191, 202, 203, 206, 207, 213, 
	208, 209, 210, 19, 211, 212, 215, 217, 
	218, 219, 220, 221, 25, 18, 204, 205, 
	27, 244, 245, 247, 249, 247, 30, 250, 
	32, 247, 257, 258, 261, 262, 268, 263, 
	264, 265, 37, 266, 267, 270, 272, 273, 
	274, 275, 276, 43, 36, 259, 260, 45, 
	299, 300, 307, 309, 307, 48, 310, 50, 
	312, 315, 312, 52, 316, 54, 322, 321, 
	0, 56, 323, 324, 58, 325, 326, 326, 
	326, 326, 439, 61, 62, 63, 439, 467, 
	64, 65, 467, 467, 471, 471, 69, 64, 
	70, 469, 470, 472, 473, 471, 467, 474, 
	475, 477, 66, 67, 478, 479, 68, 471, 
	71, 72, 77, 84, 481, 482, 70, 469, 
	470, 472, 473, 471, 467, 474, 475, 477, 
	66, 67, 478, 479, 68, 71, 72, 77, 
	84, 481, 482, 480, 73, 74, 75, 76, 
	78, 79, 82, 80, 81, 83, 85, 86, 
	467, 88, 89, 90, 92, 95, 93, 94, 
	96, 98, 498, 498, 498, 499, 100, 501, 
	101, 502, 102, 499, 100, 501, 101, 502, 
	536, 103, 536, 104, 105, 103, 536, 104, 
	536, 536, 536, 108, 109, 110, 111, 547, 
	536, 536, 552, 536, 114, 115, 116, 536, 
	119, 114, 115, 116, 536, 119, 117, 117, 
	115, 116, 558, 118, 117, 117, 115, 116, 
	558, 118, 115, 536, 574, 536, 121, 575, 
	581, 124, 127, 129, 131, 132, 133, 127, 
	128, 586, 128, 586, 130, 536, 600, 601, 
	604, 605, 611, 606, 607, 608, 138, 609, 
	610, 613, 615, 616, 617, 618, 619, 144, 
	137, 602, 603, 146, 655, 656, 148, 538, 
	106, 540, 150, 151, 658, 760, 153, 154, 
	155, 760, 768, 768, 768, 158, 789, 788, 
	768, 791, 793, 795, 768, 164, 165, 166, 
	799, 768, 168, 169, 810, 778, 832, 172, 
	173, 174, 178, 179, 172, 173, 174, 178, 
	179, 175, 175, 173, 174, 176, 177, 175, 
	175, 173, 174, 176, 177, 879, 173, 768, 
	948, 180, 181, 948, 948, 182, 182, 183, 
	184, 185, 187, 189, 190, 182, 182, 182, 
	186, 182, 186, 182, 1, 182, 182, 182, 
	5, 191, 191, 192, 191, 193, 196, 191, 
	191, 11, 13, 191, 191, 191, 197, 198, 
	199, 15, 21, 26, 222, 28, 191, 191, 
	191, 200, 201, 191, 16, 191, 191, 191, 
	17, 191, 191, 191, 20, 214, 216, 22, 
	191, 191, 23, 24, 191, 223, 227, 224, 
	225, 226, 191, 191, 228, 229, 232, 234, 
	243, 230, 231, 191, 233, 235, 237, 236, 
	191, 238, 239, 240, 241, 242, 191, 191, 
	191, 246, 247, 247, 247, 248, 251, 247, 
	29, 31, 247, 247, 247, 252, 253, 254, 
	33, 39, 44, 277, 46, 247, 247, 247, 
	255, 256, 247, 34, 247, 247, 247, 35, 
	247, 247, 247, 38, 269, 271, 40, 247, 
	247, 41, 42, 247, 278, 282, 279, 280, 
	281, 247, 247, 283, 284, 287, 289, 298, 
	285, 286, 247, 288, 290, 292, 291, 247, 
	293, 294, 295, 296, 297, 247, 247, 247, 
	301, 302, 302, 303, 302, 304, 302, 302, 
	302, 305, 305, 305, 306, 305, 305, 305, 
	307, 307, 307, 308, 307, 47, 49, 307, 
	307, 311, 311, 311, 312, 312, 313, 312, 
	314, 312, 312, 51, 53, 312, 312, 317, 
	317, 318, 317, 317, 319, 320, 319, 55, 
	57, 321, 321, 321, 327, 326, 326, 328, 
	329, 330, 331, 333, 336, 337, 338, 339, 
	326, 340, 341, 343, 345, 346, 347, 351, 
	353, 354, 355, 371, 376, 383, 388, 395, 
	402, 405, 406, 410, 404, 414, 422, 426, 
	428, 433, 435, 438, 326, 326, 326, 326, 
	326, 326, 332, 326, 332, 326, 334, 59, 
	335, 326, 60, 326, 326, 342, 344, 326, 
	348, 349, 350, 346, 352, 326, 356, 357, 
	366, 369, 358, 359, 360, 361, 362, 363, 
	364, 365, 327, 367, 368, 370, 372, 375, 
	373, 374, 377, 380, 378, 379, 381, 382, 
	384, 386, 385, 387, 389, 390, 326, 391, 
	392, 393, 394, 326, 396, 399, 397, 398, 
	400, 401, 403, 407, 408, 409, 411, 413, 
	412, 415, 416, 417, 419, 418, 420, 421, 
	423, 424, 425, 427, 429, 430, 431, 432, 
	434, 436, 437, 440, 439, 439, 441, 442, 
	444, 439, 439, 439, 443, 439, 443, 445, 
	439, 447, 446, 446, 450, 451, 452, 453, 
	446, 455, 456, 457, 458, 460, 462, 463, 
	464, 465, 466, 446, 448, 446, 449, 446, 
	446, 446, 446, 446, 454, 446, 454, 459, 
	446, 461, 446, 467, 467, 468, 483, 484, 
	470, 486, 487, 474, 488, 489, 490, 491, 
	492, 494, 495, 496, 497, 467, 467, 467, 
	467, 467, 467, 471, 476, 467, 467, 467, 
	467, 467, 467, 467, 467, 467, 485, 467, 
	485, 467, 467, 467, 467, 493, 467, 87, 
	91, 97, 498, 500, 503, 99, 498, 498, 
	499, 504, 504, 505, 506, 508, 510, 511, 
	504, 504, 507, 504, 507, 504, 509, 504, 
	504, 504, 513, 512, 512, 514, 515, 516, 
	518, 520, 521, 526, 533, 512, 512, 512, 
	512, 517, 512, 517, 512, 519, 512, 512, 
	513, 522, 523, 524, 525, 527, 528, 531, 
	529, 530, 532, 534, 535, 537, 536, 545, 
	546, 548, 549, 551, 553, 554, 555, 557, 
	559, 560, 562, 563, 585, 588, 589, 590, 
	658, 659, 660, 661, 662, 556, 664, 681, 
	686, 693, 698, 700, 706, 709, 710, 714, 
	708, 718, 729, 733, 736, 744, 748, 751, 
	752, 536, 103, 104, 536, 106, 539, 536, 
	536, 541, 543, 544, 536, 542, 536, 536, 
	536, 536, 536, 107, 536, 536, 536, 536, 
	536, 550, 536, 550, 536, 536, 112, 536, 
	536, 113, 536, 536, 556, 536, 561, 536, 
	536, 536, 564, 573, 536, 120, 576, 577, 
	578, 536, 579, 122, 582, 123, 125, 583, 
	584, 536, 565, 567, 536, 566, 536, 536, 
	568, 571, 572, 536, 569, 570, 536, 536, 
	536, 536, 536, 536, 580, 126, 587, 536, 
	536, 591, 536, 536, 536, 592, 594, 536, 
	593, 536, 593, 536, 595, 596, 597, 134, 
	140, 145, 620, 147, 536, 536, 536, 598, 
	599, 536, 135, 536, 536, 536, 136, 536, 
	536, 536, 139, 612, 614, 141, 536, 536, 
	142, 143, 536, 621, 625, 622, 623, 624, 
	536, 536, 626, 627, 630, 641, 654, 628, 
	629, 536, 631, 632, 633, 635, 634, 536, 
	636, 637, 638, 639, 640, 642, 649, 643, 
	644, 645, 646, 647, 648, 650, 651, 652, 
	653, 536, 536, 536, 657, 149, 152, 536, 
	663, 665, 666, 676, 679, 667, 668, 669, 
	670, 671, 672, 673, 674, 675, 677, 678, 
	680, 682, 685, 683, 684, 687, 690, 688, 
	689, 691, 692, 694, 696, 695, 697, 699, 
	701, 703, 702, 704, 705, 707, 675, 711, 
	712, 713, 715, 717, 716, 719, 720, 721, 
	726, 722, 723, 724, 536, 537, 538, 106, 
	725, 543, 727, 728, 730, 731, 732, 734, 
	735, 737, 738, 739, 742, 740, 741, 743, 
	745, 746, 747, 749, 750, 536, 753, 753, 
	754, 755, 756, 758, 753, 753, 753, 757, 
	753, 757, 753, 759, 753, 761, 760, 760, 
	762, 763, 760, 764, 766, 760, 760, 760, 
	760, 765, 760, 765, 767, 760, 769, 768, 
	768, 772, 773, 774, 768, 775, 777, 780, 
	781, 782, 783, 784, 768, 785, 786, 792, 
	820, 824, 768, 825, 827, 829, 768, 830, 
	831, 833, 837, 839, 840, 768, 842, 860, 
	865, 872, 880, 887, 894, 899, 900, 904, 
	898, 909, 919, 925, 928, 937, 941, 945, 
	946, 947, 780, 770, 768, 771, 768, 768, 
	768, 768, 768, 768, 776, 768, 776, 768, 
	156, 779, 768, 768, 768, 768, 768, 768, 
	768, 768, 768, 787, 790, 768, 768, 157, 
	159, 790, 160, 768, 790, 160, 768, 161, 
	801, 812, 815, 794, 816, 817, 802, 806, 
	808, 768, 794, 161, 796, 798, 162, 768, 
	796, 768, 797, 768, 768, 163, 800, 768, 
	768, 803, 805, 768, 803, 804, 806, 808, 
	805, 768, 807, 768, 768, 809, 811, 768, 
	167, 768, 768, 768, 813, 805, 806, 808, 
	813, 814, 768, 803, 805, 806, 808, 768, 
	803, 805, 806, 808, 768, 818, 805, 806, 
	808, 818, 819, 768, 161, 820, 794, 821, 
	806, 808, 822, 805, 161, 822, 794, 823, 
	826, 828, 768, 170, 171, 768, 768, 834, 
	835, 836, 831, 838, 768, 768, 841, 768, 
	768, 843, 844, 853, 858, 845, 846, 847, 
	848, 849, 850, 851, 852, 769, 854, 855, 
	856, 857, 769, 859, 861, 864, 862, 863, 
	769, 769, 866, 869, 867, 868, 870, 871, 
	769, 873, 875, 874, 876, 877, 878, 768, 
	768, 881, 769, 882, 768, 883, 884, 885, 
	886, 770, 888, 891, 889, 890, 892, 893, 
	895, 896, 897, 769, 901, 902, 903, 905, 
	907, 908, 906, 769, 910, 911, 912, 915, 
	913, 914, 916, 917, 918, 920, 922, 921, 
	923, 924, 926, 927, 929, 930, 932, 935, 
	931, 933, 934, 936, 938, 939, 940, 942, 
	943, 944, 768, 768, 948, 949, 950, 948, 
	952, 951, 953, 951, 954, 955, 956, 951, 
	951
]

class << self
	attr_accessor :_lex_trans_actions
	private :_lex_trans_actions, :_lex_trans_actions=
end
self._lex_trans_actions = [
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 2, 3, 4, 0, 5, 0, 
	0, 0, 6, 0, 7, 0, 8, 0, 
	7, 0, 0, 0, 0, 8, 7, 0, 
	8, 0, 7, 7, 0, 0, 0, 0, 
	0, 0, 0, 9, 0, 10, 0, 0, 
	0, 11, 0, 7, 0, 8, 0, 7, 
	0, 0, 0, 0, 8, 7, 0, 8, 
	0, 7, 7, 0, 0, 0, 0, 0, 
	0, 0, 12, 0, 13, 0, 0, 0, 
	14, 0, 15, 0, 0, 0, 0, 16, 
	0, 0, 0, 0, 0, 0, 17, 18, 
	19, 20, 21, 0, 0, 0, 22, 23, 
	0, 0, 24, 25, 26, 27, 28, 29, 
	29, 30, 31, 29, 32, 31, 33, 31, 
	29, 29, 30, 29, 34, 29, 29, 35, 
	29, 29, 29, 29, 29, 29, 0, 36, 
	37, 0, 38, 37, 39, 37, 0, 0, 
	36, 0, 40, 0, 0, 0, 0, 0, 
	0, 0, 0, 27, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	41, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 42, 43, 44, 45, 0, 0, 
	0, 45, 28, 46, 29, 29, 29, 46, 
	47, 0, 48, 0, 28, 29, 49, 29, 
	50, 51, 52, 0, 0, 0, 0, 0, 
	53, 54, 0, 55, 0, 28, 0, 56, 
	0, 29, 57, 29, 58, 29, 59, 60, 
	61, 60, 62, 60, 0, 63, 64, 63, 
	65, 63, 66, 67, 0, 68, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 69, 
	69, 70, 0, 28, 0, 71, 0, 7, 
	0, 8, 0, 7, 0, 0, 0, 0, 
	8, 7, 0, 8, 0, 7, 7, 0, 
	0, 0, 0, 0, 0, 0, 0, 72, 
	0, 0, 0, 0, 72, 73, 0, 0, 
	0, 74, 75, 76, 77, 0, 7, 7, 
	78, 79, 80, 80, 81, 0, 0, 0, 
	0, 82, 0, 0, 0, 0, 0, 0, 
	28, 0, 0, 0, 29, 57, 29, 29, 
	29, 59, 60, 61, 60, 60, 60, 0, 
	63, 64, 63, 63, 63, 83, 66, 84, 
	85, 0, 86, 87, 88, 91, 92, 0, 
	28, 0, 7, 0, 7, 93, 94, 95, 
	59, 96, 0, 97, 0, 98, 99, 100, 
	0, 101, 102, 0, 103, 7, 7, 104, 
	105, 0, 0, 106, 107, 108, 109, 109, 
	109, 109, 109, 109, 109, 109, 110, 111, 
	112, 0, 0, 113, 0, 114, 115, 116, 
	0, 117, 118, 119, 0, 7, 0, 0, 
	120, 121, 0, 28, 122, 0, 0, 0, 
	0, 0, 123, 124, 0, 0, 0, 0, 
	0, 0, 0, 125, 0, 0, 0, 0, 
	126, 0, 0, 0, 0, 0, 127, 128, 
	129, 0, 130, 131, 132, 7, 7, 133, 
	0, 0, 134, 135, 136, 109, 109, 109, 
	109, 109, 109, 109, 109, 137, 138, 139, 
	0, 0, 140, 0, 141, 142, 143, 0, 
	144, 145, 146, 0, 7, 0, 0, 147, 
	148, 0, 28, 149, 0, 0, 0, 0, 
	0, 150, 151, 0, 0, 0, 0, 0, 
	0, 0, 152, 0, 0, 0, 0, 153, 
	0, 0, 0, 0, 0, 154, 155, 156, 
	0, 157, 158, 0, 159, 0, 160, 161, 
	162, 163, 164, 165, 0, 166, 167, 168, 
	169, 170, 171, 7, 172, 0, 0, 173, 
	174, 175, 176, 177, 178, 179, 0, 180, 
	7, 181, 182, 0, 0, 183, 184, 185, 
	186, 0, 187, 188, 189, 0, 190, 0, 
	0, 191, 192, 193, 194, 195, 196, 0, 
	28, 0, 0, 7, 7, 0, 0, 0, 
	197, 0, 0, 0, 0, 198, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 199, 200, 201, 202, 
	203, 204, 59, 205, 0, 206, 0, 0, 
	0, 207, 0, 208, 209, 0, 0, 210, 
	0, 0, 0, 211, 0, 212, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 211, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 213, 0, 
	0, 0, 0, 214, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 7, 215, 216, 0, 0, 
	0, 217, 218, 219, 59, 220, 0, 28, 
	221, 0, 222, 223, 0, 28, 0, 0, 
	224, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 225, 0, 226, 0, 227, 
	228, 229, 230, 231, 59, 232, 0, 0, 
	233, 0, 234, 235, 236, 237, 28, 0, 
	27, 0, 0, 27, 0, 0, 0, 0, 
	0, 0, 7, 7, 7, 238, 239, 240, 
	241, 242, 243, 244, 0, 245, 246, 247, 
	248, 249, 250, 251, 252, 253, 59, 254, 
	0, 255, 256, 257, 258, 259, 260, 0, 
	0, 0, 261, 7, 7, 0, 262, 263, 
	264, 265, 266, 0, 0, 0, 0, 0, 
	267, 268, 59, 269, 0, 270, 28, 271, 
	272, 273, 274, 275, 276, 0, 28, 0, 
	0, 0, 0, 0, 0, 277, 278, 279, 
	280, 59, 281, 0, 282, 28, 283, 284, 
	285, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 286, 287, 0, 
	8, 0, 0, 7, 288, 0, 0, 288, 
	288, 0, 0, 7, 7, 0, 289, 0, 
	289, 289, 289, 0, 0, 289, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 0, 
	289, 290, 291, 291, 292, 293, 0, 294, 
	295, 0, 72, 0, 296, 0, 297, 298, 
	299, 300, 301, 29, 302, 303, 304, 305, 
	306, 59, 307, 0, 308, 309, 0, 310, 
	311, 0, 312, 313, 288, 314, 0, 315, 
	316, 317, 0, 0, 318, 0, 0, 0, 
	0, 319, 0, 0, 0, 0, 0, 0, 
	0, 320, 0, 0, 321, 0, 322, 323, 
	0, 0, 0, 324, 0, 0, 325, 326, 
	327, 328, 329, 330, 0, 0, 0, 331, 
	332, 0, 333, 334, 335, 0, 7, 336, 
	337, 338, 0, 339, 109, 109, 109, 109, 
	109, 109, 109, 109, 340, 341, 342, 0, 
	0, 343, 0, 344, 345, 346, 0, 347, 
	348, 349, 0, 7, 0, 0, 350, 351, 
	0, 28, 352, 0, 0, 0, 0, 0, 
	353, 354, 0, 0, 0, 0, 0, 0, 
	0, 355, 0, 0, 0, 0, 0, 356, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 357, 358, 359, 0, 0, 0, 360, 
	28, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 72, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 361, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 362, 363, 364, 365, 366, 
	366, 362, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 367, 368, 369, 
	0, 28, 0, 0, 370, 371, 372, 59, 
	373, 0, 374, 28, 375, 7, 376, 377, 
	0, 28, 378, 0, 0, 379, 380, 381, 
	382, 59, 383, 0, 28, 384, 385, 386, 
	387, 0, 28, 0, 388, 0, 7, 389, 
	0, 0, 0, 0, 390, 0, 0, 391, 
	391, 0, 392, 0, 0, 0, 393, 7, 
	394, 394, 394, 0, 0, 395, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 396, 397, 398, 0, 399, 400, 
	401, 402, 403, 404, 59, 405, 0, 406, 
	0, 0, 407, 408, 409, 410, 411, 412, 
	413, 414, 415, 0, 416, 417, 418, 0, 
	0, 419, 0, 420, 421, 29, 422, 423, 
	424, 0, 0, 425, 0, 0, 424, 426, 
	426, 427, 428, 0, 429, 430, 0, 431, 
	432, 433, 0, 434, 435, 0, 0, 436, 
	437, 424, 424, 438, 0, 0, 439, 439, 
	0, 440, 0, 441, 442, 7, 0, 443, 
	0, 444, 445, 446, 447, 447, 448, 448, 
	0, 0, 449, 450, 450, 451, 451, 452, 
	453, 453, 454, 454, 455, 456, 456, 457, 
	457, 0, 0, 458, 459, 460, 461, 462, 
	463, 463, 460, 462, 464, 391, 465, 0, 
	0, 0, 466, 0, 0, 467, 468, 394, 
	394, 394, 469, 394, 470, 471, 28, 472, 
	473, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 474, 0, 0, 
	0, 0, 469, 0, 0, 0, 0, 0, 
	475, 476, 0, 0, 0, 0, 0, 0, 
	477, 0, 0, 0, 0, 0, 476, 478, 
	479, 0, 480, 0, 481, 0, 0, 0, 
	0, 482, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 483, 0, 0, 0, 0, 
	0, 0, 0, 482, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 484, 485, 486, 7, 86, 487, 
	0, 488, 0, 489, 0, 0, 0, 490, 
	491
]

class << self
	attr_accessor :_lex_to_state_actions
	private :_lex_to_state_actions, :_lex_to_state_actions=
end
self._lex_to_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 89, 0, 
	0, 0, 0, 0, 0, 0, 0, 89, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 89, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 89, 0, 
	0, 89, 0, 89, 0, 0, 0, 89, 
	89, 0, 0, 0, 0, 89, 0, 89, 
	0, 89, 0, 0, 0, 0, 89, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 89, 
	0, 0, 0, 0, 0, 0, 89, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 89, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 89, 0, 0, 0, 0, 0, 
	89, 0, 0, 0, 0, 0, 0, 0, 
	89, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	89, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 89, 0, 0, 0, 0, 0, 0, 
	89, 0, 0, 0, 0, 0, 0, 0, 
	89, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 89, 0, 0, 89, 
	0, 0, 0, 0, 0
]

class << self
	attr_accessor :_lex_from_state_actions
	private :_lex_from_state_actions, :_lex_from_state_actions=
end
self._lex_from_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 90, 0, 
	0, 0, 0, 0, 0, 0, 0, 90, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 90, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 90, 0, 
	0, 90, 0, 90, 0, 0, 0, 90, 
	90, 0, 0, 0, 0, 90, 0, 90, 
	0, 90, 0, 0, 0, 0, 90, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 90, 
	0, 0, 0, 0, 0, 0, 90, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 90, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 90, 0, 0, 0, 0, 0, 
	90, 0, 0, 0, 0, 0, 0, 0, 
	90, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	90, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 90, 0, 0, 0, 0, 0, 0, 
	90, 0, 0, 0, 0, 0, 0, 0, 
	90, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 90, 0, 0, 90, 
	0, 0, 0, 0, 0
]

class << self
	attr_accessor :_lex_eof_trans
	private :_lex_eof_trans, :_lex_eof_trans=
end
self._lex_eof_trans = [
	0, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 13, 13, 13, 13, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 44, 44, 44, 
	44, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 75, 
	75, 75, 75, 81, 81, 81, 81, 0, 
	0, 0, 0, 95, 97, 99, 99, 99, 
	104, 104, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 169, 
	169, 169, 169, 169, 169, 169, 169, 169, 
	169, 169, 169, 179, 181, 181, 181, 193, 
	193, 193, 201, 203, 203, 203, 203, 203, 
	209, 201, 201, 201, 201, 201, 201, 201, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 201, 236, 236, 236, 
	236, 286, 286, 286, 291, 293, 293, 293, 
	297, 297, 297, 301, 301, 301, 301, 306, 
	306, 306, 291, 297, 297, 297, 297, 297, 
	297, 297, 297, 297, 337, 337, 0, 350, 
	351, 352, 354, 356, 358, 356, 356, 0, 
	368, 369, 373, 373, 374, 383, 384, 385, 
	385, 385, 388, 388, 390, 391, 392, 392, 
	392, 394, 395, 396, 396, 392, 388, 388, 
	401, 402, 402, 402, 402, 402, 405, 405, 
	405, 405, 411, 412, 412, 412, 412, 420, 
	412, 412, 412, 412, 425, 412, 412, 412, 
	412, 412, 412, 431, 432, 433, 433, 0, 
	440, 444, 444, 445, 454, 455, 456, 456, 
	456, 459, 459, 461, 462, 463, 463, 463, 
	465, 466, 467, 467, 463, 459, 459, 472, 
	473, 473, 473, 473, 473, 476, 476, 476, 
	476, 482, 483, 483, 483, 483, 491, 483, 
	483, 483, 483, 496, 483, 483, 483, 483, 
	483, 483, 502, 503, 504, 504, 0, 511, 
	512, 0, 518, 0, 525, 529, 529, 0, 
	0, 538, 539, 543, 543, 0, 548, 0, 
	551, 0, 554, 554, 555, 556, 0, 597, 
	599, 600, 601, 602, 604, 606, 610, 610, 
	601, 601, 601, 601, 612, 601, 601, 606, 
	601, 601, 597, 616, 616, 616, 616, 616, 
	616, 606, 606, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 655, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 622, 622, 
	622, 622, 622, 622, 622, 622, 601, 0, 
	698, 699, 700, 702, 698, 705, 0, 724, 
	726, 728, 729, 730, 731, 732, 734, 731, 
	731, 731, 731, 731, 737, 731, 731, 739, 
	737, 737, 731, 0, 758, 759, 104, 104, 
	762, 763, 104, 759, 759, 766, 768, 771, 
	759, 772, 759, 773, 774, 776, 778, 759, 
	766, 779, 779, 768, 779, 783, 779, 779, 
	779, 779, 0, 179, 791, 792, 791, 791, 
	0, 801, 802, 804, 806, 808, 806, 810, 
	0, 822, 823, 824, 825, 827, 829, 831, 
	832, 832, 832, 832, 832, 832, 832, 832, 
	832, 832, 832, 832, 832, 832, 832, 832, 
	0, 890, 893, 896, 897, 901, 903, 904, 
	905, 906, 907, 909, 912, 913, 915, 917, 
	920, 921, 923, 924, 201, 921, 926, 921, 
	912, 928, 912, 912, 946, 949, 951, 952, 
	956, 959, 960, 961, 962, 946, 946, 946, 
	946, 946, 946, 946, 946, 946, 946, 946, 
	946, 912, 968, 912, 912, 912, 969, 976, 
	976, 978, 980, 989, 990, 991, 991, 991, 
	994, 994, 996, 997, 998, 998, 998, 1000, 
	1001, 1002, 1002, 998, 994, 994, 1007, 1008, 
	1008, 1008, 1008, 1008, 1011, 1011, 1011, 1011, 
	1017, 1018, 1018, 1018, 1018, 1026, 1018, 1018, 
	1018, 1018, 1032, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1050, 1051, 
	1052, 1052, 201, 912, 912, 1056, 912, 907, 
	890, 890, 890, 890, 890, 890, 890, 890, 
	890, 890, 890, 201, 890, 890, 890, 890, 
	890, 890, 890, 890, 890, 890, 890, 890, 
	890, 890, 890, 890, 890, 890, 890, 890, 
	890, 890, 890, 890, 890, 890, 890, 890, 
	890, 890, 890, 890, 890, 890, 890, 890, 
	890, 890, 890, 890, 890, 890, 890, 890, 
	890, 890, 890, 890, 1109, 897, 890, 890, 
	890, 890, 890, 890, 890, 890, 890, 890, 
	890, 890, 890, 890, 890, 890, 890, 890, 
	890, 890, 890, 890, 890, 890, 890, 1134, 
	912, 0, 1141, 1142, 1143, 1145, 1147, 1149, 
	0, 1158, 1159, 1160, 1161, 1163, 1158, 1166, 
	0, 297, 1221, 1223, 1224, 1225, 1226, 1228, 
	1230, 1232, 1235, 1235, 297, 1237, 1239, 1240, 
	1241, 1237, 1243, 1246, 1247, 1247, 297, 1252, 
	1255, 1266, 297, 1272, 1274, 1276, 1277, 1280, 
	1281, 1255, 1255, 1284, 1284, 1284, 1290, 1292, 
	1293, 1296, 1298, 1299, 1300, 1284, 1284, 1307, 
	1312, 1317, 1284, 1284, 1324, 1324, 1284, 1284, 
	1246, 1237, 1237, 1246, 1237, 1237, 1232, 297, 
	1342, 1343, 1343, 1343, 1343, 1343, 1343, 1349, 
	1232, 1352, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1392, 1393, 
	1353, 1353, 1397, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1451, 1226, 1452, 0, 1456, 1456, 0, 
	1460, 1460, 1460, 1460, 1464
]

class << self
	attr_accessor :lex_start
end
self.lex_start = 182;
class << self
	attr_accessor :lex_error
end
self.lex_error = 0;

class << self
	attr_accessor :lex_en_interp_words
end
self.lex_en_interp_words = 191;
class << self
	attr_accessor :lex_en_interp_string
end
self.lex_en_interp_string = 247;
class << self
	attr_accessor :lex_en_plain_words
end
self.lex_en_plain_words = 302;
class << self
	attr_accessor :lex_en_plain_string
end
self.lex_en_plain_string = 305;
class << self
	attr_accessor :lex_en_interp_backslash_delimited
end
self.lex_en_interp_backslash_delimited = 307;
class << self
	attr_accessor :lex_en_plain_backslash_delimited
end
self.lex_en_plain_backslash_delimited = 311;
class << self
	attr_accessor :lex_en_interp_backslash_delimited_words
end
self.lex_en_interp_backslash_delimited_words = 312;
class << self
	attr_accessor :lex_en_plain_backslash_delimited_words
end
self.lex_en_plain_backslash_delimited_words = 317;
class << self
	attr_accessor :lex_en_regexp_modifiers
end
self.lex_en_regexp_modifiers = 319;
class << self
	attr_accessor :lex_en_expr_variable
end
self.lex_en_expr_variable = 321;
class << self
	attr_accessor :lex_en_expr_fname
end
self.lex_en_expr_fname = 326;
class << self
	attr_accessor :lex_en_expr_endfn
end
self.lex_en_expr_endfn = 439;
class << self
	attr_accessor :lex_en_expr_dot
end
self.lex_en_expr_dot = 446;
class << self
	attr_accessor :lex_en_expr_arg
end
self.lex_en_expr_arg = 467;
class << self
	attr_accessor :lex_en_expr_cmdarg
end
self.lex_en_expr_cmdarg = 498;
class << self
	attr_accessor :lex_en_expr_endarg
end
self.lex_en_expr_endarg = 504;
class << self
	attr_accessor :lex_en_expr_mid
end
self.lex_en_expr_mid = 512;
class << self
	attr_accessor :lex_en_expr_beg
end
self.lex_en_expr_beg = 536;
class << self
	attr_accessor :lex_en_expr_labelarg
end
self.lex_en_expr_labelarg = 753;
class << self
	attr_accessor :lex_en_expr_value
end
self.lex_en_expr_value = 760;
class << self
	attr_accessor :lex_en_expr_end
end
self.lex_en_expr_end = 768;
class << self
	attr_accessor :lex_en_leading_dot
end
self.lex_en_leading_dot = 948;
class << self
	attr_accessor :lex_en_line_comment
end
self.lex_en_line_comment = 951;
class << self
	attr_accessor :lex_en_line_begin
end
self.lex_en_line_begin = 182;


# line 82 "lib/parser/lexer.rl"
  # %

  ESCAPES = {
    ?a.ord => "\a", ?b.ord  => "\b", ?e.ord => "\e", ?f.ord => "\f",
    ?n.ord => "\n", ?r.ord  => "\r", ?s.ord => "\s", ?t.ord => "\t",
    ?v.ord => "\v", ?\\.ord => "\\"
  }.freeze

  REGEXP_META_CHARACTERS = Regexp.union(*"\\$()*+.<>?[]^{|}".chars).freeze

  attr_reader   :source_buffer

  attr_accessor :diagnostics
  attr_accessor :static_env
  attr_accessor :force_utf32

  attr_accessor :cond, :cmdarg, :in_kwarg, :context

  attr_accessor :tokens, :comments

  def initialize(version)
    @version    = version
    @static_env = nil
    @context    = nil

    @tokens     = nil
    @comments   = nil

    reset
  end

  def reset(reset_state=true)
    # Ragel state:
    if reset_state
      # Unit tests set state prior to resetting lexer.
      @cs     = self.class.lex_en_line_begin

      @cond   = StackState.new('cond')
      @cmdarg = StackState.new('cmdarg')
      @cond_stack   = []
      @cmdarg_stack = []
    end

    @force_utf32   = false # Set to true by some tests

    @source_pts    = nil # @source as a codepoint array

    @p             = 0   # stream position (saved manually in #advance)
    @ts            = nil # token start
    @te            = nil # token end
    @act           = 0   # next action

    @stack         = []  # state stack
    @top           = 0   # state stack top pointer

    # Lexer state:
    @token_queue   = []
    @literal_stack = []

    @eq_begin_s    = nil # location of last encountered =begin
    @sharp_s       = nil # location of last encountered #

    @newline_s     = nil # location of last encountered newline

    @num_base      = nil # last numeric base
    @num_digits_s  = nil # starting position of numeric digits
    @num_suffix_s  = nil # starting position of numeric suffix
    @num_xfrm      = nil # numeric suffix-induced transformation

    @escape_s      = nil # starting position of current sequence
    @escape        = nil # last escaped sequence, as string

    @herebody_s    = nil # starting position of current heredoc line

    # Ruby 1.9 ->() lambdas emit a distinct token if do/{ is
    # encountered after a matching closing parenthesis.
    @paren_nest    = 0
    @lambda_stack  = []

    # After encountering the closing line of <<~SQUIGGLY_HEREDOC,
    # we store the indentation level and give it out to the parser
    # on request. It is not possible to infer indentation level just
    # from the AST because escape sequences such as `\ ` or `\t` are
    # expanded inside the lexer, but count as non-whitespace for
    # indentation purposes.
    @dedent_level  = nil

    # If the lexer is in `command state' (aka expr_value)
    # at the entry to #advance, it will transition to expr_cmdarg
    # instead of expr_arg at certain points.
    @command_state = false

    # True at the end of "def foo a:"
    @in_kwarg      = false

    # State before =begin / =end block comment
    @cs_before_block_comment = self.class.lex_en_line_begin
  end

  def source_buffer=(source_buffer)
    @source_buffer = source_buffer

    if @source_buffer
      source = @source_buffer.source

      if source.encoding == Encoding::UTF_8
        @source_pts = source.unpack('U*')
      else
        @source_pts = source.unpack('C*')
      end

      if @source_pts[0] == 0xfeff
        # Skip byte order mark.
        @p = 1
      end
    else
      @source_pts = nil
    end
  end

  def encoding
    @source_buffer.source.encoding
  end

  LEX_STATES = {
    :line_begin    => lex_en_line_begin,
    :expr_dot      => lex_en_expr_dot,
    :expr_fname    => lex_en_expr_fname,
    :expr_value    => lex_en_expr_value,
    :expr_beg      => lex_en_expr_beg,
    :expr_mid      => lex_en_expr_mid,
    :expr_arg      => lex_en_expr_arg,
    :expr_cmdarg   => lex_en_expr_cmdarg,
    :expr_end      => lex_en_expr_end,
    :expr_endarg   => lex_en_expr_endarg,
    :expr_endfn    => lex_en_expr_endfn,
    :expr_labelarg => lex_en_expr_labelarg,

    :interp_string => lex_en_interp_string,
    :interp_words  => lex_en_interp_words,
    :plain_string  => lex_en_plain_string,
    :plain_words   => lex_en_plain_string,
  }

  def state
    LEX_STATES.invert.fetch(@cs, @cs)
  end

  def state=(state)
    @cs = LEX_STATES.fetch(state)
  end

  def push_cmdarg
    @cmdarg_stack.push(@cmdarg)
    @cmdarg = StackState.new("cmdarg.#{@cmdarg_stack.count}")
  end

  def pop_cmdarg
    @cmdarg = @cmdarg_stack.pop
  end

  def push_cond
    @cond_stack.push(@cond)
    @cond = StackState.new("cond.#{@cond_stack.count}")
  end

  def pop_cond
    @cond = @cond_stack.pop
  end

  def dedent_level
    # We erase @dedent_level as a precaution to avoid accidentally
    # using a stale value.
    dedent_level, @dedent_level = @dedent_level, nil
    dedent_level
  end

  # Return next token: [type, value].
  def advance
    if @token_queue.any?
      return @token_queue.shift
    end

    # Ugly, but dependent on Ragel output. Consider refactoring it somehow.
    klass = self.class
    _lex_trans_keys         = klass.send :_lex_trans_keys
    _lex_key_spans          = klass.send :_lex_key_spans
    _lex_index_offsets      = klass.send :_lex_index_offsets
    _lex_indicies           = klass.send :_lex_indicies
    _lex_trans_targs        = klass.send :_lex_trans_targs
    _lex_trans_actions      = klass.send :_lex_trans_actions
    _lex_to_state_actions   = klass.send :_lex_to_state_actions
    _lex_from_state_actions = klass.send :_lex_from_state_actions
    _lex_eof_trans          = klass.send :_lex_eof_trans

    pe = @source_pts.size + 2
    p, eof = @p, pe

    @command_state = (@cs == klass.lex_en_expr_value ||
                      @cs == klass.lex_en_line_begin)

    
# line 10862 "lib/parser/lexer.rb"
begin
	testEof = false
	_slen, _trans, _keys, _inds, _acts, _nacts = nil
	_goto_level = 0
	_resume = 10
	_eof_trans = 15
	_again = 20
	_test_eof = 30
	_out = 40
	while true
	if _goto_level <= 0
	if p == pe
		_goto_level = _test_eof
		next
	end
	if  @cs == 0
		_goto_level = _out
		next
	end
	end
	if _goto_level <= _resume
	case _lex_from_state_actions[ @cs] 
	when 90 then
# line 1 "NONE"
		begin
 @ts = p
		end
# line 10890 "lib/parser/lexer.rb"
	end
	_keys =  @cs << 1
	_inds = _lex_index_offsets[ @cs]
	_slen = _lex_key_spans[ @cs]
	_wide = ( (@source_pts[p] || 0))
	_trans = if (   _slen > 0 && 
			_lex_trans_keys[_keys] <= _wide && 
			_wide <= _lex_trans_keys[_keys + 1] 
		    ) then
			_lex_indicies[ _inds + _wide - _lex_trans_keys[_keys] ] 
		 else 
			_lex_indicies[ _inds + _slen ]
		 end
	end
	if _goto_level <= _eof_trans
	 @cs = _lex_trans_targs[_trans]
	if _lex_trans_actions[_trans] != 0
	case _lex_trans_actions[_trans]
	when 28 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 109 then
# line 800 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
	when 29 then
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
	when 59 then
# line 1179 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
	when 63 then
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
	when 293 then
# line 1223 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 36 then
# line 1492 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 38 then
# line 1508 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 40 then
# line 1536 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 69 then
# line 1726 "lib/parser/lexer.rl"
		begin
 heredoc_e      = p 		end
	when 337 then
# line 1806 "lib/parser/lexer.rl"
		begin
 @escape = nil 		end
	when 366 then
# line 1875 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 291 then
# line 1955 "lib/parser/lexer.rl"
		begin
 ident_tok = tok; ident_ts = @ts; ident_te = @te; 		end
	when 456 then
# line 2136 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
	when 450 then
# line 2137 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
	when 453 then
# line 2138 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
	when 447 then
# line 2139 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
	when 462 then
# line 2140 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
	when 424 then
# line 2141 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
	when 439 then
# line 2142 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 432 then
# line 2199 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 429 then
# line 2200 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 86 then
# line 2364 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 7 then
# line 1 "NONE"
		begin
 @te = p+1
		end
	when 106 then
# line 1061 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
     @cs = 760;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 5 then
# line 1003 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 321
		_goto_level = _again
		next
	end

   end
		end
	when 102 then
# line 928 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 101 then
# line 849 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 753;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 107 then
# line 1003 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 321
		_goto_level = _again
		next
	end

   end
		end
	when 104 then
# line 990 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 105 then
# line 849 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 753;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 6 then
# line 873 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 4 then
# line 849 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 753;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 134 then
# line 1061 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
     @cs = 760;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 10 then
# line 1003 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 321
		_goto_level = _again
		next
	end

   end
		end
	when 131 then
# line 928 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 130 then
# line 849 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 753;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 135 then
# line 1003 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 321
		_goto_level = _again
		next
	end

   end
		end
	when 133 then
# line 849 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 753;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 11 then
# line 873 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 9 then
# line 849 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 753;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 158 then
# line 928 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 157 then
# line 849 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 753;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 160 then
# line 990 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 161 then
# line 849 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 753;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 164 then
# line 928 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 163 then
# line 849 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 753;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 166 then
# line 849 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 753;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 173 then
# line 1061 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
     @cs = 760;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 13 then
# line 1003 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 321
		_goto_level = _again
		next
	end

   end
		end
	when 170 then
# line 928 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 169 then
# line 849 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 753;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 174 then
# line 1003 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 321
		_goto_level = _again
		next
	end

   end
		end
	when 172 then
# line 849 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 753;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 12 then
# line 849 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 753;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 176 then
# line 928 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 175 then
# line 849 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 753;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 183 then
# line 1061 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
     @cs = 760;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 15 then
# line 1003 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 321
		_goto_level = _again
		next
	end

   end
		end
	when 179 then
# line 928 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 178 then
# line 849 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 753;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 184 then
# line 1003 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 321
		_goto_level = _again
		next
	end

   end
		end
	when 181 then
# line 990 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 182 then
# line 849 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 753;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 14 then
# line 849 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 753;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 186 then
# line 928 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 185 then
# line 849 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 753;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 188 then
# line 990 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 189 then
# line 1153 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tREGEXP_OPT, tok(@ts, @te - 1), @ts, @te - 1)
        p = p - 1;
        	begin
		 @cs = 768
		_goto_level = _again
		next
	end

       end
		end
	when 190 then
# line 1140 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        unknown_options = tok.scan(/[^imxouesn]/)
        if unknown_options.any?
          diagnostic :error, :regexp_options,
                     { :options => unknown_options.join }
        end

        emit(:tREGEXP_OPT)
         @cs = 768;
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 16 then
# line 1282 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if    tok =~ /^\$([1-9][0-9]*)$/
          emit(:tNTH_REF, tok(@ts + 1).to_i)
        elsif tok =~ /^\$([&`'+])$/
          emit(:tBACK_REF)
        else
          emit(:tGVAR)
        end

         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 191 then
# line 1282 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if    tok =~ /^\$([1-9][0-9]*)$/
          emit(:tNTH_REF, tok(@ts + 1).to_i)
        elsif tok =~ /^\$([&`'+])$/
          emit(:tBACK_REF)
        else
          emit(:tGVAR)
        end

         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 193 then
# line 1295 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tok =~ /^@@[0-9]/
          diagnostic :error, :cvar_name, { :name => tok }
        end

        emit(:tCVAR)
         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 192 then
# line 1305 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tok =~ /^@[0-9]/
          diagnostic :error, :ivar_name, { :name => tok }
        end

        emit(:tIVAR)
         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 214 then
# line 1326 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(KEYWORDS_BEGIN);
            @cs = 439; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 200 then
# line 1334 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tIDENTIFIER)
            @cs = 439; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 18 then
# line 1338 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
            @cs = 768; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 321
		_goto_level = _again
		next
	end
  end
		end
	when 197 then
# line 1347 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 439; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 209 then
# line 1351 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; p = p - 1; 	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 20 then
# line 1357 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if version?(23)
          type, delimiter = tok[0..-2], tok[-1].chr
          	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

        else
          p = @ts - 1
          	begin
		 @cs = 768
		_goto_level = _again
		next
	end

        end
       end
		end
	when 196 then
# line 1370 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 195 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 213 then
# line 1326 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS_BEGIN);
            @cs = 439; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 210 then
# line 1330 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = 439; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 212 then
# line 1334 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tIDENTIFIER)
            @cs = 439; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 207 then
# line 1338 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
            @cs = 768; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 321
		_goto_level = _again
		next
	end
  end
		end
	when 203 then
# line 1347 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 439; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 208 then
# line 1354 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 536
		_goto_level = _again
		next
	end
  end
		end
	when 201 then
# line 1367 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 206 then
# line 1370 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 19 then
# line 1347 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  emit_table(PUNCTUATION)
            @cs = 439; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 17 then
# line 1370 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 199 then
# line 1 "NONE"
		begin
	case  @act
	when 39 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN);
            @cs = 439; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 40 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = 439; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 41 then
	begin begin p = (( @te))-1; end
 emit(:tIDENTIFIER)
            @cs = 439; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 22 then
# line 1382 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tLABEL, tok(@ts, @te - 2), @ts, @te - 1)
           p = p - 1;  @cs = 753; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 216 then
# line 1388 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 215 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 218 then
# line 1385 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 217 then
# line 1388 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 21 then
# line 1388 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 224 then
# line 1414 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 467; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 223 then
# line 1420 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 222 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 234 then
# line 1399 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 225 then
# line 1403 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tIDENTIFIER)
            @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 230 then
# line 1414 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 467; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 228 then
# line 1417 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 233 then
# line 1420 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 257 then
# line 1478 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        # Unlike expr_beg as invoked in the next rule, do not warn
        p = @ts - 1
        	begin
		 @cs = 768
		_goto_level = _again
		next
	end

       end
		end
	when 240 then
# line 1496 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if tok(tm, tm + 1) == '/'.freeze
          # Ambiguous regexp literal.
          diagnostic :warning, :ambiguous_literal, nil, range(tm, tm + 1)
        end

        p = tm - 1
        	begin
		 @cs = 536
		_goto_level = _again
		next
	end

       end
		end
	when 246 then
# line 1520 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; p = p - 1; 	begin
		 @cs = 536
		_goto_level = _again
		next
	end
  end
		end
	when 24 then
# line 1528 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @cs = 536
		_goto_level = _again
		next
	end
  end
		end
	when 248 then
# line 1537 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 39 then
# line 1548 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 768
		_goto_level = _again
		next
	end

       end
		end
	when 235 then
# line 1562 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 536
		_goto_level = _again
		next
	end
  end
		end
	when 236 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 247 then
# line 1487 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 536
		_goto_level = _again
		next
	end
  end
		end
	when 243 then
# line 1509 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :warning, :ambiguous_prefix, { :prefix => tok(tm, @te) },
                   range(tm, @te)

        p = tm - 1
        	begin
		 @cs = 536
		_goto_level = _again
		next
	end

       end
		end
	when 245 then
# line 1525 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 536
		_goto_level = _again
		next
	end
  end
		end
	when 239 then
# line 1548 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        p = @ts - 1
        	begin
		 @cs = 768
		_goto_level = _again
		next
	end

       end
		end
	when 238 then
# line 1553 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 256 then
# line 1562 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 536
		_goto_level = _again
		next
	end
  end
		end
	when 25 then
# line 1553 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
		end
	when 41 then
# line 1562 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 536
		_goto_level = _again
		next
	end
  end
		end
	when 23 then
# line 1 "NONE"
		begin
	case  @act
	when 67 then
	begin begin p = (( @te))-1; end

        if tok(tm, tm + 1) == '/'.freeze
          # Ambiguous regexp literal.
          diagnostic :warning, :ambiguous_literal, nil, range(tm, tm + 1)
        end

        p = tm - 1
        	begin
		 @cs = 536
		_goto_level = _again
		next
	end

      end
	when 68 then
	begin begin p = (( @te))-1; end

        diagnostic :warning, :ambiguous_prefix, { :prefix => tok(tm, @te) },
                   range(tm, @te)

        p = tm - 1
        	begin
		 @cs = 536
		_goto_level = _again
		next
	end

      end
	when 73 then
	begin begin p = (( @te))-1; end

        p = @ts - 1
        	begin
		 @cs = 768
		_goto_level = _again
		next
	end

      end
	else
	begin begin p = (( @te))-1; end
end
end 
			end
	when 43 then
# line 1598 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
           	begin
		 @cs = 467
		_goto_level = _again
		next
	end
  end
		end
	when 261 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 262 then
# line 1598 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 467
		_goto_level = _again
		next
	end
  end
		end
	when 44 then
# line 1598 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = @ts - 1
           	begin
		 @cs = 467
		_goto_level = _again
		next
	end
  end
		end
	when 42 then
# line 1 "NONE"
		begin
	case  @act
	when 80 then
	begin begin p = (( @te))-1; end

        if @cond.active?
          emit(:kDO_COND, 'do'.freeze, @te - 2, @te)
        else
          emit(:kDO, 'do'.freeze, @te - 2, @te)
        end
         @cs = 760; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 81 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 467
		_goto_level = _again
		next
	end
 end
end 
			end
	when 272 then
# line 1632 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_do(true)
            @cs = 760; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 265 then
# line 1638 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 266 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 267 then
# line 1635 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 270 then
# line 1638 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 276 then
# line 1662 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 536
		_goto_level = _again
		next
	end
  end
		end
	when 275 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 284 then
# line 1654 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @cs = 536
		_goto_level = _again
		next
	end
  end
		end
	when 278 then
# line 1656 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 282 then
# line 1662 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 536
		_goto_level = _again
		next
	end
  end
		end
	when 277 then
# line 1 "NONE"
		begin
	case  @act
	when 88 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 536; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 89 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 536
		_goto_level = _again
		next
	end
 end
end 
			end
	when 56 then
# line 1677 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 317 then
# line 1694 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type = delimiter = tok[0].chr
        p = p - 1; 	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 309 then
# line 1701 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = @source_buffer.slice(@ts).chr, tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 54 then
# line 1708 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok[0..-2], tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 330 then
# line 1764 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = p - 1; p = p - 1;
        emit(:tSYMBEG, tok(@ts, @ts + 1), @ts, @ts + 1)
        	begin
		 @cs = 326
		_goto_level = _again
		next
	end

       end
		end
	when 318 then
# line 1772 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok, tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 329 then
# line 1780 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tSYMBOL, tok(@ts + 1, @ts + 2))
         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 68 then
# line 1794 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tSYMBOL, tok(@ts + 1), @ts)
         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 334 then
# line 1821 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        escape = { " "  => '\s', "\r" => '\r', "\n" => '\n', "\t" => '\t',
                   "\v" => '\v', "\f" => '\f' }[@source_buffer.slice(@ts + 1)]
        diagnostic :warning, :invalid_escape_use, { :escape => escape }, range

        p = @ts - 1
        	begin
		 @cs = 768
		_goto_level = _again
		next
	end

       end
		end
	when 333 then
# line 1831 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :fatal, :incomplete_escape, nil, range(@ts, @ts + 1)
       end
		end
	when 319 then
# line 1870 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 51 then
# line 1890 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = p - 1;

        if version?(18)
          ident = tok(@ts, @te - 2)

          emit((@source_buffer.slice(@ts) =~ /[A-Z]/) ? :tCONSTANT : :tIDENTIFIER,
               ident, @ts, @te - 2)
          p = p - 1; # continue as a symbol

          if !@static_env.nil? && @static_env.declared?(ident)
             @cs = 768;
          else
             @cs = (arg_or_cmdarg);
          end
        else
          emit(:tLABEL, tok(@ts, @te - 2), @ts, @te - 1)
           @cs = 753;
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 316 then
# line 1928 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if @version >= 27
          emit(:tBDOT3)
        else
          emit(:tDOT3)
        end

         @cs = 536; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 48 then
# line 1957 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tIDENTIFIER, ident_tok, ident_ts, ident_te)
        p = ident_te - 1

        if !@static_env.nil? && @static_env.declared?(ident_tok) && @version < 25
           @cs = 439;
        else
           @cs = 498;
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 303 then
# line 1976 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        @cs_before_block_comment = @cs
        	begin
		 @cs = 182
		_goto_level = _again
		next
	end

       end
		end
	when 55 then
# line 1992 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 287 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 314 then
# line 1677 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 313 then
# line 1684 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tSTAR, '*'.freeze)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 310 then
# line 1708 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        type, delimiter = tok[0..-2], tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 308 then
# line 1714 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :string_eof, nil, range(@ts, @ts + 1)
       end
		end
	when 320 then
# line 1794 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1), @ts)
         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 332 then
# line 1831 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :incomplete_escape, nil, range(@ts, @ts + 1)
       end
		end
	when 338 then
# line 1837 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        p = @ts - 1
        	begin
		 @cs = 768
		_goto_level = _again
		next
	end

       end
		end
	when 311 then
# line 1870 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 315 then
# line 1917 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version >= 27
          emit(:tBDOT2)
        else
          emit(:tDOT2)
        end

         @cs = 536; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 290 then
# line 1267 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 439; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
   end
		end
	when 300 then
# line 1973 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 302 then
# line 1976 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        p = @ts - 1
        @cs_before_block_comment = @cs
        	begin
		 @cs = 182
		_goto_level = _again
		next
	end

       end
		end
	when 305 then
# line 1992 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 53 then
# line 1714 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :fatal, :string_eof, nil, range(@ts, @ts + 1)
       end
		end
	when 71 then
# line 1808 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 47 then
# line 1267 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 439; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
   end
		end
	when 52 then
# line 1973 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
		end
	when 67 then
# line 1992 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = @ts - 1; 	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 50 then
# line 1 "NONE"
		begin
	case  @act
	when 94 then
	begin begin p = (( @te))-1; end

        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 113 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 114 then
	begin begin p = (( @te))-1; end
 emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 512; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 115 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN)
            @cs = 760; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 119 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 768
		_goto_level = _again
		next
	end
 end
	when 120 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 439; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 124 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 768
		_goto_level = _again
		next
	end
 end
end 
			end
	when 368 then
# line 2012 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 536
		_goto_level = _again
		next
	end
  end
		end
	when 369 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 370 then
# line 2000 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 374 then
# line 2012 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 536
		_goto_level = _again
		next
	end
  end
		end
	when 74 then
# line 2022 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
           	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 378 then
# line 2027 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        	begin
		 @cs = (push_literal(tok, tok, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 377 then
# line 2037 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 536
		_goto_level = _again
		next
	end
  end
		end
	when 376 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 380 then
# line 2031 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 379 then
# line 2037 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 536
		_goto_level = _again
		next
	end
  end
		end
	when 73 then
# line 2037 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 536
		_goto_level = _again
		next
	end
  end
		end
	when 414 then
# line 2048 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tLAMBDA, '->'.freeze, @ts, @ts + 2)

        @lambda_stack.push @paren_nest
         @cs = 439; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 84 then
# line 2085 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 760; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 388 then
# line 2220 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok, tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts, nil, false, false, true))
		_goto_level = _again
		next
	end

       end
		end
	when 76 then
# line 2238 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 321
		_goto_level = _again
		next
	end
  end
		end
	when 410 then
# line 2251 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 466 then
# line 2275 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_table(PUNCTUATION)
        	begin
		 @cs = 760
		_goto_level = _again
		next
	end

       end
		end
	when 403 then
# line 2284 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_table(PUNCTUATION);
         @cs = 760; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 395 then
# line 2294 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_table(PUNCTUATION)

        if @version < 24
          @cond.lexpop
          @cmdarg.lexpop
        else
          @cond.pop
          @cmdarg.pop
        end

        if tok == '}'.freeze || tok == ']'.freeze
          if @version >= 25
             @cs = 768;
          else
             @cs = 504;
          end
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 408 then
# line 2319 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tOP_ASGN, tok(@ts, @te - 1))
            @cs = 536; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 393 then
# line 2323 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tEH, '?'.freeze)
            @cs = 760; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 390 then
# line 2331 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 536; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 392 then
# line 2344 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tSEMI, ';'.freeze)
            @cs = 760; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 471 then
# line 2347 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :error, :bare_backslash, nil, range(@ts, @ts + 1)
        p = p - 1;
       end
		end
	when 387 then
# line 2353 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 386 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 481 then
# line 2081 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS)
            @cs = 326; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 479 then
# line 2085 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 760; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 478 then
# line 2096 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS)
            @cs = 760; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 418 then
# line 2170 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :error, :no_dot_digit_literal
       end
		end
	when 468 then
# line 2230 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 407 then
# line 2238 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 321
		_goto_level = _again
		next
	end
  end
		end
	when 415 then
# line 2251 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 473 then
# line 1267 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 439; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
   end
		end
	when 413 then
# line 2275 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)
        	begin
		 @cs = 760
		_goto_level = _again
		next
	end

       end
		end
	when 409 then
# line 2284 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION);
         @cs = 760; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 402 then
# line 2290 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 536; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 417 then
# line 2331 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 536; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 400 then
# line 2338 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 406 then
# line 2353 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 82 then
# line 2143 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 77 then
# line 2170 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :error, :no_dot_digit_literal
       end
		end
	when 81 then
# line 2202 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 75 then
# line 2353 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 78 then
# line 1 "NONE"
		begin
	case  @act
	when 137 then
	begin begin p = (( @te))-1; end

        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end

         @cs = 760; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 138 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 326; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 139 then
	begin begin p = (( @te))-1; end
 emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 760; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 140 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 536; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 141 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 760; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 142 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 512; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 143 then
	begin begin p = (( @te))-1; end

        emit_table(KEYWORDS)

        if version?(18) && tok == 'not'.freeze
           @cs = 536; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = 467; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 144 then
	begin begin p = (( @te))-1; end

        if version?(18)
          emit(:tIDENTIFIER)

          unless !@static_env.nil? && @static_env.declared?(tok)
             @cs = (arg_or_cmdarg);
          end
        else
          emit(:k__ENCODING__, '__ENCODING__'.freeze)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 145 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 146 then
	begin begin p = (( @te))-1; end

        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 148 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tINTEGER, tok(@ts, @te - 1).to_i, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 149 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tFLOAT, tok(@ts, @te - 1).to_f, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 150 then
	begin begin p = (( @te))-1; end

        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 152 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 155 then
	begin begin p = (( @te))-1; end
 emit(:tDOT, '.', @ts, @ts + 1)
           emit(:tCOLON, ':', @ts + 1, @ts + 2)
           p = p - tok.length + 2
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 156 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 157 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 439; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 158 then
	begin begin p = (( @te))-1; end

        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 467; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 160 then
	begin begin p = (( @te))-1; end

        emit_table(PUNCTUATION);
         @cs = 760; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 161 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION)
            @cs = 536; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 88 then
# line 2365 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 486 then
# line 2368 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 182; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 487 then
# line 2368 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 182; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 85 then
# line 2368 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 182; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 490 then
# line 2378 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_comment(@eq_begin_s, @te)
        	begin
		 @cs = (@cs_before_block_comment)
		_goto_level = _again
		next
	end

       end
		end
	when 489 then
# line 2386 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :embedded_document, nil,
                   range(@eq_begin_s, @eq_begin_s + '=begin'.length)
       end
		end
	when 99 then
# line 2396 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  @eq_begin_s = @ts
           	begin
		 @cs = 951
		_goto_level = _again
		next
	end
  end
		end
	when 2 then
# line 2400 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = pe - 3  end
		end
	when 91 then
# line 2403 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 760
		_goto_level = _again
		next
	end
  end
		end
	when 92 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 93 then
# line 2393 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 98 then
# line 2396 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  @eq_begin_s = @ts
           	begin
		 @cs = 951
		_goto_level = _again
		next
	end
  end
		end
	when 97 then
# line 2403 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 760
		_goto_level = _again
		next
	end
  end
		end
	when 1 then
# line 2403 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 760
		_goto_level = _again
		next
	end
  end
		end
	when 66 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
	when 103 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 928 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 132 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 928 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 159 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 928 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 165 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 928 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 171 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 928 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 177 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 928 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 180 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 928 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 187 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 928 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 258 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1478 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        # Unlike expr_beg as invoked in the next rule, do not warn
        p = @ts - 1
        	begin
		 @cs = 768
		_goto_level = _again
		next
	end

       end
		end
	when 249 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1537 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 241 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1548 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 768
		_goto_level = _again
		next
	end

       end
		end
	when 335 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1821 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        escape = { " "  => '\s', "\r" => '\r', "\n" => '\n', "\t" => '\t',
                   "\v" => '\v', "\f" => '\f' }[@source_buffer.slice(@ts + 1)]
        diagnostic :warning, :invalid_escape_use, { :escape => escape }, range

        p = @ts - 1
        	begin
		 @cs = 768
		_goto_level = _again
		next
	end

       end
		end
	when 304 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1976 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        @cs_before_block_comment = @cs
        	begin
		 @cs = 182
		_goto_level = _again
		next
	end

       end
		end
	when 491 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2378 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_comment(@eq_begin_s, @te)
        	begin
		 @cs = (@cs_before_block_comment)
		_goto_level = _again
		next
	end

       end
		end
	when 488 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2383 "lib/parser/lexer.rl"
		begin
 @te = p+1
		end
	when 100 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2396 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  @eq_begin_s = @ts
           	begin
		 @cs = 951
		_goto_level = _again
		next
	end
  end
		end
	when 3 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2400 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = pe - 3  end
		end
	when 442 then
# line 626 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tRATIONAL,  Rational(chars)) } 		end
# line 2143 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 440 then
# line 627 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, chars)) } 		end
# line 2143 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 445 then
# line 628 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, Rational(chars))) } 		end
# line 2143 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 443 then
# line 629 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars, @ts, @te - 2); p -= 2 } 		end
# line 2143 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 441 then
# line 630 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars, @ts, @te - 2); p -= 2 } 		end
# line 2143 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 444 then
# line 631 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars, @ts, @te - 6); p -= 6 } 		end
# line 2143 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 433 then
# line 635 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, Float(chars))) } 		end
# line 2202 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 434 then
# line 636 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars), @ts, @te - 2); p -= 2 } 		end
# line 2202 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 435 then
# line 640 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tRATIONAL,  Rational(chars)) } 		end
# line 2202 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 437 then
# line 641 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, Rational(chars))) } 		end
# line 2202 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 436 then
# line 642 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars), @ts, @te - 6); p -= 6 } 		end
# line 2202 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 126 then
# line 657 "lib/parser/lexer.rl"
		begin

    @escape = ""

    codepoints  = tok(@escape_s + 2, p - 1)
    codepoint_s = @escape_s + 2

    if @version < 24
      if codepoints.start_with?(" ") || codepoints.start_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(@escape_s + 2, @escape_s + 3)
      end

      if spaces_p = codepoints.index(/[ \t]{2}/)
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(codepoint_s + spaces_p + 1, codepoint_s + spaces_p + 2)
      end

      if codepoints.end_with?(" ") || codepoints.end_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil, range(p - 1, p)
      end
    end

    codepoints.scan(/([0-9a-fA-F]+)|([ \t]+)/).each do |(codepoint_str, spaces)|
      if spaces
        codepoint_s += spaces.length
      else
        codepoint = codepoint_str.to_i(16)

        if codepoint >= 0x110000
          diagnostic :error, :unicode_point_too_large, nil,
                     range(codepoint_s, codepoint_s + codepoint_str.length)
          break
        end

        @escape     += codepoint.chr(Encoding::UTF_8)
        codepoint_s += codepoint_str.length
      end
    end
  		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 153 then
# line 657 "lib/parser/lexer.rl"
		begin

    @escape = ""

    codepoints  = tok(@escape_s + 2, p - 1)
    codepoint_s = @escape_s + 2

    if @version < 24
      if codepoints.start_with?(" ") || codepoints.start_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(@escape_s + 2, @escape_s + 3)
      end

      if spaces_p = codepoints.index(/[ \t]{2}/)
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(codepoint_s + spaces_p + 1, codepoint_s + spaces_p + 2)
      end

      if codepoints.end_with?(" ") || codepoints.end_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil, range(p - 1, p)
      end
    end

    codepoints.scan(/([0-9a-fA-F]+)|([ \t]+)/).each do |(codepoint_str, spaces)|
      if spaces
        codepoint_s += spaces.length
      else
        codepoint = codepoint_str.to_i(16)

        if codepoint >= 0x110000
          diagnostic :error, :unicode_point_too_large, nil,
                     range(codepoint_s, codepoint_s + codepoint_str.length)
          break
        end

        @escape     += codepoint.chr(Encoding::UTF_8)
        codepoint_s += codepoint_str.length
      end
    end
  		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 356 then
# line 657 "lib/parser/lexer.rl"
		begin

    @escape = ""

    codepoints  = tok(@escape_s + 2, p - 1)
    codepoint_s = @escape_s + 2

    if @version < 24
      if codepoints.start_with?(" ") || codepoints.start_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(@escape_s + 2, @escape_s + 3)
      end

      if spaces_p = codepoints.index(/[ \t]{2}/)
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(codepoint_s + spaces_p + 1, codepoint_s + spaces_p + 2)
      end

      if codepoints.end_with?(" ") || codepoints.end_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil, range(p - 1, p)
      end
    end

    codepoints.scan(/([0-9a-fA-F]+)|([ \t]+)/).each do |(codepoint_str, spaces)|
      if spaces
        codepoint_s += spaces.length
      else
        codepoint = codepoint_str.to_i(16)

        if codepoint >= 0x110000
          diagnostic :error, :unicode_point_too_large, nil,
                     range(codepoint_s, codepoint_s + codepoint_str.length)
          break
        end

        @escape     += codepoint.chr(Encoding::UTF_8)
        codepoint_s += codepoint_str.length
      end
    end
  		end
# line 1808 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 110 then
# line 697 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 137 then
# line 697 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 340 then
# line 697 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 1808 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 113 then
# line 704 "lib/parser/lexer.rl"
		begin

    diagnostic :fatal, :invalid_escape
  		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 140 then
# line 704 "lib/parser/lexer.rl"
		begin

    diagnostic :fatal, :invalid_escape
  		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 343 then
# line 704 "lib/parser/lexer.rl"
		begin

    diagnostic :fatal, :invalid_escape
  		end
# line 1808 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 115 then
# line 723 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 142 then
# line 723 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 345 then
# line 723 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 1808 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 112 then
# line 730 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s, p).to_i(8) % 0x100) 		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 139 then
# line 730 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s, p).to_i(8) % 0x100) 		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 342 then
# line 730 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s, p).to_i(8) % 0x100) 		end
# line 1808 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 129 then
# line 734 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s + 1, p).to_i(16)) 		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 156 then
# line 734 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s + 1, p).to_i(16)) 		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 359 then
# line 734 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s + 1, p).to_i(16)) 		end
# line 1808 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 128 then
# line 738 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_hex_escape, nil, range(@escape_s - 1, p + 2)
      		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 155 then
# line 738 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_hex_escape, nil, range(@escape_s - 1, p + 2)
      		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 358 then
# line 738 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_hex_escape, nil, range(@escape_s - 1, p + 2)
      		end
# line 1808 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 123 then
# line 744 "lib/parser/lexer.rl"
		begin
 @escape = tok(@escape_s + 1, p).to_i(16).chr(Encoding::UTF_8) 		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 150 then
# line 744 "lib/parser/lexer.rl"
		begin
 @escape = tok(@escape_s + 1, p).to_i(16).chr(Encoding::UTF_8) 		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 353 then
# line 744 "lib/parser/lexer.rl"
		begin
 @escape = tok(@escape_s + 1, p).to_i(16).chr(Encoding::UTF_8) 		end
# line 1808 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 122 then
# line 748 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 149 then
# line 748 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 352 then
# line 748 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 1808 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 127 then
# line 754 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 154 then
# line 754 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 357 then
# line 754 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 1808 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 124 then
# line 768 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 151 then
# line 768 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 354 then
# line 768 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 1808 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 111 then
# line 794 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 138 then
# line 794 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 341 then
# line 794 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 1808 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 162 then
# line 800 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 167 then
# line 800 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 57 then
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 30 then
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1492 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 32 then
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1508 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 34 then
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1536 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 202 then
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1367 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 221 then
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1385 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 229 then
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1417 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 33 then
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1548 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 768
		_goto_level = _again
		next
	end

       end
		end
	when 260 then
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1553 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 252 then
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1559 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 271 then
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1635 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 283 then
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1656 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 279 then
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1659 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 58 then
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1677 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 49 then
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1957 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tIDENTIFIER, ident_tok, ident_ts, ident_te)
        p = ident_te - 1

        if !@static_env.nil? && @static_env.declared?(ident_tok) && @version < 25
           @cs = 439;
        else
           @cs = 498;
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 301 then
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1973 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 375 then
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2000 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 371 then
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2003 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
      if @in_kwarg
        p = p - 1; 	begin
		 @cs = 768
		_goto_level = _again
		next
	end

      else
        	begin
		 @cs = 182
		_goto_level = _again
		next
	end

      end
     end
		end
	when 384 then
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2031 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 381 then
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2034 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 182
		_goto_level = _again
		next
	end
  end
		end
	when 420 then
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2245 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tDOT, '.', @ts, @ts + 1)
           emit(:tCOLON, ':', @ts + 1, @ts + 2)
           p = p - tok.length + 2
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 472 then
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2338 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 401 then
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2341 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 948
		_goto_level = _again
		next
	end
  end
		end
	when 94 then
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2393 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 251 then
# line 1028 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1461 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          emit(:tLAMBEG, '{'.freeze, @te - 1, @te)
        else
          emit(:tLCURLY, '{'.freeze, @te - 1, @te)
        end
         @cs = 760; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 273 then
# line 1028 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1621 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          emit(:tLAMBEG, '{'.freeze)
        else
          emit(:tLBRACE_ARG, '{'.freeze)
        end
         @cs = 760; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 367 then
# line 1028 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1848 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          emit(:tLAMBEG, '{'.freeze)
        else
          emit(:tLBRACE, '{'.freeze)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 484 then
# line 1028 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 2056 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end

         @cs = 760; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 485 then
# line 1037 "lib/parser/lexer.rl"
		begin

    current_literal = literal
    if current_literal
      if current_literal.end_interp_brace_and_try_closing
        if version?(18, 19)
          emit(:tRCURLY, '}'.freeze, p - 1, p)
          @cond.lexpop
          @cmdarg.lexpop
        else
          emit(:tSTRING_DEND, '}'.freeze, p - 1, p)
        end

        if current_literal.saved_herebody_s
          @herebody_s = current_literal.saved_herebody_s
        end


        p = p - 1;
         @cs = (next_state_for_literal(current_literal));
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
    end
  		end
# line 2294 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)

        if @version < 24
          @cond.lexpop
          @cmdarg.lexpop
        else
          @cond.pop
          @cmdarg.pop
        end

        if tok == '}'.freeze || tok == ']'.freeze
          if @version >= 25
             @cs = 768;
          else
             @cs = 504;
          end
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 60 then
# line 1179 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
	when 64 then
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 205 then
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1367 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 220 then
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1385 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 232 then
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1417 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 254 then
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1556 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 269 then
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1635 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 281 then
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1656 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 307 then
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1973 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 373 then
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2000 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 383 then
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2031 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 405 then
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2338 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 96 then
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2393 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 226 then
# line 1223 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1407 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tFID, tok(@ts, tm), @ts, tm)
            @cs = (arg_or_cmdarg); p = tm - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 321 then
# line 1223 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1786 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 292 then
# line 1223 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1946 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 398 then
# line 1223 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1 "NONE"
		begin
	case  @act
	when 137 then
	begin begin p = (( @te))-1; end

        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end

         @cs = 760; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 138 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 326; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 139 then
	begin begin p = (( @te))-1; end
 emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 760; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 140 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 536; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 141 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 760; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 142 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 512; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 143 then
	begin begin p = (( @te))-1; end

        emit_table(KEYWORDS)

        if version?(18) && tok == 'not'.freeze
           @cs = 536; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = 467; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 144 then
	begin begin p = (( @te))-1; end

        if version?(18)
          emit(:tIDENTIFIER)

          unless !@static_env.nil? && @static_env.declared?(tok)
             @cs = (arg_or_cmdarg);
          end
        else
          emit(:k__ENCODING__, '__ENCODING__'.freeze)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 145 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 146 then
	begin begin p = (( @te))-1; end

        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 148 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tINTEGER, tok(@ts, @te - 1).to_i, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 149 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tFLOAT, tok(@ts, @te - 1).to_f, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 150 then
	begin begin p = (( @te))-1; end

        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 152 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 155 then
	begin begin p = (( @te))-1; end
 emit(:tDOT, '.', @ts, @ts + 1)
           emit(:tCOLON, ':', @ts + 1, @ts + 2)
           p = p - tok.length + 2
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 156 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 157 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 439; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 158 then
	begin begin p = (( @te))-1; end

        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 467; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 160 then
	begin begin p = (( @te))-1; end

        emit_table(PUNCTUATION);
         @cs = 760; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 161 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION)
            @cs = 536; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 227 then
# line 1224 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1407 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tFID, tok(@ts, tm), @ts, tm)
            @cs = (arg_or_cmdarg); p = tm - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 322 then
# line 1224 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1786 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 294 then
# line 1224 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1946 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 399 then
# line 1224 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2258 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 467; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 323 then
# line 1229 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1786 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 295 then
# line 1229 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1946 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 324 then
# line 1230 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1786 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 296 then
# line 1230 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1946 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 328 then
# line 1231 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1786 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 299 then
# line 1231 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1946 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 327 then
# line 1232 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1786 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 298 then
# line 1232 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1 "NONE"
		begin
	case  @act
	when 94 then
	begin begin p = (( @te))-1; end

        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 113 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 114 then
	begin begin p = (( @te))-1; end
 emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 512; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 115 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN)
            @cs = 760; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 119 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 768
		_goto_level = _again
		next
	end
 end
	when 120 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 439; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 124 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 768
		_goto_level = _again
		next
	end
 end
end 
			end
	when 325 then
# line 1233 "lib/parser/lexer.rl"
		begin
 tm = p - 3 		end
# line 1786 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 297 then
# line 1233 "lib/parser/lexer.rl"
		begin
 tm = p - 3 		end
# line 1946 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 326 then
# line 1238 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1786 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 467 then
# line 1243 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2234 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT, tok(@ts, tm), @ts, tm)
           p = tm - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 250 then
# line 1249 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)
  		end
# line 1455 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK, '['.freeze, @te - 1, @te)
            @cs = 536; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 360 then
# line 1249 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)
  		end
# line 1860 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK, '['.freeze)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 470 then
# line 1249 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)
  		end
# line 2327 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK2, '['.freeze)
            @cs = 536; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 242 then
# line 1256 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 1436 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if version?(18)
          emit(:tLPAREN2, '('.freeze, @te - 1, @te)
           @cs = 760; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          emit(:tLPAREN_ARG, '('.freeze, @te - 1, @te)
           @cs = 536; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 255 then
# line 1256 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 1449 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLPAREN2, '('.freeze)
            @cs = 536; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 263 then
# line 1256 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 1575 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tLPAREN_ARG, '('.freeze, @te - 1, @te)
        if version?(18)
           @cs = 760; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = 536; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 312 then
# line 1256 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 1865 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLPAREN, '('.freeze)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 411 then
# line 1256 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 2290 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 536; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 412 then
# line 1262 "lib/parser/lexer.rl"
		begin

    @paren_nest -= 1
  		end
# line 2294 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)

        if @version < 24
          @cond.lexpop
          @cmdarg.lexpop
        else
          @cond.pop
          @cmdarg.pop
        end

        if tok == '}'.freeze || tok == ']'.freeze
          if @version >= 25
             @cs = 768;
          else
             @cs = 504;
          end
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 70 then
# line 1726 "lib/parser/lexer.rl"
		begin
 heredoc_e      = p 		end
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 331 then
# line 1727 "lib/parser/lexer.rl"
		begin
 new_herebody_s = p 		end
# line 1728 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        tok(@ts, heredoc_e) =~ /^<<(-?)(~?)(["'`]?)(.*)\3$/m

        indent      = !$1.empty? || !$2.empty?
        dedent_body = !$2.empty?
        type        =  $3.empty? ? '<<"'.freeze : ('<<'.freeze + $3)
        delimiter   =  $4

        if @version >= 24
          if delimiter.count("\n") > 0
            if delimiter.end_with?("\n")
              diagnostic :warning, :heredoc_id_ends_with_nl, nil, range(@ts, @ts + 1)
              delimiter = delimiter.rstrip
            else
              diagnostic :fatal, :heredoc_id_has_newline, nil, range(@ts, @ts + 1)
            end
          end
        end

        if dedent_body && version?(18, 19, 20, 21, 22)
          emit(:tLSHFT, '<<'.freeze, @ts, @ts + 2)
          p = @ts + 1
           @cs = 536; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = (push_literal(type, delimiter, @ts, heredoc_e, indent, dedent_body));

          @herebody_s ||= new_herebody_s
          p = @herebody_s - 1
        end
       end
		end
	when 336 then
# line 1806 "lib/parser/lexer.rl"
		begin
 @escape = nil 		end
# line 1808 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 363 then
# line 1875 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1876 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 512; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 457 then
# line 2136 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
# line 2142 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 451 then
# line 2137 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
# line 2142 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 454 then
# line 2138 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
# line 2142 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 448 then
# line 2139 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
# line 2142 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 463 then
# line 2140 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2142 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 426 then
# line 2141 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2142 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 464 then
# line 2142 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
	when 87 then
# line 2364 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 2365 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 8 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 430 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2200 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 211 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1326 "lib/parser/lexer.rl"
		begin
 @act = 39;		end
	when 198 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1330 "lib/parser/lexer.rl"
		begin
 @act = 40;		end
	when 194 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1334 "lib/parser/lexer.rl"
		begin
 @act = 41;		end
	when 26 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1496 "lib/parser/lexer.rl"
		begin
 @act = 67;		end
	when 244 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1509 "lib/parser/lexer.rl"
		begin
 @act = 68;		end
	when 27 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1548 "lib/parser/lexer.rl"
		begin
 @act = 73;		end
	when 237 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1553 "lib/parser/lexer.rl"
		begin
 @act = 74;		end
	when 264 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1585 "lib/parser/lexer.rl"
		begin
 @act = 80;		end
	when 45 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1598 "lib/parser/lexer.rl"
		begin
 @act = 81;		end
	when 285 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1650 "lib/parser/lexer.rl"
		begin
 @act = 88;		end
	when 274 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1654 "lib/parser/lexer.rl"
		begin
 @act = 89;		end
	when 288 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1870 "lib/parser/lexer.rl"
		begin
 @act = 113;		end
	when 362 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1876 "lib/parser/lexer.rl"
		begin
 @act = 114;		end
	when 361 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1882 "lib/parser/lexer.rl"
		begin
 @act = 115;		end
	when 72 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1946 "lib/parser/lexer.rl"
		begin
 @act = 119;		end
	when 286 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1267 "lib/parser/lexer.rl"
		begin
 @act = 120;		end
	when 289 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1992 "lib/parser/lexer.rl"
		begin
 @act = 124;		end
	when 480 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2056 "lib/parser/lexer.rl"
		begin
 @act = 137;		end
	when 475 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2081 "lib/parser/lexer.rl"
		begin
 @act = 138;		end
	when 483 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2091 "lib/parser/lexer.rl"
		begin
 @act = 140;		end
	when 476 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2096 "lib/parser/lexer.rl"
		begin
 @act = 141;		end
	when 477 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2100 "lib/parser/lexer.rl"
		begin
 @act = 142;		end
	when 482 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2104 "lib/parser/lexer.rl"
		begin
 @act = 143;		end
	when 474 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2115 "lib/parser/lexer.rl"
		begin
 @act = 144;		end
	when 469 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2129 "lib/parser/lexer.rl"
		begin
 @act = 145;		end
	when 391 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2143 "lib/parser/lexer.rl"
		begin
 @act = 146;		end
	when 428 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2187 "lib/parser/lexer.rl"
		begin
 @act = 149;		end
	when 80 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2202 "lib/parser/lexer.rl"
		begin
 @act = 150;		end
	when 394 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2230 "lib/parser/lexer.rl"
		begin
 @act = 152;		end
	when 419 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2245 "lib/parser/lexer.rl"
		begin
 @act = 155;		end
	when 416 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2251 "lib/parser/lexer.rl"
		begin
 @act = 156;		end
	when 385 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1267 "lib/parser/lexer.rl"
		begin
 @act = 157;		end
	when 397 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2258 "lib/parser/lexer.rl"
		begin
 @act = 158;		end
	when 389 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2284 "lib/parser/lexer.rl"
		begin
 @act = 160;		end
	when 396 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2290 "lib/parser/lexer.rl"
		begin
 @act = 161;		end
	when 168 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 928 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
# line 800 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
	when 116 then
# line 697 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 708 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 143 then
# line 697 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 708 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 346 then
# line 697 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 708 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 1808 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 121 then
# line 697 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 712 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 148 then
# line 697 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 712 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 351 then
# line 697 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 712 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1808 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 120 then
# line 718 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 712 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 147 then
# line 718 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 712 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 350 then
# line 718 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 712 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1808 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 118 then
# line 723 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 712 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 145 then
# line 723 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 712 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 348 then
# line 723 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 712 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1808 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 114 then
# line 724 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 708 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 141 then
# line 724 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 708 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 344 then
# line 724 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 708 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 1808 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 125 then
# line 754 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 768 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 152 then
# line 754 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 768 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 355 then
# line 754 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 768 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 1808 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 108 then
# line 800 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 794 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 136 then
# line 800 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 794 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 339 then
# line 800 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 794 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 1808 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 61 then
# line 1179 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 204 then
# line 1179 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1367 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 219 then
# line 1179 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1385 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 231 then
# line 1179 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1417 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 253 then
# line 1179 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1556 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 768
		_goto_level = _again
		next
	end
  end
		end
	when 268 then
# line 1179 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1635 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 280 then
# line 1179 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1656 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 306 then
# line 1179 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1973 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 372 then
# line 1179 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2000 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 382 then
# line 1179 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2031 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 404 then
# line 1179 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2338 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 95 then
# line 1179 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2393 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 459 then
# line 2140 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2142 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
	when 423 then
# line 2141 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2142 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
	when 438 then
# line 2142 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2143 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 431 then
# line 2199 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 634 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars)) } 		end
# line 2202 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 427 then
# line 2200 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 634 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars)) } 		end
# line 2202 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 259 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1553 "lib/parser/lexer.rl"
		begin
 @act = 74;		end
	when 79 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2245 "lib/parser/lexer.rl"
		begin
 @act = 155;		end
	when 35 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1548 "lib/parser/lexer.rl"
		begin
 @act = 73;		end
	when 46 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1598 "lib/parser/lexer.rl"
		begin
 @act = 81;		end
	when 421 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2245 "lib/parser/lexer.rl"
		begin
 @act = 155;		end
	when 65 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1677 "lib/parser/lexer.rl"
		begin
 @act = 94;		end
	when 83 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2085 "lib/parser/lexer.rl"
		begin
 @act = 139;		end
	when 37 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1508 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1509 "lib/parser/lexer.rl"
		begin
 @act = 68;		end
	when 365 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1875 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1946 "lib/parser/lexer.rl"
		begin
 @act = 119;		end
	when 364 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1875 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1267 "lib/parser/lexer.rl"
		begin
 @act = 120;		end
	when 460 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2140 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2143 "lib/parser/lexer.rl"
		begin
 @act = 146;		end
	when 119 then
# line 697 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 708 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 712 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 146 then
# line 697 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 708 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 712 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 349 then
# line 697 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 708 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 712 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1808 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 117 then
# line 724 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 708 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 712 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 144 then
# line 724 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 708 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 712 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 873 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 347 then
# line 724 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 708 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 712 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1808 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 768; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 455 then
# line 2136 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
# line 2142 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2143 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 449 then
# line 2137 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
# line 2142 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2143 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 452 then
# line 2138 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
# line 2142 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2143 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 446 then
# line 2139 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
# line 2142 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2143 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 458 then
# line 2140 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2142 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2143 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 422 then
# line 2141 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2142 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2143 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 31 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 840 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1508 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1509 "lib/parser/lexer.rl"
		begin
 @act = 68;		end
	when 62 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1179 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1182 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1677 "lib/parser/lexer.rl"
		begin
 @act = 94;		end
	when 465 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2142 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2175 "lib/parser/lexer.rl"
		begin
 @act = 148;		end
	when 461 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2140 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2142 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2175 "lib/parser/lexer.rl"
		begin
 @act = 148;		end
	when 425 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2141 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2142 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2175 "lib/parser/lexer.rl"
		begin
 @act = 148;		end
# line 23009 "lib/parser/lexer.rb"
	end
	end
	end
	if _goto_level <= _again
	case _lex_to_state_actions[ @cs] 
	when 89 then
# line 1 "NONE"
		begin
 @ts = nil;		end
# line 23019 "lib/parser/lexer.rb"
	end

	if  @cs == 0
		_goto_level = _out
		next
	end
	p += 1
	if p != pe
		_goto_level = _resume
		next
	end
	end
	if _goto_level <= _test_eof
	if p == eof
	if _lex_eof_trans[ @cs] > 0
		_trans = _lex_eof_trans[ @cs] - 1;
		_goto_level = _eof_trans
		next;
	end
	end

	end
	if _goto_level <= _out
		break
	end
end
	end

# line 284 "lib/parser/lexer.rl"
    # %

    @p = p

    if @token_queue.any?
      @token_queue.shift
    elsif @cs == klass.lex_error
      [ false, [ '$error'.freeze, range(p - 1, p) ] ]
    else
      eof = @source_pts.size
      [ false, [ '$eof'.freeze,   range(eof, eof) ] ]
    end
  end

  protected

  def eof_codepoint?(point)
    [0x04, 0x1a, 0x00].include? point
  end

  def version?(*versions)
    versions.include?(@version)
  end

  def stack_pop
    @top -= 1
    @stack[@top]
  end

  def encode_escape(ord)
    ord.chr.force_encoding(@source_buffer.source.encoding)
  end

  def tok(s = @ts, e = @te)
    @source_buffer.slice(s...e)
  end

  def range(s = @ts, e = @te)
    Parser::Source::Range.new(@source_buffer, s, e)
  end

  def emit(type, value = tok, s = @ts, e = @te)
    token = [ type, [ value, range(s, e) ] ]

    @token_queue.push(token)

    @tokens.push(token) if @tokens

    token
  end

  def emit_table(table, s = @ts, e = @te)
    value = tok(s, e)

    emit(table[value], value, s, e)
  end

  def emit_do(do_block=false)
    if @cond.active?
      emit(:kDO_COND, 'do'.freeze)
    elsif @cmdarg.active? || do_block
      emit(:kDO_BLOCK, 'do'.freeze)
    else
      emit(:kDO, 'do'.freeze)
    end
  end

  def arg_or_cmdarg
    if @command_state
      self.class.lex_en_expr_cmdarg
    else
      self.class.lex_en_expr_arg
    end
  end

  def emit_comment(s = @ts, e = @te)
    if @comments
      @comments.push(Parser::Source::Comment.new(range(s, e)))
    end

    if @tokens
      @tokens.push([ :tCOMMENT, [ tok(s, e), range(s, e) ] ])
    end

    nil
  end

  def diagnostic(type, reason, arguments=nil, location=range, highlights=[])
    @diagnostics.process(
        Parser::Diagnostic.new(type, reason, arguments, location, highlights))
  end

  #
  # === LITERAL STACK ===
  #

  def push_literal(*args)
    new_literal = Literal.new(self, *args)
    @literal_stack.push(new_literal)
    next_state_for_literal(new_literal)
  end

  def next_state_for_literal(literal)
    if literal.words? && literal.backslash_delimited?
      if literal.interpolate?
        self.class.lex_en_interp_backslash_delimited_words
      else
        self.class.lex_en_plain_backslash_delimited_words
      end
    elsif literal.words? && !literal.backslash_delimited?
      if literal.interpolate?
        self.class.lex_en_interp_words
      else
        self.class.lex_en_plain_words
      end
    elsif !literal.words? && literal.backslash_delimited?
      if literal.interpolate?
        self.class.lex_en_interp_backslash_delimited
      else
        self.class.lex_en_plain_backslash_delimited
      end
    else
      if literal.interpolate?
        self.class.lex_en_interp_string
      else
        self.class.lex_en_plain_string
      end
    end
  end

  def literal
    @literal_stack.last
  end

  def pop_literal
    old_literal = @literal_stack.pop

    @dedent_level = old_literal.dedent_level

    if old_literal.type == :tREGEXP_BEG
      # Fetch modifiers.
      self.class.lex_en_regexp_modifiers
    else
      self.class.lex_en_expr_end
    end
  end

  # Mapping of strings to parser tokens.

  PUNCTUATION = {
    '='   => :tEQL,     '&'   => :tAMPER2,  '|'   => :tPIPE,
    '!'   => :tBANG,    '^'   => :tCARET,   '+'   => :tPLUS,
    '-'   => :tMINUS,   '*'   => :tSTAR2,   '/'   => :tDIVIDE,
    '%'   => :tPERCENT, '~'   => :tTILDE,   ','   => :tCOMMA,
    ';'   => :tSEMI,    '.'   => :tDOT,     '..'  => :tDOT2,
    '...' => :tDOT3,    '['   => :tLBRACK2, ']'   => :tRBRACK,
    '('   => :tLPAREN2, ')'   => :tRPAREN,  '?'   => :tEH,
    ':'   => :tCOLON,   '&&'  => :tANDOP,   '||'  => :tOROP,
    '-@'  => :tUMINUS,  '+@'  => :tUPLUS,   '~@'  => :tTILDE,
    '**'  => :tPOW,     '->'  => :tLAMBDA,  '=~'  => :tMATCH,
    '!~'  => :tNMATCH,  '=='  => :tEQ,      '!='  => :tNEQ,
    '>'   => :tGT,      '>>'  => :tRSHFT,   '>='  => :tGEQ,
    '<'   => :tLT,      '<<'  => :tLSHFT,   '<='  => :tLEQ,
    '=>'  => :tASSOC,   '::'  => :tCOLON2,  '===' => :tEQQ,
    '<=>' => :tCMP,     '[]'  => :tAREF,    '[]=' => :tASET,
    '{'   => :tLCURLY,  '}'   => :tRCURLY,  '`'   => :tBACK_REF2,
    '!@'  => :tBANG,    '&.'  => :tANDDOT,  '.:'  => :tMETHREF
  }

  PUNCTUATION_BEGIN = {
    '&'   => :tAMPER,   '*'   => :tSTAR,    '**'  => :tDSTAR,
    '+'   => :tUPLUS,   '-'   => :tUMINUS,  '::'  => :tCOLON3,
    '('   => :tLPAREN,  '{'   => :tLBRACE,  '['   => :tLBRACK,
  }

  KEYWORDS = {
    'if'     => :kIF_MOD,      'unless'   => :kUNLESS_MOD,
    'while'  => :kWHILE_MOD,   'until'    => :kUNTIL_MOD,
    'rescue' => :kRESCUE_MOD,  'defined?' => :kDEFINED,
    'BEGIN'  => :klBEGIN,      'END'      => :klEND,
  }

  KEYWORDS_BEGIN = {
    'if'     => :kIF,          'unless'   => :kUNLESS,
    'while'  => :kWHILE,       'until'    => :kUNTIL,
    'rescue' => :kRESCUE,      'defined?' => :kDEFINED,
    'BEGIN'  => :klBEGIN,      'END'      => :klEND,
  }

  %w(class module def undef begin end then elsif else ensure case when
     for break next redo retry in do return yield super self nil true
     false and or not alias __FILE__ __LINE__ __ENCODING__).each do |keyword|
    KEYWORDS_BEGIN[keyword] = KEYWORDS[keyword] = :"k#{keyword.upcase}"
  end

  
# line 2408 "lib/parser/lexer.rl"

  # %
end
