/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import net.sf.freecol.common.ServerInfo;
import net.sf.freecol.common.i18n.Messages;

class ServerListTableModel
extends AbstractTableModel {
    private static final String[] columnNames = new String[]{Messages.message("name"), Messages.message("host"), Messages.message("port"), Messages.message("serverListPanel.players"), Messages.message("serverListPanel.gameState")};
    private List<ServerInfo> items;

    public ServerListTableModel(List<ServerInfo> items) {
        this.items = items;
    }

    public void setItems(List<ServerInfo> items) {
        this.items = items;
    }

    public ServerInfo getItem(int row) {
        return this.items.get(row);
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    @Override
    public int getRowCount() {
        return this.items.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < this.getRowCount() && column < this.getColumnCount() && row >= 0 && column >= 0) {
            ServerInfo si = this.items.get(row);
            switch (column) {
                case 0: {
                    return si.getName();
                }
                case 1: {
                    return si.getAddress();
                }
                case 2: {
                    return Integer.toString(si.getPort());
                }
                case 3: {
                    return Integer.toString(si.getCurrentlyPlaying()) + "/" + Integer.toString(si.getCurrentlyPlaying() + si.getSlotsAvailable());
                }
                case 4: {
                    return Messages.message("serverListPanel.gameState." + Integer.toString(si.getGameState()));
                }
            }
            return null;
        }
        return null;
    }
}

