define(["layoutManager","cardBuilder","listView","playbackManager","userSettings","alphaPicker","connectionManager","focusManager","loading","globalize","browser"],function(layoutManager,cardBuilder,listView,playbackManager,userSettings,AlphaPicker,connectionManager,focusManager,loading,globalize,browser){"use strict";function page(offset){var startIndex=this.startIndex||0,newStartIndex=Math.max(0,startIndex+offset);newStartIndex!==startIndex&&(this.startIndex=newStartIndex,this.scrollOnNextRefresh=!0,this.itemsContainer.refreshItems())}function nextPage(){page.call(this,100)}function previousPage(){page.call(this,-100)}function onAlphaValueChanged(){var value=this.alphaPicker.value();!function trySelectValue(instance,scroller,view,value){if(instance.enablePaging())return instance.startIndex=0,instance.scrollOnNextRefresh=!0,void instance.itemsContainer.refreshItems();var selectableItem;if("#"===value&&(selectableItem=view.querySelector(".card,.listItem")))scroller?scroller.toStart(selectableItem,!1):(selectableItem.querySelector(".cardContent-button")||selectableItem).focus();else if(selectableItem=view.querySelector("*[data-prefix^='"+value+"']"))scroller?scroller.toStart(selectableItem,!1):(selectableItem.querySelector(".cardContent-button")||selectableItem).focus();else{var values=instance.alphaPicker.values(),index=values.indexOf(value);if(index<values.length-2)trySelectValue(instance,scroller,view,values[index+1]);else{var all=view.querySelectorAll(".card,.listItem");(selectableItem=all.length?all[all.length-1]:null)&&(scroller?scroller.toStart(selectableItem,!1):(selectableItem.querySelector(".cardContent-button")||selectableItem).focus())}}}(this,this.scroller,this.itemsContainer,value)}function showFilterMenu(){var instance=this;require(["filterMenu"],function(FilterMenu){(new FilterMenu).show({settingsKey:instance.getSettingsKey(),settings:instance.getFilters(),visibleSettings:instance.getVisibleFilters(),onChange:instance.itemsContainer.refreshItems.bind(instance.itemsContainer),parentId:instance.params.parentId,itemTypes:instance.getItemTypes?instance.getItemTypes():[],serverId:instance.apiClient.serverId(),filterMenuOptions:instance.getFilterMenuOptions()}).then(function(){refreshAfterSettingsChange(instance)})})}function showSortMenu(e){var instance=this;require(["actionsheet"],function(actionsheet){var options=instance.getSortMenuOptions();!function(instance,options){for(var currentValues=instance.getSortValues(),i=0,length=options.length;i<length;i++){var opt=options[i];if(opt.selected=opt.value===currentValues.sortBy,opt.selected){var icon="Descending"===currentValues.sortOrder?"&#xE5DB;":"&#xE5D8;";opt.asideIcon=icon;break}}}(instance,options),options.sort(compareByName),actionsheet.show({items:options,positionTo:e.target,title:globalize.translate("LabelSortBy")}).then(function(value){var currentValues=instance.getSortValues(),sortOrder=currentValues.sortOrder;sortOrder=currentValues.sortBy===value&&"Ascending"===sortOrder?"Descending":"Ascending";var settingsKey=instance.getSettingsKey();userSettings.setFilter(settingsKey+"-sortby",value),userSettings.setFilter(settingsKey+"-sortorder",sortOrder),updateSortText(instance),refreshAfterSettingsChange(instance)})})}function showViewSettingsMenu(){var instance=this;require(["viewSettings"],function(ViewSettings){(new ViewSettings).show({settingsKey:instance.getSettingsKey(),settings:instance.getViewSettings(),visibleSettings:instance.getVisibleViewSettings()}).then(function(){updateItemsContainerForViewType(instance),refreshAfterSettingsChange(instance)})})}function refreshAfterSettingsChange(instance){instance.totalItemCount=null,instance.startIndex=0,instance.alphaPicker&&instance.enablePaging()&&instance.alphaPicker.value(null,!1),instance.scrollOnNextRefresh=!0,instance.itemsContainer.refreshItems()}function updateItemsContainerForViewType(instance){"list"===instance.getViewSettings().imageType?(instance.itemsContainer.classList.remove("vertical-wrap"),instance.itemsContainer.classList.add("vertical-list")):(instance.itemsContainer.classList.add("vertical-wrap"),instance.itemsContainer.classList.remove("vertical-list"))}function updateSortText(instance){var btnSortText=instance.btnSortText;if(btnSortText){for(var options=instance.getSortMenuOptions(),values=instance.getSortValues(),sortBy=values.sortBy,i=0,length=options.length;i<length;i++)if(sortBy===options[i].value){btnSortText.innerHTML=globalize.translate("SortByValue",options[i].name);break}var btnSortIcon=instance.btnSortIcon;btnSortIcon&&(btnSortIcon.innerHTML="Descending"===values.sortOrder?"&#xE5DB;":"&#xE5D8;")}}function bindAll(elems,eventName,fn){for(var i=0,length=elems.length;i<length;i++)elems[i].addEventListener(eventName,fn)}function hideOrShowAll(elems,hide){for(var i=0,length=elems.length;i<length;i++)hide?elems[i].classList.add("hide"):elems[i].classList.remove("hide")}function afterRefresh(result){this.enablePaging()&&this.scrollOnNextRefresh&&window.scrollTo(0,0),this.scrollOnNextRefresh=!1,null==this.totalItemCount&&(null!=result.TotalRecordCount?this.totalItemCount=result.TotalRecordCount:this.totalItemCount=result.Items?result.Items.length:result.length),function(instance,numItems){if(instance.alphaPicker){var alphaPicker=instance.alphaPickerElement;if(alphaPicker){var values=instance.getSortValues();null==numItems&&(numItems=100);var elemWithPadding=instance.itemsContainer.classList.contains("padded-left")?instance.itemsContainer:instance.itemsContainer.parentNode;"SortName"===values.sortBy&&"Ascending"===values.sortOrder&&30<numItems?(alphaPicker.classList.remove("hide"),layoutManager.tv?(elemWithPadding.classList.remove("padded-right-withalphapicker"),elemWithPadding.classList.add("padded-left-withalphapicker"),alphaPicker.classList.add("alphaPicker-fixed-left"),alphaPicker.classList.remove("alphaPicker-fixed-right")):(elemWithPadding.classList.remove("padded-left-withalphapicker"),elemWithPadding.classList.add("padded-right-withalphapicker"),alphaPicker.classList.remove("alphaPicker-fixed-left"),alphaPicker.classList.add("alphaPicker-fixed-right")),instance.refreshPrefixes()):(alphaPicker.classList.add("hide"),elemWithPadding.classList.remove("padded-left-withalphapicker"),elemWithPadding.classList.remove("padded-right-withalphapicker"))}}}(this,this.totalItemCount);var i,length,startIndex=this.startIndex||0,previousPageButtons=this.previousPageButtons;for(i=0,length=previousPageButtons.length;i<length;i++)previousPageButtons[i].disabled=startIndex<=0;var totalRecordCount=result.TotalRecordCount;if(null!=totalRecordCount){var nextPageButtons=this.nextPageButtons;for(i=0,length=nextPageButtons.length;i<length;i++)nextPageButtons[i].disabled=totalRecordCount<startIndex+100}hideOrShowAll(this.view.querySelectorAll(".btnPlay"),!totalRecordCount),hideOrShowAll(this.view.querySelectorAll(".btnShuffle"),!(totalRecordCount&&this.supportsShuffle()))}function ItemsTab(view,params){var i,length;this.view=view,(this.params=params).serverId&&(this.apiClient=connectionManager.getApiClient(params.serverId)),this.itemsContainer=view.querySelector(".itemsContainer"),this.scroller=view.querySelector(".scrollFrameY"),this.itemsContainer.fetchData=this.fetchData.bind(this),this.itemsContainer.getItemsHtml=this.getItemsHtml.bind(this),this.itemsContainer.afterRefresh=afterRefresh.bind(this),params.parentId&&this.itemsContainer.setAttribute("data-parentid",params.parentId);var btnViewSettings=view.querySelectorAll(".btnViewSettings");for(i=0,length=btnViewSettings.length;i<length;i++)btnViewSettings[i].addEventListener("click",showViewSettingsMenu.bind(this));var filterButtons=view.querySelectorAll(".btnFilter");this.filterButtons=filterButtons;var hasVisibleFilters=this.getVisibleFilters().length;for(i=0,length=filterButtons.length;i<length;i++){var btnFilter=filterButtons[i];btnFilter.addEventListener("click",showFilterMenu.bind(this)),hasVisibleFilters?btnFilter.classList.remove("hide"):btnFilter.classList.add("hide")}var nextPageButtons=view.querySelectorAll(".btnNextPage");for(i=0,length=(this.nextPageButtons=nextPageButtons).length;i<length;i++)nextPageButtons[i].addEventListener("click",nextPage.bind(this));var previousPageButtons=view.querySelectorAll(".btnPreviousPage");for(i=0,length=(this.previousPageButtons=previousPageButtons).length;i<length;i++)previousPageButtons[i].addEventListener("click",previousPage.bind(this));var sortButtons=view.querySelectorAll(".btnSort");for(i=0,length=(this.sortButtons=sortButtons).length;i<length;i++){var sortButton=sortButtons[i];sortButton.addEventListener("click",showSortMenu.bind(this)),"nextup"!==params.type&&sortButton.classList.remove("hide")}this.btnSortText=view.querySelector(".btnSortText"),this.btnSortIcon=view.querySelector(".btnSortIcon"),this.enableAlphaNumericShortcuts="true"===this.itemsContainer.getAttribute("data-alphanumericshortcuts")&&!layoutManager.mobile&&!this.enablePaging(),this.alphaPickerElement=view.querySelector(".alphaPicker"),bindAll(view.querySelectorAll(".btnPlay"),"click",function(){this.fetchData({Limit:300}).then(function(result){playbackManager.play({items:result.Items||result})})}.bind(this)),bindAll(view.querySelectorAll(".btnShuffle"),"click",function(){this.fetchData({SortBy:"Random",Limit:300}).then(function(result){playbackManager.play({items:result.Items||result})})}.bind(this)),this.scrollOnNextRefresh=!0}function compareByName(a,b){return a.name<b.name?-1:a.name>b.name?1:0}return ItemsTab.prototype.refreshPrefixes=function(){var instance=this;instance.prefixesLoaded||this.getPrefixes().then(function(prefixes){instance.prefixesLoaded=!0,instance.alphaPicker.setPrefixes(prefixes)})},ItemsTab.prototype.getPrefixes=function(){var queryInfo=this.getQueryInfo(!1),apiClient=this.apiClient,query=queryInfo.query;return query.SortBy=null,query.SortOrder=null,query.StartIndex=null,query.Limit=null,query.Fields=null,query.EnableImageTypes=null,query.ImageTypeLimit=null,query.NameStartsWithOrGreater=null,query.IncludeItemTypes=this.getPrefixQueryIncludeItemTypes().join(","),apiClient.getPrefixes(apiClient.getCurrentUserId(),query).then(function(result){return result.map(function(i){return i.Name})})},ItemsTab.prototype.getItemsHtml=function(items){var settings=this.getViewSettings();return"list"===settings.imageType?listView.getListViewHtml({items:items}):cardBuilder.getCardsHtml(items,this.getCardOptions(items,settings))},ItemsTab.prototype.getCardOptions=function(items,settings){var shape,preferThumb,preferDisc,preferLogo;"banner"===settings.imageType?shape="banner":"disc"===settings.imageType?(shape="square",preferDisc=!0):"logo"===settings.imageType?(shape="square",preferLogo=!0):"thumb"===settings.imageType?(shape="backdrop",preferThumb=!0):shape="auto";var parentId=this.params.parentId;return{items:items,shape:shape,centerText:!0,preferThumb:preferThumb,preferDisc:preferDisc,preferLogo:preferLogo,overlayMoreButton:!layoutManager.tv,showTitle:settings.showTitle,showYear:settings.showYear,overlayText:!settings.showTitle,context:this.getContext(),parentId:parentId,playAction:this.getPlayAction()}},ItemsTab.prototype.getPlayAction=function(){return null},ItemsTab.prototype.getContext=function(){return null},ItemsTab.prototype.supportsShuffle=function(){return!0},ItemsTab.prototype.getPrefixQueryIncludeItemTypes=function(){return this.getQueryIncludeItemTypes()},ItemsTab.prototype.getQueryIncludeItemTypes=function(){return this.getItemTypes()},ItemsTab.prototype.getBaseQuery=function(){var parentId=this.params.parentId,sortValues=this.getSortValues(),fields="BasicSyncInfo,MediaSourceCount";layoutManager.mobile||(fields+=",SortName");var settings=this.getViewSettings();"primary"===settings.imageType&&(fields+=",PrimaryImageAspectRatio"),settings.showYear&&(fields+=",ProductionYear");var imageTypes="Primary,Backdrop,Thumb";"banner"===settings.imageType?imageTypes+=",Banner":"disc"===settings.imageType?imageTypes+=",Disc":"logo"===settings.imageType&&(imageTypes+=",Logo");var query={SortBy:sortValues.sortBy,SortOrder:sortValues.sortOrder,IncludeItemTypes:this.getQueryIncludeItemTypes().join(","),Recursive:!0,Fields:fields,ImageTypeLimit:1,EnableImageTypes:imageTypes,StartIndex:this.startIndex||0,Limit:this.enablePaging()?100:null,ParentId:parentId},alphaPicker=this.alphaPicker;return alphaPicker&&(query.NameStartsWithOrGreater=alphaPicker.value()),query},ItemsTab.prototype.getQueryInfo=function(enableFilters){var hasFilters,query=this.getBaseQuery(),queryFilters=[];if("unwatched"===this.mode?queryFilters.push("IsUnplayed"):"favorites"===this.mode&&queryFilters.push("IsFavorite"),!1!==enableFilters){var filters=this.getFilters();filters.SeriesStatus&&(query.SeriesStatus=filters.SeriesStatus,hasFilters=!0),filters.IsPlayed&&(queryFilters.push("IsPlayed"),hasFilters=!0),filters.IsUnplayed&&(queryFilters.push("IsUnplayed"),hasFilters=!0),filters.IsFavorite&&(queryFilters.push("IsFavorite"),hasFilters=!0),filters.IsResumable&&(queryFilters.push("IsResumable"),hasFilters=!0),filters.Containers&&(hasFilters=!0,query.Containers=filters.Containers),filters.AudioCodecs&&(hasFilters=!0,query.AudioCodecs=filters.AudioCodecs),filters.VideoCodecs&&(hasFilters=!0,query.VideoCodecs=filters.VideoCodecs),filters.SubtitleCodecs&&(hasFilters=!0,query.SubtitleCodecs=filters.SubtitleCodecs),filters.GenreIds&&(hasFilters=!0,query.GenreIds=filters.GenreIds),filters.OfficialRatings&&(hasFilters=!0,query.OfficialRatings=filters.OfficialRatings),filters.StudioIds&&(hasFilters=!0,query.StudioIds=filters.StudioIds),filters.TagIds&&(hasFilters=!0,query.TagIds=filters.TagIds),filters.Tags&&(hasFilters=!0,query.Tags=filters.Tags),filters.Years&&(hasFilters=!0,query.Years=filters.Years),filters.Is4K&&(hasFilters=query.Is4K=!0),filters.IsHD&&(hasFilters=query.IsHD=!0),filters.IsSD&&(hasFilters=!(query.IsHD=!1)),filters.Is3D&&(hasFilters=query.Is3D=!0),null!=filters.HasSubtitles&&(query.HasSubtitles=filters.HasSubtitles,hasFilters=!0),null!=filters.HasTrailer&&(query.HasTrailer=filters.HasTrailer,hasFilters=!0),null!=filters.HasSpecialFeature&&(query.HasSpecialFeature=filters.HasSpecialFeature,hasFilters=!0),null!=filters.HasThemeSong&&(query.HasThemeSong=filters.HasThemeSong,hasFilters=!0),null!=filters.HasThemeVideo&&(query.HasThemeVideo=filters.HasThemeVideo,hasFilters=!0),null!=filters.HasOverview&&(query.HasOverview=filters.HasOverview,hasFilters=!0),null!=filters.IsLocked&&(query.IsLocked=filters.IsLocked,hasFilters=!0)}return query.Filters=queryFilters.length?queryFilters.join(","):null,this.getViewSettings().groupItemsIntoCollections&&(query.GroupItemsIntoCollections=!0),{query:query,hasFilters:hasFilters}},ItemsTab.prototype.fetchData=function(baseQuery){var queryInfo=this.getQueryInfo();this.setFilterStatus(queryInfo.hasFilters);var apiClient=this.apiClient,query=Object.assign(queryInfo.query,baseQuery||{});return apiClient.getItems(apiClient.getCurrentUserId(),query)},ItemsTab.prototype.getViewSettings=function(){var basekey=this.getSettingsKey(),showYearVisible=-1!==this.getVisibleViewSettings().indexOf("showYear");return{showTitle:"false"!==userSettings.get(basekey+"-showTitle"),showYear:showYearVisible&&"false"!==userSettings.get(basekey+"-showYear"),groupItemsIntoCollections:"true"===userSettings.get(basekey+"-groupItemsIntoCollections"),imageType:userSettings.get(basekey+"-imageType")||this.getDefaultImageType()}},ItemsTab.prototype.getDefaultImageType=function(){return"primary"},ItemsTab.prototype.getSettingsKey=function(){return this.params.parentId+"-1"},ItemsTab.prototype.onResume=function(options){options&&options.refresh&&(updateSortText(this),updateItemsContainerForViewType(this),loading.show());var view=this.view,scroller=this.scroller;scroller&&scroller.resume&&scroller.resume();var itemsContainer=this.itemsContainer;itemsContainer&&itemsContainer.resume&&itemsContainer.resume(),this.enableAlphaPicker&&!this.alphaPicker&&function(instance,view){instance.itemsContainer=view.querySelector(".itemsContainer"),instance.alphaPicker=new AlphaPicker({element:instance.alphaPickerElement,itemsContainer:instance.itemsContainer,itemClass:["card","listItem"],prefixes:instance.apiClient.isMinServerVersion("3.6.0.60")?[]:null}),instance.alphaPicker.on("alphavaluechanged",onAlphaValueChanged.bind(instance))}(this,view),this.enableAlphaNumericShortcuts&&function(instance){require(["alphaNumericShortcuts"],function(AlphaNumericShortcuts){instance.alphaNumericShortcuts=new AlphaNumericShortcuts({itemsContainer:instance.itemsContainer})})}(this);var instance=this,autoFocus=options.autoFocus;this.itemsContainer.resume(options).then(function(result){loading.hide(),autoFocus&&focusManager.autoFocus(instance.itemsContainer)})},ItemsTab.prototype.refresh=function(options){loading.show();var instance=this,autoFocus=options.autoFocus;this.itemsContainer.refreshItems(options).then(function(result){loading.hide(),autoFocus&&focusManager.autoFocus(instance.itemsContainer)})},ItemsTab.prototype.getVisibleViewSettings=function(){return["showTitle","showYear","imageType"]},ItemsTab.prototype.getFilters=function(){var basekey=this.getSettingsKey();return{IsPlayed:"true"===userSettings.getFilter(basekey+"-filter-IsPlayed"),IsUnplayed:"true"===userSettings.getFilter(basekey+"-filter-IsUnplayed"),IsFavorite:"true"===userSettings.getFilter(basekey+"-filter-IsFavorite"),IsResumable:"true"===userSettings.getFilter(basekey+"-filter-IsResumable"),Is4K:"true"===userSettings.getFilter(basekey+"-filter-Is4K"),IsHD:"true"===userSettings.getFilter(basekey+"-filter-IsHD"),IsSD:"true"===userSettings.getFilter(basekey+"-filter-IsSD"),Is3D:"true"===userSettings.getFilter(basekey+"-filter-Is3D"),VideoTypes:userSettings.getFilter(basekey+"-filter-VideoTypes"),SeriesStatus:userSettings.getFilter(basekey+"-filter-SeriesStatus"),HasSubtitles:userSettings.getFilter(basekey+"-filter-HasSubtitles"),HasTrailer:userSettings.getFilter(basekey+"-filter-HasTrailer"),HasSpecialFeature:userSettings.getFilter(basekey+"-filter-HasSpecialFeature"),HasThemeSong:userSettings.getFilter(basekey+"-filter-HasThemeSong"),HasThemeVideo:userSettings.getFilter(basekey+"-filter-HasThemeVideo"),HasOverview:userSettings.getFilter(basekey+"-filter-HasOverview"),IsLocked:userSettings.getFilter(basekey+"-filter-IsLocked"),GenreIds:userSettings.getFilter(basekey+"-filter-GenreIds"),StudioIds:userSettings.getFilter(basekey+"-filter-StudioIds"),Tags:userSettings.getFilter(basekey+"-filter-Tags"),TagIds:userSettings.getFilter(basekey+"-filter-TagIds"),OfficialRatings:userSettings.getFilter(basekey+"-filter-OfficialRatings"),Containers:userSettings.getFilter(basekey+"-filter-Containers"),AudioCodecs:userSettings.getFilter(basekey+"-filter-AudioCodecs"),VideoCodecs:userSettings.getFilter(basekey+"-filter-VideoCodecs"),SubtitleCodecs:userSettings.getFilter(basekey+"-filter-SubtitleCodecs"),Years:userSettings.getFilter(basekey+"-filter-Years")}},ItemsTab.prototype.getSortValues=function(){var basekey=this.getSettingsKey();return{sortBy:userSettings.getFilter(basekey+"-sortby")||this.getDefaultSortBy(),sortOrder:"Descending"===userSettings.getFilter(basekey+"-sortorder")?"Descending":"Ascending"}},ItemsTab.prototype.getVisibleFilters=function(){return[]},ItemsTab.prototype.getDefaultSortBy=function(){return"SortName"},ItemsTab.prototype.sortOptionsByName=function(options){options.sort(compareByName)},ItemsTab.prototype.getSortMenuOptions=function(){var sortBy=[],option=this.getNameSortOption();return option&&sortBy.push(option),(option=this.getFolderSortOption())&&sortBy.push(option),(option=this.getCommunityRatingSortOption())&&sortBy.push(option),(option=this.getCriticRatingSortOption())&&sortBy.push(option),sortBy.push({name:globalize.translate("DateAdded"),value:"DateCreated,SortName"}),(option=this.getDatePlayedSortOption())&&sortBy.push(option),sortBy.push({name:globalize.translate("ParentalRating"),value:"OfficialRating,SortName"}),(option=this.getPlayCountSortOption())&&sortBy.push(option),(option=this.getReleaseDateSortOption())&&sortBy.push(option),sortBy.push({name:globalize.translate("Runtime"),value:"Runtime,SortName"}),this.sortOptionsByName(sortBy),sortBy},ItemsTab.prototype.getNameSortOption=function(){return{name:globalize.translate("Title"),value:"SortName"}},ItemsTab.prototype.getReleaseDateSortOption=function(){return{name:globalize.translate("ReleaseDate"),value:"PremiereDate,ProductionYear,SortName"}},ItemsTab.prototype.getFolderSortOption=function(){return null},ItemsTab.prototype.getPlayCountSortOption=function(){return{name:globalize.translate("PlayCount"),value:"PlayCount,SortName"}},ItemsTab.prototype.getDatePlayedSortOption=function(){return{name:globalize.translate("DatePlayed"),value:"DatePlayed,SortName"}},ItemsTab.prototype.getCriticRatingSortOption=function(){return{name:globalize.translate("CriticRating"),value:"CriticRating,SortName"}},ItemsTab.prototype.enablePaging=function(){return this.nextPageButtons.length},ItemsTab.prototype.getCommunityRatingSortOption=function(){return{name:globalize.translate("CommunityRating"),value:"CommunityRating,SortName"}},ItemsTab.prototype.getFilterMenuOptions=function(){this.params;return{}},ItemsTab.prototype.getItemTypes=function(){return[]},ItemsTab.prototype.setFilterStatus=function(hasFilters){this.hasFilters=hasFilters;var filterButtons=this.filterButtons;if(filterButtons.length)for(var i=0,length=filterButtons.length;i<length;i++){var btnFilter=filterButtons[i],bubble=btnFilter.querySelector(".filterButtonBubble");if(!bubble){if(!hasFilters)continue;btnFilter.insertAdjacentHTML("afterbegin",'<div class="filterButtonBubble">!</div>'),btnFilter.classList.add("btnFilterWithBubble"),bubble=btnFilter.querySelector(".filterButtonBubble")}hasFilters?bubble.classList.remove("hide"):bubble.classList.add("hide")}},ItemsTab.prototype.onPause=function(){var scroller=this.scroller;scroller&&scroller.pause&&scroller.pause();var itemsContainer=this.itemsContainer;itemsContainer&&itemsContainer.pause&&itemsContainer.pause();var alphaNumericShortcuts=this.alphaNumericShortcuts;alphaNumericShortcuts&&(alphaNumericShortcuts.destroy(),this.alphaNumericShortcuts=null)},ItemsTab.prototype.destroy=function(){this.view=null,this.itemsContainer=null,this.params=null,this.apiClient=null,this.scroller=null,this.filterButtons=null,this.nextPageButtons=null,this.previousPageButtons=null,this.alphaPicker&&(this.alphaPicker.destroy(),this.alphaPicker=null),this.sortButtons=null,this.btnSortText=null,this.btnSortIcon=null,this.alphaPickerElement=null,this.startIndex=null,this.prefixesLoaded=null,this.totalItemCount=null,this.scrollOnNextRefresh=null},ItemsTab});