/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.console;

import java.io.IOException;
import org.eclipse.cdt.debug.ui.debuggerconsole.IDebuggerConsoleView;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.ConsoleMessages;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.GdbAbstractConsolePreferenceListener;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.GdbBasicCliConsolePage;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.GdbConsoleLifecycleListener;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.IGDBDebuggerConsole;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.AbstractConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.part.IPageBookViewPage;

public class GdbBasicCliConsole
extends IOConsole
implements IGDBDebuggerConsole {
    private static final int CHARS_PER_LINE_AVG = 80;
    private static final int HIGH_WATERMARK_OFFSET_CHARS = 8000;
    private final ILaunch fLaunch;
    private final String fLabel;
    private final Process fProcess;
    private final IOConsoleOutputStream fOutputStream;
    private final IOConsoleOutputStream fErrorStream;
    private GdbAbstractConsolePreferenceListener fPreferenceListener = new GdbAbstractConsolePreferenceListener(){

        @Override
        protected void handleAutoTerminatePref(boolean enabled) {
        }

        @Override
        protected void handleInvertColorsPref(boolean enabled) {
            GdbBasicCliConsole.this.setInvertedColors(enabled);
        }

        @Override
        protected void handleBufferLinesPref(int bufferLines) {
            GdbBasicCliConsole.this.setBufferLineLimit(bufferLines);
        }
    };

    public GdbBasicCliConsole(ILaunch launch, String label, Process process) {
        super("", "GdbBasicCliConsole", null, false);
        this.fLaunch = launch;
        this.fLabel = label;
        this.fProcess = process;
        this.fOutputStream = this.newOutputStream();
        this.fErrorStream = this.newOutputStream();
        assert (process != null);
        new GdbConsoleLifecycleListener((AbstractConsole)this);
        GdbUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        this.resetName();
        this.setDefaults();
        new InputReadJob().schedule();
        new OutputReadJob().schedule();
        new ErrorReadJob().schedule();
    }

    protected void dispose() {
        this.stop();
        super.dispose();
    }

    public void stop() {
        try {
            this.fOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.fErrorStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        IOConsoleInputStream istream = this.getInputStream();
        if (istream != null) {
            try {
                istream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        GdbUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
    }

    private void setDefaults() {
        IPreferenceStore store = GdbUIPlugin.getDefault().getPreferenceStore();
        boolean enabled = store.getBoolean("org.eclipse.cdt.dsf.gdb.consoleInvertedColors");
        int bufferLines = store.getInt("org.eclipse.cdt.dsf.gdb.consoleBufferLines");
        Display.getDefault().asyncExec(() -> {
            IOConsoleInputStream inputStream = this.getInputStream();
            if (inputStream != null) {
                inputStream.setColor(Display.getDefault().getSystemColor(5));
            }
            this.fErrorStream.setColor(Display.getDefault().getSystemColor(3));
            this.setInvertedColors(enabled);
            this.setBufferLineLimit(bufferLines);
        });
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public void resetName() {
        block3: {
            String newName = this.computeName();
            String name = this.getName();
            if (!name.equals(newName)) {
                try {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(() -> this.setName(newName));
                }
                catch (SWTException e) {
                    if (e.code == 24) break block3;
                    throw e;
                }
            }
        }
    }

    protected String computeName() {
        if (this.fLaunch == null) {
            return "";
        }
        String label = this.fLabel;
        ILaunchConfiguration config = this.fLaunch.getLaunchConfiguration();
        if (config != null && !DebugUITools.isPrivate((ILaunchConfiguration)config)) {
            String type = null;
            try {
                type = config.getType().getName();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(config.getName());
            if (type != null) {
                buffer.append(" [");
                buffer.append(type);
                buffer.append("] ");
            }
            buffer.append(label);
            label = buffer.toString();
        }
        if (this.fLaunch.isTerminated()) {
            return String.valueOf(ConsoleMessages.ConsoleMessages_console_terminated) + label;
        }
        return label;
    }

    public IPageBookViewPage createPage(IConsoleView view) {
        return new GdbBasicCliConsolePage(this, view);
    }

    public IPageBookViewPage createDebuggerPage(IDebuggerConsoleView view) {
        if (view instanceof IConsoleView) {
            return this.createPage((IConsoleView)view);
        }
        return null;
    }

    private void setInvertedColors(boolean enable) {
        if (enable) {
            this.setBackground(Display.getDefault().getSystemColor(2));
            this.fOutputStream.setColor(Display.getDefault().getSystemColor(1));
        } else {
            this.setBackground(Display.getDefault().getSystemColor(1));
            this.fOutputStream.setColor(Display.getDefault().getSystemColor(2));
        }
    }

    private void setBufferLineLimit(int bufferLines) {
        int chars = bufferLines * 80;
        this.setWaterMarks(chars, chars + 8000);
    }

    private class ErrorReadJob
    extends Job {
        ErrorReadJob() {
            super("GDB CLI error output Job");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                byte[] b = new byte[1024];
                int read = 0;
                do {
                    if ((read = GdbBasicCliConsole.this.fProcess.getErrorStream().read(b)) <= 0) continue;
                    GdbBasicCliConsole.this.fErrorStream.write(b, 0, read);
                } while (read >= 0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return Status.OK_STATUS;
        }
    }

    private class InputReadJob
    extends Job {
        InputReadJob() {
            super("GDB CLI Input Job");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                IOConsoleInputStream inputStream;
                byte[] b = new byte[1024];
                int read = 0;
                while ((inputStream = GdbBasicCliConsole.this.getInputStream()) != null) {
                    read = inputStream.read(b);
                    if (read > 0) {
                        GdbBasicCliConsole.this.fProcess.getOutputStream().write(b, 0, read);
                    }
                    if (read >= 0) continue;
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return Status.OK_STATUS;
        }
    }

    private class OutputReadJob
    extends Job {
        OutputReadJob() {
            super("GDB CLI output Job");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                byte[] b = new byte[1024];
                int read = 0;
                do {
                    if ((read = GdbBasicCliConsole.this.fProcess.getInputStream().read(b)) <= 0) continue;
                    GdbBasicCliConsole.this.fOutputStream.write(b, 0, read);
                } while (read >= 0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return Status.OK_STATUS;
        }
    }
}

