/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.editor;

import org.cloudfoundry.client.lib.domain.InstanceStats;
import org.eclipse.cft.server.ui.internal.editor.AppStatsContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class AppStatsLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof AppStatsContentProvider.InstanceStatsAndInfo) {
            AppStatsContentProvider.InstanceStatsAndInfo statsAndInfo = (AppStatsContentProvider.InstanceStatsAndInfo)element;
            InstanceStats stats = statsAndInfo.getStats();
            InstanceStats.Usage usage = stats.getUsage();
            double cpu = 0.0;
            String memory = "0M";
            String disk = "0M";
            if (usage != null) {
                cpu = usage.getCpu();
                memory = this.getFormattedMemory(usage.getMem() / 1024L);
                disk = this.getFormattedMemory(usage.getDisk() / 1024L);
            }
            switch (columnIndex) {
                case 0: {
                    return stats.getId();
                }
                case 1: {
                    return stats.getHost();
                }
                case 2: {
                    return String.valueOf(stats.getPort());
                }
                case 3: {
                    return String.valueOf(String.valueOf(cpu)) + "% (" + String.valueOf(stats.getCores()) + ")";
                }
                case 4: {
                    return String.valueOf(memory) + " (" + this.getFormattedMemory(stats.getMemQuota() / 1024L) + ")";
                }
                case 5: {
                    return String.valueOf(disk) + " (" + this.getFormattedMemory(stats.getDiskQuota() / 1024L) + ")";
                }
                case 6: {
                    return this.getFormattedDuration(Math.round(stats.getUptime()));
                }
            }
        }
        return null;
    }

    private String getFormattedDuration(long duration) {
        if (duration <= 0L) {
            return "0h:0m:0s";
        }
        long remainderSeconds = duration % 60L;
        long totalMinutes = duration / 60L;
        long remainderMinutes = totalMinutes % 60L;
        long totalHours = totalMinutes / 60L;
        String hourString = "" + totalHours;
        String minuteString = "" + remainderMinutes;
        String secondString = "" + remainderSeconds;
        return String.valueOf(hourString) + "h:" + minuteString + "m:" + secondString + "s";
    }

    private String getFormattedMemory(double mem) {
        return String.valueOf(String.valueOf(Math.round(mem * 10.0 / 1024.0) / 10L)) + "M";
    }
}

